/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import javax.media.opengl.GL;
import vitamin.VLogger;
import vitamin.VSamplerState;
import vitamin.VTexture;

public class RenderTarget2D {
    GL _gl;
    VTexture _tex;
    private int[] _fboID;
    private int[] _depthStencilBufferID;
    int _width;
    int _height;
    int _id;

    public RenderTarget2D(GL gl, int width, int height) {
        this._gl = gl;
        this._width = width;
        this._height = height;
        this._tex = new VTexture(this._gl, "RenderTarget");
        this._tex.create(3553, this._width, this._height, 5, new VSamplerState());
        this._fboID = new int[1];
        this._depthStencilBufferID = new int[1];
        this._gl.glGenFramebuffersEXT(1, this._fboID, 0);
    }

    public void bind() {
        this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
    }

    public void unbind() {
        this._gl.glBindFramebufferEXT(36160, 0);
    }

    public void enable() {
        this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
    }

    public void disable() {
        this._gl.glBindFramebufferEXT(36160, 0);
    }

    public void attachTexture(int attachment, int texTarget, int texId) {
        this._gl.glFramebufferTexture2DEXT(36160, attachment, texTarget, texId, 0);
    }

    public void attachRenderBuffer(int attachment) {
        this._gl.glGenRenderbuffersEXT(1, this._depthStencilBufferID, 0);
        this._gl.glBindRenderbufferEXT(36161, this._depthStencilBufferID[0]);
        this._gl.glRenderbufferStorageEXT(36161, attachment, this._width, this._height);
        this._gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this._depthStencilBufferID[0]);
    }

    public void setDrawBuffer(int idx) {
        if (idx == -1) {
            this._gl.glDrawBuffer(0);
            this._gl.glReadBuffer(0);
        } else if (idx == 0) {
            this._gl.glDrawBuffer(36064);
        } else if (idx == 1) {
            this._gl.glDrawBuffer(36065);
        }
    }

    public void restoreDrawBuffer() {
        this._gl.glReadBuffer(1029);
        this._gl.glDrawBuffer(1029);
    }

    public void validate() {
        int stat = this._gl.glCheckFramebufferStatusEXT(36160);
        switch (stat) {
            case 36053: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_COMPLETE_EXT");
                break;
            }
            case 36054: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT");
                break;
            }
            case 36055: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                break;
            }
            case 36057: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                break;
            }
            case 36058: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                break;
            }
            case 36059: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                break;
            }
            case 36060: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                break;
            }
            case 36061: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                break;
            }
            default: {
                VLogger.getSingleton().log("(RenderTarget2D)  Unknown");
            }
        }
    }

    public void delete() {
        this._gl.glDeleteFramebuffersEXT(1, this._fboID, 0);
        this._gl.glDeleteRenderbuffersEXT(1, this._depthStencilBufferID, 0);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._width;
    }

    public int getId() {
        return this._fboID[0];
    }
}

