/*
 * Decompiled with CFR 0.152.
 */
import com.sun.opengl.cg.CGpass;
import com.sun.opengl.cg.CgGL;
import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.FPSAnimator;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import ddf.minim.AudioOutput;
import ddf.minim.AudioPlayer;
import ddf.minim.AudioSample;
import ddf.minim.Minim;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.sound.sampled.FloatControl;
import krister.Ess.AudioChannel;
import krister.Ess.Ess;
import krister.Ess.FFT;
import penner.easing.Sine;
import processing.core.PApplet;
import processing.core.PImage;
import vitamin.ShaderCGFX;
import vitamin.VGL;
import vitamin.VTimer;
import vitamin.math.Color4;
import vitamin.math.Matrix;
import vitamin.math.Quaternion;
import vitamin.math.Vector3;
import vitamin.math.Vector4;

public class Deep
extends PApplet {
    Frame deepFrame;
    GLCapabilities deepCaps;
    GLCanvas deepCanvas;
    GLRenderer deepListener;
    FPSAnimator animator;
    boolean isFullScreen = true;
    int WIDTH = 1280;
    int HEIGHT = 720;
    int NUM_SAMPLES = 4;
    float gamma = 0.9f;
    final boolean useMinim = true;
    final boolean useESS = false;
    final boolean saveFrameSequence = false;
    final float frequencyScale = 400.0f;
    float addTime = 0.0f;
    final float addTimeStep = 5.0f;
    Minim minim;
    AudioOutput out;
    AudioPlayer track;
    AudioPlayer credits;
    AudioSample outsphere;
    boolean playedOutsphere = false;
    FloatControl ourcontrol1;
    FloatControl ourcontrol2;
    float time;
    float startTime;
    VTimer timer;
    float backgroundTime = 0.0f;
    float fadeBGOutTime = 334.0f;
    float bgEndTime = 337.0f;
    float logoTime = 20.0f;
    float landTime = 0.0f;
    float candlesTime = 15.0f;
    float spikeyTime = 5.0f;
    float planktonTime = 5.0f;
    float jellyTime = 73.0f;
    float tactuTime = 337.0f;
    float endFadeOutTime = 380.0f;
    boolean isEndOfDemo = false;
    VGL vgl;
    float aspectRatio;
    Vector3 eye;
    Vector3 target;
    Vector3 up;
    float[] fogColorArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    Vector4 fogColor = new Vector4(0.0f, 0.0f, 0.0f, 1.0f);
    float fogConstant = 7.0E-4f;
    float fogDensity = 8.0E-4f;
    Vector4 lightPos;
    float kC = 0.0f;
    float kL = 8.0E-4f;
    float kQ = 8.0E-6f;
    Vector3 jeye;
    Vector3 jtarget;
    Vector3 jellyEye;
    Vector3 jellyTarget;
    JellyScene jellys;
    GrassScene grassScene;
    SpikeyScene spikey;
    Landscape land;
    TactuScene tactu;
    Matrix camMatrix;
    Matrix invCamMatrix;
    XTexture backG;
    XTexture deepTex;
    boolean isDemoRunning = false;
    AudioChannel chn;
    FFT fft;
    int frameNumber = 0;
    int framesPerSecond = 30;
    float level;
    float[] fftbuffer;
    float lastTime;
    float currentTime;
    int sphereStacks = 120;
    int sphereSlices = 120;
    Vector3[] sphereSurface;
    int[] sphereIndices;
    Vector3[] sphereSurfaceUV;
    Vector3[] sphereSurfaceNormal;

    public void writelog(String string) {
    }

    public void setup() {
        String[] stringArray = this.loadStrings(this.dataPath("res.txt"));
        if (stringArray.length == 5) {
            this.WIDTH = Integer.parseInt(stringArray[0]);
            this.HEIGHT = Integer.parseInt(stringArray[1]);
            this.isFullScreen = Integer.parseInt(stringArray[2]) != 0;
            this.NUM_SAMPLES = Integer.parseInt(stringArray[3]);
            this.gamma = Float.parseFloat(stringArray[4]);
        }
        this.isDemoRunning = false;
        this.minim = new Minim((PApplet)this);
        this.out = this.minim.getLineOut(2, 2048);
        this.track = this.minim.loadFile(this.dataPath("deep_mixdown3.mp3"), 2048);
        this.ourcontrol1 = this.track.gain();
        this.outsphere = this.minim.loadSample(this.dataPath("outsphere.wav"), 2048);
        this.credits = this.minim.loadFile(this.dataPath("clicking.wav"), 2048);
        this.ourcontrol2 = this.credits.gain();
        this.initDemo();
    }

    public void initDemo() {
        this.isDemoRunning = true;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.deepListener = new GLRenderer();
        this.deepFrame = new Frame("Deep");
        this.deepCaps = new GLCapabilities();
        this.deepCaps.setHardwareAccelerated(true);
        this.deepCaps.setDoubleBuffered(true);
        if (this.NUM_SAMPLES > 0) {
            this.deepCaps.setSampleBuffers(true);
            this.deepCaps.setNumSamples(this.NUM_SAMPLES);
        } else {
            this.deepCaps.setSampleBuffers(false);
        }
        this.deepCanvas = new GLCanvas(this.deepCaps);
        this.deepCanvas.addGLEventListener((GLEventListener)this.deepListener);
        this.deepCanvas.addKeyListener((KeyListener)this.deepListener);
        this.deepFrame.add((Component)this.deepCanvas);
        this.deepFrame.setSize(this.WIDTH, this.HEIGHT);
        this.deepFrame.setResizable(false);
        this.deepFrame.setAlwaysOnTop(true);
        this.deepFrame.setUndecorated(true);
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        Point point = graphicsEnvironment.getCenterPoint();
        this.deepFrame.setLocation(point.x - this.WIDTH / 2, point.y - this.HEIGHT / 2);
        if (this.isFullScreen) {
            graphicsDevice.setFullScreenWindow(this.deepFrame);
            int[] nArray = new int[256];
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, nArray, 0, 16));
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
            this.deepCanvas.setCursor(cursor);
        }
        this.deepFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Deep.this.stopDemo();
                System.exit(0);
            }
        });
        this.deepFrame.show();
        this.deepCanvas.requestFocusInWindow();
        this.animator = new FPSAnimator((GLAutoDrawable)this.deepCanvas, 60);
        this.animator.setRunAsFastAsPossible(true);
        this.animator.start();
    }

    public void stopDemo() {
        this.deepCanvas.removeGLEventListener((GLEventListener)this.deepListener);
        this.vgl = null;
        this.animator.stop();
        this.deepFrame.setVisible(false);
        this.deepFrame.dispose();
        this.deepFrame = null;
    }

    public void setupJOGL() {
        this.writelog("setupJOGL - start");
        this.aspectRatio = (float)this.WIDTH / (float)this.HEIGHT;
        this.eye = new Vector3();
        this.target = new Vector3();
        this.up = new Vector3(0.0f, 1.0f, 0.0f);
        this.lightPos = new Vector4(100.0f, 300.0f, 500.0f, 1.0f);
        this.jeye = new Vector3();
        this.jtarget = new Vector3();
        this.jellyEye = new Vector3();
        this.jellyTarget = new Vector3();
        this.writelog("setupJOGL - jellys init");
        this.jellys = new JellyScene();
        this.jellys.init();
        this.writelog("setupJOGL - grass init");
        this.grassScene = new GrassScene();
        this.grassScene.init(250);
        this.writelog("setupJOGL - landscape init");
        this.land = new Landscape(this.vgl.gl(), 75.0f, 75.0f, 180.0f, 64);
        this.writelog("setupJOGL - spikey init");
        this.spikey = new SpikeyScene();
        this.spikey.init();
        int n = 0;
        while (n < this.spikey._ballPos.size()) {
            Vector3Order vector3Order = (Vector3Order)((Object)this.spikey._ballPos.get(n));
            vector3Order.y = this.land.InterpolatedValue(vector3Order.x, vector3Order.z) + 100.0f;
            ++n;
        }
        this.writelog("setupJOGL - tactu init");
        this.tactu = new TactuScene();
        this.tactu.init();
        this.writelog("setupJOGL - backG init");
        this.backG = new XTexture(34037);
        this.backG.loadPImage("Comp1280.png");
        this.writelog("setupJOGL - deep2 init");
        this.deepTex = new XTexture("deep2.png");
        this.deepTex.setClampToEdge();
        this.writelog("setupJOGL - track play");
        this.track.play();
        this.writelog("setupJOGL - timer start");
        this.timer = new VTimer();
        this.timer.start();
        this.writelog("setupJOGL - end");
    }

    public void draw() {
    }

    public void drawJOGL() {
        this.time = this.timer.getCurrTime() + this.addTime;
        this.timer.update();
        this.renderDeep();
    }

    public void renderDeep() {
        float f;
        float f2;
        this.fogDensity = this.fogConstant + (0.5f - this.noise(this.land.eye.z * 0.2f, this.time * 0.01f)) * 1.0E-4f;
        this.lightPos.x = -400.0f;
        this.lightPos.y = 400.0f;
        this.lightPos.z = 2100.0f - this.time * 0.9f;
        this.vgl.begin();
        this.vgl.background(0.0f, 0.0f, 0.0f);
        if (this.time >= this.backgroundTime && this.time < this.bgEndTime) {
            this.vgl.ortho();
            this.vgl.pushMatrix();
            f2 = 1.0f;
            f = 1.0f - this.noise(this.land.eye.z * 0.05f, this.time * 0.01f) * 0.3f;
            if (f2 > f) {
                f2 = f * this.gamma;
            }
            if (this.time < this.fadeBGOutTime) {
                this.vgl.translate(0.0f, -0.2f, 0.0f);
                this.vgl.fill(1.0f * this.gamma, 1.0f);
            } else {
                this.vgl.translate(0.0f, -0.2f - (this.time - this.fadeBGOutTime) * 0.25f, 0.0f);
                this.vgl.fill(f2, 1.0f - (this.time - this.fadeBGOutTime) * 0.25f);
            }
            this.vgl.setDepthWrite(false);
            this.vgl.setDepthMask(false);
            this.vgl.setAlphaBlend();
            this.vgl.texCoordScale((float)this.WIDTH, (float)this.HEIGHT);
            this.backG.enable();
            this.vgl.rect(1.0f, 1.0f);
            this.backG.disable();
            this.vgl.texCoordScale(1.0f, 1.0f);
            this.vgl.popMatrix();
            if (this.time >= this.logoTime && this.time < this.logoTime + 20.0f) {
                this.vgl.pushMatrix();
                this.vgl.translate(0.6f + (this.time - this.logoTime) * 0.01f, 0.0f, 0.0f);
                this.vgl.setAdditiveBlend();
                if (this.time - this.logoTime < 10.0f) {
                    this.vgl.fill((this.time - this.logoTime) * 0.1f);
                } else {
                    this.vgl.fill(1.0f - (this.time - (this.logoTime + 10.0f)) * 0.1f);
                }
                this.deepTex.enable();
                this.vgl.rect(0.15f, 0.125f);
                this.deepTex.disable();
                this.vgl.popMatrix();
            }
            this.vgl.setDepthMask(true);
            this.vgl.setDepthWrite(true);
        }
        this.vgl.perspective(45.0f, this.aspectRatio, 1.0f, 6000.0f);
        if (this.time >= this.landTime && this.time < 337.0f) {
            this.vgl.setDepthWrite(true);
            this.vgl.setDepthMask(false);
            this.vgl.enableTexture(false);
            this.vgl.setAlphaBlend();
            f2 = (this.time - this.landTime) * 0.9f;
            this.land.eye.set(-400.0f, 300.0f, 2100.0f - f2 * 10.0f);
            this.land.target.set(-400.0f, 350.0f, 0.0f - f2 * 10.0f);
            this.vgl.camera(this.land.eye, this.land.target, this.up);
            this.land.invCamMatrix = this.vgl.getTransposeViewMatrix();
            this.land.draw();
        }
        if (this.time >= this.candlesTime && this.time < 337.0f) {
            this.eye = this.land.eye.copy();
            this.target = this.land.target.copy();
            this.grassScene.eye = this.land.eye.copy();
            this.grassScene.target = this.land.target.copy();
            this.vgl.camera(this.eye.x, this.eye.y, this.eye.z, this.target.x, this.target.y, this.target.z, this.up.x, this.up.y, this.up.z);
            this.grassScene.camMatrix = this.vgl.getViewMatrix();
            this.vgl.gl().glEnable(2912);
            this.vgl.gl().glFogi(2917, 2049);
            this.vgl.gl().glFogfv(2918, this.fogColorArray, 0);
            this.vgl.gl().glFogf(2914, this.fogDensity);
            this.grassScene.draw(this.time - this.candlesTime);
        }
        if (this.time > this.spikeyTime && this.time < 337.0f) {
            this.vgl.enableLighting(false);
            this.vgl.setDepthMask(false);
            this.vgl.setDepthWrite(true);
            this.vgl.setAlphaBlend();
            this.spikey.eye = this.land.eye.copy();
            this.spikey.target = this.land.target.copy();
            this.vgl.camera(this.spikey.eye, this.spikey.target, this.up);
            this.camMatrix = this.vgl.getViewMatrix();
            this.invCamMatrix = this.vgl.getTransposeViewMatrix();
            this.spikey.draw(this.time);
        }
        if (this.time >= this.planktonTime && this.time < 240.0f) {
            f2 = (this.time - this.planktonTime) * 0.1f;
            f = f2 * 2.0f;
            this.eye.set(50.0f + Deep.cos((float)f2) * 100.0f, -20.0f + Deep.sin((float)f) * 120.0f, 350.0f);
            this.target.set(50.0f, -20.0f, 0.0f);
            this.vgl.camera(this.eye, this.target, this.up);
            this.vgl.gl().glEnable(2912);
            this.vgl.gl().glFogi(2917, 2049);
            this.vgl.gl().glFogfv(2918, this.fogColorArray, 0);
            this.vgl.gl().glFogf(2914, this.fogDensity);
            this.jellys.drawPlankton(this.time - this.planktonTime);
            this.jellys.updatePlankton(this.time - this.planktonTime);
        }
        if (this.time >= this.jellyTime && this.time < 310.0f) {
            this.jellys.eye = this.land.eye.copy();
            this.jellys.target = this.land.target.copy();
            this.jeye = this.jellys.eye.copy();
            this.jtarget = this.jellys.target.copy();
            this.vgl.camera(this.jeye, this.jtarget, this.up);
            this.jellys.camMatrix = this.vgl.getViewMatrix();
            this.vgl.gl().glEnable(2912);
            this.vgl.gl().glFogi(2917, 2049);
            this.vgl.gl().glFogfv(2918, this.fogColorArray, 0);
            this.vgl.gl().glFogf(2914, this.fogDensity);
            this.jellys.drawJelly(this.time - this.jellyTime);
            this.jellys.updateJelly(this.time - this.jellyTime);
        }
        if (this.time >= this.tactuTime) {
            if (!this.playedOutsphere) {
                this.outsphere.trigger();
                this.playedOutsphere = true;
            }
            this.tactu.draw(this.time - this.tactuTime);
        }
        f2 = 10.0f;
        if (this.time >= 0.0f && this.time < f2) {
            f = 0.0f;
            f = 1.0f - this.time * 0.1f;
            if (f <= 0.0f) {
                f = 0.0f;
            }
            if (f >= 1.0f) {
                f = 1.0f;
            }
            this.vgl.ortho();
            this.vgl.gl().glDisable(2912);
            this.vgl.enableLighting(false);
            this.vgl.setDepthWrite(false);
            this.vgl.setDepthMask(false);
            this.vgl.setAlphaBlend();
            this.vgl.enableTexture(false);
            this.vgl.fill(0.0f, f);
            this.vgl.rect(1.0f, 1.0f);
            this.vgl.setDepthWrite(true);
            this.vgl.setDepthMask(true);
        }
        if (this.time >= this.endFadeOutTime) {
            f = 0.0f;
            f = (this.time - this.endFadeOutTime) * 0.1f;
            if (f <= 0.0f) {
                f = 0.0f;
            }
            if (f >= 1.0f) {
                f = 1.0f;
                this.isEndOfDemo = true;
            }
            this.vgl.ortho();
            this.vgl.gl().glDisable(2912);
            this.vgl.enableLighting(false);
            this.vgl.setDepthWrite(false);
            this.vgl.setAlphaBlend();
            this.vgl.enableTexture(false);
            this.vgl.fill(0.0f, f);
            this.vgl.rect(1.0f, 1.0f);
            this.vgl.setDepthWrite(true);
            this.ourcontrol1.setValue(this.endFadeOutTime - this.time);
            this.ourcontrol2.setValue(this.endFadeOutTime - this.time);
        }
        this.vgl.end();
        if (this.isEndOfDemo) {
            this.stopDemo();
            System.exit(0);
        }
    }

    public void stop() {
    }

    public void init_sound(int n, String string) {
        this.lastTime = 0.0f;
        this.currentTime = 0.0f;
        Ess.start((PApplet)this);
        Ess.masterVolume((float)1.0f);
        Deep.println((String)("loading " + string));
        this.chn = new AudioChannel(string);
        this.fft = new FFT(n * 2);
        this.fft.limits();
        this.fftbuffer = new float[n];
    }

    public void play_sound() {
        this.chn.play();
    }

    public void analyze(float f) {
        int n = (int)((float)this.frameNumber * this.chn.sampleRate / (float)this.framesPerSecond);
        if (n >= this.chn.size) {
            this.exit();
        }
        this.fft.getSpectrum(this.chn.samples, n);
        int n2 = 0;
        while (n2 < this.fft.spectrum.length) {
            this.fftbuffer[n2] = this.fft.spectrum[n2] * f;
            ++n2;
        }
    }

    public void store(String string, String string2, String string3) {
        this.saveFrame(String.valueOf(string2) + "\\" + string + "_" + Deep.nf((int)this.frameNumber, (int)7) + "." + string3);
    }

    public void advance() {
        if (this.frameNumber % this.framesPerSecond == 0) {
            this.lastTime = this.currentTime;
            this.currentTime = (float)this.millis() * 0.001f - this.startTime;
            Deep.println((String)("Frame: " + this.frameNumber + " | time: " + this.currentTime / 60.0f / 60.0f + "h" + " | average time per frame: " + (this.currentTime - this.lastTime) / 30.0f + " secs"));
        }
        ++this.frameNumber;
    }

    public void volume(float f) {
        Ess.masterVolume((float)f);
    }

    public void stop_sound() {
        this.chn.stop();
        Ess.stop();
    }

    public void glReverseCamera(Vector3 vector3, Vector3 vector32) {
        float f = vector3.x - vector32.x;
        float f2 = vector3.y - vector32.y;
        float f3 = vector3.z - vector32.z;
        float f4 = Deep.atan2((float)f2, (float)f);
        float f5 = Deep.sqrt((float)(Deep.sq((float)f) + Deep.sq((float)f2)));
        float f6 = Deep.atan2((float)f5, (float)f3);
        this.vgl.gl().glRotatef(Deep.degrees((float)f4) + 90.0f, 0.0f, 0.0f, 1.0f);
        this.vgl.gl().glRotatef(Deep.degrees((float)f6), 0.0f, 1.0f, 0.0f);
    }

    public void glReverseCamera2(Vector3 vector3, Vector3 vector32) {
        float f = vector3.x - vector32.x;
        float f2 = vector3.y - vector32.y;
        float f3 = vector3.z - vector32.z;
        float f4 = Deep.atan2((float)f2, (float)f);
        float f5 = Deep.sqrt((float)(Deep.sq((float)f) + Deep.sq((float)f2)));
        Deep.atan2((float)f5, (float)f3);
        this.vgl.gl().glRotatef(Deep.degrees((float)f4), 0.0f, 0.0f, 1.0f);
    }

    public void glReverseCameraJelly(Vector3 vector3, Vector3 vector32) {
        float f = vector3.x - vector32.x;
        float f2 = vector3.y - vector32.y;
        float f3 = vector3.z - vector32.z;
        float f4 = Deep.atan2((float)f2, (float)f);
        float f5 = Deep.sqrt((float)(Deep.sq((float)f) + Deep.sq((float)f2)));
        Deep.atan2((float)f5, (float)f3);
        if (f4 > -0.62831855f && f4 < 0.62831855f) {
            this.vgl.gl().glRotatef(Deep.degrees((float)f4), 0.0f, 0.0f, 1.0f);
        }
    }

    public void box(float f, float f2, float f3) {
        Vector3 vector3 = new Vector3(-f, -f2, -f3);
        Vector3 vector32 = new Vector3(f, f2, f3);
        this.vgl.gl().glBegin(3);
        this.vgl.gl().glVertex3f(vector3.x, vector3.y, vector3.z);
        this.vgl.gl().glVertex3f(vector32.x, vector3.y, vector3.z);
        this.vgl.gl().glVertex3f(vector32.x, vector3.y, vector32.z);
        this.vgl.gl().glVertex3f(vector3.x, vector3.y, vector32.z);
        this.vgl.gl().glVertex3f(vector3.x, vector3.y, vector3.z);
        this.vgl.gl().glVertex3f(vector3.x, vector32.y, vector3.z);
        this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector3.z);
        this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector32.z);
        this.vgl.gl().glVertex3f(vector3.x, vector32.y, vector32.z);
        this.vgl.gl().glVertex3f(vector3.x, vector32.y, vector3.z);
        this.vgl.gl().glEnd();
        this.vgl.gl().glBegin(1);
        this.vgl.gl().glVertex3f(vector32.x, vector3.y, vector3.z);
        this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector3.z);
        this.vgl.gl().glEnd();
        this.vgl.gl().glBegin(1);
        this.vgl.gl().glVertex3f(vector32.x, vector3.y, vector32.z);
        this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector32.z);
        this.vgl.gl().glEnd();
        this.vgl.gl().glBegin(1);
        this.vgl.gl().glVertex3f(vector3.x, vector3.y, vector32.z);
        this.vgl.gl().glVertex3f(vector3.x, vector32.y, vector32.z);
        this.vgl.gl().glEnd();
    }

    public void buildSphere(int n, int n2, float f) {
        int n3;
        Vector3 vector3 = new Vector3(0.0f, 0.0f, 0.0f);
        this.sphereStacks = n;
        this.sphereSlices = n2;
        float f2 = f;
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3();
        int n4 = n2;
        int n5 = (n + 1) * n2;
        this.sphereSurface = new Vector3[n5];
        this.sphereSurfaceNormal = new Vector3[n5];
        this.sphereSurfaceUV = new Vector3[n5];
        int n6 = 0;
        while (n6 < n5) {
            this.sphereSurface[n6] = new Vector3();
            this.sphereSurfaceNormal[n6] = new Vector3();
            this.sphereSurfaceUV[n6] = new Vector3();
            ++n6;
        }
        n6 = 0;
        while (n6 < n + 1) {
            n3 = 0;
            while (n3 < n2) {
                float f3 = (float)n6 * (float)Math.PI / (float)n;
                float f4 = (float)(n3 * 2) * (float)Math.PI / (float)n2;
                float f5 = Deep.sin((float)f3);
                float f6 = Deep.sin((float)f4);
                float f7 = Deep.cos((float)f3);
                float f8 = Deep.cos((float)f4);
                float f9 = 1.0f - (float)n3 / PApplet.parseFloat((int)(n2 - 1));
                f9 *= 3.0f;
                float f10 = (float)n6 / PApplet.parseFloat((int)n);
                vector32.x = f8 * f5;
                vector32.y = f7;
                vector32.z = f6 * f5;
                vector33.x = vector3.x + f2 * vector32.x;
                vector33.y = vector3.y + f2 * vector32.y;
                vector33.z = vector3.z + f2 * vector32.z;
                int n7 = n6 * n4 + n3;
                this.sphereSurface[n7].x = vector33.x;
                this.sphereSurface[n7].y = vector33.y;
                this.sphereSurface[n7].z = vector33.z;
                this.sphereSurfaceNormal[n7].x = vector32.x;
                this.sphereSurfaceNormal[n7].y = vector32.y;
                this.sphereSurfaceNormal[n7].z = vector32.z;
                this.sphereSurfaceUV[n7].x = f9;
                this.sphereSurfaceUV[n7].y = f10;
                ++n3;
            }
            ++n6;
        }
        n3 = 0;
        while (n3 < n + 1) {
            this.sphereSurface[n3 * n2 + n2 - 1].x = this.sphereSurface[n3 * n2 + 0].x;
            this.sphereSurface[n3 * n2 + n2 - 1].y = this.sphereSurface[n3 * n2 + 0].y;
            this.sphereSurface[n3 * n2 + n2 - 1].z = this.sphereSurface[n3 * n2 + 0].z;
            this.sphereSurfaceNormal[n3 * n2 + n2 - 1].x = this.sphereSurfaceNormal[n3 * n2 + 0].x;
            this.sphereSurfaceNormal[n3 * n2 + n2 - 1].y = this.sphereSurfaceNormal[n3 * n2 + 0].y;
            this.sphereSurfaceNormal[n3 * n2 + n2 - 1].z = this.sphereSurfaceNormal[n3 * n2 + 0].z;
            ++n3;
        }
        this.sphereIndices = new int[n5 * 2];
        int n8 = 0;
        n6 = 0;
        while (n6 < n) {
            n3 = 0;
            while (n3 < n2) {
                this.sphereIndices[n8 + 0] = n6 * n2 + n3 % n2;
                this.sphereIndices[n8 + 0] = (n6 + 1) * n2 + n3 % n2;
                ++n3;
            }
            ++n6;
        }
    }

    public void drawSphere(float f, float f2, float f3, float f4) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.sphereStacks) {
            n = n3 * this.sphereSlices;
            n2 = (n3 + 1) * this.sphereSlices;
            this.vgl.gl().glBegin(5);
            this.vgl.gl().glColor4f(this.vgl._r, this.vgl._g, this.vgl._b, this.vgl._a);
            int n4 = 0;
            while (n4 < this.sphereSlices) {
                float f5 = this.sphereSurface[n + n4].x * f4;
                float f6 = this.sphereSurface[n + n4].y * f4;
                float f7 = this.sphereSurface[n + n4].z * f4;
                float f8 = this.sphereSurface[n2 + n4].x * f4;
                float f9 = this.sphereSurface[n2 + n4].y * f4;
                float f10 = this.sphereSurface[n2 + n4].z * f4;
                float f11 = this.sphereSurfaceNormal[n + n4].x;
                float f12 = this.sphereSurfaceNormal[n + n4].y;
                float f13 = this.sphereSurfaceNormal[n + n4].z;
                float f14 = this.sphereSurfaceNormal[n2 + n4].x;
                float f15 = this.sphereSurfaceNormal[n2 + n4].y;
                float f16 = this.sphereSurfaceNormal[n2 + n4].z;
                this.vgl.gl().glNormal3f(f11, f12, f13);
                this.vgl.gl().glVertex3f(f5, f6, f7);
                this.vgl.gl().glNormal3f(f14, f15, f16);
                this.vgl.gl().glVertex3f(f8, f9, f10);
                ++n4;
            }
            this.vgl.gl().glEnd();
            ++n3;
        }
    }

    public void drawSphereTextured(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.sphereStacks) {
            n = n3 * this.sphereSlices;
            n2 = (n3 + 1) * this.sphereSlices;
            this.vgl.gl().glBegin(5);
            this.vgl.gl().glColor4f(this.vgl._r, this.vgl._g, this.vgl._b, this.vgl._a);
            int n4 = 0;
            while (n4 < this.sphereSlices) {
                float f4 = this.sphereSurface[n + n4].x + f;
                float f5 = this.sphereSurface[n + n4].y + f2;
                float f6 = this.sphereSurface[n + n4].z + f3;
                float f7 = this.sphereSurface[n2 + n4].x + f;
                float f8 = this.sphereSurface[n2 + n4].y + f2;
                float f9 = this.sphereSurface[n2 + n4].z + f3;
                float f10 = this.sphereSurfaceNormal[n + n4].x + f;
                float f11 = this.sphereSurfaceNormal[n + n4].y + f2;
                float f12 = this.sphereSurfaceNormal[n + n4].z + f3;
                float f13 = this.sphereSurfaceNormal[n2 + n4].x + f;
                float f14 = this.sphereSurfaceNormal[n2 + n4].y + f2;
                float f15 = this.sphereSurfaceNormal[n2 + n4].z + f3;
                this.vgl.gl().glColor4f(this.vgl._r, this.vgl._g, this.vgl._b, this.vgl._a);
                this.vgl.gl().glNormal3f(f10, f11, f12);
                this.vgl.gl().glTexCoord2f(this.sphereSurfaceUV[n + n4].x, this.sphereSurfaceUV[n + n4].y);
                this.vgl.gl().glVertex3f(f4, f5, f6);
                this.vgl.gl().glColor4f(this.vgl._r, this.vgl._g, this.vgl._b, this.vgl._a);
                this.vgl.gl().glNormal3f(f13, f14, f15);
                this.vgl.gl().glTexCoord2f(this.sphereSurfaceUV[n2 + n4].x, this.sphereSurfaceUV[n2 + n4].y);
                this.vgl.gl().glVertex3f(f7, f8, f9);
                ++n4;
            }
            this.vgl.gl().glEnd();
            ++n3;
        }
    }

    public void sphere(float f, int n, boolean bl) {
        int n2 = n;
        float f2 = 1.0f / (float)n2;
        float f3 = f;
        float f4 = (float)Math.PI;
        float f5 = 1.5707964f;
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3();
        if (!bl) {
            this.vgl.gl().glPolygonMode(1032, 6913);
        }
        int n3 = 0;
        while (n3 < n2 * 2) {
            double d = -f5 + (float)n3 * f4 * (f2 * 0.5f);
            double d2 = -f5 + (float)(n3 + 1) * f4 * (f2 * 0.5f);
            this.vgl.gl().glBegin(8);
            this.vgl.gl().glColor4f(this.vgl._r, this.vgl._g, this.vgl._b, this.vgl._a);
            int n4 = 0;
            while (n4 <= n2) {
                double d3 = (float)n4 * f4 * 2.0f * f2;
                vector3.x = (float)Math.cos(d) * (float)Math.cos(d3);
                vector3.y = (float)Math.sin(d);
                vector3.z = (float)Math.cos(d) * (float)Math.sin(d3);
                vector32.x = vector33.x + f3 * vector3.x;
                vector32.y = vector33.y + f3 * vector3.y;
                vector32.z = vector33.z + f3 * vector3.z;
                this.vgl.gl().glNormal3f(vector3.x, vector3.y, vector3.z);
                this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector32.z);
                vector3.x = (float)Math.cos(d2) * (float)Math.cos(d3);
                vector3.y = (float)Math.sin(d2);
                vector3.z = (float)Math.cos(d2) * (float)Math.sin(d3);
                vector32.x = vector33.x + f3 * vector3.x;
                vector32.y = vector33.y + f3 * vector3.y;
                vector32.z = vector33.z + f3 * vector3.z;
                this.vgl.gl().glNormal3f(vector3.x, vector3.y, vector3.z);
                this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector32.z);
                ++n4;
            }
            this.vgl.gl().glEnd();
            ++n3;
        }
        if (!bl) {
            this.vgl.gl().glPolygonMode(1032, 6914);
        }
    }

    public void sphereTextured(float f, int n, boolean bl) {
        int n2 = n;
        float f2 = 1.0f / (float)n2;
        float f3 = 1.0f / (float)n2 * 2.0f;
        float f4 = f;
        float f5 = (float)Math.PI;
        float f6 = 1.5707964f;
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3();
        int n3 = 0;
        while (n3 < n2) {
            double d = -f6 + (float)n3 * f5 * (f2 * 0.5f);
            double d2 = -f6 + (float)(n3 + 1) * f5 * (f3 * 0.5f);
            this.vgl.gl().glBegin(8);
            this.vgl.gl().glColor4f(this.vgl._r, this.vgl._g, this.vgl._b, this.vgl._a);
            int n4 = 0;
            while (n4 <= n2) {
                double d3 = (float)n4 * f5 * 2.0f * f2;
                float f7 = (float)n4 / (float)n2;
                float f8 = (float)n3 / (float)n2;
                float f9 = (float)(n3 + 1) / (float)n2;
                vector3.x = (float)Math.cos(d) * (float)Math.cos(d3);
                vector3.y = (float)Math.sin(d);
                vector3.z = (float)Math.cos(d) * (float)Math.sin(d3);
                vector32.x = vector33.x + f4 * vector3.x;
                vector32.y = vector33.y + f4 * vector3.y;
                vector32.z = vector33.z + f4 * vector3.z;
                this.vgl.gl().glNormal3f(vector3.x, vector3.y, vector3.z);
                this.vgl.gl().glTexCoord2f(f7, f8);
                this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector32.z);
                vector3.x = (float)Math.cos(d2) * (float)Math.cos(d3);
                vector3.y = (float)Math.sin(d2);
                vector3.z = (float)Math.cos(d2) * (float)Math.sin(d3);
                vector32.x = vector33.x + f4 * vector3.x;
                vector32.y = vector33.y + f4 * vector3.y;
                vector32.z = vector33.z + f4 * vector3.z;
                this.vgl.gl().glNormal3f(vector3.x, vector3.y, vector3.z);
                this.vgl.gl().glTexCoord2f(f7, f9);
                this.vgl.gl().glVertex3f(vector32.x, vector32.y, vector32.z);
                ++n4;
            }
            this.vgl.gl().glEnd();
            ++n3;
        }
    }

    public void setupPointLight(Vector3 vector3) {
        GL gL = this.vgl.gl();
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float[] fArray2 = new float[]{0.01f, 0.01f, 0.01f, 0.0f};
        float[] fArray3 = new float[]{0.9f, 0.9f, 0.9f, 1.0f};
        float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] fArray5 = new float[]{64.0f};
        float[] fArray6 = new float[]{vector3.x, vector3.y, vector3.z, 1.0f};
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray2);
        gL.glLightfv(16385, 4608, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray3);
        gL.glLightfv(16385, 4609, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray4);
        gL.glLightfv(16385, 4610, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray6);
        gL.glLightfv(16385, 4611, floatBuffer);
        gL.glEnable(16385);
        gL.glEnable(2896);
        gL.glEnable(2903);
        floatBuffer = FloatBuffer.wrap(fArray);
        gL.glMaterialfv(1032, 4608, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray3);
        gL.glMaterialfv(1032, 4609, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray5);
        gL.glMaterialfv(1032, 5633, floatBuffer);
        floatBuffer = FloatBuffer.wrap(fArray4);
        gL.glMaterialfv(1032, 4610, floatBuffer);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#d4d0c8", "Deep"});
    }

    class CylinderRoll {
        float minNoise;
        float maxNoise;
        int _facets;
        int[] yTable;
        Vector3[] _vertices;
        Vector3[] _texcoords;
        Vector3[] _normals;
        Vector4 _colour;
        boolean _doRenderHead;
        boolean _doUpdate;
        float _age;
        float _agePer;
        float _timeToLive;
        float _invTimeToLive;
        Vector3 _initPos;
        float _headSize;
        Vector3 _head;
        Vector3 _right;
        Vector3 _target;
        Vector3 _add;
        float _damp;
        boolean _usePerlin;
        Vector3 _perlin;
        float _dispoffset;
        float _displaces;
        float _dispscale;
        float _tailWidth;
        int _tailRenderSegments;
        int _tailSize;
        Vector3[] _tail;
        int _flowerCount;
        int _numFlowers;
        ArrayList _flowers;
        ArrayList _flowersSizeValue;
        ArrayList _flowersDir;

        CylinderRoll() {
            this.minNoise = 0.499f;
            this.maxNoise = 0.501f;
            this._doRenderHead = true;
            this._doUpdate = true;
            this._tailSize = 100;
            this._tailRenderSegments = 0;
            this._tailWidth = 11.0f;
            this._initPos = new Vector3();
            this._headSize = 24.0f;
            this._head = new Vector3();
            this._target = new Vector3();
            this._right = new Vector3();
            this._usePerlin = false;
            this._perlin = new Vector3();
            this._add = new Vector3();
            this._damp = 0.95f;
            this._age = 0.0f;
            this._agePer = 0.0f;
            this._timeToLive = 100.0f;
            this._invTimeToLive = 1.0f / this._timeToLive;
            this._facets = 5;
            this._colour = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
            this._flowerCount = 0;
            this._numFlowers = 20;
            this._flowers = new ArrayList();
            this._flowersSizeValue = new ArrayList();
            this._flowersDir = new ArrayList();
            this._dispoffset = 0.0f;
            this._displaces = 0.0f;
            this._dispscale = 9.0f;
        }

        CylinderRoll(int n, float f, float f2, boolean bl) {
            this._doRenderHead = bl;
            this._doUpdate = true;
            this._tailSize = n;
            this._tailRenderSegments = 0;
            this._tailWidth = f;
            this._initPos = new Vector3();
            this._headSize = f2;
            this._head = new Vector3();
            this._target = new Vector3();
            this._right = new Vector3();
            this._usePerlin = false;
            this._perlin = new Vector3();
            this._add = new Vector3();
            this._damp = 0.95f;
            this._age = 0.0f;
            this._agePer = 0.0f;
            this._timeToLive = 100.0f;
            this._invTimeToLive = 1.0f / this._timeToLive;
            this._colour = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
            this._facets = 8;
            this._dispoffset = 0.0f;
            this._displaces = 0.0f;
            this._dispscale = 9.0f;
        }

        public float getRads(float f, float f2, float f3, float f4) {
            float f5 = Deep.this.noise(f / f4, f2 / f4, (float)Deep.this.frameCount / f4);
            if (f5 < this.minNoise) {
                this.minNoise = f5;
            }
            if (f5 > this.maxNoise) {
                this.maxNoise = f5;
            }
            f5 -= this.minNoise;
            return (f5 *= 1.0f / (this.maxNoise - this.minNoise)) * f3;
        }

        public void setCylinderDetail(int n) {
            this._facets = n;
        }

        public void setCylinderRadius(int n) {
            this._tailWidth = n;
        }

        public void findPerlin() {
            float f = this.getRads(this._head.x, this._head.z, 5.0f, 15.0f);
            float f2 = this.getRads(this._head.x, this._head.y, 5.0f, 15.0f);
            this._perlin.set(Deep.cos((float)(5.2f * f)), Deep.sin((float)(4.0f * f2)), Deep.sin((float)(5.2f * f)));
            this._perlin.mul(2.85f);
        }

        public void computeTail() {
            if (this._tail == null) {
                this._tail = new Vector3[this._tailSize];
            }
            int n = 0;
            while (n < this._tailSize) {
                this._tail[n] = new Vector3();
                this._tail[n] = this._head.copy();
                ++n;
            }
            this.yTable = new int[this._tailSize];
            n = 0;
            while (n < this._tailSize) {
                this.yTable[n] = n * (this._facets + 1);
                ++n;
            }
            this._vertices = new Vector3[this._tailSize * (this._facets + 1)];
            this._normals = new Vector3[this._tailSize * (this._facets + 1)];
            this._texcoords = new Vector3[this._tailSize * (this._facets + 1)];
            n = 0;
            while (n < this._tailSize * (this._facets + 1)) {
                this._vertices[n] = new Vector3();
                this._normals[n] = new Vector3();
                this._texcoords[n] = new Vector3();
                ++n;
            }
        }

        public boolean isDead() {
            return this._age >= this._timeToLive;
        }

        public void setTailSize(int n) {
            this._tailSize = n;
            this.computeTail();
        }

        public void setTimeToLive(float f) {
            this._timeToLive = f;
            this._invTimeToLive = 1.0f / this._timeToLive;
        }

        public void setHeadY(float f) {
            this._head.y = f;
            this._initPos = this._head.copy();
        }

        public void setHead(float f, float f2) {
            this._head.set(f, f2, 0.0f);
            this._initPos = this._head.copy();
            this._target = this._head.copy();
        }

        public void setHead(float f, float f2, float f3) {
            this._head.set(f, f2, f3);
            this._initPos = this._head.copy();
        }

        public void setHead(Vector3 vector3) {
            this._head = vector3;
            this._initPos = this._head.copy();
        }

        public void addHead(float f, float f2) {
            if (!this._usePerlin) {
                this._head.add(f, f2, 0.0f);
            }
        }

        public void addHead(float f, float f2, float f3) {
            if (!this._usePerlin) {
                this._head.x += f;
                this._head.y += f2;
                this._head.z += f3;
            }
        }

        public void addHead(Vector3 vector3) {
            if (!this._usePerlin) {
                this._head.add(vector3);
            }
        }

        public void renderHead(boolean bl) {
            this._doRenderHead = bl;
        }

        public void update(float f) {
            if (this._age < this._timeToLive) {
                if (this._tailRenderSegments < this._tailSize) {
                    int n = this._tailRenderSegments;
                    while (n > 0) {
                        this._tail[n] = this._tail[n - 1];
                        --n;
                    }
                    this._tail[0] = this._head.copy();
                    ++this._tailRenderSegments;
                } else {
                    this._doUpdate = false;
                }
            }
            if (this._usePerlin) {
                float f2 = 200.0f;
                float f3 = 60.0f;
                float f4 = Vector3.distance((Vector3)this._head, (Vector3)this._target);
                if (f4 < f2) {
                    this._target.x += Deep.this.random(-f3, f3);
                    this._target.y += Deep.this.random(-f3, f3);
                    this._target.z += Deep.this.random(-f3, f3);
                }
                this._add.x += (this._target.x - this._head.x) * 0.002f;
                this._add.y += (this._target.y - this._head.y) * 0.002f;
                this._add.z += (this._target.z - this._head.z) * 0.002f;
                this._add.mul(0.97f);
                this._head.add(this._add);
            } else if (this._doUpdate) {
                this._head.add(this._add);
            }
            this._age += 1.0f;
            this._agePer = this._age * this._invTimeToLive;
        }

        public void draw(float f) {
            if (this._age < this._timeToLive) {
                this.renderTailCylinder();
                if (!this._doUpdate) {
                    this._head = this._tail[0].copy();
                }
            }
        }

        public void drawCylinder(float f) {
            if (this._age < this._timeToLive) {
                Deep.this.vgl.gl().glDisable(2884);
                Deep.this.vgl.setDepthWrite(true);
                Deep.this.vgl.setAlphaBlend();
                this.renderTailCylinder();
            }
        }

        public void renderBase() {
        }

        public void renderHead() {
            Deep.this.vgl.setDepthWrite(false);
            Deep.this.vgl.setAlphaBlend();
            Deep.this.vgl.fill(1.0f, 1.0f - this._agePer);
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this._head.x, this._head.y, this._head.z);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.quad(this._headSize);
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.setDepthWrite(true);
        }

        public void renderTail(float f) {
            Deep.this.vgl.gl().glBegin(8);
            int n = 0;
            while (n < this._tailSize - 1) {
                float f2 = (float)n / (float)this._tailSize;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                Vector3 vector3 = Vector3.sub((Vector3)this._tail[n + 1], (Vector3)this._tail[n]);
                vector3.normalize();
                Vector3 vector32 = vector3.cross(new Vector3(0.0f, 1.0f, 0.0f));
                vector32.normalize();
                Vector3 vector33 = vector3.cross(vector32);
                vector33.normalize();
                vector32 = vector33.cross(vector3);
                vector32.normalize();
                this._right = vector32.copy();
                float f3 = this._tail[n].x + this._right.x * Deep.sin((float)((float)n * 0.2f + f * 8.0f)) * 3.0f * (float)(this._tailSize - n) * 0.053f;
                float f4 = this._tail[n].y - 30.0f;
                float f5 = this._tail[n].z + this._right.z * Deep.sin((float)((float)n * 0.2f + f * 8.0f)) * 3.0f * (float)(this._tailSize - n) * 0.053f;
                float f6 = vector32.x * this._tailWidth * f2 * 1.5f;
                float f7 = vector32.y * this._tailWidth * f2 * 1.5f;
                float f8 = vector32.z * this._tailWidth * f2 * 1.5f;
                Deep.this.vgl.gl().glColor4f(0.0f, 0.0f, 0.0f, 1.0f - this._agePer);
                Deep.this.vgl.gl().glVertex3f(f3 - f6, f4 - f7, f5 - f8);
                Deep.this.vgl.gl().glVertex3f(f3 + f6, f4 + f7, f5 + f8);
                ++n;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void transformRect(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3[] vector3Array) {
            int n = 0;
            while (n < 4) {
                Vector3 vector34 = vector3Array[n];
                Vector3 vector35 = new Vector3(vector34.x, vector34.y, vector34.z);
                Vector3 vector36 = vector3.copy();
                vector36.normalize();
                Vector3 vector37 = vector32.copy();
                vector37.normalize();
                Vector3 vector38 = vector36.cross(vector37);
                vector38.normalize();
                float f = vector36.dot(vector37);
                float f2 = Deep.acos((float)f);
                Quaternion quaternion = new Quaternion();
                quaternion.rotateAxis(vector38, f2);
                Vector3 vector39 = quaternion.mul(vector35);
                vector34.set(vector39);
                vector34.add(vector33);
                ++n;
            }
        }

        public void renderTailCylinder() {
            float f;
            float f2 = 1.0f / (float)(this._tailSize - 1);
            float f3 = 1.0f / (float)this._facets;
            float f4 = (float)Math.PI * 2 / (float)(this._tailSize - 1);
            float f5 = (float)Math.PI * 2 / (float)this._facets;
            int n = 0;
            while (n < this._tailRenderSegments - 1) {
                f = 0.0f;
                float f6 = this._tailSize;
                float f7 = 1.0f * this._tailWidth;
                f = f7 - Deep.min((float)(f7 * (float)(Deep.min((int)this._tailSize, (int)this._tailRenderSegments) - n) / f6), (float)f7);
                Vector3 vector3 = new Vector3();
                vector3 = this._tail[n];
                Vector3 vector32 = new Vector3();
                vector32 = this._tail[n + 1];
                Vector3 vector33 = new Vector3();
                vector33.x = vector32.x - vector3.x;
                vector33.y = vector32.y - vector3.y;
                vector33.z = vector32.z - vector3.z;
                vector33.normalize();
                Vector3 vector34 = new Vector3(0.0f, 1.0f, 0.0f);
                Vector3 vector35 = vector33.cross(vector34);
                vector35.normalize();
                vector34 = vector35.cross(vector33);
                vector35.normalize();
                vector34.normalize();
                if (n == 0) {
                    this._right = vector34.copy();
                }
                int n2 = 0;
                while (n2 < this._facets + 1) {
                    float f8 = Deep.sin((float)((float)n2 * f5)) * f;
                    float f9 = Deep.cos((float)((float)n2 * f5)) * f;
                    if (this._displaces != 0.0f) {
                        f8 *= 1.0f + Deep.sin((float)(this._dispoffset + this._displaces * (float)n * f4)) * this._dispscale;
                        f9 *= 1.0f + Deep.cos((float)(this._dispoffset + this._displaces * (float)n * f4)) * this._dispscale;
                    }
                    int n3 = this.yTable[n] + n2;
                    this._vertices[n3].x = vector34.x * f8 + vector35.x * f9 + vector3.x;
                    this._vertices[n3].y = vector34.y * f8 + vector35.y * f9 + vector3.y;
                    this._vertices[n3].z = vector34.z * f8 + vector35.z * f9 + vector3.z;
                    this._texcoords[n3].x = (float)n2 / (float)this._facets * 1.0f;
                    this._texcoords[n3].y = (float)n / (float)this._tailRenderSegments * 10.0f;
                    this._normals[n3].x = this._vertices[n3].x - vector3.x;
                    this._normals[n3].y = this._vertices[n3].y - vector3.y;
                    this._normals[n3].z = this._vertices[n3].z - vector3.z;
                    this._normals[n3].normalize();
                    ++n2;
                }
                n2 = this.yTable[n] + 0;
                int n4 = this.yTable[n] + this._facets;
                this._vertices[n4].x = this._vertices[n2].x;
                this._vertices[n4].y = this._vertices[n2].y;
                this._vertices[n4].z = this._vertices[n2].z;
                this._texcoords[n4].x = this._texcoords[n2].x;
                this._texcoords[n4].y = this._texcoords[n2].y;
                this._normals[n4].x = this._normals[n2].x;
                this._normals[n4].y = this._normals[n2].y;
                this._normals[n4].z = this._normals[n2].z;
                ++n;
            }
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.enableTexture(false);
            n = 0;
            f = 10.0f;
            float cfr_ignored_0 = f * (float)n * f2;
            float cfr_ignored_1 = f * (float)(n + 1) * f2;
            n = 0;
            while (n < this._tailRenderSegments - 2) {
                Deep.this.vgl.gl().glBegin(5);
                int n5 = 0;
                while (n5 < this._facets + 1) {
                    Deep.this.vgl.gl().glColor4f(this._colour.x, this._colour.y, this._colour.z, 1.0f);
                    Deep.this.vgl.gl().glNormal3f(this._normals[this.yTable[n] + n5].x, this._normals[this.yTable[n] + n5].y, this._normals[this.yTable[n] + n5].z);
                    Deep.this.vgl.gl().glTexCoord2f(this._texcoords[this.yTable[n] + n5].x, this._texcoords[this.yTable[n] + n5].y);
                    Deep.this.vgl.gl().glVertex3f(this._vertices[this.yTable[n] + n5].x, this._vertices[this.yTable[n] + n5].y, this._vertices[this.yTable[n] + n5].z);
                    Deep.this.vgl.gl().glNormal3f(this._normals[this.yTable[n + 1] + n5].x, this._normals[this.yTable[n + 1] + n5].y, this._normals[this.yTable[n + 1] + n5].z);
                    Deep.this.vgl.gl().glTexCoord2f(this._texcoords[this.yTable[n + 1] + n5].x, this._texcoords[this.yTable[n + 1] + n5].y);
                    Deep.this.vgl.gl().glVertex3f(this._vertices[this.yTable[n + 1] + n5].x, this._vertices[this.yTable[n + 1] + n5].y, this._vertices[this.yTable[n + 1] + n5].z);
                    ++n5;
                }
                Deep.this.vgl.gl().glEnd();
                ++n;
            }
        }

        public void reset(Vector3 vector3, float f) {
            this.setHead(vector3);
            this.computeTail();
            this.setTimeToLive(f);
            this._tailRenderSegments = 0;
            this._age = 0.0f;
            this._doUpdate = true;
            if (Deep.this.random(100.0f) > 50.0f) {
                this._colour.set(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this._colour.set(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    class EmitterJelly {
        Vector3 loc;
        Vector3 vel;
        Vector3 accel;
        float radius;
        Vector3 myColor;
        JellyComparator comparator;
        ArrayList particles;
        ArrayList particlesViewSpace;
        int maxParticles;
        int particleCount;
        int _nebulaTexID;
        int _tailTexID;

        EmitterJelly(Vector3 vector3, int n) {
            this.loc = vector3;
            this.vel = new Vector3();
            this.accel = new Vector3();
            this.maxParticles = n;
            this.radius = 30.0f;
            this.myColor = new Vector3(1.0f, 1.0f, 1.0f);
            this.comparator = new JellyComparator();
            this.particles = new ArrayList();
            this.particlesViewSpace = new ArrayList();
            this.particleCount = 0;
            this._nebulaTexID = -1;
            this._tailTexID = -1;
        }

        public void update(float f) {
            this.findAccel(f);
            this.vel.add(this.accel);
            this.accel.mul(0.0f);
            this.vel.mul(0.75f);
        }

        public void findAccel(float f) {
            Vector3 vector3 = new Vector3();
            vector3.x = (Deep.this.noise(f * 0.1f, Deep.cos((float)(f * 0.25f)) * 1.0f, f * 0.2f) - 0.5f) * 0.2f;
            vector3.y = (Deep.this.noise(f * 0.1f, Deep.sin((float)(f * 0.25f)) * 1.0f, f * 0.2f) - 0.5f) * 0.2f;
            this.accel.add(vector3);
        }

        public void draw(int n, float f) {
            Object object;
            this.particlesViewSpace.clear();
            int n2 = 0;
            while (n2 < this.particles.size()) {
                Vector3 vector3 = ((ParticleJelly)this.particles.get((int)n2)).pos;
                object = Vector3.transform((Vector3)vector3, (Matrix)Deep.this.jellys.camMatrix);
                this.particlesViewSpace.add(new Vector3Order((Vector3)object, n2));
                ++n2;
            }
            Collections.sort(this.particlesViewSpace, this.comparator);
            n2 = 0;
            while (n2 < this.particles.size()) {
                int n3 = ((Vector3Order)((Object)this.particlesViewSpace.get((int)n2))).idx;
                object = (ParticleJelly)this.particles.get(n3);
                if (((ParticleJelly)object).ISSPLIT) {
                    this.addParticles((ParticleJelly)object);
                }
                if (!((ParticleJelly)object).ISDEAD) {
                    ((ParticleJelly)object)._nebulaTexID = this._nebulaTexID;
                    ((ParticleJelly)object)._tailTexID = this._tailTexID;
                    ((ParticleJelly)object).setTexture(n);
                    ((ParticleJelly)object).draw(f);
                    ((ParticleJelly)object).update(f);
                }
                ++n2;
            }
        }

        public void addParticles(int n) {
            int n2 = 0;
            while (n2 < n) {
                this.particles.add(new ParticleJelly(this.particleCount + 1, 1, this.loc, this.vel));
                ++this.particleCount;
                ++n2;
            }
        }

        public void addParticle(Vector3 vector3) {
            this.particles.add(new ParticleJelly(this.particleCount + 1, 1, vector3, this.vel));
            ++this.particleCount;
        }

        public void addParticles(int n, Vector3 vector3) {
            int n2 = 0;
            while (n2 < n) {
                this.particles.add(new ParticleJelly(this.particleCount + 1, 1, vector3, this.vel));
                ++this.particleCount;
                ++n2;
            }
        }

        public void addParticles(ParticleJelly particleJelly) {
            int n = (int)(particleJelly.radius * 0.15f);
            int n2 = 0;
            while (n2 < n) {
                this.particles.add(new ParticleJelly(this.particleCount + 1, particleJelly.gen + 1, particleJelly.pos, particleJelly._vel));
                ++this.particleCount;
                ++n2;
            }
        }
    }

    class EmitterPlankton {
        Vector3 loc;
        Vector3 vel;
        Vector3 accel;
        float radius;
        Vector3 myColor;
        ArrayList particles;
        int maxParticles;
        int _particleTexID;
        FloatBuffer _planktonPos;
        FloatBuffer _planktonTexCoords;

        EmitterPlankton(Vector3 vector3, int n) {
            this.loc = vector3;
            this.vel = new Vector3();
            this.accel = new Vector3();
            this.maxParticles = n;
            this.radius = 30.0f;
            this.myColor = new Vector3(1.0f, 1.0f, 1.0f);
            this.particles = new ArrayList();
            int n2 = 5400;
            this._planktonPos = BufferUtil.newFloatBuffer((int)n2);
            this._planktonPos.rewind();
            this._planktonTexCoords = BufferUtil.newFloatBuffer((int)n2);
            this._planktonTexCoords.rewind();
        }

        public void draw(float f) {
            int n = this.particles.size();
            if (this._particleTexID > 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._particleTexID);
            }
            int n2 = n - 1;
            while (n2 >= 0) {
                ParticlePlankton particlePlankton = (ParticlePlankton)this.particles.get(n2);
                if (particlePlankton.ISSPLIT) {
                    this.addParticles(particlePlankton);
                }
                if (!particlePlankton.ISDEAD) {
                    particlePlankton._particleTexID = this._particleTexID;
                    particlePlankton.exist(f);
                } else {
                    this.particles.set(n2, this.particles.get(this.particles.size() - 1));
                    this.particles.remove(this.particles.size() - 1);
                }
                --n2;
            }
        }

        public void drawUsingVertexArray(float f) {
            if (this._particleTexID > 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._particleTexID);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.particles.size()) {
                ParticlePlankton particlePlankton = (ParticlePlankton)this.particles.get(n3);
                if (!particlePlankton.ISDEAD) {
                    particlePlankton._particleTexID = this._particleTexID;
                    particlePlankton.update(f);
                    float f2 = particlePlankton.radius * 0.5f;
                    float f3 = particlePlankton.radius * 0.5f;
                    this._planktonPos.put(n + 0, particlePlankton.pos.x - f2);
                    this._planktonPos.put(n + 1, particlePlankton.pos.y + f3);
                    this._planktonPos.put(n + 2, particlePlankton.pos.z);
                    this._planktonPos.put(n + 3, particlePlankton.pos.x + f2);
                    this._planktonPos.put(n + 4, particlePlankton.pos.y + f3);
                    this._planktonPos.put(n + 5, particlePlankton.pos.z);
                    this._planktonPos.put(n + 6, particlePlankton.pos.x - f2);
                    this._planktonPos.put(n + 7, particlePlankton.pos.y - f3);
                    this._planktonPos.put(n + 8, particlePlankton.pos.z);
                    this._planktonTexCoords.put(n2 + 0, 0.0f);
                    this._planktonTexCoords.put(n2 + 1, 0.0f);
                    this._planktonTexCoords.put(n2 + 2, 1.0f);
                    this._planktonTexCoords.put(n2 + 3, 0.0f);
                    this._planktonTexCoords.put(n2 + 4, 0.0f);
                    this._planktonTexCoords.put(n2 + 5, 1.0f);
                    this._planktonPos.put(n + 9, particlePlankton.pos.x + f2);
                    this._planktonPos.put(n + 10, particlePlankton.pos.y + f3);
                    this._planktonPos.put(n + 11, particlePlankton.pos.z);
                    this._planktonPos.put(n + 12, particlePlankton.pos.x + f2);
                    this._planktonPos.put(n + 13, particlePlankton.pos.y - f3);
                    this._planktonPos.put(n + 14, particlePlankton.pos.z);
                    this._planktonPos.put(n + 15, particlePlankton.pos.x - f2);
                    this._planktonPos.put(n + 16, particlePlankton.pos.y - f3);
                    this._planktonPos.put(n + 17, particlePlankton.pos.z);
                    this._planktonTexCoords.put(n2 + 6, 1.0f);
                    this._planktonTexCoords.put(n2 + 7, 0.0f);
                    this._planktonTexCoords.put(n2 + 8, 1.0f);
                    this._planktonTexCoords.put(n2 + 9, 1.0f);
                    this._planktonTexCoords.put(n2 + 10, 0.0f);
                    this._planktonTexCoords.put(n2 + 11, 1.0f);
                    n += 18;
                    n2 += 12;
                } else {
                    particlePlankton.reset(Deep.this.random(250.0f, 380.0f), Deep.this.random(-200.0f, -300.0f), Deep.this.random(0.0f, 200.0f));
                }
                ++n3;
            }
            this._planktonPos.rewind();
            this._planktonTexCoords.rewind();
            Deep.this.vgl.gl().glEnableClientState(32884);
            Deep.this.vgl.gl().glEnableClientState(32888);
            Deep.this.vgl.gl().glVertexPointer(3, 5126, 0, (Buffer)this._planktonPos);
            Deep.this.vgl.gl().glTexCoordPointer(2, 5126, 0, (Buffer)this._planktonTexCoords);
            Deep.this.vgl.gl().glDrawArrays(4, 0, this.particles.size() * 2 * 3);
            Deep.this.vgl.gl().glDisableClientState(32884);
            Deep.this.vgl.gl().glDisableClientState(32888);
        }

        public void addParticles(int n) {
            int n2 = 0;
            while (n2 < n) {
                this.particles.add(new ParticlePlankton(1, this.loc, this.vel));
                ++n2;
            }
        }

        public void addParticles(int n, Vector3 vector3) {
            int n2 = 0;
            while (n2 < n) {
                this.particles.add(new ParticlePlankton(1, vector3, this.vel));
                ++n2;
            }
        }

        public void addParticles(ParticlePlankton particlePlankton) {
            int n = (int)(particlePlankton.radius * 0.15f);
            int n2 = 0;
            while (n2 < n) {
                this.particles.add(new ParticlePlankton(particlePlankton.gen + 1, particlePlankton.pos, particlePlankton._vel));
                ++n2;
            }
        }
    }

    class FBO {
        protected GL _gl;
        boolean _depthOnly;
        protected int[] FBO;
        protected int[] depthStencilBuffer;
        private int _width;
        private int _height;

        FBO(int n, int n2, boolean bl) {
            this._gl = Deep.this.vgl.gl();
            this.FBO = new int[1];
            this.FBO[0] = 0;
            this.depthStencilBuffer = new int[1];
            this.depthStencilBuffer[0] = 0;
            this._width = n;
            this._height = n2;
            this._depthOnly = bl;
        }

        public void init() {
            this._gl.glGenFramebuffersEXT(1, this.FBO, 0);
            this.errcheck();
            Deep.println((String)("FBO id: " + this.FBO[0]));
        }

        public void attachTexture(int n, int n2, int n3) {
            this._gl.glFramebufferTexture2DEXT(36160, n, n2, n3, 0);
            this.errcheck();
            if (this._depthOnly) {
                Deep.println((String)"depth only texture!");
                this._gl.glDrawBuffer(0);
                this._gl.glReadBuffer(0);
            }
        }

        public void attachRenderBuffer(int n, int n2) {
            this._gl.glGenRenderbuffersEXT(1, this.depthStencilBuffer, 0);
            this.errcheck();
            Deep.println((String)("RenderBuffer id: " + this.depthStencilBuffer[0]));
            this._gl.glBindRenderbufferEXT(36161, this.depthStencilBuffer[0]);
            this.errcheck();
            this._gl.glRenderbufferStorageEXT(36161, 33190, n, n2);
            this.errcheck();
            this._gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.depthStencilBuffer[0]);
            this.errcheck();
            this._gl.glBindRenderbufferEXT(36161, this.depthStencilBuffer[0]);
            this._gl.glFramebufferRenderbufferEXT(36160, 36128, 36161, this.depthStencilBuffer[0]);
        }

        public void validate() {
            int n = this._gl.glCheckFramebufferStatusEXT(36160);
            switch (n) {
                case 36053: {
                    Deep.println((String)"GL_FRAMEBUFFER_COMPLETE_EXT");
                    break;
                }
                case 36054: {
                    Deep.println((String)"GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT");
                    break;
                }
                case 36055: {
                    Deep.println((String)"GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                    break;
                }
                case 36057: {
                    Deep.println((String)"GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                    break;
                }
                case 36058: {
                    Deep.println((String)"GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                    break;
                }
                case 36059: {
                    Deep.println((String)"GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                    break;
                }
                case 36060: {
                    Deep.println((String)"GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                    break;
                }
                case 36061: {
                    Deep.println((String)"GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                    break;
                }
                default: {
                    Deep.println((String)"Unknown");
                }
            }
        }

        public void bind() {
            this._gl.glBindFramebufferEXT(36160, this.FBO[0]);
        }

        public void unbind() {
            this._gl.glBindFramebufferEXT(36160, 0);
        }

        public void disable() {
            this._gl.glBindFramebufferEXT(36160, 0);
            this.errcheck();
        }

        public void drawBuffer(int n) {
            if (n == 0) {
                this._gl.glDrawBuffer(36064);
            } else if (n == 1) {
                this._gl.glDrawBuffer(36065);
            }
        }

        public void delete() {
            this._gl.glDeleteFramebuffersEXT(1, this.FBO, 0);
            this._gl.glDeleteRenderbuffersEXT(1, this.depthStencilBuffer, 0);
        }

        public int checkStatus() {
            int n = this._gl.glCheckFramebufferStatusEXT(36160);
            if (n == 36053) {
                System.out.println("FBO is complete.. ok!");
                return 1;
            }
            return n;
        }

        public void errcheck() {
            int n = Deep.this.vgl.gl().glGetError();
            if (n != 0) {
                String string = Deep.this.vgl.glu().gluErrorString(n);
                Deep.println((String)string);
                Deep.this.exit();
            }
        }
    }

    public class FFTHelper {
        public int num;
        public int numbands;
        public float[] spectrum;
        public float[] ttv;
        public double[] v;
        private double[] tv;
        double dampUp;
        double dampDown;
        double mult;
        boolean doDampen = false;
        boolean doDampenAsymm = false;
        boolean doAverage = false;
        boolean isFirstTime = true;
        boolean doNorm = false;
        public double maxinternal;
        public float max;
        public float maxMinimum;
        public float maxMaximum;
        double maxD;
        int maxCnt;
        double[] bandv;
        public float[] band;
        public float[] bandmax;
        public int bandsteps;

        public FFTHelper(int n, int n2, boolean bl) {
            this.num = n;
            this.numbands = n2;
            this.spectrum = new float[this.num];
            this.v = new double[this.num];
            this.tv = new double[this.num];
            this.ttv = new float[this.num];
            this.doAverage = bl;
            this.doNorm = true;
            this.mult = 1.0;
            this.maxMinimum = 200.0f;
            this.maxMaximum = 2000.0f;
            this.maxinternal = this.maxMinimum;
            this.maxCnt = 0;
            this.bandsteps = 256 / this.numbands;
            this.band = new float[this.numbands];
            this.bandv = new double[this.numbands];
            this.bandmax = new float[this.numbands];
        }

        public void setMaxLimits(float f, float f2) {
            this.maxMinimum = f;
            this.maxMaximum = f2;
        }

        public void setDamper(double d, double d2) {
            this.dampUp = d;
            this.dampDown = d2;
            this.doDampen = this.dampUp != -1.0;
            this.doDampenAsymm = true;
        }

        public void setDamper(double d) {
            this.setDamper(d, d);
            this.doDampenAsymm = false;
        }

        public float dampenVal(double d, double d2) {
            d = this.doDampenAsymm ? (d > d2 ? d2 * this.dampDown + d * (1.0 - this.dampDown) : d2 * this.dampUp + d * (1.0 - this.dampUp)) : d2 * this.dampUp + d * (1.0 - this.dampUp);
            return (float)d;
        }

        public void update(float[] fArray) {
            int n;
            int n2;
            if (this.isFirstTime) {
                this.isFirstTime = false;
            }
            if (this.doAverage) {
                this.tv[0] = (fArray[0] + fArray[1]) * 0.5f;
                this.tv[this.num - 1] = (fArray[this.num - 1] + fArray[this.num - 2]) * 0.5f;
                n2 = 1;
                while (n2 < this.num - 1) {
                    this.tv[n2] = (fArray[n2 - 1] + fArray[n2] + fArray[n2 + 1]) * 0.333f;
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < this.num) {
                    this.tv[n2] = fArray[n2];
                    ++n2;
                }
            }
            if (this.doDampen && !this.isFirstTime) {
                if (this.doDampenAsymm) {
                    n2 = 0;
                    while (n2 < this.num) {
                        this.v[n2] = this.v[n2] > this.tv[n2] ? this.tv[n2] * this.dampDown + this.v[n2] * (1.0 - this.dampDown) : this.tv[n2] * this.dampUp + this.v[n2] * (1.0 - this.dampUp);
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.num) {
                        this.v[n2] = this.tv[n2] * this.dampUp + this.v[n2] * (1.0 - this.dampUp);
                        if (this.v[n2] > (double)this.maxMaximum) {
                            this.v[n2] = this.maxMaximum;
                        }
                        ++n2;
                    }
                }
            } else {
                System.arraycopy(this.tv, 0, this.v, 0, this.num);
            }
            if (this.doNorm) {
                double d = 0.0;
                double d2 = 0.0;
                if (this.maxCnt > 0) {
                    this.maxinternal += this.maxD;
                    --this.maxCnt;
                }
                n = 0;
                while (n < this.num) {
                    if (this.v[n] > this.maxinternal) {
                        this.maxinternal = this.v[n];
                        this.maxD = (this.v[n] - this.maxinternal) / 4.0;
                        this.maxCnt = 4;
                        this.maxinternal += this.maxD;
                        --this.maxCnt;
                    }
                    d2 += this.v[n];
                    if (this.v[n] > d) {
                        d = this.v[n];
                    }
                    ++n;
                }
                if (d > (double)this.maxMaximum) {
                    d = this.maxMaximum;
                }
                if (this.maxinternal > (double)this.maxMinimum && this.maxCnt == 0) {
                    this.maxinternal = d * (double)0.005f + this.maxinternal * (double)0.995f;
                } else if (this.maxinternal > (double)this.maxMaximum) {
                    this.maxinternal = this.maxMaximum;
                }
                d2 /= (double)this.num;
                n = 0;
                while (n < this.num) {
                    this.spectrum[n] = (float)(this.v[n] / this.maxinternal);
                    if (this.spectrum[n] > 1.0f) {
                        this.spectrum[n] = 1.0f;
                    }
                    ++n;
                }
                this.max = (float)this.maxinternal;
            } else {
                n2 = 0;
                while (n2 < this.num) {
                    this.spectrum[n2] = (float)this.v[n2];
                    ++n2;
                }
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.numbands) {
                double d = this.bandv[n4];
                this.bandv[n4] = 0.0;
                n = 0;
                while (n < this.bandsteps) {
                    int n5 = n4;
                    this.bandv[n5] = this.bandv[n5] + (double)this.spectrum[n3++];
                    ++n;
                }
                int n6 = n4;
                this.bandv[n6] = this.bandv[n6] / (double)this.bandsteps;
                this.bandv[n4] = this.dampenVal(d, this.bandv[n4]);
                if ((double)this.bandmax[n4] < this.bandv[n4]) {
                    this.bandmax[n4] = (float)this.bandv[n4];
                } else {
                    int n7 = n4;
                    this.bandmax[n7] = this.bandmax[n7] * 0.995f;
                }
                this.band[n4] = (float)this.bandv[n4];
                ++n4;
            }
        }

        public void update(float[] fArray, int n, int n2) {
            System.arraycopy(fArray, n, this.ttv, 0, n2);
            this.update(this.ttv);
        }

        public void updateBands(float[] fArray, int n) {
            int n2 = fArray.length / n;
            float f = 0.0f;
            int n3 = 0;
            while (n3 < n2) {
                f = 0.0f;
                int n4 = 0;
                while (n4 < n2) {
                    f += fArray[n3 * n2 + n4];
                    ++n4;
                }
                this.ttv[n3] = f / (float)n2;
                ++n3;
            }
            this.update(this.ttv);
        }

        public double checkBandMax(int n) {
            return this.bandmax[n / this.bandsteps];
        }
    }

    class GLRenderer
    implements GLEventListener,
    KeyListener {
        GL _gl;

        GLRenderer() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            this._gl = gLAutoDrawable.getGL();
            this._gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Deep.this.vgl = new VGL(gLAutoDrawable.getGL(), new GLU());
            Deep.this.setupJOGL();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this._gl.glGetIntegerv(32936, nArray, 0);
            System.out.println("number of sample buffers is " + nArray[0]);
            this._gl.glGetIntegerv(32937, nArray2, 0);
            System.out.println("number of samples is " + nArray2[0]);
            if (Deep.this.NUM_SAMPLES > 0) {
                this._gl.glEnable(32925);
            }
            this._gl.glEnable(2977);
            this._gl.glEnable(3042);
            this._gl.glHint(3152, 4354);
            this._gl.glHint(3156, 4354);
            Deep.println((String)"init finished");
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            Deep.this.drawJOGL();
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                System.exit(0);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class GrassComparator
    implements Comparator {
        GrassComparator() {
        }

        public final int compare(Object object, Object object2) {
            float f = ((Vector3)object).z;
            float f2 = ((Vector3)object2).z;
            if (f > f2) {
                return 1;
            }
            return -1;
        }
    }

    class GrassLine {
        int id;
        int numConnections;
        int[] connectIds;
        float ysize;
        int numSegments;
        float segStep;
        float lineWidth;
        Vector3 origin;
        Vector3[] points;
        Vector3[] renderPoints;
        float leafTextureSize;
        float segTextureSize;
        int _headTexID = -1;

        GrassLine() {
        }

        public void init(int n, Vector3 vector3, int n2, float f) {
            this.id = n;
            this.numSegments = n2;
            this.ysize = f;
            this.origin = new Vector3(vector3);
            this.points = new Vector3[n2];
            this.renderPoints = new Vector3[n2];
            this.points[0] = new Vector3(vector3);
            this.renderPoints[0] = this.points[0].copy();
            int n3 = 1;
            while (n3 < this.numSegments) {
                float f2;
                this.points[n3] = new Vector3();
                this.segStep = f2 = (float)n3 / (float)this.numSegments * f;
                this.points[n3].x = vector3.x;
                this.points[n3].y = vector3.y - f2;
                this.points[n3].z = vector3.z;
                this.renderPoints[n3] = this.points[n3].copy();
                ++n3;
            }
            this.lineWidth = 1.0f;
            Deep.this.vgl.gl().glLineWidth(this.lineWidth);
        }

        public void setLeafTextureSize(float f) {
            this.leafTextureSize = f;
        }

        public void loadSegmentTexture(String string, float f) {
            this.segTextureSize = f;
        }

        public void draw(float f) {
            float f2 = f * 0.025f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.enableTexture(false);
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setDepthMask(false);
            Deep.this.vgl.setAdditiveBlend();
            Deep.this.vgl.fill(1.0f, 0.95f * f2);
            Deep.this.vgl.gl().glBegin(3);
            Deep.this.vgl.gl().glColor4f(Deep.this.vgl._r, Deep.this.vgl._g, Deep.this.vgl._b, 0.1f * f2);
            Deep.this.vgl.gl().glVertex3f(this.renderPoints[0].x, this.renderPoints[0].y, this.renderPoints[0].z);
            int n = 1;
            while (n < this.numSegments) {
                float f3 = 1.0f - (float)n / (float)this.numSegments;
                Deep.this.vgl.gl().glColor4f(Deep.this.vgl._r, Deep.this.vgl._g, Deep.this.vgl._b, Deep.this.vgl._a * f3 * f2);
                Deep.this.vgl.gl().glVertex3f(this.renderPoints[n].x, this.renderPoints[n].y, this.renderPoints[n].z);
                ++n;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void update(float f) {
            float f2 = 21.0f;
            int n = 1;
            while (n < this.numSegments) {
                this.renderPoints[n].x = this.points[n].x + Deep.sin((float)((float)n * 0.3f + f2 + f)) * (float)n;
                this.renderPoints[n].y = this.points[n].y - f2;
                this.renderPoints[n].z = this.points[n].z + Deep.cos((float)((float)(this.numSegments - n) * 0.52f + f + f2 * 0.5f)) * (float)n * 2.5f;
                ++n;
            }
        }
    }

    class GrassScene {
        int _numGrass;
        GrassLine[] _grassLines;
        GrassComparator comparator;
        ArrayList _grassList;
        ArrayList _grassListViewSpace;
        XTexture grassTexture;
        Vector3 eye;
        Vector3 target;
        Matrix camMatrix;
        FloatBuffer _grassSegPos;
        FloatBuffer _grassSegTexCoords;
        FloatBuffer _grassSegColor;

        GrassScene() {
        }

        public void init(int n) {
            this.eye = new Vector3();
            this.target = new Vector3();
            this.camMatrix = new Matrix();
            this.grassTexture = new XTexture("flare3.png");
            this.comparator = new GrassComparator();
            this._grassList = new ArrayList();
            this._grassListViewSpace = new ArrayList();
            int n2 = n;
            this._numGrass = n;
            this._grassLines = new GrassLine[this._numGrass];
            int n3 = 0;
            while (n3 < this._grassLines.length) {
                this._grassLines[n3] = new GrassLine();
                this._grassLines[n3].setLeafTextureSize(Deep.this.random(8.0f, 30.0f));
                int n4 = 15;
                n2 += n4;
                this._grassLines[n3].init(n3, new Vector3(Deep.this.random(-1850.0f, 1350.0f), Deep.this.random(1600.0f, 2000.0f), Deep.this.random(-1350.0f, 100.0f)), n4, Deep.this.random(500.0f, 1500.0f));
                this._grassLines[n3]._headTexID = this.grassTexture.getId();
                this._grassList.add(this._grassLines[n3]);
                ++n3;
            }
            this._grassSegPos = BufferUtil.newFloatBuffer((int)(n2 * 18));
            this._grassSegPos.rewind();
            this._grassSegTexCoords = BufferUtil.newFloatBuffer((int)(n2 * 12));
            this._grassSegTexCoords.rewind();
            this._grassSegColor = BufferUtil.newFloatBuffer((int)(n2 * 24));
            this._grassSegColor.rewind();
        }

        public void draw(float f) {
            this._grassListViewSpace.clear();
            int n = 0;
            while (n < this._grassList.size()) {
                Vector3 vector3 = ((GrassLine)this._grassList.get((int)n)).origin;
                Vector3 vector32 = Vector3.transform((Vector3)vector3, (Matrix)this.camMatrix);
                this._grassListViewSpace.add(new Vector3Order(vector32, n));
                ++n;
            }
            Collections.sort(this._grassListViewSpace, this.comparator);
            Deep.this.vgl.setDepthMask(true);
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setAdditiveBlend();
            n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this._grassList.size()) {
                int n6 = ((Vector3Order)((Object)this._grassListViewSpace.get((int)n5))).idx;
                GrassLine grassLine = (GrassLine)this._grassList.get(n6);
                n4 += grassLine.numSegments;
                float f2 = grassLine.leafTextureSize;
                float f3 = grassLine.leafTextureSize;
                int n7 = 0;
                while (n7 < grassLine.numSegments) {
                    Vector3 vector3 = grassLine.renderPoints[n7];
                    f2 = grassLine.leafTextureSize * (f * 0.01f) * Deep.sin((float)(f * 0.952f + (float)grassLine.id + (float)n7 * 0.2f));
                    f3 = grassLine.leafTextureSize * (f * 0.01f) * Deep.sin((float)(f * 0.952f + (float)grassLine.id + (float)n7 * 0.2f));
                    this._grassSegPos.put(n + 0, vector3.x - f2);
                    this._grassSegPos.put(n + 1, vector3.y + f3);
                    this._grassSegPos.put(n + 2, vector3.z);
                    this._grassSegPos.put(n + 3, vector3.x + f2);
                    this._grassSegPos.put(n + 4, vector3.y + f3);
                    this._grassSegPos.put(n + 5, vector3.z);
                    this._grassSegPos.put(n + 6, vector3.x - f2);
                    this._grassSegPos.put(n + 7, vector3.y - f3);
                    this._grassSegPos.put(n + 8, vector3.z);
                    this._grassSegTexCoords.put(n3 + 0, 0.0f);
                    this._grassSegTexCoords.put(n3 + 1, 0.0f);
                    this._grassSegTexCoords.put(n3 + 2, 1.0f);
                    this._grassSegTexCoords.put(n3 + 3, 0.0f);
                    this._grassSegTexCoords.put(n3 + 4, 0.0f);
                    this._grassSegTexCoords.put(n3 + 5, 1.0f);
                    this._grassSegColor.put(n2 + 0, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 1, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 2, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 3, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 4, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 5, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 6, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 7, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 8, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 9, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 10, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 11, 1.0f * Deep.this.gamma);
                    this._grassSegPos.put(n + 9, vector3.x + f2);
                    this._grassSegPos.put(n + 10, vector3.y + f3);
                    this._grassSegPos.put(n + 11, vector3.z);
                    this._grassSegPos.put(n + 12, vector3.x + f2);
                    this._grassSegPos.put(n + 13, vector3.y - f3);
                    this._grassSegPos.put(n + 14, vector3.z);
                    this._grassSegPos.put(n + 15, vector3.x - f2);
                    this._grassSegPos.put(n + 16, vector3.y - f3);
                    this._grassSegPos.put(n + 17, vector3.z);
                    this._grassSegTexCoords.put(n3 + 6, 1.0f);
                    this._grassSegTexCoords.put(n3 + 7, 0.0f);
                    this._grassSegTexCoords.put(n3 + 8, 1.0f);
                    this._grassSegTexCoords.put(n3 + 9, 1.0f);
                    this._grassSegTexCoords.put(n3 + 10, 0.0f);
                    this._grassSegTexCoords.put(n3 + 11, 1.0f);
                    this._grassSegColor.put(n2 + 12, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 13, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 14, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 15, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 16, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 17, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 18, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 19, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 20, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 21, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 22, 1.0f * Deep.this.gamma);
                    this._grassSegColor.put(n2 + 23, 1.0f * Deep.this.gamma);
                    n += 18;
                    n2 += 24;
                    n3 += 12;
                    ++n7;
                }
                grassLine.draw(f);
                grassLine.update(f + (float)(n5 * 4));
                ++n5;
            }
            this.grassTexture.enable();
            Deep.this.vgl.fill(1.0f, 1.0f);
            this._grassSegPos.rewind();
            this._grassSegColor.rewind();
            this._grassSegTexCoords.rewind();
            Deep.this.vgl.gl().glEnableClientState(32884);
            Deep.this.vgl.gl().glEnableClientState(32886);
            Deep.this.vgl.gl().glEnableClientState(32888);
            Deep.this.vgl.gl().glVertexPointer(3, 5126, 0, (Buffer)this._grassSegPos);
            Deep.this.vgl.gl().glColorPointer(4, 5126, 0, (Buffer)this._grassSegColor);
            Deep.this.vgl.gl().glTexCoordPointer(2, 5126, 0, (Buffer)this._grassSegTexCoords);
            Deep.this.vgl.gl().glDrawArrays(4, 0, n4 * 3 * 2);
            Deep.this.vgl.gl().glDisableClientState(32884);
            Deep.this.vgl.gl().glDisableClientState(32886);
            Deep.this.vgl.gl().glDisableClientState(32888);
            this.grassTexture.disable();
        }
    }

    class JellyComparator
    implements Comparator {
        JellyComparator() {
        }

        public final int compare(Object object, Object object2) {
            float f = ((Vector3)object).z;
            float f2 = ((Vector3)object2).z;
            if (f > f2) {
                return 1;
            }
            return -1;
        }
    }

    class JellyScene {
        int _numFrames = 0;
        int _animFrame = 0;
        float _animFramef = 0.0f;
        XTexture[] _jellyAnim = null;
        XTexture flare2;
        XTexture flare4;
        int numJellys = 2;
        EmitterJelly jellyField;
        EmitterPlankton planktonField;
        Vector3 eye;
        Vector3 target;
        Matrix camMatrix;
        boolean sendmorefish = true;
        boolean sendmorefish2 = true;

        JellyScene() {
        }

        public void init() {
            Deep.this.randomSeed(29L);
            this.eye = new Vector3();
            this.target = new Vector3();
            this.camMatrix = new Matrix();
            this._numFrames = 36;
            this._jellyAnim = new XTexture[this._numFrames];
            int n = 0;
            while (n < this._numFrames) {
                this._jellyAnim[n] = n <= 9 ? new XTexture("jellyfish2/jellyfish000" + n + ".png") : new XTexture("jellyfish2/jellyfish00" + n + ".png");
                ++n;
            }
            this.flare2 = new XTexture("flare2.png");
            this.flare4 = new XTexture("flare4.png");
            this.jellyField = new EmitterJelly(new Vector3(0.0f, 300.0f, 0.0f), 300);
            while (this.jellyField.particles.size() < this.numJellys) {
                this.jellyField.addParticle(new Vector3(Deep.this.random(-300.0f, 0.0f), Deep.this.random(-300.0f, -270.0f), Deep.this.random(900.0f, 1200.0f)));
            }
            this.jellyField._nebulaTexID = this.flare2.getId();
            this.jellyField._tailTexID = this.flare4.getId();
            this.planktonField = new EmitterPlankton(new Vector3(-100.0f, 0.0f, 0.0f), 100);
            this.planktonField.vel.set(Deep.this.random(0.1f, 0.1f), Deep.this.random(-0.2f, 0.2f), Deep.this.random(-0.1f, 0.3f));
            this.planktonField._particleTexID = this.flare4.getId();
        }

        public void draw(float f) {
            this.drawPlankton(f);
            this.drawJelly(f);
        }

        public void drawJelly(float f) {
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.setDepthMask(false);
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setAdditiveBlend();
            this.jellyField.draw(-1, f);
        }

        public void drawPlankton(float f) {
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.setDepthMask(false);
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setAdditiveBlend();
            this.planktonField.draw(f);
        }

        public void updatePlankton(float f) {
            if (this.planktonField.particles.size() < 300) {
                this.planktonField.addParticles(1, new Vector3(Deep.this.random(250.0f, 380.0f), Deep.this.random(-200.0f, -300.0f), Deep.this.random(0.0f, 200.0f)));
            }
        }

        public void updateJelly(float f) {
            float f2;
            if (f < 180.0f && this.jellyField.particles.size() < this.numJellys + PApplet.parseInt((float)Deep.floor((float)(f * 0.42f)))) {
                float f3 = Deep.this.random(this.eye.z - 600.0f, this.eye.z - 300.0f);
                this.jellyField.addParticle(new Vector3(Deep.this.random(-300.0f, 0.0f), Deep.this.random(-270.0f, -150.0f), f3));
                this.jellyField.addParticle(new Vector3(Deep.this.random(-300.0f, 0.0f), Deep.this.random(-270.0f, -150.0f), Deep.this.random(this.eye.z - 600.0f, this.eye.z - 300.0f)));
                this.jellyField.addParticle(new Vector3(Deep.this.random(-300.0f, 0.0f), Deep.this.random(-270.0f, -150.0f), Deep.this.random(this.eye.z - 600.0f, this.eye.z - 300.0f)));
            }
            if (f >= 90.0f && this.sendmorefish) {
                int n = 0;
                while (n < 20) {
                    f2 = Deep.this.random(-370.0f, -150.0f);
                    this.jellyField.addParticle(new Vector3(Deep.this.random(-300.0f, 0.0f), f2, Deep.this.random(-500.0f, this.eye.z - 300.0f)));
                    ++n;
                }
                this.sendmorefish = false;
            }
            if (f >= 120.0f && this.sendmorefish2) {
                int n = 0;
                while (n < 20) {
                    f2 = Deep.this.random(-370.0f, -150.0f);
                    this.jellyField.addParticle(new Vector3(Deep.this.random(-300.0f, 0.0f), f2, Deep.this.random(-500.0f, this.eye.z - 300.0f)));
                    ++n;
                }
                this.sendmorefish2 = false;
            }
        }

        public void update(float f) {
            this.updatePlankton(f);
            this.updateJelly(f);
        }

        public void release() {
            if (this.planktonField != null) {
                this.planktonField = null;
            }
            if (this.jellyField != null) {
                this.jellyField = null;
            }
        }
    }

    class LandTriangle {
        int a;
        int b;
        int c;
        Vector3 _normal;

        LandTriangle() {
        }
    }

    class Landscape {
        Vector3 eye;
        Vector3 target;
        Matrix localMatrix;
        Matrix invCamMatrix;
        boolean _useList;
        int _callListID;
        boolean _callListCompiled;
        float _gridScaleX;
        float _gridScaleZ;
        float _heightScale;
        int _numCells;
        Vector3[] _map;
        int[] _indices;
        Vector3[] _vertexNormals;
        Vector3[] _vertexTexCoords;
        Vector3[] _grassOffset;
        LandTriangle[] _triangles;
        XTexture _landTex;
        int diffspecID;
        float _alpha;
        GL _gl;

        Landscape(GL gL, float f, float f2, float f3, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            this._gl = gL;
            this._useList = true;
            this.eye = new Vector3();
            this.target = new Vector3();
            this.localMatrix = new Matrix();
            this.localMatrix.identity();
            Deep.this.writelog("land - load tex");
            this._landTex = new XTexture("fur_color2.jpg");
            Deep.this.writelog("land - load shader");
            this.diffspecID = Deep.this.vgl.addEffectFromFile(Deep.this.dataPath("diffusespecular.cgfx"));
            this._gridScaleX = f;
            this._gridScaleZ = f2;
            this._heightScale = f3;
            this._numCells = n;
            this._alpha = 1.0f;
            Deep.this.writelog("land - load data");
            this._vertexTexCoords = new Vector3[n * n];
            this._grassOffset = new Vector3[n * n];
            if (this._map != null) {
                this._map = null;
            }
            this._map = new Vector3[n * n];
            int n7 = 0;
            while (n7 < n) {
                n6 = 0;
                while (n6 < n) {
                    this._vertexTexCoords[n6 + n7 * n] = new Vector3();
                    this._vertexTexCoords[n6 + n7 * n].x = (float)n6 * 5.0f / (float)n;
                    this._vertexTexCoords[n6 + n7 * n].y = (float)n7 * 5.0f / (float)n;
                    this._grassOffset[n6 + n7 * n] = new Vector3();
                    this._grassOffset[n6 + n7 * n].x = Deep.this.random(-100.0f, 100.0f);
                    this._grassOffset[n6 + n7 * n].y = 0.0f;
                    this._grassOffset[n6 + n7 * n].z = Deep.this.random(-100.0f, 100.0f);
                    this._map[n6 + n7 * n] = new Vector3();
                    this._map[n6 + n7 * n].x = (float)n * this._gridScaleX * 0.5f - (float)n6 * this._gridScaleX;
                    this._map[n6 + n7 * n].z = (float)n * this._gridScaleZ * 0.5f - (float)n7 * this._gridScaleZ;
                    this._map[n6 + n7 * n].y = Deep.this.noise((float)n7 * 0.2f, (float)n6 * 0.1f) * this._heightScale - Deep.sqrt((float)(this._map[n6 + n7 * n].x * this._map[n6 + n7 * n].x + this._map[n6 + n7 * n].z * this._map[n6 + n7 * n].z)) * 0.125f;
                    ++n6;
                }
                ++n7;
            }
            Deep.this.writelog("land - compute triangle indices");
            this._indices = new int[n * n * 3 * 2];
            int n8 = 0;
            n7 = 0;
            while (n7 < n - 1) {
                n6 = 0;
                while (n6 < n - 1) {
                    n5 = n6 + n7 * this._numCells;
                    n4 = n6 + 1 + n7 * this._numCells;
                    n3 = n6 + (n7 + 1) * this._numCells;
                    n2 = n6 + 1 + (n7 + 1) * this._numCells;
                    this._indices[n8] = n5;
                    this._indices[++n8] = n3;
                    this._indices[++n8] = n4;
                    this._indices[++n8] = n4;
                    this._indices[++n8] = n3;
                    this._indices[++n8] = n2;
                    ++n8;
                    ++n6;
                }
                ++n7;
            }
            this._triangles = new LandTriangle[(n - 1) * (n - 1) * 2];
            n5 = 0;
            n7 = 0;
            while (n7 < n - 1) {
                n6 = 0;
                while (n6 < n - 1) {
                    n4 = n6 + n7 * this._numCells;
                    n3 = n6 + 1 + n7 * this._numCells;
                    n2 = n6 + (n7 + 1) * this._numCells;
                    int n9 = n6 + 1 + (n7 + 1) * this._numCells;
                    this._triangles[n5] = new LandTriangle();
                    this._triangles[n5].a = n4;
                    this._triangles[n5].b = n2;
                    this._triangles[n5].c = n3;
                    this._triangles[n5 + 1] = new LandTriangle();
                    this._triangles[n5 + 1].a = n3;
                    this._triangles[n5 + 1].b = n2;
                    this._triangles[n5 + 1].c = n9;
                    n5 += 2;
                    ++n6;
                }
                ++n7;
            }
            Deep.this.writelog("land - compute normals");
            this.computeNormals();
            Deep.this.writelog("land - use list");
            if (this._useList) {
                this._callListCompiled = false;
                this._callListID = Deep.this.vgl.gl().glGenLists(1);
                this.renderLandscape();
            }
            Deep.this.writelog("land - end init");
        }

        public void computeNormals() {
            Object object;
            Vector3 vector3;
            int n = 0;
            Vector3[] vector3Array = new Vector3[this._triangles.length];
            n = 0;
            while (n < this._triangles.length) {
                vector3 = this._map[this._triangles[n].a].copy();
                Vector3 vector32 = this._map[this._triangles[n].b].copy();
                Vector3 vector33 = this._map[this._triangles[n].c].copy();
                Vector3 vector34 = Vector3.sub((Vector3)vector32, (Vector3)vector3);
                object = Vector3.sub((Vector3)vector33, (Vector3)vector3);
                Vector3 vector35 = Vector3.cross((Vector3)vector34, (Vector3)object);
                vector3Array[n] = vector35.copy();
                vector35.normalize();
                this._triangles[n]._normal = vector35.copy();
                ++n;
            }
            this._vertexNormals = new Vector3[this._map.length];
            vector3 = new Vector3();
            int n2 = 0;
            int n3 = 0;
            while (n3 < this._map.length) {
                Vector3 cfr_ignored_0 = this._map[n3];
                vector3.set(0.0f, 0.0f, 0.0f);
                int n4 = 0;
                while (n4 < this._triangles.length) {
                    object = this._triangles[n4];
                    if (n3 == object.a || n3 == object.b || n3 == object.c) {
                        ++n2;
                        vector3.add(vector3Array[n4]);
                    }
                    ++n4;
                }
                if (n2 > 1) {
                    vector3.mul(1.0f / (float)n2);
                }
                vector3.normalize();
                this._vertexNormals[n3] = vector3.copy();
                ++n3;
            }
            vector3Array = null;
        }

        public float InterpolatedValue(float f, float f2) {
            int n = (int)(f / this._gridScaleX);
            int n2 = (int)(f2 / this._gridScaleZ);
            int n3 = (int)Math.floor(n += this._numCells / 2);
            int n4 = (int)Math.floor(n2 += this._numCells / 2);
            float f3 = n - n3;
            float f4 = n2 - n4;
            if (n3 < 0 || n3 >= this._numCells || n4 < 0 || n4 >= this._numCells) {
                System.err.println("(Landscape)   Position outside of the terrain area. ERROR!");
                return -99999.0f;
            }
            float f5 = this._map[n3 + n4 * this._numCells].y;
            float f6 = this._map[n3 + 1 + n4 * this._numCells].y;
            float f7 = this._map[n3 + (n4 + 1) * this._numCells].y;
            float f8 = this._map[n3 + 1 + (n4 + 1) * this._numCells].y;
            float f9 = f5 * (1.0f - f4) + f7 * f4;
            float f10 = f6 * (1.0f - f4) + f8 * f4;
            float f11 = f9 * (1.0f - f3) + f10 * f3;
            return f11;
        }

        public void setAlpha(float f) {
            this._alpha = f < 1.0f ? f : 1.0f;
        }

        public void draw() {
            Deep.this.vgl.setShader(this.diffspecID);
            Deep.this.vgl.setTextureParameter("ColorSampler", this._landTex.getId());
            Deep.this.vgl.setParameter3f("cameraPos", this.eye);
            Deep.this.vgl.setParameter4f("lightPos", Deep.this.lightPos);
            Deep.this.vgl.setParameter4f("fogColor", Deep.this.fogColor);
            Deep.this.vgl.setParameter1f("fogDensity", Deep.this.fogDensity);
            Deep.this.vgl.setParameter1f("kC", Deep.this.kC);
            Deep.this.vgl.setParameter1f("kL", Deep.this.kL);
            Deep.this.vgl.setParameter1f("kQ", Deep.this.kQ);
            Deep.this.vgl.setParameter1f("specularLevel", 16.0f);
            Deep.this.vgl.setParameter1f("useSpecular", 1.0f);
            Deep.this.vgl.setMatrixParameterSemantic("WORLDVIEWPROJECTION", 12, 100);
            Deep.this.vgl.setMatrixParameterSemantic("MODELVIEW", 4, 100);
            Deep.this.vgl.setMatrixParameterSemantic("VIEWINVERSE", 4, 101);
            Deep.this.vgl.setMatrixParameterSemantic("VIEWINVERSETRANSPOSE", 4, 103);
            Deep.this.vgl.setMatrixParameterSemantic("WORLD", this.localMatrix.getArray());
            Deep.this.vgl.setMatrixParameterSemantic("WORLDTOCAMERA", this.invCamMatrix.getArray());
            CGpass cGpass = ((ShaderCGFX)Deep.this.vgl.getActiveShader()).getTechniqueFirstPass("Technique_DiffuseSpecular");
            CgGL.cgSetPassState((CGpass)cGpass);
            this.renderLandscape();
            CgGL.cgResetPassState((CGpass)cGpass);
            Deep.this.vgl.disableShader();
        }

        public void renderLandscape() {
            if (this._useList && this._callListID > 0 && this._callListCompiled) {
                Deep.this.vgl.gl().glCallList(this._callListID);
                return;
            }
            if (this._useList && this._callListID > 0 && !this._callListCompiled) {
                Deep.this.vgl.gl().glNewList(this._callListID, 4864);
            }
            this._gl.glBegin(4);
            int n = 0;
            while (n < this._triangles.length) {
                Vector3 vector3 = this._map[this._triangles[n].a].copy();
                Vector3 vector32 = this._map[this._triangles[n].b].copy();
                Vector3 vector33 = this._map[this._triangles[n].c].copy();
                Vector3 vector34 = this._vertexTexCoords[this._triangles[n].a].copy();
                Vector3 vector35 = this._vertexTexCoords[this._triangles[n].b].copy();
                Vector3 vector36 = this._vertexTexCoords[this._triangles[n].c].copy();
                Vector3 vector37 = this._vertexNormals[this._triangles[n].a];
                Vector3 vector38 = this._vertexNormals[this._triangles[n].b];
                Vector3 vector39 = this._vertexNormals[this._triangles[n].c];
                float f = 9.0f - Deep.this.noise(this.eye.z * 0.2f, Deep.this.time * 0.01f) * 0.3f * 9.0f;
                this._gl.glColor4f(1.0f * Deep.this.gamma / 255.0f * f * this._alpha, 13.0f * Deep.this.gamma / 255.0f * f * this._alpha, 36.0f * Deep.this.gamma / 255.0f * f * this._alpha, 1.0f * this._alpha);
                this._gl.glNormal3f(vector37.x, vector37.y, vector37.z);
                this._gl.glTexCoord2f(vector34.x, vector34.y);
                this._gl.glVertex3f(vector3.x, vector3.y, vector3.z);
                this._gl.glNormal3f(vector38.x, vector38.y, vector38.z);
                this._gl.glTexCoord2f(vector35.x, vector35.y);
                this._gl.glVertex3f(vector32.x, vector32.y, vector32.z);
                this._gl.glNormal3f(vector39.x, vector39.y, vector39.z);
                this._gl.glTexCoord2f(vector36.x, vector36.y);
                this._gl.glVertex3f(vector33.x, vector33.y, vector33.z);
                ++n;
            }
            this._gl.glEnd();
            if (this._useList && this._callListID > 0 && !this._callListCompiled) {
                Deep.this.vgl.gl().glEndList();
                this._callListCompiled = true;
            }
        }
    }

    class Nebula {
        Vector3 loc;
        Vector3 vel;
        float radius;
        float scaleFac;
        float age;
        int lifeSpan;
        float invLifeSpan;
        float agePer;
        float rot;
        Vector3 c;
        boolean ISDEAD;
        boolean ISGROUNDED;

        Nebula(Vector3 vector3, float f, boolean bl) {
            this.loc = new Vector3(vector3);
            this.vel = new Vector3(0.0f, 0.0f, 0.0f);
            this.radius = Deep.this.random(f * 0.8f, f * 1.75f);
            this.scaleFac = Deep.this.random(1.0005f, 1.005f);
            this.age = 0.0f;
            this.lifeSpan = (int)Deep.this.random(20.0f, 40.0f);
            this.invLifeSpan = 1.0f / (float)this.lifeSpan;
            this.rot = Deep.this.random((float)Math.PI * 2);
            this.c = new Vector3(Deep.this.random(0.75f, 1.0f), Deep.this.random(0.2f, 0.8f), Deep.this.random(0.5f, 0.75f));
            this.ISGROUNDED = bl;
            if (this.ISGROUNDED) {
                this.scaleFac = Deep.this.random(1.01f, 1.025f);
                this.vel.y -= Deep.this.random(1.0f);
                this.radius *= 2.0f;
            }
        }

        public void computeAndRender() {
            this.move();
            this.render();
            this.update();
        }

        public void move() {
            if (this.radius < 1000.0f) {
                this.radius *= this.scaleFac;
            }
            this.loc.add(this.vel);
            this.loc.add(0.0f, 0.04f, 0.0f);
        }

        public void render() {
            Deep.this.vgl.setDepthWrite(false);
            Deep.this.vgl.setDepthMask(false);
            Deep.this.vgl.setAdditiveBlend();
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.loc.x, this.loc.y, this.loc.z);
            Deep.this.glReverseCamera(Deep.this.jeye, Deep.this.jtarget);
            Deep.this.vgl.rotate(Deep.degrees((float)(this.rot * 2.0f)), 0.0f, 0.0f, 1.0f);
            Deep.this.vgl.scale(this.radius * 0.001f);
            Deep.this.vgl.fill(this.c.z, this.c.z, this.c.z, Deep.sin((float)(this.agePer * (float)Math.PI)) * 0.24f);
            Deep.this.vgl.rect(1.0f, 1.0f);
            Deep.this.vgl.popMatrix();
        }

        public void update() {
            this.age += 1.0f;
            this.agePer = 1.0f - this.age * this.invLifeSpan;
        }

        public boolean isDead() {
            if (this.age > (float)this.lifeSpan) {
                this.ISDEAD = true;
                return true;
            }
            return false;
        }
    }

    class ParticleJelly {
        int index;
        Vector3 pos;
        Vector3 oldPos;
        Vector3 _vel;
        Vector3 _accel;
        Vector3 perlin;
        float radius;
        float age;
        float lifeSpan;
        float agePer;
        int gen;
        boolean ISDEAD;
        boolean ISSPLIT;
        int _particleTexID;
        int _nebulaTexID;
        int _tailTexID;
        int numFrames;
        int animFrame;
        float animFramef;
        float seaLevel = 350.0f;
        Ribbon rib;
        Vector3[] _tailCopy;
        Vector3[] _tailCopy2;
        Vector3[] _tailCopy3;
        Vector3[] _tailCopy4;
        Nebula neb;

        ParticleJelly(int n, int n2, Vector3 vector3, Vector3 vector32) {
            this.index = n;
            this.pos = vector3.copy();
            this.oldPos = vector3.copy();
            this._vel = vector32.copy();
            this._accel = new Vector3(Deep.this.random(-0.052f, 0.052f), Deep.this.random(-0.2f, 0.532f), Deep.this.random(-0.052f, 0.0532f));
            this.radius = 60.0f;
            this.age = 0.0f;
            this.lifeSpan = 112.0f + Deep.this.random(85.0f);
            this.ISSPLIT = false;
            this.ISDEAD = false;
            this.rib = new Ribbon((int)Deep.this.random(40.0f, 70.0f), 1.0f, 8.0f, false);
            this.rib.setHead(this.pos.x, this.pos.y, this.pos.z);
            this.rib.setTimeToLive(this.lifeSpan);
            this.rib.computeTail();
            this._tailCopy = new Vector3[this.rib._tailSize];
            this._tailCopy2 = new Vector3[this.rib._tailSize];
            this._tailCopy3 = new Vector3[this.rib._tailSize];
            this._tailCopy4 = new Vector3[this.rib._tailSize];
            int n3 = 0;
            while (n3 < this._tailCopy.length) {
                this._tailCopy[n3] = new Vector3();
                this._tailCopy[n3] = this.rib._tail[n3].copy();
                this._tailCopy2[n3] = new Vector3();
                this._tailCopy2[n3] = this.rib._tail[n3].copy();
                this._tailCopy3[n3] = new Vector3();
                this._tailCopy3[n3] = this.rib._tail[n3].copy();
                this._tailCopy4[n3] = new Vector3();
                this._tailCopy4[n3] = this.rib._tail[n3].copy();
                ++n3;
            }
            this.neb = new Nebula(vector3, this.radius * 0.5f, false);
            this.numFrames = Deep.this.jellys._numFrames;
            this.animFrame = (int)Deep.this.random(0.0f, this.numFrames - 1);
            this.animFramef = this.animFrame;
        }

        public void computeAndRender(float f) {
            this.draw(f);
            this.update(f);
        }

        public void setTexture(int n) {
            this._particleTexID = Deep.this.jellys._jellyAnim[this.animFrame].getId();
        }

        public void draw(float f) {
            float f2 = 0.75f;
            Deep.this.vgl.setAdditiveBlend();
            this.rib.setHead(this.pos.x, this.pos.y, this.pos.z);
            this.rib.updateJelly(f);
            if (this._tailTexID > 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._tailTexID);
                this.rib._tailTexID = this._tailTexID;
            }
            int n = 0;
            while (n < this._tailCopy.length) {
                this._tailCopy[n] = this.rib._tail[n].copy();
                this._tailCopy2[n] = this.rib._tail[n].copy();
                this._tailCopy3[n] = this.rib._tail[n].copy();
                this._tailCopy4[n] = this.rib._tail[n].copy();
                float f3 = 1.94f;
                this._tailCopy[n].x += f3;
                this._tailCopy[n].z += f3;
                this._tailCopy2[n].x -= f3;
                this._tailCopy2[n].z -= f3;
                this._tailCopy3[n].x += f3;
                this._tailCopy3[n].z -= f3;
                this._tailCopy4[n].x -= f3;
                this._tailCopy4[n].z += f3;
                float f4 = this.rib._add.y + 0.21f;
                this._tailCopy[n].x += Deep.cos((float)(f4 * 7.0f * f + (float)n * 0.01f + (float)this.index)) * (float)n * 0.05f * 1.0f;
                this._tailCopy2[n].x -= Deep.cos((float)(f4 * 7.0f * f + (float)n * 0.01f + (float)this.index)) * (float)n * 0.05f * 1.0f;
                this._tailCopy3[n].x -= Deep.cos((float)(f4 * 7.0f * f + (float)n * 0.01f + (float)this.index)) * (float)n * 0.05f * 1.0f;
                this._tailCopy4[n].x -= Deep.cos((float)(f4 * 7.0f * f + (float)n * 0.01f + (float)this.index)) * (float)n * 0.05f * 1.0f;
                ++n;
            }
            this.rib.renderTailFromBuffer(this.rib._tail, 1, f2);
            this.rib.renderTailFromBuffer(this._tailCopy, 1, f2);
            this.rib.renderTailFromBuffer(this._tailCopy2, 1, f2);
            this.rib.renderTailFromBuffer(this._tailCopy3, 1, f2);
            this.rib.renderTailFromBuffer(this._tailCopy4, 1, f2);
            if (this._nebulaTexID >= 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._nebulaTexID);
            }
            this.neb.computeAndRender();
            if (this._nebulaTexID >= 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._nebulaTexID);
            }
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.pos);
            Deep.this.glReverseCamera(Deep.this.jellys.eye, Deep.this.jellys.target);
            Deep.this.vgl.fill(1.0f, 1.0f - (0.3f + 0.2f * Deep.sin((float)(f * 2.2f + (float)this.index + this.agePer))));
            Deep.this.vgl.rect(this.radius * 0.5f + f * 0.05f, this.radius * 0.3f + f * 0.05f);
            Deep.this.vgl.popMatrix();
            if (this._particleTexID > 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._particleTexID);
            }
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.pos.x, this.pos.y - this.radius * 0.1f, this.pos.z);
            Deep.this.glReverseCamera(Deep.this.jellys.eye, Deep.this.jellys.target);
            Deep.this.vgl.scale(1.0f, -1.0f, 1.0f);
            Deep.this.vgl.fill(1.0f, (1.0f - (0.3f + 0.2f * Deep.sin((float)(f * 2.2f + (float)this.index + this.agePer)))) * (1.0f - this.agePer * 2.0f));
            Deep.this.vgl.rect(this.radius * 0.5f, this.radius * 0.4f);
            Deep.this.vgl.rect(this.radius * 0.5f, this.radius * 0.4f);
            Deep.this.vgl.popMatrix();
        }

        public void update(float f) {
            this.oldPos = this.pos.copy();
            this.pos.add(this._vel);
            this._vel.add(this._accel);
            this._accel.mul(0.0f);
            this._vel.mul(0.88f);
            Vector3 vector3 = new Vector3();
            vector3.x = (-0.5f + Deep.this.noise(this.pos.x * 0.03f, this.pos.y * 0.1f + this.pos.z * 0.03f, f * 0.1f)) * 0.13f;
            vector3.y = (-0.235f + Deep.this.noise(10.0f + this.pos.x * 0.1f, 100.0f + this.pos.x * 0.01f, f * 1.0f)) * 0.6f;
            vector3.z = (-0.55f + Deep.this.noise(10.0f + this.pos.y * 0.1f, 100.0f + this.pos.x * 0.01f, f * 1.0f)) * 1.8f;
            vector3.mul(0.65f);
            this._accel.add(vector3);
            this.age += 0.05f;
            if (this.age > this.lifeSpan) {
                this.ISDEAD = true;
            } else {
                this.agePer = this.age / this.lifeSpan;
            }
            this.animFramef += 0.2f + Deep.abs((float)(this._vel.y * 0.5f));
            this.animFrame = Deep.floor((float)this.animFramef);
            if (this.animFrame >= this.numFrames) {
                this.animFramef = 0.0f;
                this.animFrame = 0;
            }
        }
    }

    class ParticlePlankton {
        Vector3 pos;
        Vector3 oldPos;
        Vector3 _vel;
        Vector3 _accel;
        Vector3 perlin;
        float radius;
        float age;
        float lifeSpan;
        float agePer;
        int gen;
        boolean ISDEAD;
        boolean ISSPLIT;
        int _particleTexID;

        ParticlePlankton(int n, Vector3 vector3, Vector3 vector32) {
            this.pos = vector3.copy();
            this.oldPos = vector3.copy();
            this._vel = vector32.copy();
            this._accel = new Vector3(Deep.this.random(-0.82f, 0.82f), Deep.this.random(-0.42f, 0.42f), Deep.this.random(-0.82f, 0.82f));
            this.radius = 1.0f + Deep.this.random(2.0f);
            this.age = 2.0f + Deep.this.random(5.0f);
            this.lifeSpan = 2.0f + Deep.this.random(55.0f);
            this.ISSPLIT = false;
            this.ISDEAD = false;
            this._particleTexID = -1;
        }

        public void exist(float f) {
            this.render(f);
            this.update(f);
        }

        public void render(float f) {
            Deep.this.vgl.setAdditiveBlend();
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setDepthMask(false);
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.pos);
            Deep.this.glReverseCamera2(this.pos, this.oldPos);
            if (f < 230.0f) {
                Deep.this.vgl.fill(0.6f, 0.7f, 0.95f, Deep.abs((float)(Deep.cos((float)(0.5f * f + this.age * 0.13f)) * 0.93f)));
            } else {
                float f2 = Deep.abs((float)(Deep.cos((float)(0.5f * f + this.age * 0.13f)) * 0.93f)) * (1.0f - (f - 230.0f) * 0.1f);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                Deep.this.vgl.fill(0.6f, 0.7f, 0.95f, f2);
            }
            Deep.this.vgl.rect(0.0f, 0.0f, 0.0f, this.radius * 0.5f, this.radius * 0.25f);
            Deep.this.vgl.popMatrix();
        }

        public void update(float f) {
            this.oldPos = this.pos.copy();
            this.pos.add(this._vel);
            this._vel.add(this._accel);
            this._vel.mul(0.975f);
            this._accel.mul(0.0f);
            Vector3 vector3 = new Vector3();
            vector3.y = (-0.3f + Deep.this.noise(this._vel.x * 0.5f, this._vel.y * 0.03f, f * 10.01f)) * 0.85f;
            vector3.x = -(-0.3f + Deep.this.noise(this.pos.x * 0.3f, this.pos.y * 0.3f, f * 0.1f)) * 0.95f;
            vector3.z = (-0.4f + Deep.this.noise(this.pos.x * 0.3f, this.pos.y * 0.3f, f * 0.1f)) * 0.135f;
            vector3.mul(0.75f);
            this._accel.add(vector3);
            this.age += 0.1f;
            if (this.age > this.lifeSpan) {
                this.ISDEAD = true;
            } else {
                this.agePer = 1.0f - this.age / this.lifeSpan;
            }
        }

        public void reset(float f, float f2, float f3) {
            this.pos.set(f, f2, f3);
            this.oldPos = this.pos.copy();
            this._vel.set(0.0f, 0.0f, 0.0f);
            this._accel.set(Deep.this.random(-0.82f, 0.82f), Deep.this.random(-0.42f, 0.42f), Deep.this.random(-0.82f, 0.82f));
            this.radius = 1.0f + Deep.this.random(2.0f);
            this.age = 2.0f + Deep.this.random(5.0f);
            this.lifeSpan = 2.0f + Deep.this.random(55.0f);
            this.ISSPLIT = false;
            this.ISDEAD = false;
        }
    }

    class Ribbon {
        int _facets;
        int[] yTable;
        Vector3[] _vertices;
        Vector3[] _normals;
        int _headTexID;
        int _tailTexID;
        Vector4 _colour;
        boolean _doRenderHead;
        boolean _doUpdate;
        float _age;
        float _agePer;
        float _timeToLive;
        float _invTimeToLive;
        Vector3 _initPos;
        float _headSize;
        Vector3 _head;
        Vector3 _right;
        Vector3 _add;
        float _tailWidth;
        int _tailRenderSegments;
        int _tailSize;
        Vector3[] _tail;

        Ribbon() {
            this._doRenderHead = true;
            this._doUpdate = true;
            this._tailTexID = -1;
            this._headTexID = -1;
            this._tailSize = 20;
            this._tailRenderSegments = 0;
            this._tailWidth = 1.0f;
            this._initPos = new Vector3();
            this._headSize = 24.0f;
            this._head = new Vector3();
            this._right = new Vector3();
            this._add = new Vector3();
            this._age = 0.0f;
            this._agePer = 0.0f;
            this._timeToLive = 100.0f;
            this._invTimeToLive = 1.0f / this._timeToLive;
            this._facets = 8;
            this._colour = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
            this.yTable = new int[this._tailSize];
            int n = 0;
            while (n < this._tailSize) {
                this.yTable[n] = n * (this._facets + 1);
                ++n;
            }
            this._vertices = new Vector3[this._tailSize * (this._facets + 1)];
            this._normals = new Vector3[this._tailSize * (this._facets + 1)];
            n = 0;
            while (n < this._tailSize * (this._facets + 1)) {
                this._vertices[n] = new Vector3();
                this._normals[n] = new Vector3();
                ++n;
            }
        }

        Ribbon(int n, float f, float f2, boolean bl) {
            this._doRenderHead = bl;
            this._doUpdate = true;
            this._tailSize = n;
            this._tailRenderSegments = 0;
            this._tailWidth = f;
            this._initPos = new Vector3();
            this._headSize = f2;
            this._head = new Vector3();
            this._right = new Vector3();
            this._add = new Vector3();
            this._age = 0.0f;
            this._agePer = 0.0f;
            this._timeToLive = 100.0f;
            this._invTimeToLive = 1.0f / this._timeToLive;
            this._colour = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
            this._facets = 8;
            this.yTable = new int[this._tailSize];
            int n2 = 0;
            while (n2 < this._tailSize) {
                this.yTable[n2] = n2 * (this._facets + 1);
                ++n2;
            }
            this._vertices = new Vector3[this._tailSize * (this._facets + 1)];
            this._normals = new Vector3[this._tailSize * (this._facets + 1)];
            n2 = 0;
            while (n2 < this._tailSize * (this._facets + 1)) {
                this._vertices[n2] = new Vector3();
                this._normals[n2] = new Vector3();
                ++n2;
            }
        }

        public void setHeadTexture(int n) {
            this._headTexID = n;
        }

        public void setTailTexture(int n) {
            this._tailTexID = n;
        }

        public void computeTail() {
            if (this._tail == null) {
                this._tail = new Vector3[this._tailSize];
            }
            int n = 0;
            while (n < this._tailSize) {
                this._tail[n] = new Vector3();
                this._tail[n] = this._head.copy();
                ++n;
            }
        }

        public boolean isDead() {
            return this._age >= this._timeToLive;
        }

        public void setTimeToLive(float f) {
            this._timeToLive = f;
            this._invTimeToLive = 1.0f / this._timeToLive;
        }

        public void setHeadY(float f) {
            this._head.y = f;
            this._initPos = this._head.copy();
        }

        public void setHead(float f, float f2) {
            this._head.set(f, f2, 0.0f);
            this._initPos = this._head.copy();
        }

        public void setHead(float f, float f2, float f3) {
            this._head.set(f, f2, f3);
            this._initPos = this._head.copy();
        }

        public void setHead(Vector3 vector3) {
            this._head = vector3;
            this._initPos = this._head.copy();
        }

        public void addHead(float f, float f2) {
            if (this._doUpdate) {
                this._head.add(f, f2, 0.0f);
            }
        }

        public void addHead(float f, float f2, float f3) {
            if (this._doUpdate) {
                this._head.add(f, f2, f3);
            }
        }

        public void addHead(Vector3 vector3) {
            if (this._doUpdate) {
                this._head.add(vector3);
            }
        }

        public void renderHead(boolean bl) {
            this._doRenderHead = bl;
        }

        public void update(float f) {
            if (this._age < this._timeToLive) {
                if (this._tailRenderSegments < this._tailSize) {
                    int n = this._tailRenderSegments;
                    while (n > 0) {
                        this._tail[n] = this._tail[n - 1];
                        --n;
                    }
                    this._tail[0] = this._head.copy();
                    if (this._tailRenderSegments < this._tailSize - 1) {
                        ++this._tailRenderSegments;
                    }
                } else {
                    this._doUpdate = false;
                }
            }
            if (this._doUpdate) {
                this._head.add(this._add);
                this._age += 0.05f;
                this._agePer = this._age * this._invTimeToLive;
            }
        }

        public void updateJelly(float f) {
            int n = this._tailRenderSegments;
            while (n > 0) {
                this._tail[n] = this._tail[n - 1];
                --n;
            }
            this._tail[0] = this._head.copy();
            if (this._tailRenderSegments < this._tailSize - 1) {
                ++this._tailRenderSegments;
            }
            this._head.add(this._add);
            this._age += 0.05f;
            this._agePer = this._age * this._invTimeToLive;
        }

        public void draw(float f) {
            Deep.this.vgl.gl().glDisable(2884);
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setDepthMask(false);
            this.renderTail();
            if (!this._doUpdate) {
                this._head = this._tail[0].copy();
            }
        }

        public void drawCylinderRibbon(float f) {
            if (this._age < this._timeToLive) {
                Deep.this.vgl.gl().glDisable(2884);
                Deep.this.vgl.setDepthWrite(true);
                Deep.this.vgl.setAlphaBlend();
                this.renderTailCylinder();
            }
        }

        public void renderHead() {
            if (this._headTexID >= 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._headTexID);
            }
            Deep.this.vgl.setDepthWrite(false);
            Deep.this.vgl.setAlphaBlend();
            Deep.this.vgl.fill(1.0f, 1.0f - this._agePer);
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this._head.x, this._head.y, this._head.z);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.quad(this._headSize);
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.setDepthWrite(true);
        }

        public void renderTail() {
            Deep.this.vgl.enableTexture(false);
            Deep.this.vgl.gl().glBegin(8);
            int n = 0;
            while (n < this._tailSize - 1) {
                float f = 1.0f - (float)n / (float)this._tailSize;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                if (f < 0.0f) {
                    f = 0.0f;
                }
                float f2 = (float)n / (float)this._tailSize;
                if (n < this._tailSize - 1) {
                    Vector3 vector3 = Vector3.sub((Vector3)this._tail[n + 1], (Vector3)this._tail[n]);
                    vector3.normalize();
                    Vector3 vector32 = vector3.cross(new Vector3(0.0f, 1.0f, 0.0f));
                    vector32.normalize();
                    Vector3 vector33 = vector3.cross(vector32);
                    vector33.normalize();
                    vector32 = vector33.cross(vector3);
                    vector32.normalize();
                    this._right = vector32.copy();
                    float f3 = this._tail[n].x;
                    float f4 = this._tail[n].y;
                    float f5 = this._tail[n].z;
                    float f6 = vector32.x * this._tailWidth * f;
                    float f7 = vector32.y * this._tailWidth * f;
                    float f8 = vector32.z * this._tailWidth * f;
                    Deep.this.vgl.gl().glColor4f(1.0f, 1.0f, 1.0f, f * f2);
                    Deep.this.vgl.gl().glVertex3f(f3 - f6, f4 - f7, f5 - f8);
                    Deep.this.vgl.gl().glVertex3f(f3 + f6, f4 + f7, f5 + f8);
                }
                ++n;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void renderTailColor(float f, float f2, float f3, float f4) {
            Deep.this.vgl.gl().glBegin(8);
            int n = 0;
            while (n < this._tailSize - 1) {
                float f5 = (float)n / (float)this._tailSize;
                if (f5 > 1.0f) {
                    f5 = 1.0f;
                }
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (n < this._tailSize - 1) {
                    Vector3 vector3 = Vector3.sub((Vector3)this._tail[n + 1], (Vector3)this._tail[n]);
                    vector3.normalize();
                    Vector3 vector32 = vector3.cross(new Vector3(0.0f, 1.0f, 0.0f));
                    vector32.normalize();
                    Vector3 vector33 = vector3.cross(vector32);
                    vector33.normalize();
                    vector32 = vector33.cross(vector3);
                    vector32.normalize();
                    this._right = vector32.copy();
                    float f6 = this._tail[n].x;
                    float f7 = this._tail[n].y;
                    float f8 = this._tail[n].z;
                    f6 = this._tail[n].x + this._right.x * Deep.sin((float)((float)n * 0.12f + Deep.this.time * 2.0f)) * 3.0f * (float)(this._tailSize - n) * 0.053f;
                    f7 = this._tail[n].y - 3.0f;
                    f8 = this._tail[n].z + this._right.z * Deep.sin((float)((float)n * 0.12f + Deep.this.time * 2.0f)) * 3.0f * (float)(this._tailSize - n) * 0.053f;
                    float f9 = vector32.x * this._tailWidth * f5;
                    float f10 = vector32.y * this._tailWidth * f5;
                    float f11 = vector32.z * this._tailWidth * f5;
                    Deep.this.vgl.gl().glColor4f(f, f2, f3, 1.0f - this._agePer);
                    Deep.this.vgl.gl().glVertex3f(f6 - f9, f7 - f10, f8 - f11);
                    Deep.this.vgl.gl().glVertex3f(f6 + f9, f7 + f10, f8 + f11);
                }
                ++n;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void renderTailFromBuffer(Vector3[] vector3Array, int n, float f) {
            int n2 = vector3Array.length;
            Deep.this.vgl.enableTexture(false);
            Deep.this.vgl.gl().glBegin(8);
            int n3 = 0;
            while (n3 < n2) {
                float f2 = 1.0f - (float)n3 / (float)this._tailSize;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                float f3 = (float)n3 / (float)this._tailSize;
                if (n3 < n2 - 1) {
                    Vector3 vector3 = Vector3.sub((Vector3)vector3Array[n3 + 1], (Vector3)vector3Array[n3]);
                    vector3.normalize();
                    Vector3 vector32 = vector3.cross(new Vector3(0.0f, 0.0f, 1.0f));
                    vector32.normalize();
                    Vector3 vector33 = vector3.cross(vector32);
                    vector33.normalize();
                    vector32 = vector33.cross(vector3);
                    vector32.normalize();
                    this._right = vector32.copy();
                    float f4 = vector3Array[n3].x;
                    float f5 = vector3Array[n3].y;
                    float f6 = vector3Array[n3].z;
                    float f7 = vector32.x * (float)n * f2;
                    float f8 = vector32.y * (float)n * f2;
                    float f9 = vector32.z * (float)n * f2;
                    Deep.this.vgl.gl().glColor4f(1.0f, 1.0f, 1.0f, f2 * f3 * f);
                    Deep.this.vgl.gl().glVertex3f(f4 - f7, f5 - f8, f6 - f9);
                    Deep.this.vgl.gl().glVertex3f(f4 + f7, f5 + f8, f6 + f9);
                }
                ++n3;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void renderTailCylinder() {
            float f = 1.0f / (float)(this._facets + 1);
            float f2 = (float)Math.PI * 2 / (float)(this._facets + 1);
            int n = 0;
            while (n < this._tailRenderSegments - 1) {
                float f3 = (float)(n + 1) / (float)this._tailSize;
                Vector3 vector3 = new Vector3();
                vector3 = this._tail[n].copy();
                Vector3 vector32 = new Vector3();
                vector32 = this._tail[n + 1].copy();
                Vector3 vector33 = new Vector3();
                vector33.x = vector32.x - vector3.x;
                vector33.y = vector32.y - vector3.y;
                vector33.z = vector32.z - vector3.z;
                Vector3 vector34 = new Vector3();
                vector34.x = vector32.x + vector3.x;
                vector34.y = vector32.y + vector3.y;
                vector34.z = vector32.z + vector3.z;
                Vector3 vector35 = new Vector3();
                vector35 = vector33.cross(vector34);
                vector34 = vector35.cross(vector33);
                vector35.normalize();
                vector34.normalize();
                int n2 = 0;
                while (n2 < this._facets + 1) {
                    float f4 = Deep.sin((float)((float)n2 * f2)) * this._tailWidth * f3;
                    float f5 = Deep.cos((float)((float)n2 * f2)) * this._tailWidth * f3;
                    int n3 = n * this._facets + n2;
                    this._vertices[n3].x = vector34.x * f4 + vector35.x * f5 + vector3.x;
                    this._vertices[n3].y = vector34.y * f4 + vector35.y * f5 + vector3.y;
                    this._vertices[n3].z = vector34.z * f4 + vector35.z * f5 + vector3.z;
                    this._normals[n3].x = this._vertices[n3].x - vector3.x;
                    this._normals[n3].y = this._vertices[n3].y - vector3.y;
                    this._normals[n3].z = this._vertices[n3].z - vector3.z;
                    this._normals[n3].normalize();
                    ++n2;
                }
                this._vertices[n * this._facets + this._facets].x = this._vertices[n * this._facets + 0].x;
                this._vertices[n * this._facets + this._facets].y = this._vertices[n * this._facets + 0].y;
                this._vertices[n * this._facets + this._facets].z = this._vertices[n * this._facets + 0].z;
                this._normals[n * this._facets + this._facets].x = this._normals[n * this._facets + 0].x;
                this._normals[n * this._facets + this._facets].y = this._normals[n * this._facets + 0].y;
                this._normals[n * this._facets + this._facets].z = this._normals[n * this._facets + 0].z;
                ++n;
            }
            n = this._facets;
            int n4 = 2;
            n4 = 0;
            while (n4 < this._tailSize - 1) {
                Deep.this.vgl.gl().glBegin(5);
                int n5 = 0;
                while (n5 < n + 1) {
                    Deep.this.vgl.gl().glColor4f(this._colour.x, this._colour.y, this._colour.z, this._colour.w);
                    Deep.this.vgl.gl().glNormal3f(this._normals[n5 + n4 * n].x, this._normals[n5 + n4 * n].y, this._normals[n5 + n4 * n].z);
                    Deep.this.vgl.gl().glVertex3f(this._vertices[n5 + n4 * n].x, this._vertices[n5 + n4 * n].y, this._vertices[n5 + n4 * n].z);
                    Deep.this.vgl.gl().glColor4f(this._colour.x, this._colour.y, this._colour.z, this._colour.w);
                    Deep.this.vgl.gl().glNormal3f(this._normals[n5 + (n4 + 1) * n].x, this._normals[n5 + (n4 + 1) * n].y, this._normals[n5 + (n4 + 1) * n].z);
                    Deep.this.vgl.gl().glVertex3f(this._vertices[n5 + (n4 + 1) * n].x, this._vertices[n5 + (n4 + 1) * n].y, this._vertices[n5 + (n4 + 1) * n].z);
                    ++n5;
                }
                Deep.this.vgl.gl().glEnd();
                ++n4;
            }
        }

        public void reset(Vector3 vector3, float f) {
            this.setHead(vector3);
            this.computeTail();
            this.setTimeToLive(f);
            this._tailRenderSegments = 0;
            this._age = 0.0f;
            this._doUpdate = true;
            if (Deep.this.random(100.0f) > 50.0f) {
                this._colour.set(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this._colour.set(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    class RibbonTactu {
        int _facets;
        int[] yTable;
        Vector3[] _vertices;
        Vector3[] _normals;
        int _headTexID;
        int _tailTexID;
        Vector4 _colour;
        boolean _doRenderHead;
        boolean _doUpdate;
        float _age;
        float _agePer;
        float _timeToLive;
        float _invTimeToLive;
        Vector3 _initPos;
        float _headSize;
        Vector3 _head;
        Vector3 _right;
        Vector3 _add;
        float _tailWidth;
        int _tailRenderSegments;
        int _tailSize;
        Vector3[] _tail;

        RibbonTactu() {
            this._doRenderHead = true;
            this._doUpdate = true;
            this._tailTexID = -1;
            this._headTexID = -1;
            this._tailSize = 20;
            this._tailRenderSegments = 0;
            this._tailWidth = 1.0f;
            this._initPos = new Vector3();
            this._headSize = 24.0f;
            this._head = new Vector3();
            this._right = new Vector3();
            this._add = new Vector3();
            this._age = 0.0f;
            this._agePer = 0.0f;
            this._timeToLive = 100.0f;
            this._invTimeToLive = 1.0f / this._timeToLive;
            this._facets = 8;
            this._colour = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
            this.yTable = new int[this._tailSize];
            int n = 0;
            while (n < this._tailSize) {
                this.yTable[n] = n * (this._facets + 1);
                ++n;
            }
            this._vertices = new Vector3[this._tailSize * (this._facets + 1)];
            this._normals = new Vector3[this._tailSize * (this._facets + 1)];
            n = 0;
            while (n < this._tailSize * (this._facets + 1)) {
                this._vertices[n] = new Vector3();
                this._normals[n] = new Vector3();
                ++n;
            }
        }

        RibbonTactu(int n, float f, float f2, boolean bl) {
            this._doRenderHead = bl;
            this._doUpdate = true;
            this._tailSize = n;
            this._tailRenderSegments = 0;
            this._tailWidth = f;
            this._initPos = new Vector3();
            this._headSize = f2;
            this._head = new Vector3();
            this._right = new Vector3();
            this._add = new Vector3();
            this._age = 0.0f;
            this._agePer = 0.0f;
            this._timeToLive = 100.0f;
            this._invTimeToLive = 1.0f / this._timeToLive;
            this._colour = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
            this._facets = 8;
            this.yTable = new int[this._tailSize];
            int n2 = 0;
            while (n2 < this._tailSize) {
                this.yTable[n2] = n2 * (this._facets + 1);
                ++n2;
            }
            this._vertices = new Vector3[this._tailSize * (this._facets + 1)];
            this._normals = new Vector3[this._tailSize * (this._facets + 1)];
            n2 = 0;
            while (n2 < this._tailSize * (this._facets + 1)) {
                this._vertices[n2] = new Vector3();
                this._normals[n2] = new Vector3();
                ++n2;
            }
        }

        public void setHeadTexture(int n) {
            this._headTexID = n;
        }

        public void setTailTexture(int n) {
            this._tailTexID = n;
        }

        public void computeTail() {
            if (this._tail == null) {
                this._tail = new Vector3[this._tailSize];
            }
            int n = 0;
            while (n < this._tailSize) {
                this._tail[n] = new Vector3();
                this._tail[n] = this._head.copy();
                ++n;
            }
        }

        public boolean isDead() {
            return this._age >= this._timeToLive;
        }

        public void setTimeToLive(float f) {
            this._timeToLive = f;
            this._invTimeToLive = 1.0f / this._timeToLive;
        }

        public void setHeadY(float f) {
            this._head.y = f;
            this._initPos = this._head.copy();
        }

        public void setHead(float f, float f2) {
            this._head.set(f, f2, 0.0f);
            this._initPos = this._head.copy();
        }

        public void setHead(float f, float f2, float f3) {
            this._head.set(f, f2, f3);
            this._initPos = this._head.copy();
        }

        public void setHead(Vector3 vector3) {
            this._head = vector3;
            this._initPos = this._head.copy();
        }

        public void addHead(float f, float f2) {
            if (this._doUpdate) {
                this._head.add(f, f2, 0.0f);
            }
        }

        public void addHead(float f, float f2, float f3) {
            if (this._doUpdate) {
                this._head.add(f, f2, f3);
            }
        }

        public void addHead(Vector3 vector3) {
            if (this._doUpdate) {
                this._head.add(vector3);
            }
        }

        public void renderHead(boolean bl) {
            this._doRenderHead = bl;
        }

        public void update(float f) {
            if (this._age < this._timeToLive) {
                if (this._tailRenderSegments < this._tailSize) {
                    int n = this._tailRenderSegments;
                    while (n > 0) {
                        this._tail[n] = this._tail[n - 1];
                        --n;
                    }
                    this._tail[0] = this._head.copy();
                    ++this._tailRenderSegments;
                } else {
                    this._doUpdate = false;
                }
            }
            if (this._doUpdate) {
                this._head.add(this._add);
                this._age += 0.05f;
                this._agePer = this._age * this._invTimeToLive;
            }
        }

        public void draw(float f) {
            Deep.this.vgl.gl().glDisable(2884);
            Deep.this.vgl.setDepthWrite(false);
            this.renderTail(f);
            if (!this._doUpdate) {
                this._head = this._tail[0].copy();
            }
        }

        public void drawCylinderRibbon(float f) {
            if (this._age < this._timeToLive) {
                Deep.this.vgl.gl().glDisable(2884);
                Deep.this.vgl.setDepthWrite(true);
                Deep.this.vgl.setAlphaBlend();
                this.renderTailCylinder(f);
            }
        }

        public void renderHead() {
            if (this._headTexID >= 0) {
                Deep.this.vgl.enableTexture(true);
                Deep.this.vgl.gl().glBindTexture(3553, this._headTexID);
            }
            Deep.this.vgl.setDepthWrite(false);
            Deep.this.vgl.setAlphaBlend();
            Deep.this.vgl.fill(1.0f, 1.0f - this._agePer);
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this._head.x, this._head.y, this._head.z);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.quad(this._headSize);
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.setDepthWrite(true);
        }

        public void renderTail(float f) {
            Deep.this.vgl.gl().glBegin(8);
            int n = 0;
            while (n < this._tailSize - 1) {
                float f2 = (float)n / (float)this._tailSize;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                if (n < this._tailSize - 1) {
                    Vector3 vector3 = Vector3.sub((Vector3)this._tail[n + 1], (Vector3)this._tail[n]);
                    vector3.normalize();
                    Vector3 vector32 = vector3.cross(new Vector3(0.0f, 1.0f, 0.0f));
                    vector32.normalize();
                    Vector3 vector33 = vector3.cross(vector32);
                    vector33.normalize();
                    vector32 = vector33.cross(vector3);
                    vector32.normalize();
                    this._right = vector32.copy();
                    float f3 = this._tail[n].x;
                    float f4 = this._tail[n].y - 10.0f;
                    float f5 = this._tail[n].z;
                    f3 += Deep.sin((float)(f * 0.2f + (float)n * 0.05f)) * 10.0f;
                    float f6 = vector32.x * this._tailWidth * f2;
                    float f7 = vector32.y * this._tailWidth * f2;
                    float f8 = vector32.z * this._tailWidth * f2;
                    Deep.this.vgl.gl().glColor4f(0.0f, 0.0f, 0.0f, (1.0f - this._agePer) * 0.25f);
                    Deep.this.vgl.gl().glVertex3f(f3 - f6, (f4 += Deep.sin((float)(f * 0.2f + (float)n * 0.05f)) * 10.0f) - f7, (f5 += Deep.sin((float)(f * 0.2f + (float)n * 0.05f)) * 10.0f) - f8);
                    Deep.this.vgl.gl().glVertex3f(f3 + f6, f4 + f7, f5 + f8);
                }
                ++n;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void renderTailColor(float f, float f2, float f3, float f4) {
            Deep.this.vgl.gl().glBegin(8);
            int n = 0;
            while (n < this._tailSize - 1) {
                float f5 = (float)n / (float)this._tailSize;
                if (f5 > 1.0f) {
                    f5 = 1.0f;
                }
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (n < this._tailSize - 1) {
                    Vector3 vector3 = Vector3.sub((Vector3)this._tail[n + 1], (Vector3)this._tail[n]);
                    vector3.normalize();
                    Vector3 vector32 = vector3.cross(new Vector3(0.0f, 1.0f, 0.0f));
                    vector32.normalize();
                    Vector3 vector33 = vector3.cross(vector32);
                    vector33.normalize();
                    vector32 = vector33.cross(vector3);
                    vector32.normalize();
                    this._right = vector32.copy();
                    float f6 = this._tail[n].x;
                    float f7 = this._tail[n].y;
                    float f8 = this._tail[n].z;
                    f6 = this._tail[n].x + this._right.x * Deep.sin((float)((float)n * 0.12f + Deep.this.time * 2.0f)) * 3.0f * (float)(this._tailSize - n) * 0.053f;
                    f7 = this._tail[n].y - 3.0f;
                    f8 = this._tail[n].z + this._right.z * Deep.sin((float)((float)n * 0.12f + Deep.this.time * 2.0f)) * 3.0f * (float)(this._tailSize - n) * 0.053f;
                    float f9 = vector32.x * this._tailWidth * f5;
                    float f10 = vector32.y * this._tailWidth * f5;
                    float f11 = vector32.z * this._tailWidth * f5;
                    Deep.this.vgl.gl().glColor4f(f, f2, f3, 1.0f - this._agePer);
                    Deep.this.vgl.gl().glVertex3f(f6 - f9, f7 - f10, f8 - f11);
                    Deep.this.vgl.gl().glVertex3f(f6 + f9, f7 + f10, f8 + f11);
                }
                ++n;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void renderTailFromBuffer(Vector3[] vector3Array, int n) {
            int n2 = vector3Array.length;
            Deep.this.vgl.enableTexture(false);
            Deep.this.vgl.gl().glBegin(8);
            int n3 = 0;
            while (n3 < n2) {
                float f = 1.0f - (float)n3 / (float)this._tailSize;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                if (f < 0.0f) {
                    f = 0.0f;
                }
                float f2 = (float)n3 / (float)this._tailSize;
                if (n3 < n2 - 1) {
                    Vector3 vector3 = Vector3.sub((Vector3)vector3Array[n3 + 1], (Vector3)vector3Array[n3]);
                    vector3.normalize();
                    Vector3 vector32 = vector3.cross(new Vector3(0.0f, 0.0f, 1.0f));
                    vector32.normalize();
                    Vector3 vector33 = vector3.cross(vector32);
                    vector33.normalize();
                    vector32 = vector33.cross(vector3);
                    vector32.normalize();
                    this._right = vector32.copy();
                    float f3 = vector3Array[n3].x;
                    float f4 = vector3Array[n3].y;
                    float f5 = vector3Array[n3].z;
                    float f6 = vector32.x * (float)n * f;
                    float f7 = vector32.y * (float)n * f;
                    float f8 = vector32.z * (float)n * f;
                    Deep.this.vgl.gl().glColor4f(1.0f, 1.0f, 1.0f, this._agePer * f * f2);
                    Deep.this.vgl.gl().glVertex3f(f3 - f6, f4 - f7, f5 - f8);
                    Deep.this.vgl.gl().glVertex3f(f3 + f6, f4 + f7, f5 + f8);
                }
                ++n3;
            }
            Deep.this.vgl.gl().glEnd();
        }

        public void renderTailCylinder(float f) {
            float f2 = 1.0f / (float)(this._facets + 1);
            float f3 = (float)Math.PI * 2 / (float)(this._facets + 1);
            int n = 0;
            while (n < this._tailRenderSegments - 1) {
                float f4 = (float)n / (float)this._tailSize;
                Vector3 vector3 = new Vector3();
                vector3 = this._tail[n].copy();
                vector3.x += Deep.sin((float)(f * 0.2f + (float)n * 0.05f)) * 10.0f;
                vector3.y += Deep.sin((float)(f * 0.2f + (float)n * 0.05f)) * 10.0f;
                vector3.z += Deep.sin((float)(f * 0.2f + (float)n * 0.05f)) * 10.0f;
                Vector3 vector32 = new Vector3();
                vector32 = this._tail[n + 1].copy();
                vector32.x += Deep.sin((float)(f * 0.2f + (float)(n + 1) * 0.05f)) * 10.0f;
                vector32.y += Deep.sin((float)(f * 0.2f + (float)n * 0.05f)) * 10.0f;
                vector32.z += Deep.sin((float)(f * 0.2f + (float)(n + 1) * 0.05f)) * 10.0f;
                Vector3 vector33 = new Vector3();
                vector33.x = vector32.x - vector3.x;
                vector33.y = vector32.y - vector3.y;
                vector33.z = vector32.z - vector3.z;
                vector33.normalize();
                Vector3 vector34 = new Vector3(0.0f, 1.0f, 0.0f);
                Vector3 vector35 = new Vector3();
                vector35 = vector33.cross(vector34);
                vector35.normalize();
                vector34 = vector35.cross(vector33);
                vector34.normalize();
                int n2 = 0;
                while (n2 < this._facets + 1) {
                    float f5 = Deep.sin((float)((float)n2 * f3)) * this._tailWidth * f4;
                    float f6 = Deep.cos((float)((float)n2 * f3)) * this._tailWidth * f4;
                    int n3 = n * this._facets + n2;
                    this._vertices[n3].x = vector34.x * f5 + vector35.x * f6 + vector3.x;
                    this._vertices[n3].y = vector34.y * f5 + vector35.y * f6 + vector3.y;
                    this._vertices[n3].z = vector34.z * f5 + vector35.z * f6 + vector3.z;
                    this._normals[n3].x = this._vertices[n3].x - vector3.x;
                    this._normals[n3].y = this._vertices[n3].y - vector3.y;
                    this._normals[n3].z = this._vertices[n3].z - vector3.z;
                    this._normals[n3].normalize();
                    ++n2;
                }
                this._vertices[n * this._facets + this._facets].x = this._vertices[n * this._facets + 0].x;
                this._vertices[n * this._facets + this._facets].y = this._vertices[n * this._facets + 0].y;
                this._vertices[n * this._facets + this._facets].z = this._vertices[n * this._facets + 0].z;
                this._normals[n * this._facets + this._facets].x = this._normals[n * this._facets + 0].x;
                this._normals[n * this._facets + this._facets].y = this._normals[n * this._facets + 0].y;
                this._normals[n * this._facets + this._facets].z = this._normals[n * this._facets + 0].z;
                ++n;
            }
            n = this._facets;
            int n4 = 2;
            n4 = 0;
            while (n4 < this._tailSize - 1) {
                Deep.this.vgl.gl().glBegin(5);
                int n5 = 0;
                while (n5 < n + 1) {
                    Deep.this.vgl.gl().glColor4f(this._colour.x, this._colour.y, this._colour.z, this._colour.w);
                    Deep.this.vgl.gl().glNormal3f(this._normals[n5 + n4 * n].x, this._normals[n5 + n4 * n].y, this._normals[n5 + n4 * n].z);
                    Deep.this.vgl.gl().glVertex3f(this._vertices[n5 + n4 * n].x, this._vertices[n5 + n4 * n].y, this._vertices[n5 + n4 * n].z);
                    Deep.this.vgl.gl().glColor4f(this._colour.x, this._colour.y, this._colour.z, this._colour.w);
                    Deep.this.vgl.gl().glNormal3f(this._normals[n5 + (n4 + 1) * n].x, this._normals[n5 + (n4 + 1) * n].y, this._normals[n5 + (n4 + 1) * n].z);
                    Deep.this.vgl.gl().glVertex3f(this._vertices[n5 + (n4 + 1) * n].x, this._vertices[n5 + (n4 + 1) * n].y, this._vertices[n5 + (n4 + 1) * n].z);
                    ++n5;
                }
                Deep.this.vgl.gl().glEnd();
                ++n4;
            }
        }

        public void reset(Vector3 vector3, float f) {
            this.setHead(vector3);
            this.computeTail();
            this.setTimeToLive(f);
            this._tailRenderSegments = 0;
            this._age = 0.0f;
            this._doUpdate = true;
            if (Deep.this.random(100.0f) > 50.0f) {
                this._colour.set(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this._colour.set(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    class Sphere {
        int sphereStacks = 120;
        int sphereSlices = 120;
        Vector3[] sphereSurface;
        int[] sphereIndices;
        Vector3[] sphereSurfaceUV;
        Vector3[] sphereSurfaceNormal;
        Color4 _color;
        float _radius;
        int _callListID;
        boolean _callListCompiled;

        Sphere() {
            this._callListID = 0;
            this._callListCompiled = false;
            this._color = new Color4(1.0f, 0.0f, 1.0f, 1.0f);
        }

        Sphere(boolean bl) {
            this._callListID = Deep.this.vgl.gl().glGenLists(1);
            this._callListCompiled = false;
            this._color = new Color4(1.0f, 0.0f, 1.0f, 1.0f);
        }

        public void buildSphere(int n, int n2, float f) {
            int n3;
            Vector3 vector3 = new Vector3(0.0f, 0.0f, 0.0f);
            this.sphereStacks = n;
            this.sphereSlices = n2;
            this._radius = f;
            Vector3 vector32 = new Vector3();
            Vector3 vector33 = new Vector3();
            int n4 = n2;
            int n5 = (n + 1) * n2;
            this.sphereSurface = new Vector3[n5];
            this.sphereSurfaceNormal = new Vector3[n5];
            this.sphereSurfaceUV = new Vector3[n5];
            int n6 = 0;
            while (n6 < n5) {
                this.sphereSurface[n6] = new Vector3();
                this.sphereSurfaceNormal[n6] = new Vector3();
                this.sphereSurfaceUV[n6] = new Vector3();
                ++n6;
            }
            n6 = 0;
            while (n6 < n + 1) {
                n3 = 0;
                while (n3 < n2) {
                    float f2 = (float)n6 * (float)Math.PI / (float)n;
                    float f3 = (float)(n3 * 2) * (float)Math.PI / (float)n2;
                    float f4 = Deep.sin((float)f2);
                    float f5 = Deep.sin((float)f3);
                    float f6 = Deep.cos((float)f2);
                    float f7 = Deep.cos((float)f3);
                    float f8 = 1.0f - (float)n3 / PApplet.parseFloat((int)(n2 - 1));
                    f8 *= 3.0f;
                    float f9 = (float)n6 / PApplet.parseFloat((int)n);
                    vector32.x = f7 * f4;
                    vector32.y = f6;
                    vector32.z = f5 * f4;
                    vector33.x = vector3.x + this._radius * vector32.x;
                    vector33.y = vector3.y + this._radius * vector32.y;
                    vector33.z = vector3.z + this._radius * vector32.z;
                    int n7 = n6 * n4 + n3;
                    this.sphereSurface[n7].x = vector33.x;
                    this.sphereSurface[n7].y = vector33.y;
                    this.sphereSurface[n7].z = vector33.z;
                    this.sphereSurfaceNormal[n7].x = vector32.x;
                    this.sphereSurfaceNormal[n7].y = vector32.y;
                    this.sphereSurfaceNormal[n7].z = vector32.z;
                    this.sphereSurfaceNormal[n7].normalize();
                    this.sphereSurfaceUV[n7].x = f8;
                    this.sphereSurfaceUV[n7].y = f9;
                    ++n3;
                }
                ++n6;
            }
            n3 = 0;
            while (n3 < n + 1) {
                this.sphereSurface[n3 * n2 + n2 - 1].x = this.sphereSurface[n3 * n2 + 0].x;
                this.sphereSurface[n3 * n2 + n2 - 1].y = this.sphereSurface[n3 * n2 + 0].y;
                this.sphereSurface[n3 * n2 + n2 - 1].z = this.sphereSurface[n3 * n2 + 0].z;
                this.sphereSurfaceNormal[n3 * n2 + n2 - 1].x = this.sphereSurfaceNormal[n3 * n2 + 0].x;
                this.sphereSurfaceNormal[n3 * n2 + n2 - 1].y = this.sphereSurfaceNormal[n3 * n2 + 0].y;
                this.sphereSurfaceNormal[n3 * n2 + n2 - 1].z = this.sphereSurfaceNormal[n3 * n2 + 0].z;
                ++n3;
            }
            this.sphereIndices = new int[n5 * 2];
            int n8 = 0;
            n6 = 0;
            while (n6 < n) {
                n3 = 0;
                while (n3 < n2) {
                    this.sphereIndices[n8 + 0] = n6 * n2 + n3 % n2;
                    this.sphereIndices[n8 + 0] = (n6 + 1) * n2 + n3 % n2;
                    ++n3;
                }
                ++n6;
            }
        }

        public void drawSphere() {
            this.drawSphere(0.0f, 0.0f, 0.0f, this._radius);
        }

        public void drawSphere(float f) {
            this.drawSphere(0.0f, 0.0f, 0.0f, f);
        }

        public void drawSphere(float f, float f2, float f3, float f4) {
            if (this._callListID > 0 && this._callListCompiled) {
                Deep.this.vgl.gl().glCallList(this._callListID);
                return;
            }
            if (this._callListID > 0 && !this._callListCompiled) {
                Deep.this.vgl.gl().glNewList(this._callListID, 4864);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.sphereStacks) {
                n = n3 * this.sphereSlices;
                n2 = (n3 + 1) * this.sphereSlices;
                Deep.this.vgl.gl().glBegin(5);
                Deep.this.vgl.gl().glColor4f(this._color.r, this._color.g, this._color.b, this._color.a);
                int n4 = 0;
                while (n4 < this.sphereSlices) {
                    float f5 = f + this.sphereSurface[n + n4].x * f4;
                    float f6 = f2 + this.sphereSurface[n + n4].y * f4;
                    float f7 = f3 + this.sphereSurface[n + n4].z * f4;
                    float f8 = f + this.sphereSurface[n2 + n4].x * f4;
                    float f9 = f2 + this.sphereSurface[n2 + n4].y * f4;
                    float f10 = f3 + this.sphereSurface[n2 + n4].z * f4;
                    float f11 = this.sphereSurfaceNormal[n + n4].x;
                    float f12 = this.sphereSurfaceNormal[n + n4].y;
                    float f13 = this.sphereSurfaceNormal[n + n4].z;
                    float f14 = this.sphereSurfaceNormal[n2 + n4].x;
                    float f15 = this.sphereSurfaceNormal[n2 + n4].y;
                    float f16 = this.sphereSurfaceNormal[n2 + n4].z;
                    Deep.this.vgl.gl().glNormal3f(f11, f12, f13);
                    Deep.this.vgl.gl().glVertex3f(f5, f6, f7);
                    Deep.this.vgl.gl().glNormal3f(f14, f15, f16);
                    Deep.this.vgl.gl().glVertex3f(f8, f9, f10);
                    ++n4;
                }
                Deep.this.vgl.gl().glEnd();
                ++n3;
            }
            if (this._callListID > 0 && !this._callListCompiled) {
                Deep.this.vgl.gl().glEndList();
                this._callListCompiled = true;
            }
        }

        public void drawSphereTextured(float f, float f2, float f3, float f4) {
            if (this._callListID > 0 && this._callListCompiled) {
                Deep.this.vgl.gl().glCallList(this._callListID);
                return;
            }
            if (this._callListID > 0 && !this._callListCompiled) {
                Deep.this.vgl.gl().glNewList(this._callListID, 4864);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.sphereStacks) {
                n = n3 * this.sphereSlices;
                n2 = (n3 + 1) * this.sphereSlices;
                Deep.this.vgl.gl().glBegin(5);
                Deep.this.vgl.gl().glColor4f(this._color.r, this._color.g, this._color.b, this._color.a);
                int n4 = 0;
                while (n4 < this.sphereSlices) {
                    float f5 = f + this.sphereSurface[n + n4].x * f4;
                    float f6 = f2 + this.sphereSurface[n + n4].y * f4;
                    float f7 = f3 + this.sphereSurface[n + n4].z * f4;
                    float f8 = f + this.sphereSurface[n2 + n4].x * f4;
                    float f9 = f2 + this.sphereSurface[n2 + n4].y * f4;
                    float f10 = f3 + this.sphereSurface[n2 + n4].z * f4;
                    float f11 = this.sphereSurfaceNormal[n + n4].x;
                    float f12 = this.sphereSurfaceNormal[n + n4].y;
                    float f13 = this.sphereSurfaceNormal[n + n4].z;
                    float f14 = this.sphereSurfaceNormal[n2 + n4].x;
                    float f15 = this.sphereSurfaceNormal[n2 + n4].y;
                    float f16 = this.sphereSurfaceNormal[n2 + n4].z;
                    Deep.this.vgl.gl().glNormal3f(f11, f12, f13);
                    Deep.this.vgl.gl().glTexCoord2f(this.sphereSurfaceUV[n + n4].x, this.sphereSurfaceUV[n + n4].y);
                    Deep.this.vgl.gl().glVertex3f(f5, f6, f7);
                    Deep.this.vgl.gl().glNormal3f(f14, f15, f16);
                    Deep.this.vgl.gl().glTexCoord2f(this.sphereSurfaceUV[n2 + n4].x, this.sphereSurfaceUV[n2 + n4].y);
                    Deep.this.vgl.gl().glVertex3f(f8, f9, f10);
                    ++n4;
                }
                Deep.this.vgl.gl().glEnd();
                ++n3;
            }
            if (this._callListID > 0 && !this._callListCompiled) {
                Deep.this.vgl.gl().glEndList();
                this._callListCompiled = true;
            }
        }

        public void setColor(float f, float f2, float f3, float f4) {
            this._color.set(f, f2, f3, f4);
        }
    }

    class SpikeyScene {
        Matrix tmpMat;
        int furID;
        float _globalAlpha;
        float furLength;
        float uvTexScale;
        float uvFurScale;
        Vector3 force;
        Vector3 gravity;
        Vector3 normalNoise;
        int numLayers;
        float invNumLayers;
        int furTexSize;
        XTexture[] furTex;
        PImage[] noiseTextures;
        XTexture furColor;
        XTexture shadowTex;
        objComparator comparator;
        int _numBalls;
        ArrayList _ballPos;
        ArrayList _ballPosViewSpace;
        float[] anglesZ;
        float sphereRadius;
        float[] sphereScale;
        Sphere oursphere;
        Vector3 eye;
        Vector3 target;

        SpikeyScene() {
            this.comparator = new objComparator();
            this._ballPos = new ArrayList();
            this._ballPosViewSpace = new ArrayList();
            this._ballPos.add(new Vector3Order(-460.0f, -400.0f, -1230.0f, 6));
            this._ballPos.add(new Vector3Order(-710.0f, -200.0f, -500.0f, 4));
            this._ballPos.add(new Vector3Order(-910.0f, 0.0f, 0.0f, 3));
            this._numBalls = this._ballPos.size();
            this.sphereScale = new float[this._numBalls];
            this.sphereScale[0] = 2.5f;
            this.sphereScale[Deep.abs((int)-1)] = 2.0f;
            this.sphereScale[2] = 2.0f;
            this.anglesZ = new float[this._numBalls];
            int n = 0;
            while (n < this._numBalls) {
                this.anglesZ[n] = 0.0f;
                ++n;
            }
            this.sphereRadius = 60.0f;
            this.oursphere = new Sphere(true);
            this.oursphere.setColor(0.7f * Deep.this.gamma, 0.7f * Deep.this.gamma, 1.0f * Deep.this.gamma, 1.0f);
            this.oursphere.buildSphere(10, 10, this.sphereRadius);
            this.furLength = 30.0f;
            this.uvTexScale = 2.0f;
            this.uvFurScale = 4.0f;
            this.numLayers = 26;
            this.invNumLayers = 1.0f / (float)this.numLayers;
            this.furTexSize = 128;
            this.furColor = new XTexture("texture_blue.png");
            this.furColor.setWrap();
            this.shadowTex = new XTexture("particle_black.png");
            this.shadowTex.setClamp();
            this.furID = Deep.this.vgl.addEffectFromFile(Deep.this.dataPath("fursimple.cgfx"));
            this.eye = new Vector3();
            this.target = new Vector3();
            this._globalAlpha = 0.0f;
        }

        public void init() {
            int n;
            int n2;
            int n3;
            int n4 = 19000;
            this.furTex = new XTexture[this.numLayers];
            this.noiseTextures = new PImage[this.numLayers];
            int n5 = 0;
            while (n5 < this.numLayers) {
                this.noiseTextures[n5] = Deep.this.createImage(this.furTexSize, this.furTexSize, 2);
                this.noiseTextures[n5].loadPixels();
                n3 = 0;
                while (n3 < this.furTexSize) {
                    n2 = 0;
                    while (n2 < this.furTexSize) {
                        this.noiseTextures[n5].pixels[n3 * this.furTexSize + n2] = Deep.this.color(0, 0, 0, 0);
                        ++n2;
                    }
                    ++n3;
                }
                this.noiseTextures[n5].updatePixels();
                ++n5;
            }
            n5 = n4 * this.furTexSize * this.furTexSize;
            n3 = n5 / this.numLayers;
            n2 = 0;
            while (n2 < this.numLayers) {
                this.noiseTextures[n2].loadPixels();
                float f = PApplet.parseFloat((int)n2) / (float)this.numLayers;
                f = 1.0f - f;
                n = (int)((float)n4 * f * 6.0f);
                Deep.this.randomSeed(28382L);
                int n6 = 0;
                while (n6 < n) {
                    int n7 = n6 * this.numLayers / n3;
                    int n8 = (int)Deep.this.random(0.0f, this.furTexSize);
                    int n9 = (int)Deep.this.random(0.0f, this.furTexSize);
                    this.noiseTextures[n2].pixels[n9 * this.furTexSize + n8] = Deep.this.color(255, 255, 255, 255);
                    ++n6;
                }
                this.noiseTextures[n2].updatePixels();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.furTexSize) {
                int n10 = 0;
                while (n10 < this.furTexSize) {
                    n = 0;
                    while (n < this.numLayers) {
                        this.noiseTextures[n].loadPixels();
                        float f = (float)n / (float)this.numLayers;
                        float f2 = Deep.this.alpha(this.noiseTextures[n].pixels[n10 * this.furTexSize + n2]);
                        if (f2 > 0.0f) {
                            this.noiseTextures[n].pixels[n10 * this.furTexSize + n2] = Deep.this.color(255.0f, 255.0f, 255.0f, (1.0f - f) * 128.0f);
                        }
                        this.noiseTextures[n].updatePixels();
                        ++n;
                    }
                    ++n10;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.numLayers) {
                this.furTex[n2] = new XTexture();
                this.furTex[n2].loadPImageFromMemory(this.noiseTextures[n2]);
                this.furTex[n2].setWrap();
                ++n2;
            }
            this.force = new Vector3();
            this.gravity = new Vector3(0.0f, 0.0f, 0.0f);
            this.normalNoise = new Vector3();
        }

        public void draw(float f) {
            this._ballPosViewSpace.clear();
            int n = 0;
            while (n < this._ballPos.size()) {
                Vector3 vector3 = (Vector3)this._ballPos.get(n);
                Vector3 vector32 = Vector3.transform((Vector3)vector3, (Matrix)Deep.this.camMatrix);
                this._ballPosViewSpace.add(new Vector3Order(vector32, n));
                ++n;
            }
            n = 0;
            while (n < this._ballPos.size()) {
                int n2 = ((Vector3Order)((Object)this._ballPosViewSpace.get((int)n))).idx;
                this.drawfur(n, f, (Vector3)this._ballPos.get(n2), 1 + n2, 2.0f);
                ++n;
            }
            this.update(f);
        }

        public void update(float f) {
            this._globalAlpha = 1.0f;
            int n = 0;
            while (n < this._ballPos.size()) {
                Vector3 vector3 = (Vector3)this._ballPos.get(n);
                float f2 = Deep.this.land.InterpolatedValue(vector3.x, vector3.z) + this.sphereRadius;
                vector3.y = vector3.y <= f2 ? f2 : (vector3.y -= 0.5f);
                ++n;
            }
        }

        public void drawfur(int n, float f, Vector3 vector3, float f2, float f3) {
            if (f >= 185.0f && f < 205.0f && n == 1) {
                this.anglesZ[n] = (f - 185.0f) * 10.0f;
                vector3.x -= 0.7f;
            }
            if (f >= 115.0f && f < 135.0f && n == 2) {
                vector3.x -= 0.3f;
                vector3.z += 0.1f;
                this.anglesZ[n] = (f - 115.0f) * 5.0f;
            }
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.identity();
            Deep.this.vgl.translate(vector3.x, vector3.y, vector3.z);
            Deep.this.vgl.rotateZ(this.anglesZ[n]);
            Deep.this.vgl.scale(this.sphereScale[n]);
            this.tmpMat = Deep.this.vgl.getTransposeViewMatrix();
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(vector3.x, vector3.y, vector3.z);
            Deep.this.vgl.rotateZ(this.anglesZ[n]);
            Deep.this.vgl.scale(this.sphereScale[n]);
            float f4 = this._globalAlpha;
            float f5 = 9.0f - Deep.this.noise(this.eye.z * 0.2f, f * 0.01f) * 0.3f * 9.0f;
            Deep.this.vgl.fill(0.003921569f * f5 * f4, 0.050980393f * f5 * f4, 0.14117648f * f5 * f4, 1.0f * f4);
            Deep.this.vgl.setShader(this.furID);
            Deep.this.vgl.setParameter1f("UVTexScale", f2);
            Deep.this.vgl.setParameter1f("UVFurScale", f3);
            Deep.this.vgl.setParameter3f("gravity", this.gravity);
            Deep.this.vgl.setParameter4f("fogColor", Deep.this.fogColor);
            Deep.this.vgl.setParameter1f("fogDensity", Deep.this.fogDensity);
            Deep.this.vgl.setParameter3f("cameraPos", this.eye);
            Deep.this.vgl.setParameter4f("lightPos", Deep.this.lightPos);
            Deep.this.vgl.setParameter1f("kC", Deep.this.kC);
            Deep.this.vgl.setParameter1f("kL", Deep.this.kL);
            Deep.this.vgl.setParameter1f("kQ", Deep.this.kQ);
            Deep.this.vgl.setMatrixParameterSemantic("WORLDVIEWPROJECTION", 12, 100);
            Deep.this.vgl.setMatrixParameterSemantic("MODELVIEWMATRIX", 4, 100);
            Deep.this.vgl.setMatrixParameterSemantic("VIEWINVERSETRANSPOSE", 4, 103);
            Deep.this.vgl.setMatrixParameterSemantic("WORLDMATRIX", this.tmpMat.getArray());
            Deep.this.vgl.setMatrixParameterSemantic("VIEWMATRIX", Deep.this.invCamMatrix.getArray());
            Deep.this.vgl.setTextureParameter("ColourSampler", this.furColor.getId());
            CGpass cGpass = ((ShaderCGFX)Deep.this.vgl.getActiveShader()).getTechniqueFirstPass("Technique_FurSimple");
            int n2 = 0;
            while (n2 < this.numLayers) {
                float f6 = (float)n2 * this.invNumLayers;
                float f7 = this.furLength * f6;
                this.furLength = 25.0f + (1.0f + Deep.sin((float)(f * 0.0165625f)) * 10.0f);
                this.force.set(14.0f * Deep.sin((float)(f * 1.6f)), 7.0f * Deep.sin((float)(f * 1.6f)), 4.0f * Deep.sin((float)(f * 2.12f)));
                Deep.this.vgl.setTextureParameter("FurSampler", this.furTex[n2].getId());
                Deep.this.vgl.setParameter1f("Layer", f6);
                Deep.this.vgl.setParameter1f("FurLength", f7);
                Deep.this.vgl.setParameter3f("force", this.force);
                CgGL.cgSetPassState((CGpass)cGpass);
                this.oursphere.drawSphereTextured(0.0f, 0.0f, 0.0f, 1.0f);
                CgGL.cgResetPassState((CGpass)cGpass);
                ++n2;
            }
            Deep.this.vgl.disableShader();
            Deep.this.vgl.popMatrix();
        }
    }

    class TactuScene {
        float noiseAmp;
        float noiseTimeStart = 0.0f;
        XTexture shadowTex;
        XTexture chapa;
        XTexture chapaPS;
        XTexture chapaV;
        XTexture chapaNNY;
        XTexture chapaKaz;
        int diffspecID;
        Vector4 lightPos;
        Vector3 eye;
        Vector3 eyeEnd;
        Vector3 target;
        Vector3 targetEnd;
        Vector3 up;
        float camSpeed;
        Vector4 _fogColor;
        float lfo1 = 1.0f;
        float lfo2 = 1.0f;
        float lfo3 = 1.0f;
        float time = 0.0f;
        int numRibbons = 8;
        ArrayList ribbons;
        int cylsCount = 0;
        int numCyls = 25;
        CylinderRoll[] cyls;
        float groundLevel = -105.0f;
        Sphere aquario;
        Vector3 psPos;
        Vector3 vPos;
        Vector3 nnyPos;
        Vector3 kazPos;
        int psIdx = -1;
        int vIdx = -1;
        int nnyIdx = -1;
        int kazIdx = -1;
        boolean psOn = false;
        boolean vOn = false;
        boolean nnyOn = false;
        boolean kazOn = false;
        float psTime;
        float vTime;
        float nnyTime;
        float kazTime;

        TactuScene() {
        }

        public void init() {
            this._fogColor = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
            this.lightPos = new Vector4(-600.0f, 300.0f, -600.0f, 1.0f);
            this.eye = new Vector3(0.0f, 200.0f, 180.0f);
            this.target = new Vector3(0.0f, 0.0f, 0.0f);
            this.up = new Vector3(0.0f, 1.0f, 0.0f);
            this.eyeEnd = new Vector3();
            this.targetEnd = new Vector3();
            this.camSpeed = 0.006666667f;
            this.shadowTex = new XTexture("particle_black.png");
            this.chapa = new XTexture("rotulo.png");
            this.chapaPS = new XTexture();
            this.chapaPS.loadPImage("rotulo_ps.png");
            this.chapaPS.setClamp();
            this.chapaV = new XTexture();
            this.chapaV.loadPImage("rotulo_v.png");
            this.chapaV.setClamp();
            this.chapaNNY = new XTexture();
            this.chapaNNY.loadPImage("rotulo_nny.png");
            this.chapaNNY.setClamp();
            this.chapaKaz = new XTexture();
            this.chapaKaz.loadPImage("rotulo_kaz.png");
            this.chapaKaz.setClamp();
            this.ribbons = new ArrayList();
            int n = 0;
            while (n < this.numRibbons) {
                RibbonTactu ribbonTactu = new RibbonTactu(400, 26.0f, 1.0f, false);
                ribbonTactu.setHead(0.0f, 90.0f, 0.0f);
                ribbonTactu.setTimeToLive(Deep.this.random(80.0f, 500.0f));
                ribbonTactu._colour.set(0.0f, 0.0f, 0.0f, 1.0f);
                ribbonTactu.computeTail();
                this.ribbons.add(ribbonTactu);
                ++n;
            }
            this.cyls = new CylinderRoll[this.numCyls];
            n = 0;
            while (n < this.numCyls) {
                this.cyls[n] = new CylinderRoll();
                this.cyls[n].setHead(Deep.this.random(-30.0f, 30.0f), 0.0f, Deep.this.random(-90.0f, 90.0f));
                this.cyls[n].setTimeToLive(4000.0f);
                this.cyls[n].setTailSize(300);
                this.cyls[n].setCylinderDetail(4);
                this.cyls[n].setCylinderRadius((int)Deep.this.random(4.0f, 10.0f));
                this.cyls[n]._add.set(Deep.this.random(-0.01251f, 0.01251f), Deep.this.random(0.1251f, (float)(n + 1) * 0.51f), Deep.this.random(-0.01251f, 0.01251f));
                this.cyls[n]._usePerlin = true;
                this.cyls[n].computeTail();
                ++n;
            }
            this.aquario = new Sphere();
            this.aquario.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.aquario.buildSphere(80, 80, 160.0f);
            this.diffspecID = Deep.this.vgl.addEffectFromFile(Deep.this.dataPath("diffusespecular_notexture.cgfx"));
            float f = 0.0f;
            float f2 = 400.0f;
            float f3 = Deep.cos((float)Deep.radians((float)f)) * f2;
            float f4 = Deep.sin((float)Deep.radians((float)f)) * f2;
            this.psPos = new Vector3(f3, this.groundLevel, f4);
            f = 90.0f;
            f3 = Deep.cos((float)Deep.radians((float)f)) * f2;
            f4 = Deep.sin((float)Deep.radians((float)f)) * f2;
            this.vPos = new Vector3(f3, this.groundLevel, f4);
            f = 180.0f;
            f3 = Deep.cos((float)Deep.radians((float)f)) * f2;
            f4 = Deep.sin((float)Deep.radians((float)f)) * f2;
            this.nnyPos = new Vector3(f3, this.groundLevel, f4);
            f = 270.0f;
            f3 = Deep.cos((float)Deep.radians((float)f)) * f2;
            f4 = Deep.sin((float)Deep.radians((float)f)) * f2;
            this.kazPos = new Vector3(f3, this.groundLevel, f4);
        }

        public void draw(float f) {
            Deep.this.vgl.background(1.0f);
            this.renderScene(f);
        }

        public void renderPlants() {
            this.eye.set(Deep.sin((float)(this.time * 0.1f)) * 1200.0f, 450.0f, Deep.cos((float)(this.time * 0.1f)) * 1200.0f);
            this.target.set(0.0f, 200.0f, 0.0f);
            Deep.this.vgl.perspective(45.0f, Deep.this.aspectRatio, 1.0f, 4000.0f);
            Deep.this.vgl.camera(this.eye, this.target, this.up);
            Deep.this.vgl.enableLighting(false);
            int n = 0;
            while (n < this.numCyls) {
                this.cyls[n].addHead(2.0f * Deep.sin((float)(this.time * 2.0f)), 0.0f, 0.0f);
                this.cyls[n]._colour.set(0.0f, 0.0f, 0.0f, 1.0f);
                this.cyls[n].update(this.time - this.noiseTimeStart);
                this.cyls[n].draw(this.time - this.noiseTimeStart);
                this.cyls[n]._dispoffset = 1.0f;
                this.cyls[n]._displaces = 0.0f;
                this.cyls[n]._dispscale = 19.0f;
                ++n;
            }
        }

        public void renderScene(float f) {
            float f2;
            float f3 = 7.0f;
            float f4 = f;
            float f5 = 8.0f;
            if (f4 < f3) {
                float f6 = 100.0f;
                f2 = 100.0f;
                this.eye.set(Sine.easeInOut((float)f4, (float)f2, (float)(1000.0f * Deep.sin((float)(f5 * 0.14f)) - f2), (float)f3), Sine.easeIn((float)f4, (float)160.0f, (float)290.0f, (float)f3), Sine.easeInOut((float)f4, (float)f6, (float)(1000.0f * Deep.cos((float)(f5 * 0.14f)) - f6), (float)f3));
                this.target.set(0.0f, Sine.easeInOut((float)f4, (float)50.0f, (float)150.0f, (float)f3), 0.0f);
            } else {
                this.eye.set(1000.0f * Deep.sin((float)(f5 * 0.14f)), 450.0f, 1000.0f * Deep.cos((float)(f5 * 0.14f)));
                this.target.set(0.0f, 200.0f, 0.0f);
            }
            Deep.this.vgl.perspective(45.0f, Deep.this.aspectRatio, 1.0f, 4000.0f);
            Deep.this.vgl.camera(this.eye, this.target, this.up);
            Matrix matrix = Deep.this.vgl.getTransposeViewMatrix();
            Deep.this.vgl.rotateY(Deep.degrees((float)(f * 0.14f)));
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.enableTexture(false);
            Deep.this.vgl.gl().glDisable(2912);
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(0.0f, this.groundLevel - 5.0f, 0.0f);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.fill(1.0f, 1.0f);
            Deep.this.vgl.rect(3000.0f, 3000.0f);
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.enableTexture(true);
            Deep.this.vgl.setAlphaBlend();
            Deep.this.vgl.fill(1.0f, 1.0f);
            f2 = 0.0f;
            f2 = 0.0f;
            this.chapa.enable();
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.psPos);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.rotateZ(90.0f + f2);
            Deep.this.vgl.rect(256.0f, 128.0f);
            Deep.this.vgl.popMatrix();
            this.chapa.enable();
            f2 = 90.0f;
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.vPos);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.rotateZ(90.0f + f2);
            Deep.this.vgl.rect(256.0f, 128.0f);
            Deep.this.vgl.popMatrix();
            this.chapa.enable();
            f2 = 180.0f;
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.nnyPos);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.rotateZ(90.0f + f2);
            Deep.this.vgl.rect(256.0f, 128.0f);
            Deep.this.vgl.popMatrix();
            this.chapa.enable();
            f2 = 270.0f;
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(this.kazPos);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.rotateZ(90.0f + f2);
            Deep.this.vgl.rect(256.0f, 128.0f);
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.setAdditiveBlend();
            Deep.this.vgl.enableLighting(false);
            Deep.this.vgl.setDepthWrite(false);
            Deep.this.vgl.enableTexture(true);
            Deep.this.vgl.fill(1.0f, 1.0f);
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            int n = 0;
            while (n < this.ribbons.size()) {
                RibbonTactu ribbonTactu = (RibbonTactu)this.ribbons.get(n);
                Vector3 vector3 = ribbonTactu._head.copy();
                f7 = Vector3.distance((Vector3)this.psPos, (Vector3)vector3);
                f8 = Vector3.distance((Vector3)this.vPos, (Vector3)vector3);
                f9 = Vector3.distance((Vector3)this.nnyPos, (Vector3)vector3);
                f10 = Vector3.distance((Vector3)this.kazPos, (Vector3)vector3);
                if (!this.psOn && f7 <= 90.0f) {
                    this.psOn = true;
                    this.psIdx = n;
                    this.psTime = f;
                    Deep.this.credits.loop();
                    break;
                }
                if (!this.vOn && f8 < 90.0f) {
                    this.vOn = true;
                    this.vIdx = n;
                    this.vTime = f;
                    break;
                }
                if (!this.nnyOn && f9 < 90.0f) {
                    this.nnyOn = true;
                    this.nnyIdx = n;
                    this.nnyTime = f;
                    break;
                }
                if (!this.kazOn && f10 < 90.0f) {
                    this.kazOn = true;
                    this.kazIdx = n;
                    this.kazTime = f;
                    break;
                }
                ++n;
            }
            if (this.psOn) {
                Deep.this.vgl.fill(1.0f, Deep.this.random(0.0f, (f - this.psTime) * 0.25f));
                f2 = 0.0f;
                this.chapaPS.enable();
                Deep.this.vgl.pushMatrix();
                Deep.this.vgl.translate(this.psPos);
                Deep.this.vgl.rotateX(90.0f);
                Deep.this.vgl.rotateZ(90.0f + f2);
                Deep.this.vgl.rect(256.0f, 128.0f);
                Deep.this.vgl.popMatrix();
            }
            if (this.vOn) {
                f2 = 90.0f;
                Deep.this.vgl.fill(1.0f, Deep.this.random(0.0f, (f - this.vTime) * 0.25f));
                this.chapaV.enable();
                Deep.this.vgl.pushMatrix();
                Deep.this.vgl.translate(this.vPos);
                Deep.this.vgl.rotateX(90.0f);
                Deep.this.vgl.rotateZ(90.0f + f2);
                Deep.this.vgl.rect(256.0f, 128.0f);
                Deep.this.vgl.popMatrix();
            }
            if (this.nnyOn) {
                f2 = 180.0f;
                Deep.this.vgl.fill(1.0f, Deep.this.random(0.0f, (f - this.nnyTime) * 0.25f));
                this.chapaNNY.enable();
                Deep.this.vgl.pushMatrix();
                Deep.this.vgl.translate(this.nnyPos);
                Deep.this.vgl.rotateX(90.0f);
                Deep.this.vgl.rotateZ(90.0f + f2);
                Deep.this.vgl.rect(256.0f, 128.0f);
                Deep.this.vgl.popMatrix();
            }
            if (this.kazOn) {
                f2 = 270.0f;
                Deep.this.vgl.fill(1.0f, Deep.this.random(0.0f, (f - this.kazTime) * 0.25f));
                this.chapaKaz.enable();
                Deep.this.vgl.pushMatrix();
                Deep.this.vgl.translate(this.kazPos);
                Deep.this.vgl.rotateX(90.0f);
                Deep.this.vgl.rotateZ(90.0f + f2);
                Deep.this.vgl.rect(256.0f, 128.0f);
                Deep.this.vgl.popMatrix();
            }
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setDepthMask(false);
            Deep.this.vgl.setAlphaBlend();
            Deep.this.vgl.fill(0.0095f, 0.75f);
            this.shadowTex.enable();
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(0.0f, this.groundLevel, 0.0f);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.fill(0.0f, 1.0f);
            Deep.this.vgl.rect(315.0f, 315.0f);
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(0.0f, this.groundLevel, 0.0f);
            Deep.this.vgl.rotateX(90.0f);
            Deep.this.vgl.fill(0.0f, 1.0f);
            Deep.this.vgl.rect(155.0f, 155.0f);
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.setDepthMask(true);
            if (f > f3 * 0.8f) {
                Deep.this.vgl.setAlphaBlend();
                Deep.this.vgl.enableTexture(false);
                f7 = 0.1f;
                int n2 = 0;
                while (n2 < this.ribbons.size()) {
                    RibbonTactu ribbonTactu = (RibbonTactu)this.ribbons.get(n2);
                    ribbonTactu._tailWidth = 12.0f;
                    f10 = -((float)(n2 * 2) * (float)Math.PI / (float)this.ribbons.size());
                    ribbonTactu.addHead(f7 * Deep.cos((float)(-f10)) * 16.0f, (this.groundLevel - ribbonTactu._head.y + ribbonTactu._tailWidth) * 0.025f, f7 * Deep.sin((float)(-f10)) * 16.0f);
                    ribbonTactu.update(f);
                    ribbonTactu.draw(f);
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.ribbons.size()) {
                    Deep.this.vgl.setAlphaBlend();
                    RibbonTactu ribbonTactu = (RibbonTactu)this.ribbons.get(n2);
                    ribbonTactu.drawCylinderRibbon(f);
                    ++n2;
                }
            }
            Deep.this.vgl.enableLighting(true);
            Deep.this.vgl.setDepthWrite(true);
            Deep.this.vgl.setDepthMask(true);
            Deep.this.vgl.enableTexture(false);
            Deep.this.vgl.fill(0.0f, 0.0f, 0.1f, 1.0f);
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.translate(0.0f, this.groundLevel + 160.0f, 0.0f);
            Deep.this.vgl.rotateY(f * 10.0f);
            Deep.this.vgl.pushMatrix();
            Deep.this.vgl.identity();
            Deep.this.vgl.translate(0.0f, this.groundLevel + 160.0f, 0.0f);
            Deep.this.vgl.rotateY(f * 10.0f);
            Matrix matrix2 = Deep.this.vgl.getTransposeViewMatrix();
            Deep.this.vgl.popMatrix();
            Deep.this.vgl.setShader(this.diffspecID);
            Deep.this.vgl.setParameter3f("cameraPos", this.eye);
            Deep.this.vgl.setParameter4f("lightPos", this.lightPos);
            Deep.this.vgl.setParameter4f("fogColor", Deep.this.fogColor);
            Deep.this.vgl.setParameter1f("fogDensity", 8.0E-5f);
            Deep.this.vgl.setParameter1f("kC", Deep.this.kC);
            Deep.this.vgl.setParameter1f("kL", Deep.this.kL);
            Deep.this.vgl.setParameter1f("kQ", Deep.this.kQ);
            Deep.this.vgl.setParameter1f("specularLevel", 8.0f);
            Deep.this.vgl.setParameter1f("useSpecular", 1.0f);
            Deep.this.vgl.setMatrixParameterSemantic("WORLDVIEWPROJECTION", 12, 100);
            Deep.this.vgl.setMatrixParameterSemantic("MODELVIEW", 4, 100);
            Deep.this.vgl.setMatrixParameterSemantic("VIEWINVERSE", 4, 101);
            Deep.this.vgl.setMatrixParameterSemantic("VIEWINVERSETRANSPOSE", 4, 103);
            Deep.this.vgl.setMatrixParameterSemantic("WORLD", Matrix.transpose((Matrix)matrix2).getArray());
            Deep.this.vgl.setMatrixParameterSemantic("WORLDTOCAMERA", matrix.getArray());
            CGpass cGpass = ((ShaderCGFX)Deep.this.vgl.getActiveShader()).getTechniqueFirstPass("Technique_DiffuseSpecularNoTextureWrap");
            CgGL.cgSetPassState((CGpass)cGpass);
            this.aquario.drawSphere(0.0f, 0.0f, 0.0f, 1.0f);
            CgGL.cgResetPassState((CGpass)cGpass);
            Deep.this.vgl.disableShader();
            Deep.this.vgl.popMatrix();
            if (this.psOn) {
                this.cylsCount = (int)(f * 0.5f) - 2;
                if (this.cylsCount < 0) {
                    this.cylsCount = 0;
                }
                if (this.cylsCount >= this.numCyls) {
                    this.cylsCount = this.numCyls;
                }
                this.noiseAmp = Deep.this.random(0.0f, 0.9f);
                float f11 = (f - this.noiseTimeStart) * 6.0f * this.noiseAmp * 10.0f;
                int n3 = 0;
                while (n3 < this.cylsCount) {
                    this.cyls[n3]._colour.set(0.0f, 0.0f, 0.0f, 1.0f);
                    this.cyls[n3].update(f - this.noiseTimeStart);
                    this.cyls[n3].draw(f - this.noiseTimeStart);
                    this.cyls[n3]._dispoffset = 1.0f + f11;
                    this.cyls[n3]._displaces = 0.0f;
                    this.cyls[n3]._dispscale = 19.0f;
                    ++n3;
                }
                Deep.this.vgl.enableLighting(true);
            }
        }
    }

    class Vector3Order
    extends Vector3 {
        int idx;

        Vector3Order() {
            this.idx = 0;
        }

        Vector3Order(float f, float f2, float f3, int n) {
            super(f, f2, f3);
            this.idx = n;
        }

        Vector3Order(Vector3 vector3, int n) {
            super(vector3.x, vector3.y, vector3.z);
            this.idx = n;
        }
    }

    class XTexture {
        String fileName;
        Texture _tex;
        int _id;
        int _texType;
        PImage _img;
        int _width;
        int _height;
        BufferedImage _buffer;
        boolean isLoaded;

        XTexture() {
            this._tex = null;
            this._texType = 3553;
        }

        XTexture(int n) {
            this._tex = null;
            this.isLoaded = false;
            this._texType = n;
        }

        XTexture(String string) {
            this.fileName = string;
            this._tex = null;
            this._buffer = null;
            this._texType = 3553;
            this.load(string);
        }

        XTexture(String string, int n) {
            this.fileName = string;
            this._tex = null;
            this._buffer = null;
            this._img = null;
            this.isLoaded = false;
            this._texType = n;
            this.loadPImage(string);
        }

        public void bind() {
            if (this._texType == 3553) {
                Deep.this.vgl.gl().glBindTexture(3553, this._id);
            } else {
                Deep.this.vgl.gl().glBindTexture(34037, this._id);
            }
        }

        public void unbind() {
            if (this._texType == 3553) {
                Deep.this.vgl.gl().glBindTexture(3553, 0);
            } else {
                Deep.this.vgl.gl().glBindTexture(34037, 0);
            }
        }

        public void enable() {
            if (this._texType == 3553) {
                Deep.this.vgl.gl().glEnable(3553);
            } else {
                Deep.this.vgl.gl().glEnable(34037);
            }
            this.bind();
        }

        public void disable() {
            if (this._texType == 3553) {
                Deep.this.vgl.gl().glDisable(3553);
            } else {
                Deep.this.vgl.gl().glDisable(34037);
            }
            this.unbind();
        }

        public void setWrap() {
            if (this._tex != null) {
                this._tex.setTexParameteri(10242, 10497);
                this._tex.setTexParameteri(10243, 10497);
            } else {
                Deep.this.vgl.gl().glTexParameteri(3553, 10242, 10497);
                Deep.this.vgl.gl().glTexParameteri(3553, 10243, 10497);
            }
        }

        public void setClamp() {
            if (this._tex != null) {
                this._tex.setTexParameteri(10242, 10496);
                this._tex.setTexParameteri(10243, 10496);
            } else {
                Deep.this.vgl.gl().glTexParameteri(3553, 10242, 10496);
                Deep.this.vgl.gl().glTexParameteri(3553, 10243, 10496);
            }
        }

        public void setClampToEdge() {
            if (this._tex != null) {
                this._tex.setTexParameterf(10242, 33071.0f);
                this._tex.setTexParameterf(10243, 33071.0f);
            } else {
                Deep.this.vgl.gl().glTexParameteri(3553, 10242, 33071);
                Deep.this.vgl.gl().glTexParameteri(3553, 10243, 33071);
            }
        }

        public void createGL(int n, int n2) {
            this._width = n;
            this._height = n2;
            int[] nArray = new int[1];
            Deep.this.vgl.gl().glGenTextures(1, nArray, 0);
            this._id = nArray[0];
            Deep.println((String)("texture created: " + this._id));
            Deep.this.vgl.gl().glBindTexture(3553, this._id);
            Deep.this.vgl.gl().glTexParameteri(3553, 10242, 10496);
            Deep.this.vgl.gl().glTexParameteri(3553, 10243, 10496);
            Deep.this.vgl.gl().glTexParameteri(3553, 10241, 9729);
            Deep.this.vgl.gl().glTexParameteri(3553, 10240, 9729);
            Deep.this.vgl.gl().glTexImage2D(3553, 0, 6408, this._width, this._height, 0, 32993, 5121, null);
        }

        public void createGLDepth(int n, int n2) {
            this._width = n;
            this._height = n2;
            int[] nArray = new int[1];
            Deep.this.vgl.gl().glGenTextures(1, nArray, 0);
            this._id = nArray[0];
            Deep.println((String)("texture created: " + this._id));
            Deep.this.vgl.gl().glBindTexture(3553, this._id);
            Deep.this.vgl.gl().glTexParameteri(3553, 10242, 10496);
            Deep.this.vgl.gl().glTexParameteri(3553, 10243, 10496);
            Deep.this.vgl.gl().glTexParameteri(3553, 10241, 9728);
            Deep.this.vgl.gl().glTexParameteri(3553, 10240, 9728);
            Deep.this.vgl.gl().glTexParameteri(3553, 34892, 34894);
            Deep.this.vgl.gl().glTexParameteri(3553, 34893, 515);
            Deep.this.vgl.gl().glTexParameteri(3553, 34891, 6409);
            Deep.this.vgl.gl().glTexImage2D(3553, 0, 33191, this._width, this._height, 0, 6402, 5126, null);
        }

        public void create(int n, int n2) {
            this._width = n;
            this._height = n2;
            this._buffer = new BufferedImage(n, n2, 2);
            this._tex = TextureIO.newTexture((BufferedImage)this._buffer, (boolean)false);
            this._id = this._tex.getTextureObject();
            Deep.println((String)("texture created: " + this._id));
            this._tex.setTexParameterf(10242, 10497.0f);
            this._tex.setTexParameterf(10243, 10497.0f);
            this._tex.setTexParameterf(10241, 9729.0f);
            this._tex.setTexParameterf(10240, 9729.0f);
        }

        public void load(String string) {
            this.fileName = string;
            try {
                this._tex = TextureIO.newTexture((File)new File(Deep.this.dataPath(this.fileName)), (boolean)true);
                this._id = this._tex.getTextureObject();
                this._tex.setTexParameterf(10242, 10497.0f);
                this._tex.setTexParameterf(10243, 10497.0f);
                this._tex.setTexParameterf(10240, 9729.0f);
                this._tex.setTexParameterf(10241, 9987.0f);
            }
            catch (Exception exception) {
                Deep.println((String)("texture error: " + exception));
            }
        }

        public void loadPImage(String string) {
            this.fileName = string;
            PImage pImage = Deep.this.loadImage(string);
            if (pImage == null) {
                Deep.println((String)("couldnt load texture: " + this.fileName));
                return;
            }
            this._width = pImage.width;
            this._height = pImage.height;
            int[] nArray = new int[1];
            Deep.this.vgl.gl().glGenTextures(1, nArray, 0);
            this._id = nArray[0];
            if (this._texType == 3553) {
                Deep.this.vgl.gl().glBindTexture(3553, this._id);
                Deep.this.vgl.gl().glPixelStorei(3317, 1);
                Deep.this.vgl.gl().glTexParameteri(3553, 33169, 1);
                Deep.this.vgl.gl().glTexParameterf(3553, 10242, 10496.0f);
                Deep.this.vgl.gl().glTexParameterf(3553, 10243, 10496.0f);
                Deep.this.vgl.gl().glTexParameterf(3553, 10241, 9987.0f);
                Deep.this.vgl.gl().glTexParameterf(3553, 10240, 9729.0f);
                Deep.this.vgl.gl().glTexImage2D(3553, 0, 4, this._width, this._height, 0, 32993, 5121, (Buffer)IntBuffer.wrap(pImage.pixels));
            } else if (this._texType == 34037) {
                Deep.this.vgl.gl().glBindTexture(34037, this._id);
                Deep.this.vgl.gl().glTexParameterf(34037, 10242, 33071.0f);
                Deep.this.vgl.gl().glTexParameterf(34037, 10243, 33071.0f);
                Deep.this.vgl.gl().glTexParameterf(34037, 10241, 9729.0f);
                Deep.this.vgl.gl().glTexParameterf(34037, 10240, 9729.0f);
                Deep.this.vgl.gl().glTexImage2D(34037, 0, 3, this._width, this._height, 0, 32993, 5121, (Buffer)IntBuffer.wrap(pImage.pixels));
            }
        }

        public void loadPImageFromMemory(PImage pImage) {
            this.fileName = "__";
            this._width = pImage.width;
            this._height = pImage.height;
            int[] nArray = new int[1];
            Deep.this.vgl.gl().glGenTextures(1, nArray, 0);
            this._id = nArray[0];
            Deep.this.vgl.gl().glBindTexture(3553, this._id);
            Deep.this.vgl.gl().glPixelStorei(3317, 1);
            Deep.this.vgl.gl().glTexParameteri(3553, 10242, 10497);
            Deep.this.vgl.gl().glTexParameteri(3553, 10243, 10497);
            Deep.this.vgl.gl().glTexParameteri(3553, 10241, 9729);
            Deep.this.vgl.gl().glTexParameteri(3553, 10240, 9729);
            Deep.this.vgl.gl().glTexImage2D(3553, 0, 4, this._width, this._height, 0, 32993, 5121, (Buffer)IntBuffer.wrap(pImage.pixels));
        }

        public int getTarget() {
            return this._tex.getTarget();
        }

        public int getId() {
            return this._id;
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._height;
        }
    }

    class objComparator
    implements Comparator {
        objComparator() {
        }

        public final int compare(Object object, Object object2) {
            float f = ((Vector3)object).z;
            float f2 = ((Vector3)object2).z;
            if (f > f2) {
                return 1;
            }
            return -1;
        }
    }
}

