
class ParticlePlankton
{
//  int len;            // number of elements in position array
//  Vector3[] loc;        // array of position vectors
//  Vector3 startLoc;     // just used to make sure every loc[] is initialized to the same position
  Vector3 pos;          // position point
  Vector3 oldPos;
  Vector3 _vel;          // velocity vector
  Vector3 _accel;        // acceleration vector
  float radius;       // particle's size
  float age;          // current age of particle
  float lifeSpan;       // max allowed age of particle
  float agePer;       // range from 1.0 (birth) to 0.0 (death)
  int gen;            // number of times particle has been involved in a SPLIT
  boolean _isDead;     // if age == lifeSpan, make particle die

  int _particleTexID;  


  ParticlePlankton( int gen, Vector3 loc, Vector3 vel )
  {
    //int len = 10;
    //startLoc = loc;
    //this.loc = new Vector3[len];
    
    pos = loc.copy();
    oldPos = loc.copy();
    
    _vel = vel.copy();
//    pos = new Vector3(random(-0.52, 0.52), random(-0.2, 0.2), 0);
//    _vel = new Vector3(random(-.52, .52), random(-.2, .2), 0);
//    _vel = new Vector3();

    _accel = new Vector3(random(-.82, .82), random(-.42, .42), random(-.82, .82)); // push to side
//    _accel = new Vector3(random(-.52, .52), random(-.2, .2), 0); // push to side

//    radius = 2+random(4);
    radius = 1+random(2);

    age = 2+random(5);
    lifeSpan = 2+random(55);

    _isDead = false;
    
    _particleTexID = -1;
  }

  void exist( float time )
  {
    render( time );
    update( time );
  }


  void render( float time )
  {
/*    if( _particleTexID > 0 )
    {
      //vgl.gl().glDisable( GL.GL_CULL_FACE );
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _particleTexID );
    }*/
    
    vgl.setAdditiveBlend();
    vgl.setDepthWrite( true );
    vgl.setDepthMask( false );
    vgl.enableLighting( false );

    vgl.pushMatrix();
    vgl.translate( this.pos );
//    glReverseCamera( eye, target );    
    glReverseCamera2( this.pos, this.oldPos );
    
    if( time < 230 )
      vgl.fill( 0.6, 0.7, 0.95, abs(cos(.5*time+age*.13)*0.93) );
    else
    {
      float aa = (abs(cos(.5*time+age*.13)*0.93)*(1.0-((time-230)*0.1)));
      if( aa < 0.0 ) aa = 0.0;
      vgl.fill( 0.6, 0.7, 0.95, aa );
    }
//    vgl.rect( 0, 0, 0, radius*1.3*0.5, radius*.475 );
    vgl.rect( 0, 0, 0, radius*.5, radius*.25 );
//    vgl.rect( 0, 0, 0, radius*1.3, radius*.475 );
    vgl.popMatrix();
  }
  
  void update( float time )
  {
    // keep track on last frame's position
    oldPos = pos.copy();
    
    // compute new position with simple physics
    pos.add( _vel );
    _vel.add( _accel );
    _vel.mul( 0.975 );

    _accel.mul( 0.0 );

    // add some noise to acceleration
    Vector3 noi = new Vector3();
    noi.y = (-0.3 + noise( _vel.x*0.5, _vel.y*.03, time*10.01 )) * .85;
//    noi.y = (-0.18 + noise( 10+pos.x*0.1, 100+pos.x*.01, time*.1 )) * .55;
    noi.x = -(-0.3 + noise( pos.x*0.3, pos.y*0.3, time*0.1)) * 0.95;
    noi.z = (-0.4 + noise( pos.x*0.3, pos.y*0.3, time*0.1)) * .135;
    noi.mul( 0.75 );
    _accel.add( noi );
    
    // check for age
    age += 0.1;
/*    if( age < 0 )
    {
      ISDEAD = true;
      age = 0;
    }*/

    if( age > lifeSpan ) //|| pos.y < floorLevel )
    {
      _isDead = true;
    } 
    else 
    {
      agePer = 1.0 - age/(float)lifeSpan;
    }     
  }
  
  void reset( float x, float y, float z )
  {
    pos.set( x, y, z );
    oldPos = pos.copy();
    
    _vel.set( 0, 0, 0 );

    _accel.set( random(-.82, .82), random(-.42, .42), random(-.82, .82) );

//    radius = 2+random(4);
    radius = 1+random(2);

    age = 2+random(5);
    lifeSpan = 2+random(55);
    
    _isDead = false;
  }
    
}
