import krister.Ess.*; 

AudioChannel chn;
FFT fft; 
int frameNumber = 0; 

//float fpsFudgeFactor = 30.0 / 29.97; // normally 1.0f
//float framesPerSecond = 30.0 * fpsFudgeFactor; 
int framesPerSecond = 30;

float level;  // channel level

float[] fftbuffer;

float lastTime;
float currentTime;


void init_sound( int spectrumLength, String filename ) 
{
  lastTime = 0.0;
  currentTime = 0.0;
  
  //
  // ESS
  //
  Ess.start( this ); 
  Ess.masterVolume( 1.0 );

  println( "loading " + filename );
  chn = new AudioChannel( filename ); 
  //println( "channel sample rate:  " + chn.sampleRate );

  fft = new FFT( spectrumLength*2 ); 

//  fft.equalizer( true );
  fft.limits();

//  //
//  // HELPER
//  // 
//  ffthelper = new SoniaHelper( spectrumLength, 256, false );
//  ffthelper.setMaxLimits( 200, 2000 );
//  damperval = 0.62f;
//  ffthelper.setDamper(damperval);

  fftbuffer = new float[spectrumLength];
}


void play_sound()
{
  chn.play();
}


void analyze( float freq_scale ) 
{ 
  int pos = (int)(frameNumber * chn.sampleRate / framesPerSecond);
  //println( "pos: " + pos );
  if( pos >= chn.size )
  {
    exit();
  }

  fft.getSpectrum( chn.samples, pos );
  
  for( int i=0; i<fft.spectrum.length; i++ )
    fftbuffer[i] = fft.spectrum[i] * freq_scale;

//  ffthelper.update( fftbuffer );


  // intensify freq bands
//  for( int i=0; i<ffthelper.band.length; i++ )
//  {
//    ffthelper.band[i] *= freq_scale; 
//    ffthelper.bandmax[i] *= freq_scale; 
//  }
}


void store( String demoName, String directory, String extension ) 
{ 
  saveFrame( directory + "\\" + demoName + "_" + nf(frameNumber, 7) + "." + extension ); 
}


void advance() 
{ 
  if ((frameNumber%framesPerSecond) == 0) 
  {
     lastTime = currentTime;
     currentTime = (millis()*0.001-startTime);
    println( "Frame: " + frameNumber 
             + " | time: " + ((currentTime/60.0)/60.0) + "h"
             + " | average time per frame: " + ((currentTime-lastTime)/30.0) + " secs" );
  }

  frameNumber++; 
}

void volume(float value){
    Ess.masterVolume(value);
}

void stop_sound()
{
  chn.stop();
  Ess.stop();
}  

