/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Channel;
import micromod.Synthesizer;
import micromod.WaveScaler;
import micromod.WaveShaper;
import micromod.resamplers.Resampler;

public class Mixer {
    protected WaveShaper waveShaper;
    protected WaveScaler waveScaler;
    protected Synthesizer synthesizer;
    protected int[] leftMixBuffer;
    protected int[] rightMixBuffer;
    protected int gain;

    public Mixer(Synthesizer synth, WaveShaper shaper, WaveScaler scaler) {
        this.setWaveShaper(shaper);
        this.setWaveScaler(scaler);
        this.synthesizer = synth;
        this.leftMixBuffer = new int[8192];
        this.rightMixBuffer = new int[8192];
        this.gain = 8192;
    }

    public void setWaveShaper(WaveShaper shaper) {
        if (shaper == null) {
            shaper = new WaveShaper();
        }
        this.waveShaper = shaper;
    }

    public void setWaveScaler(WaveScaler scaler) {
        if (scaler == null) {
            scaler = new WaveScaler();
        }
        this.waveScaler = scaler;
    }

    public int getGain() {
        return this.gain;
    }

    public void setGain(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > Short.MAX_VALUE) {
            value = Short.MAX_VALUE;
        }
        this.gain = value;
    }

    public void output(short[] leftBuffer, short[] rightBuffer, int length, Resampler resampler, boolean snapBack) {
        int rightAmp;
        int leftAmp;
        int n;
        int numChan = this.synthesizer.getNumberOfChannels();
        numChan += numChan % 2;
        Channel channel = this.synthesizer.getChannel(0);
        if (channel.isSilent()) {
            n = 0;
            while (n < length) {
                this.leftMixBuffer[n] = 0;
                this.rightMixBuffer[n] = 0;
                ++n;
            }
        } else {
            leftAmp = channel.getLeftAmplitude() * this.gain / numChan >> 15;
            rightAmp = channel.getRightAmplitude() * this.gain / numChan >> 15;
            channel.getAudio(leftBuffer, length, resampler, snapBack);
            this.waveScaler.scaleWaves(leftBuffer, this.leftMixBuffer, length, leftAmp);
            this.waveScaler.scaleWaves(leftBuffer, this.rightMixBuffer, length, rightAmp);
        }
        n = 1;
        while (n < numChan) {
            channel = this.synthesizer.getChannel(n);
            if (!channel.isSilent()) {
                leftAmp = channel.getLeftAmplitude() * this.gain / numChan >> 15;
                rightAmp = channel.getRightAmplitude() * this.gain / numChan >> 15;
                channel.getAudio(leftBuffer, length, resampler, snapBack);
                this.waveScaler.scaleWavesAccumulate(leftBuffer, this.leftMixBuffer, length, leftAmp);
                this.waveScaler.scaleWavesAccumulate(leftBuffer, this.rightMixBuffer, length, rightAmp);
            }
            ++n;
        }
        this.waveShaper.shapeWaves(this.leftMixBuffer, leftBuffer, length);
        this.waveShaper.shapeWaves(this.rightMixBuffer, rightBuffer, length);
    }
}

