/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Instrument;

public class LoopDecoder {
    protected Instrument instrument = this.assigned = new Instrument();
    protected Instrument assigned;
    protected int samplePos = 0;

    public void assignInstrument(Instrument inst) {
        this.assigned = inst;
    }

    public void setAssigned() {
        this.instrument = this.assigned;
        this.setSamplePosition(this.samplePos);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public boolean finishedPlaying() {
        return !this.instrument.looped && this.samplePos >= this.instrument.sampleEnd;
    }

    public void setSamplePosition(int samplePosition) {
        if (samplePosition < 0) {
            samplePosition = 0;
        }
        if (samplePosition >= this.instrument.sampleEnd) {
            samplePosition = this.instrument.looped ? this.instrument.loopStart : 0;
        }
        this.samplePos = samplePosition;
    }

    public int getSamplePosition() {
        return this.samplePos;
    }

    public void output(short[] buffer, int offset, int length, boolean snapBack) {
        int samPos = this.samplePos;
        int end = offset + length;
        Instrument inst = this.instrument;
        int n = offset;
        while (n < end) {
            if (samPos >= inst.sampleEnd) {
                if (inst != this.assigned && this.assigned.looped) {
                    inst = this.assigned;
                    samPos = inst.loopStart;
                } else if (inst.looped) {
                    samPos = inst.loopStart;
                } else {
                    LoopDecoder.zero(buffer, n, end);
                    break;
                }
            }
            buffer[n] = (short)(inst.data[samPos] << 8);
            ++samPos;
            ++n;
        }
        if (!snapBack) {
            this.samplePos = samPos;
            this.instrument = inst;
        }
    }

    protected static void zero(short[] buffer, int start, int end) {
        int n = start;
        while (n < end) {
            buffer[n] = 0;
            ++n;
        }
    }
}

