#include "system/xstdio.h"
#include "system/xstring.h"
#include "3dmath/vector.h"
#include "formats/v3o.h"
#include "formats/3ds.h"
/* hora */


void printhelp (void)
{
	printf ("Usage:\n");
	printf ("3ds2v3o.exe <switch> [infile] [outfile]\n");
	printf ("Switches:\n");
	printf ("  -n  : Calculate pointnormals\n");
	printf ("  -c  : Center object\n");
	printf ("  -e  : Explicit decide outfiles...\n");
	printf ("  -d1 : Dump contents of v3ofile (only header)\n");
	printf ("  -d2 : Dump.. (header + vertices)\n");
	printf ("  -d3 : Dump.. (header + vertices + surfaces)\n");
	printf ("\n");
	exit (1);

}

int main (int argc,char **argv)
{
	char infile[64],outfile[64];
	int i,inf,outf,d,dv,ds,center,norm,explicit;
	V3O *obj;

	printf ("-- 3ds2v3o converter by Gnilk & Network --\n");

	inf=outf=dv=ds=d=center=norm=explicit=0;
	obj=NULL;
	if (argc<2) printhelp ();

	for (i=1;i<argc;i++)
	{
		if (argv[i][0]!='-')
		{
			if (!inf)
			{
			  strcpy (infile,argv[i]);
				inf=1;
				} else if (!outf)
						{
							 strcpy (outfile,argv[i]);
							 outf=1;
						 } else {
											printf ("[!] Error: Only one outfile can be specified!\n");
											exit (1);
						 			  }

		} else {
						 switch (argv[i][1])
						 {
							 case 'e' : explicit=1;
													break;
							 case 'd' : d=1;
							 					  switch (argv[i][2])
													{
														case '3' : ds=1;
														case '2' : dv=1;
														case '1' : d=1; break;
														default : printhelp ();
													}
													break;
							 case 'c' : center = 1;
													break;
							 case 'n' : norm=1;
													break;
							 default : printhelp ();

						 }
					 }
	}

	if (inf && outf)
	{
	  if (!(obj=load_3ds(infile,1)))
		{
			printf ("[!] Error: Failed while loading: %s\n",infile);
			exit (1);
			}
    if (explicit) v3o_save (outfile,obj);
	} else
			if ((!explicit) && inf)
			{
				printf ("[-] Using automatic filenames...\n");
				load_3ds (infile,1);
			}
/*
	printf ("material size: %i\n",sizeof (V3OMATERIAL));
	printf ("vertexsize...: %i\n",sizeof (VECTOR));
	printf ("Surfacesize..: %i\n",sizeof (V3OSURFACE));
	printf ("Matbufsize...: %x,%i\n",obj->material,_msize (obj->material));
	printf ("Vertbufsize..: %x,%i\n",obj->orgvertex,_msize (obj->orgvertex));
	printf ("Surfbufsize..: %x,%i\n",obj->surface,_msize (obj->surface));
*/
	if (d)
	{
		if ((obj==NULL) && (inf))
		{
		  if ((obj=v3o_load (infile))==NULL)
		  {
				printf ("[!] Error: %s, is not a v3o file or incorrect verision\n");
				exit (1);
			}
		}
			else printhelp ();
	  v3o_dump (obj,dv,ds);
	}
  v3o_free( obj);
/*
	if (argv[1][0]!='-')
	{
	  obj = lwo_load( argv[1]);
	  if ( obj != NULL)
		  v3o_save( argv[2], obj);
	  else
		  printf("Failed while loading %s\n", argv[1]);
	} else {
					 obj=v3o_load (argv[2]);
					 v3o_dump (obj,1,1);
				 }
*/
	return( 0);
}
