;---------------------------------------------------------------------
;
; Polydrawers..
; This one should be used with Watcom C/C++ 11.0
;
;----------------------------------------------------------------------
;.586p
.486p
.model flat,syscall
.code

OPTION	PROC:PRIVATE
OPTION	NOKEYWORD:<NAME,WIDTH,TYPE>

;----------------------------------------------------------------------
;
; Flat shadeded polydrawer...
;
;----------------------------------------------------------------------


poly_glzt_asm           PROC    PUBLIC USES ebx ecx edx edi,
				screen:dword,minx:dword,maxx:dword,width:dword,ylen:dword,
				x1:dword,x1add:dword,
				x2:dword,x2add:dword,
				col:dword

			cmp	ylen,0
			jle	skip

lp:			mov	eax,x1
			mov	ebx,x2
			mov	ecx,minx
			mov 	edx,maxx
			mov	edi,screen
			cmp	eax,ebx
			jge 	back
			sar 	eax,16
			sar 	ebx,16
			cmp 	eax,ecx
			jge 	back_ok1
			cmp 	ebx,ecx
			jl 	done
			mov 	eax,ecx
back_ok1:
			cmp 	ebx,edx
			jle 	back_ok2
			cmp 	eax,edx
			jg 	done
			mov 	ebx,edx
back_ok2:
			mov	ecx,ebx
			add 	edi,eax
			sub 	ecx,eax
			jmp 	ok

back:

			sar 	eax,16
			sar 	ebx,16
			cmp 	ebx,ecx
			jge 	forw_ok1
			cmp 	eax,ecx
			jl 	done
			mov 	ebx,minx
forw_ok1:
			cmp 	eax,edx
			jle 	forw_ok2
			cmp 	ebx,edx
			jg 	done
			mov 	eax,maxx
forw_ok2:
			mov	ecx,eax
			add 	edi,ebx
			sub 	ecx,ebx

			ok:
			mov 	al,byte ptr col
			mov 	ah,al
			rol 	eax,16
			mov 	al,byte ptr col
			mov 	ah,al

			mov 	edx,ecx
			shr 	ecx,2
			jz 	rest
		rep 	stosd
rest:
			mov	ecx,edx
			and	ecx,03h
			jz 	done
		rep 	stosb
done:

			mov 	eax,x1add
			mov 	ebx,x2add
			add 	x1,eax
			mov 	ecx,width
			add 	x2,ebx
			add 	screen,ecx
			dec 	ylen
			jnz 	lp
skip:
			ret
poly_glzt_asm   	ENDP

;----------------------------------------------------------------------
;
; Flat shadeded Z-bufferd polydrawer...
;
;----------------------------------------------------------------------

poly_glZt_asm           PROC    PUBLIC USES ebx ecx edx esi edi,
				screen:dword,zbuffer:dword,minx:sdword,maxx:sdword,width:dword,ylen:sdword,
				x1:sdword,x1add:sdword,z1:sdword,z1add:sdword,
				x2:sdword,x2add:sdword,z2:sdword,z2add:sdword,
				col:dword

LOCAL			x:dword,xf:dword
LOCAL			z:dword,zf:dword,zadd:dword

			cmp	ylen,0
			jle	done

lp:
			mov	eax,z2
			sub	eax,z1
			cdq

			mov	ebx,x2
			sar	ebx,16
			mov	ecx,x1
			sar	ecx,16

			sub	ebx,ecx
			jz	skip
			idiv	ebx
			mov	zadd,eax

			mov	eax,x1
			mov	ebx,z1
			mov	ecx,x2
			mov	edx,z2
			sar	ecx,16
			sar	edx,16
			mov	xf,ecx
			mov	zf,edx
		.IF		eax > x2
			sar	eax,16
			sar	ebx,16
			mov	xf,eax
			mov	zf,ebx
			mov	eax,x2
			mov	ebx,z2
		.ENDIF
			sar	eax,16

			cmp	eax,maxx
			jg	skip

		.IF		eax < minx
			mov	ecx,minx
			sub	ecx,eax
			imul	ecx,zadd
			add	ebx,ecx
			mov 	eax,minx
		.ENDIF

			mov	ecx,xf
		.IF		ecx > maxx
			mov	ecx,maxx
		.ENDIF
			sub	ecx,eax
			jle	skip
			mov	edx,zadd

			mov	edi,screen
			mov	esi,zbuffer
			lea	edi,[edi+eax]
			lea	esi,[esi+eax*4]
			mov 	al,byte ptr col
		.WHILE		ecx
                 .IF            ebx < sdword ptr [esi]
			mov	[esi],ebx
			mov	[edi],al
		 .ENDIF
			add	ebx,edx
			inc	edi
			add	esi,4
			dec	ecx
		.ENDW
skip:
			mov	eax,width
			mov	ebx,x1add
			mov	ecx,z1add
			add	screen,eax
			add	x1,ebx
			shl	eax,2
			add	z1,ecx
			add	zbuffer,eax
			mov	ebx,x2add
			mov	ecx,z2add
			add	x2,ebx
			add	z2,ecx

			dec	ylen
			jnz	lp
done:

			ret
poly_glZt_asm   	ENDP

;----------------------------------------------------------------------
;
; Gourade shadeded Z-bufferd polydrawer...
;
;----------------------------------------------------------------------


poly_GLZt_asm           PROC    PUBLIC USES ebx ecx edx esi edi,
				screen:dword,zbuffer:dword,lighttab:dword,minx:sdword,maxx:sdword,width:dword,ylen:sdword,
				x1:sdword,x1add:sdword,z1:sdword,z1add:sdword,l1:sdword,l1add:sdword,
				x2:sdword,x2add:sdword,z2:sdword,z2add:sdword,l2:sdword,l2add:sdword

LOCAL			x:dword,xf:dword
LOCAL			z:dword,zf:dword,zadd:dword
LOCAL			l:dword,lf:dword,ladd:dword

			cmp	ylen,0
			jle	done
lp:
			mov	ebx,x2
			sar	ebx,16
			mov	ecx,x1
			sar	ecx,16

			sub	ebx,ecx
			jz	skip
		; Calc color and Z-add values...
			mov	eax,z2
			sub	eax,z1
			cdq
			idiv	ebx
			mov	zadd,eax

			mov	eax,l2
			sub	eax,l1
			cdq
			idiv	ebx
			mov	ladd,eax
	       ; Go on...
			mov	ebx,l2
			mov	ecx,x2
			mov	edx,z2
			sar	ebx,16
			sar	ecx,16
			sar	edx,16
			mov	lf,ebx
			mov	xf,ecx
			mov	zf,edx

			mov	eax,x1
			mov	ebx,z1
			mov	edx,l1
		;------------------
		; eax - x1, ebx - z1, edx - c1
		;------------------
		.IF		eax > x2
			sar	eax,16
			sar	ebx,16
			sar	edx,16
			mov	xf,eax
			mov	zf,ebx
			mov	lf,edx
			mov	eax,x2
			mov	ebx,z2
			mov	edx,l2
		.ENDIF
			sar	eax,16

			cmp	eax,maxx
			jg	skip

			; Klipp vnster vrden..

		.IF		eax < minx
			mov	ecx,minx
			sub	ecx,eax		; Nya Delta X
			imul	ecx,zadd	; Klipp Z
			add	ebx,ecx		; Fixa till Z-start

			mov	ecx,minx	; Snabbare n push/pop
			sub	ecx,eax
			imul	ecx,ladd	; Klipp frgvrden
			add	edx,ecx		; Fixa till colstart...

			mov 	eax,minx
		.ENDIF

			mov	ecx,xf
		.IF		ecx > maxx
			mov	ecx,maxx
		.ENDIF
			sub	ecx,eax
			jle	skip


		; ebx - Zvrde, edx - Lightvrde


			mov	edi,screen
			mov	esi,zbuffer
			lea	edi,[edi+eax]
			lea	esi,[esi+eax*4]
			;mov 	al,byte ptr col
		.WHILE		ecx
                 .IF            ebx < sdword ptr [esi]  ; Check Z-buffer
			mov	[esi],ebx		; Put Z-value
			mov	eax,edx			; Fetch lightvalue
			shr	eax,8			; Get it down... (finns i ah)..
			and	eax,0ff00h
			add	eax,lighttab
			mov	al,[eax]		; Ls av...
			mov	[edi],al		; stt...
		 .ENDIF
			add	edx,ladd		; Uppdatera light
			add	ebx,zadd		; Uppdatera z
			inc	edi
			add	esi,4
			dec	ecx
		.ENDW
skip:
		; Update loop fuckups...
			mov	eax,width
			mov	ebx,x1add
			mov	ecx,z1add
			mov	edx,l1add
			add	screen,eax
			add	x1,ebx
			shl	eax,2
			add	z1,ecx
			add	l1,edx
			add	zbuffer,eax
			mov	ebx,x2add
			mov	ecx,z2add
			mov	edx,l2add
			add	x2,ebx
			add	z2,ecx
			add	l2,edx

			dec	ylen
			jnz	lp
done:

			ret
poly_GLZt_asm   	ENDP

;----------------------------------------------------------------------
;
; Z-bufferd texturemapper....
;
;----------------------------------------------------------------------
_tpl_glZt_s	STRUC
		dword	0		; Regs...
		dword	0		; Caller
screen          dword	?
zbuffer		dword	?
texture		dword	?
minx		sdword	?
maxx		sdword	?
width		sdword	?
ylen		sdword	?
x1		sdword	?
x1add		sdword	?
z1		sdword	?
z1add		sdword	?
tx1		sdword	?
tx1add		sdword	?
ty1		sdword	?
ty1add		sdword	?
x2		sdword	?
x2add		sdword	?
z2		sdword	?
z2add		sdword	?
tx2		sdword	?
tx2add		sdword	?
ty2		sdword	?
ty2add		sdword	?

_tpl_glZt_s	ENDS

tpoly_glZt_asm           PROC    PUBLIC USES ebx ecx edx esi edi

LOCAL			x:dword,xf:dword
LOCAL			z:dword,zf:dword,zadd:dword
LOCAL			tx:dword,txf:dword,txadd:dword
LOCAL			ty:dword,tyf:dword,tyadd:dword
LOCAL			efx:dword,egx:dword
LOCAL			xlen:dword
LOCAL			scrptr:dword

			push	ebp

                        cmp     _tpl_glZt_s.ylen[ebp],0
			jle	done
lp:
			mov	ebx,_tpl_glZt_s.x2[ebp]
			sar	ebx,16
                        mov     ecx,_tpl_glZt_s.x1[ebp]
			sar	ecx,16

			sub	ebx,ecx
			jz	skip
		;--------------------------------------------
		; Calc color,z and texture add values....
		;--------------------------------------------
                        mov     eax,_tpl_glZt_s.z2[ebp]
                        sub     eax,_tpl_glZt_s.z1[ebp]
			cdq
			idiv	ebx
			mov	zadd,eax

                        mov     eax,_tpl_glZt_s.tx2[ebp]
                        sub     eax,_tpl_glZt_s.tx1[ebp]
			cdq
			idiv	ebx
			mov	txadd,eax

                        mov     eax,_tpl_glZt_s.ty2[ebp]
                        sub     eax,_tpl_glZt_s.ty1[ebp]
			cdq
			idiv	ebx
			mov	tyadd,eax
	       ;--------------------------------------
	       ; Go on... Factors...
	       ;--------------------------------------
                        mov     ecx,_tpl_glZt_s.x2[ebp]
                        mov     edx,_tpl_glZt_s.z2[ebp]
			sar	ecx,16
			sar	edx,16
			mov	xf,ecx
			mov	zf,edx

                        mov     eax,_tpl_glZt_s.tx2[ebp]
                        mov     ebx,_tpl_glZt_s.ty2[ebp]
			sar	eax,16
			sar	ebx,16
			mov	txf,eax
			mov	tyf,ebx

                        mov     eax,_tpl_glZt_s.tx1[ebp]
                        mov     efx,eax
                        mov     eax,_tpl_glZt_s.ty1[ebp]
                        mov     egx,eax
                        mov     eax,_tpl_glZt_s.x1[ebp]
                        mov     ebx,_tpl_glZt_s.z1[ebp]
		;---------------------------------
		; eax - x1, ebx - z1, edx - l1
		; efx - tx1, egx - ty1
		;---------------------------------
                .IF             eax > _tpl_glZt_s.x2[ebp]
			sar	eax,16
			sar	ebx,16
			sar	efx,16
			sar	egx,16
			mov	xf,eax
			mov	zf,ebx
			mov	eax,efx
			mov	txf,eax
			mov	eax,egx
			mov	tyf,eax

                        mov     eax,_tpl_glZt_s.tx2[ebp]
                        mov     efx,eax
                        mov     eax,_tpl_glZt_s.ty2[ebp]
                        mov     egx,eax
                        mov     eax,_tpl_glZt_s.x2[ebp]
                        mov     ebx,_tpl_glZt_s.z2[ebp]
		.ENDIF
			sar	eax,16

                        cmp     eax,_tpl_glZt_s.maxx[ebp]
			jg	skip
		;-------------------------------
		; Klipp vnster vrden..
		;-------------------------------
                .IF             eax < _tpl_glZt_s.minx[ebp]
                        mov     ecx,_tpl_glZt_s.minx[ebp]
			sub	ecx,eax		; Nya Delta X
			mov	xlen,ecx

			imul	ecx,zadd	; Klipp Z
			add	ebx,ecx		; Fixa till Z-start

			mov	ecx,xlen	; Klipp till texture coords
			imul	ecx,txadd
			add	efx,ecx

                        mov     ecx,xlen
			imul	ecx,tyadd
			add	egx,ecx

                        mov     eax,_tpl_glZt_s.minx[ebp]
		.ENDIF
		;---------------------------------------
                        mov     ecx,xf
                .IF             ecx > _tpl_glZt_s.maxx[ebp]
                        mov     ecx,_tpl_glZt_s.maxx[ebp]
		.ENDIF
			sub	ecx,eax
			jle	skip
                        mov     xlen,ecx

		; ebx - Zvrde, edx - Lightvrde, efx - texture X, egx - texture Y

			mov	ecx,txadd


                        mov     edi,_tpl_glZt_s.screen[ebp]
                        mov     esi,_tpl_glZt_s.zbuffer[ebp]
			lea	edi,[edi+eax]
			lea	esi,[esi+eax*4]
			; Save edi for loop usage...
			mov	scrptr,edi

			mov	edi,ebx
			mov	edx,tyadd
			;mov 	al,byte ptr col
;---------------------------------------------------------------------------------------
; Texture loop:
; edi - Zvrde, edx - lightvrde, efx - textureX, egx - textureY
; ecx - txadd,
;
txlp:
                 .IF            edi < sdword ptr [esi]  ; Check Z-buffer
			mov	[esi],edi		; Put Z-value

			xor	ebx,ebx
			mov	bl,byte ptr [efx+2]	; Get Texture X
			mov	bh,byte ptr [egx+2]	; Get Texture Y

                        add     ebx,_tpl_glZt_s.texture[ebp]    ; Hello...  Fetch texturevalue...
			mov	al,[ebx]

			mov	ebx,scrptr		; Fetch scr....
			mov	[ebx],al		; put texture coord...
		 .ENDIF
	;------> Update all values in texturemapper... z, light, x,y...
			add	edi,zadd		; Uppdatera z
			add	efx,ecx  		; Texture X add
			;mov	eax,tyadd		; Lame soloution...
			add	egx,edx			; Texture Y add...

			inc	scrptr
			add	esi,4
			dec	xlen
			jne	txlp
;---------------------------------------------------------
skip:
		; Update loop fuckups...

		; First scanline
                        mov     eax,_tpl_glZt_s.tx1add[ebp]
                        add     _tpl_glZt_s.tx1[ebp],eax
                        mov     eax,_tpl_glZt_s.ty1add[ebp]
                        add     _tpl_glZt_s.ty1[ebp],eax
                        mov     eax,_tpl_glZt_s.width[ebp]
                        mov     ebx,_tpl_glZt_s.x1add[ebp]
                        mov     ecx,_tpl_glZt_s.z1add[ebp]
                        add     _tpl_glZt_s.screen[ebp],eax
                        add     _tpl_glZt_s.x1[ebp],ebx
			shl	eax,2
                        add     _tpl_glZt_s.z1[ebp],ecx
                        add     _tpl_glZt_s.zbuffer[ebp],eax
		; Second scanline
                        mov     ebx,_tpl_glZt_s.x2add[ebp]
                        mov     ecx,_tpl_glZt_s.z2add[ebp]
                        add     _tpl_glZt_s.x2[ebp],ebx
                        add     _tpl_glZt_s.z2[ebp],ecx
                        mov     eax,_tpl_glZt_s.tx2add[ebp]
                        add     _tpl_glZt_s.tx2[ebp],eax
                        mov     eax,_tpl_glZt_s.ty2add[ebp]
                        add     _tpl_glZt_s.ty2[ebp],eax

                        dec     _tpl_glZt_s.ylen[ebp]
			jnz	lp
done:
			pop	ebp
			ret
tpoly_glZt_asm   	ENDP
;----------------------------------------------------------------------
;
; Flat shadeded Z-bufferd texturemapper....
;
;----------------------------------------------------------------------
_tpl_gLZt_s	STRUC
		dword	0		; Regs...
		dword	0		; Caller
screen          dword	?
zbuffer		dword	?
lighttab	dword	?
texture		dword	?
minx		sdword	?
maxx		sdword	?
width		sdword	?
ylen		sdword	?
x1		sdword	?
x1add		sdword	?
z1		sdword	?
z1add		sdword	?
tx1		sdword	?
tx1add		sdword	?
ty1		sdword	?
ty1add		sdword	?
x2		sdword	?
x2add		sdword	?
z2		sdword	?
z2add		sdword	?
tx2		sdword	?
tx2add		sdword	?
ty2		sdword	?
ty2add		sdword	?

_tpl_gLZt_s	ENDS

tpoly_gLZt_asm           PROC    PUBLIC USES ebx ecx edx esi edi

LOCAL			x:dword,xf:dword
LOCAL			z:dword,zf:dword,zadd:dword
LOCAL			tx:dword,txf:dword,txadd:dword
LOCAL			ty:dword,tyf:dword,tyadd:dword
LOCAL			l:dword,lf:dword,ladd:dword
LOCAL			efx:dword,egx:dword
LOCAL			xlen:dword
LOCAL			scrptr:dword

			push	ebp

                        cmp     _tpl_gLZt_s.ylen[ebp],0
			jle	done
lp:
			mov	ebx,_tpl_gLZt_s.x2[ebp]
			sar	ebx,16
                        mov     ecx,_tpl_gLZt_s.x1[ebp]
			sar	ecx,16

			sub	ebx,ecx
			jz	skip
		;--------------------------------------------
		; Calc color,z and texture add values....
		;--------------------------------------------
                        mov     eax,_tpl_gLZt_s.z2[ebp]
                        sub     eax,_tpl_gLZt_s.z1[ebp]
			cdq
			idiv	ebx
			mov	zadd,eax

                        mov     eax,_tpl_gLZt_s.tx2[ebp]
                        sub     eax,_tpl_gLZt_s.tx1[ebp]
			cdq
			idiv	ebx
			mov	txadd,eax

                        mov     eax,_tpl_gLZt_s.ty2[ebp]
                        sub     eax,_tpl_gLZt_s.ty1[ebp]
			cdq
			idiv	ebx
			mov	tyadd,eax
	       ;--------------------------------------
	       ; Go on... Factors...
	       ;--------------------------------------
                        mov     ecx,_tpl_gLZt_s.x2[ebp]
                        mov     edx,_tpl_gLZt_s.z2[ebp]
			sar	ecx,16
			sar	edx,16
			mov	xf,ecx
			mov	zf,edx

                        mov     eax,_tpl_gLZt_s.tx2[ebp]
                        mov     ebx,_tpl_gLZt_s.ty2[ebp]
			sar	eax,16
			sar	ebx,16
			mov	txf,eax
			mov	tyf,ebx

                        mov     eax,_tpl_gLZt_s.tx1[ebp]
                        mov     efx,eax
                        mov     eax,_tpl_gLZt_s.ty1[ebp]
                        mov     egx,eax
                        mov     eax,_tpl_gLZt_s.x1[ebp]
                        mov     ebx,_tpl_gLZt_s.z1[ebp]
		;---------------------------------
		; eax - x1, ebx - z1, edx - l1
		; efx - tx1, egx - ty1
		;---------------------------------
                .IF             eax > _tpl_gLZt_s.x2[ebp]
			sar	eax,16
			sar	ebx,16
			sar	efx,16
			sar	egx,16
			mov	xf,eax
			mov	zf,ebx
			mov	eax,efx
			mov	txf,eax
			mov	eax,egx
			mov	tyf,eax

                        mov     eax,_tpl_gLZt_s.tx2[ebp]
                        mov     efx,eax
                        mov     eax,_tpl_gLZt_s.ty2[ebp]
                        mov     egx,eax
                        mov     eax,_tpl_gLZt_s.x2[ebp]
                        mov     ebx,_tpl_gLZt_s.z2[ebp]
		.ENDIF
			sar	eax,16

                        cmp     eax,_tpl_gLZt_s.maxx[ebp]
			jg	skip
		;-------------------------------
		; Klipp vnster vrden..
		;-------------------------------
                .IF             eax < _tpl_gLZt_s.minx[ebp]
                        mov     ecx,_tpl_gLZt_s.minx[ebp]
			sub	ecx,eax		; Nya Delta X
			mov	xlen,ecx

			imul	ecx,zadd	; Klipp Z
			add	ebx,ecx		; Fixa till Z-start

			mov	ecx,xlen	; Klipp till texture coords
			imul	ecx,txadd
			add	efx,ecx

                        ;mov     ecx,_tpl_gLZt_s.ylen[ebp]
			mov	ecx,xlen
			imul	ecx,tyadd
			add	egx,ecx

                        mov     eax,_tpl_gLZt_s.minx[ebp]
		.ENDIF
		;---------------------------------------
                        mov     ecx,xf
                .IF             ecx > _tpl_gLZt_s.maxx[ebp]
                        mov     ecx,_tpl_gLZt_s.maxx[ebp]
		.ENDIF
			sub	ecx,eax
			jle	skip
                        mov     xlen,ecx

		; ebx - Zvrde, edx - Lightvrde, efx - texture X, egx - texture Y

			mov	ecx,txadd


                        mov     edi,_tpl_gLZt_s.screen[ebp]
                        mov     esi,_tpl_gLZt_s.zbuffer[ebp]
			lea	edi,[edi+eax]
			lea	esi,[esi+eax*4]
			; Save edi for loop usage...
			mov	scrptr,edi

			mov	edi,ebx
			mov	edx,tyadd
			;mov 	al,byte ptr col
;---------------------------------------------------------------------------------------
; Texture-shade loop:
; edi - Zvrde,  efx - textureX, egx - textureY
; ecx - txadd, edx - tyadd
;
txlp:
                 .IF            edi < sdword ptr [esi]  ; Check Z-buffer
			mov	[esi],edi		; Put Z-value

			xor	ebx,ebx
			xor	eax,eax			; Clear EAX
			mov	bl,byte ptr [efx+2]	; Get Texture X
			mov	bh,byte ptr [egx+2]	; Get Texture Y
                        add     ebx,_tpl_gLZt_s.texture[ebp]    ; Hello...  Fetch texturevalue...
			mov	al,[ebx]

                        add     eax,_tpl_gLZt_s.lighttab[ebp]
			mov	ebx,scrptr		; Fetch scr....
			mov	al,[eax]	      	; Ls av...

			mov	[ebx],al		; put texture coord...
		 .ENDIF
	;------> Update all values in texturemapper... z, light, x,y...
			add	edi,zadd
			add	efx,ecx  		; Texture X add
			add	egx,edx			; Texture Y add...

			inc	scrptr
			add	esi,4
			dec	xlen
			jne	txlp
;---------------------------------------------------------
skip:
		; Update loop fuckups...

		; First scanline
                        mov     eax,_tpl_gLZt_s.tx1add[ebp]
                        add     _tpl_gLZt_s.tx1[ebp],eax
                        mov     eax,_tpl_gLZt_s.ty1add[ebp]
                        add     _tpl_gLZt_s.ty1[ebp],eax
                        mov     eax,_tpl_gLZt_s.width[ebp]
                        mov     ebx,_tpl_gLZt_s.x1add[ebp]
                        mov     ecx,_tpl_gLZt_s.z1add[ebp]
                        add     _tpl_gLZt_s.screen[ebp],eax
                        add     _tpl_gLZt_s.x1[ebp],ebx
			shl	eax,2
                        add     _tpl_gLZt_s.z1[ebp],ecx
                        add     _tpl_gLZt_s.zbuffer[ebp],eax
		; Second scanline
                        mov     ebx,_tpl_gLZt_s.x2add[ebp]
                        mov     ecx,_tpl_gLZt_s.z2add[ebp]
                        add     _tpl_gLZt_s.x2[ebp],ebx
                        add     _tpl_gLZt_s.z2[ebp],ecx
                        mov     eax,_tpl_gLZt_s.tx2add[ebp]
                        add     _tpl_gLZt_s.tx2[ebp],eax
                        mov     eax,_tpl_gLZt_s.ty2add[ebp]
                        add     _tpl_gLZt_s.ty2[ebp],eax

                        dec     _tpl_gLZt_s.ylen[ebp]
			jnz	lp
done:
			pop	ebp
			ret
tpoly_gLZt_asm   	ENDP

;----------------------------------------------------------------------
;
; Gourade shadeded Z-bufferd texturemapper....
;
; TEXTUREMAPPER!!!
;
;----------------------------------------------------------------------
_tpl_GLZt_s	STRUC
		dword	0		; Regs...
		dword	0		; Caller
screen          dword	?
zbuffer		dword	?
lighttab	dword	?
texture		dword	?
minx		sdword	?
maxx		sdword	?
width		sdword	?
ylen		sdword	?
x1		sdword	?
x1add		sdword	?
z1		sdword	?
z1add		sdword	?
tx1		sdword	?
tx1add		sdword	?
ty1		sdword	?
ty1add		sdword	?
l1		sdword	?
l1add		sdword	?
x2		sdword	?
x2add		sdword	?
z2		sdword	?
z2add		sdword	?
tx2		sdword	?
tx2add		sdword	?
ty2		sdword	?
ty2add		sdword	?
l2		sdword	?
l2add		sdword	?

_tpl_GLZt_s	ENDS

tpoly_GLZt_asm           PROC    PUBLIC USES ebx ecx edx esi edi
;				screen:dword,zbuffer:dword,lighttab:dword,texture:dword,minx:sdword,maxx:sdword,width:dword,ylen:sdword,
;				x1:sdword,x1add:sdword,z1:sdword,z1add:sdword,tx1:sdword,tx1add:sdword,ty1:sdword,ty1add:dword,l1:sdword,l1add:sdword,
;				x2:sdword,x2add:sdword,z2:sdword,z2add:sdword,tx2:sdword,tx2add:sdword,ty2:sdword,ty2add:dword,l2:sdword,l2add:sdword

LOCAL			x:dword,xf:dword
LOCAL			z:dword,zf:dword,zadd:dword
LOCAL			tx:dword,txf:dword,txadd:dword
LOCAL			ty:dword,tyf:dword,tyadd:dword
LOCAL			l:dword,lf:dword,ladd:dword
LOCAL			efx:dword,egx:dword
LOCAL			xlen:dword
LOCAL			scrptr:dword

			push	ebp

                        cmp     _tpl_GLZt_s.ylen[ebp],0
			jle	done
lp:
			mov	ebx,_tpl_GLZt_s.x2[ebp]
			sar	ebx,16
                        mov     ecx,_tpl_GLZt_s.x1[ebp]
			sar	ecx,16

			sub	ebx,ecx
			jz	skip
		;--------------------------------------------
		; Calc color,z and texture add values....
		;--------------------------------------------
                        mov     eax,_tpl_GLZt_s.z2[ebp]
                        sub     eax,_tpl_GLZt_s.z1[ebp]
			cdq
			idiv	ebx
			mov	zadd,eax

                        mov     eax,_tpl_GLZt_s.l2[ebp]
                        sub     eax,_tpl_GLZt_s.l1[ebp]
			cdq
			idiv	ebx
			mov	ladd,eax

                        mov     eax,_tpl_GLZt_s.tx2[ebp]
                        sub     eax,_tpl_GLZt_s.tx1[ebp]
			cdq
			idiv	ebx
			mov	txadd,eax

                        mov     eax,_tpl_GLZt_s.ty2[ebp]
                        sub     eax,_tpl_GLZt_s.ty1[ebp]
			cdq
			idiv	ebx
			mov	tyadd,eax
	       ;--------------------------------------
	       ; Go on... Factors...
	       ;--------------------------------------
                        mov     ebx,_tpl_GLZt_s.l2[ebp]
                        mov     ecx,_tpl_GLZt_s.x2[ebp]
                        mov     edx,_tpl_GLZt_s.z2[ebp]
			sar	ebx,16
			sar	ecx,16
			sar	edx,16
			mov	lf,ebx
			mov	xf,ecx
			mov	zf,edx

                        mov     eax,_tpl_GLZt_s.tx2[ebp]
                        mov     ebx,_tpl_GLZt_s.ty2[ebp]
			sar	eax,16
			sar	ebx,16
			mov	txf,eax
			mov	tyf,ebx

                        mov     eax,_tpl_GLZt_s.tx1[ebp]
                        mov     efx,eax
                        mov     eax,_tpl_GLZt_s.ty1[ebp]
                        mov     egx,eax
                        mov     eax,_tpl_GLZt_s.x1[ebp]
                        mov     ebx,_tpl_GLZt_s.z1[ebp]
                        mov     edx,_tpl_GLZt_s.l1[ebp]
		;---------------------------------
		; eax - x1, ebx - z1, edx - c1
		; efx - tx1, egx - ty1
		;---------------------------------
                .IF             eax > _tpl_GLZt_s.x2[ebp]
			sar	eax,16
			sar	ebx,16
			sar	edx,16
			sar	efx,16
			sar	egx,16
			mov	xf,eax
			mov	zf,ebx
			mov	lf,edx
			mov	eax,efx
			mov	txf,eax
			mov	eax,egx
			mov	tyf,eax

                        mov     eax,_tpl_GLZt_s.tx2[ebp]
                        mov     efx,eax
                        mov     eax,_tpl_GLZt_s.ty2[ebp]
                        mov     egx,eax
                        mov     eax,_tpl_GLZt_s.x2[ebp]
                        mov     ebx,_tpl_GLZt_s.z2[ebp]
			mov	edx,_tpl_GLZt_s.l2[ebp]
		.ENDIF
			sar	eax,16

                        cmp     eax,_tpl_GLZt_s.maxx[ebp]
			jg	skip
		;-------------------------------
		; Klipp vnster vrden..
		;-------------------------------
                .IF             eax < _tpl_GLZt_s.minx[ebp]
                        mov     ecx,_tpl_GLZt_s.minx[ebp]
			sub	ecx,eax		; Nya Delta X
			mov	xlen,ecx

			imul	ecx,zadd	; Klipp Z
			add	ebx,ecx		; Fixa till Z-start

			mov	ecx,xlen	; Klipp till texture coords
			imul	ecx,ladd
			add	edx,ecx

			mov	ecx,xlen	; Klipp till texture coords
			imul	ecx,txadd
			add	efx,ecx

			mov	ecx,xlen
			imul	ecx,tyadd
			add	egx,ecx

                        mov     eax,_tpl_GLZt_s.minx[ebp]
		.ENDIF
		;---------------------------------------
                        mov     ecx,xf
                .IF             ecx > _tpl_GLZt_s.maxx[ebp]
                        mov     ecx,_tpl_GLZt_s.maxx[ebp]
		.ENDIF
			sub	ecx,eax
			jle	skip
                        mov     xlen,ecx

		; ebx - Zvrde, edx - Lightvrde, efx - texture X, egx - texture Y

			mov	ecx,txadd


                        mov     edi,_tpl_GLZt_s.screen[ebp]
                        mov     esi,_tpl_GLZt_s.zbuffer[ebp]
			lea	edi,[edi+eax]
			lea	esi,[esi+eax*4]
			; Save edi for loop usage...
			mov	scrptr,edi

			mov	edi,ebx
			;mov 	al,byte ptr col
;---------------------------------------------------------------------------------------
; Texture loop:
; edi - Zvrde, edx - lightvrde, efx - textureX, egx - textureY
; ecx - txadd,
;
txlp:
                 .IF            edi < sdword ptr [esi]  ; Check Z-buffer
			mov	[esi],edi		; Put Z-value

			mov	eax,edx			; Get color value
			xor	ebx,ebx			; Clear EBX
			sar	eax,8			; Set color in ah
			mov	bl,byte ptr [efx+2]	; Get Texture X
			and	eax,0ff00h		; Make sure we are safe...
			mov	bh,byte ptr [egx+2]	; Get Texture Y

                        add     ebx,_tpl_GLZt_s.texture[ebp]    ; Fetch texturevalue...
			mov	al,[ebx]

			add	eax,_tpl_GLZt_s.lighttab[ebp]
			mov	ebx,scrptr		; Fetch scr....
			mov	al,[eax]

			mov	[ebx],al		; put texture coord...
		 .ENDIF
	;------> Update all values in texturemapper... z, light, x,y...
			add	edx,ladd
			add	edi,zadd		; Uppdatera z
			add	efx,ecx  		; Texture X add
			mov	eax,tyadd		; Lame soloution...
			inc	scrptr
			add	egx,eax			; Texture Y add...

			add	esi,4
			dec	xlen
			jne	txlp
;---------------------------------------------------------
skip:
		; Update loop fuckups...

		; First scanline
                        mov     eax,_tpl_GLZt_s.tx1add[ebp]
                        mov     ebx,_tpl_GLZt_s.ty1add[ebp]
                        add     _tpl_GLZt_s.tx1[ebp],eax
                        add     _tpl_GLZt_s.ty1[ebp],ebx
                        mov     eax,_tpl_GLZt_s.width[ebp]
                        mov     ebx,_tpl_GLZt_s.x1add[ebp]
                        mov     ecx,_tpl_GLZt_s.z1add[ebp]
			mov	edx,_tpl_GLZt_s.l1add[ebp]
                        add     _tpl_GLZt_s.screen[ebp],eax
                        add     _tpl_GLZt_s.x1[ebp],ebx
			shl	eax,2
                        add     _tpl_GLZt_s.z1[ebp],ecx
			add	_tpl_GLZt_s.l1[ebp],edx
                        add     _tpl_GLZt_s.zbuffer[ebp],eax
		; Second scanline
                        mov     ebx,_tpl_GLZt_s.x2add[ebp]
                        mov     ecx,_tpl_GLZt_s.z2add[ebp]
			mov	edx,_tpl_GLZt_s.l2add[ebp]
                        add     _tpl_GLZt_s.x2[ebp],ebx
                        add     _tpl_GLZt_s.z2[ebp],ecx
                        add     _tpl_GLZt_s.l2[ebp],edx
                        mov     eax,_tpl_GLZt_s.tx2add[ebp]
                        mov     ebx,_tpl_GLZt_s.ty2add[ebp]
                        add     _tpl_GLZt_s.tx2[ebp],eax
                        add     _tpl_GLZt_s.ty2[ebp],ebx

                        dec     _tpl_GLZt_s.ylen[ebp]
			jnz	lp
done:
			pop	ebp
			ret
tpoly_GLZt_asm   	ENDP

			END




