/*-----------------------------------------------------------------------------
  File: 3dmath.h
  Written by: Fredrik Kling, 1997-03-05
  Description: Header file for math systemlib.

  -- Date -- | --- Name ---- |-- Did what....
  1997-05-03 | Fredrik Kling | Implementation
-----------------------------------------------------------------------------*/

#pragma once

//#ifndef __VMATH_H
//#define __VMATH_H

#ifdef __WATCOMC__
#pragma library("vmath.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//

extern float *sintable;

#define SINESIZE 16384
#define SIN(__v) (sintable[__v])
#define COS(__v) (sintable[__v+SINESIZE/4])

// functions

void mathinit ();
void mathclose ();

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
