/*-----------------------------------------------------------------------------
  File: vector.h
  Written by: Fredrik Kling, 1997-03-05
  Description: Header file for vector calcultions

  -- Date -- | --- Name ---- |-- Did what....
  1997-05-03 | Fredrik Kling | Implementation
-----------------------------------------------------------------------------*/

#pragma once

//#ifndef __VECTOR_H
//#define __VECTOR_H

#ifdef __WATCOMC__
#pragma library("vmath.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//

// Type definitions

typedef struct s_VECTOR VECTOR;    // Vector def. for vmath.c and 3dmath.lib


// Structures!

struct s_VECTOR
{
  float x,y,z;
};


// Function declarations...

float vector_length (VECTOR *);
float dotproduct (VECTOR *,VECTOR *);
#ifdef __WATCOMC__
#pragma aux dotproduct "*" = \
	"fld	dword ptr [esi]",\
	"fmul	dword ptr [edi]",\
	"fld  dword ptr [esi+4]",\
	"fmul dword ptr [edi+4]",\
	"fld	dword ptr [esi+8]",\
	"fmul dword ptr [edi+8]",\
\
	"fxch	st(1)",\
	"faddp	st(2),st(0)",\
	"faddp	st(1),st(0)",\
	parm [esi] [edi] value [8087];
#endif

// Ripped from Michael Abrash in Dr Dobbs's sourcebook.. there is an error in this function....
void vector_crossprod (VECTOR *, VECTOR *, VECTOR *);
/*
#ifdef __WATCOMC__
#pragma aux vector_crossprod "*" = \
	"fld     dword ptr [esi+4]",\
	"fmul    dword ptr [ebx+8]",\
	"fld     dword ptr [esi+8]",\
	"fmul    dword ptr [ebx+0]",\
\
	"fld     dword ptr [esi+0]",\
	"fmul    dword ptr [ebx+4]",\
	"fld     dword ptr [esi+8]",\
	"fmul    dword ptr [ebx+4]",\
\
	"fld     dword ptr [esi+0]",\
	"fmul    dword ptr [ebx+8]",\
	"fld     dword ptr [esi+4]",\
	"fmul    dword ptr [ebx+0]",\
\
	"fxch    st(2)",\
\
	"fsubrp  st(5),st(0)",\
	"fsubrp  st(3),st(0)",\
	"fsubrp  st(1),st(0)",\
	"fxch    st(2)",\
\
	"fstp    dword ptr [edi+0]",\
	"fstp    dword ptr [edi+4]",\
	"fstp    dword ptr [edi+8]",\
	parm [esi] [ebx] [edi];
#endif
*/
void vector_normalize (VECTOR *);
float vector_angle (VECTOR *,VECTOR *);
void vector_translate (VECTOR *, float, float, float);
void vector_scale (VECTOR *, float);

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif

