/*--------------------------------------------------------------------------
 * File: tpoly.c
 * Written by: Alexander Boczar, 1997-03-29
 * Description: Poly drawer for 32 bit truecolor drawers!
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-06-24 | Alexander Boczar | Implementation
 *
 -------------------------------------------------------------------------------*/

#include "system/xstdlib.h"
#include "system/xmath.h"
#include "drivers/drv16.h"
#include "draw16/draw16.h"
#include "misc/clip.h"
//#include "debug/mono.h"
// Use only C-functions!!!!!
/*
#if defined(__X86__)
	#undef __X86__
#endif

*/
//#if defined(__X86__)

//#endif

extern void tpoly_glZt_asm(RGBA *screen, int *zbuffer, BYTE *texture, int minx, int maxx, int width, int ylen,
											int x1, int x1add, int z1, int z1add, int tx1, int tx1add, int ty1, int ty1add,
											int x2, int x2add, int z2, int z2add, int tx2, int tx2add, int ty2, int ty2add);

#ifdef __WATCOMC__
#pragma aux tpoly_glZt_asm "*" parm caller [];
#endif

extern void tpoly_glzt_asm(RGBA *screen, BYTE *texture, int minx, int maxx, int width, int ylen,
											int x1, int x1add, int tx1, int tx1add, int ty1, int ty1add,
											int x2, int x2add, int tx2, int tx2add, int ty2, int ty2add);

#ifdef __WATCOMC__
#pragma aux tpoly_glzt_asm "*" parm caller [];
#endif

extern tpoly_GLZt_asm(RGBA *screen, int *zbuffer, BYTE *lighttab, BYTE *texture, int minx, int maxx, int width, int ylen,
											int x1, int x1add, int z1, int z1add, int tx1, int tx1add, int ty1, int ty1add, int l1, int l1add,
											int x2, int x2add, int z2, int z2add, int tx2, int tx2add, int ty2, int ty2add, int l2, int l2add);
#ifdef __WATCOMC__
#pragma aux tpoly_GLZt_asm "*" parm caller [];
#endif

extern tpoly_gLZt_asm(RGBA *screen, int *zbuffer, BYTE *lighttab, BYTE *texture, int minx, int maxx, int width, int ylen,
											int x1, int x1add, int z1, int z1add, int tx1, int tx1add, int ty1, int ty1add,
											int x2, int x2add, int z2, int z2add, int tx2, int tx2add, int ty2, int ty2add);
#ifdef __WATCOMC__
#pragma aux tpoly_gLZt_asm "*" parm caller [];
#endif

//#endif

#undef  GOURADE
#undef  LIGHT
#undef  ZBUFFER
#undef  TRANS
static void tpoly_glzt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
#include "tpoly0.c"


#undef  GOURADE
#define LIGHT
#undef  ZBUFFER
#undef  TRANS
static void tpoly_gLzt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

#define GOURADE
#define LIGHT
#undef  ZBUFFER
#undef  TRANS
static void tpoly_GLzt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"


#undef  GOURADE
#undef  LIGHT
#define ZBUFFER
#undef  TRANS
static void tpoly_glZt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
#include "tpoly0.c"


#undef  GOURADE
#define LIGHT
#define ZBUFFER
#undef  TRANS
static void tpoly_gLZt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
#include "tpoly0.c"

#define GOURADE
#define LIGHT
#define ZBUFFER
#undef  TRANS
static void tpoly_GLZt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

#undef  GOURADE
#undef  LIGHT
#undef  ZBUFFER
#define TRANS
static void tpoly_glzT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

#undef  GOURADE
#define LIGHT
#undef  ZBUFFER
#define TRANS
static void tpoly_gLzT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

#define GOURADE
#define LIGHT
#undef  ZBUFFER
#define TRANS
static void tpoly_GLzT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

#undef  GOURADE
#undef  LIGHT
#define ZBUFFER
#define TRANS
static void tpoly_glZT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

#undef  GOURADE
#define LIGHT
#define ZBUFFER
#define TRANS
static void tpoly_gLZT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

#define GOURADE
#define LIGHT
#define ZBUFFER
#define TRANS
static void tpoly_GLZT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
}
//#include "tpoly0.c"

void tpoly16( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE *texture)
{
	BYTE funcs;
	funcs = ((buff->zbuffer != NULL)? 0x01 : 0x00)
 			 	| ((buff->lighttab != NULL)? 0x02 : 0x00)
			 	| ((buff->transtab != NULL)? 0x04 : 0x00)
			 	| (((p1.l == p2.l) && (p1.l == p3.l))? 0x00 : 0x08);

	switch( funcs)
	{
    case 0x00: tpoly_glzt( buff, p1, p2, p3, texture); break;
    case 0x01: tpoly_glZt( buff, p1, p2, p3, texture); break;
    case 0x02: tpoly_gLzt( buff, p1, p2, p3, texture); break;
    case 0x03: tpoly_gLZt( buff, p1, p2, p3, texture); break;
    case 0x04: tpoly_glzT( buff, p1, p2, p3, texture); break;
    case 0x05: tpoly_glZT( buff, p1, p2, p3, texture); break;
    case 0x06: tpoly_gLzT( buff, p1, p2, p3, texture); break;
    case 0x07: tpoly_gLZT( buff, p1, p2, p3, texture); break;
    case 0x08: tpoly_glzt( buff, p1, p2, p3, texture); break;
    case 0x09: tpoly_glZt( buff, p1, p2, p3, texture); break;
    case 0x0a: tpoly_GLzt( buff, p1, p2, p3, texture); break;
    case 0x0b: tpoly_GLZt( buff, p1, p2, p3, texture); break;
    case 0x0c: tpoly_glzT( buff, p1, p2, p3, texture); break;
    case 0x0d: tpoly_glZT( buff, p1, p2, p3, texture); break;
    case 0x0e: tpoly_GLzT( buff, p1, p2, p3, texture); break;
    case 0x0f: tpoly_GLZT( buff, p1, p2, p3, texture); break;
	}
}
