
/*--------------------------------------------------------------------------
 * File: line.c
 * Written by: Fredrik Kling, 1997-11-13
 * Description: Line drawer for 16 bit based drivers.
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-11-13 | Fredrik Kling    | Implementation
 *
 -------------------------------------------------------------------------------*/

#include "system/xstdlib.h"
#include "drivers/drv16.h"
#include "draw16/draw16.h"
#include "misc/clip.h"

typedef struct
{
	float x;
	float y;
	float z;
	float l;
} COORD;

void line16( BUFF *buff, const XYZ p1, const XYZ p2, RGBA col)
{
	COORD	c1,c2;
	register int x,y,z,l;
	register int xadd,yadd,zadd,ladd;
	register int offset;
  int len;
  int i;
	RGBA *vscreen = buff->image;
	BYTE *lighttab = NULL; // buff->r_lighttab;
	BYTE *transtab = NULL; // buff->transtab;
  int *zbuffer = buff->zbuffer;
	int *ytab = buff->ytab;

	c1.x = p1.x;
	c1.y = p1.y;

	c2.x = p2.x;
	c2.y = p2.y;

	i = 4;

	if( zbuffer != NULL)
		c1.z = p1.z, c2.z = p2.z;

	//if( lighttab != NULL)
//		c1.l = p1.l, c2.l = p2.l;

	if ( !xyclip( i, (float *)&c1, (float *)&c2, buff->minx, buff->maxx, buff->miny, buff->maxy))
		return;

	xadd = c2.x - c1.x;
	yadd = c2.y - c1.y;
  if ( abs(xadd) > abs(yadd)) len = abs(xadd);
    else len = abs( yadd);

	if( !len)
		return;

	xadd = (xadd * 65536) / len;
  yadd = (yadd * 65536) / len;

  x = c1.x * 65536;
  y = c1.y * 65536;

	if( zbuffer != NULL)
	{
		zadd = c2.z - c1.z;
  	zadd = (zadd * 65536) / len;
  	z = c1.z * 65536;
	}
/*
	if( lighttab != NULL)
	{
		ladd = c2.l - c1.l;
  	ladd = (ladd * 65536) / len;
  	l = c1.l * 65536;
	}
*/
	if( zbuffer != NULL)
	{
		if( lighttab != NULL)
		{
			for( i=0; i<(len+1); i++)// Z,L
			{
				offset = (x >> 16) + ytab[y >> 16];
        if ( zbuffer[offset] > z)
				{
				  zbuffer[offset] = z;
				  vscreen[offset] = col; //lighttab[ ((l >> 8) & ~0xff) + col];
				}
				x += xadd;
				y += yadd;
				z += zadd;
				l += ladd;
			}
		}
		else
		{
			for( i=0; i<(len+1); i++)// Z
			{
				offset = (x >> 16) + ytab[y >> 16];
        if ( zbuffer[offset] > z)
				{
				  zbuffer[offset] = z;
				  vscreen[offset] = col;
				}
				x+=xadd;
				y+=yadd;
				z+=zadd;
			}
		}
	}
	else
	{
		if( lighttab != NULL)
		{
			for( i=0; i<(len+1); i++)// L
			{
				offset = (x >> 16) + ytab[y >> 16];
				vscreen[offset] = col; //lighttab[ ((l >> 8) & ~0xff) + col];
				x+=xadd;
				y+=yadd;
				l+=ladd;
			}
		}
		else
		{
			for( i=0; i<(len+1); i++)//
			{
				offset = (x >> 16) + ytab[y >> 16];
				vscreen[offset] = col;
				x+=xadd;
				y+=yadd;
			}
		}

	}

}

