/*--------------------------------------------------------------------------
 * File: ex1.c
 * Written by: Gnilk
 * Description:
 *    Small example for SAGA.
 *		Creates a virtual screen buffer draws a horizontal line each frame.
 *		Shows how to use the buffers on your own...
 *    The buffer structure is defined in "drivers/XXXXX.h"  where XXXX
 *    is the driver to be used..  Here it is "drv16.h".
 *
 *
 * Note:
 *		Get rid of all comments to make the code look less complicated....
 *
 -------------------------------------------------------------------------------*/

#include "system/xstdio.h"
#include "drivers/drv16.h"

/*
 * Define the driver as an external...
 */
extern DRV vesa16DRV;
static DRV *drv = &vesa16DRV;


static BUFF *virtual_buffer;



/* ######################################################################### */
/* ######################################################################### */
void init_driver (void)
{
	int i;

	/*
	 * Setup driver
	 * If this call isnt done the drv->init call does it for you...
	 * Setup checks for videomodes and such..
	 *
	 */
  if (!drv->setup())
	{
		printf("Driver setup failed(%s)\n", drv->geterror());
		exit( 1);
	}
	else
	{
		printf ("Available modes:\n");
		for(i=0; i<drv->modes; i++)
			printf ("%dx%d\n", drv->modelist[i].width, drv->modelist[i].height);
	}

	/*
	 * Init graphics driver with 16 bits output and Zbuffer
	 */
	if( !drv->init(640,480, DRVCFG_ZBUFFER | DRVCFG_16BITS))
	{
		printf("Unable to initilize %s.(%s)\n", drv->name, drv->geterror());
		exit(0);
	}

}

int main (void)
{
	/*
	 * All internal data i processed as 32 bit RGBA, although the Alpha channel
	 * isn't used. Range for RGB values are 0-255.
	 */
	RGBA RGBA_color = {255,255,255,0};
	RGBA RGBA_black = {0,0,0,0};

	int i;

	/*
	 * Small subroutine to start driver...
	 * It almost look the same for all code...
	 */
	init_driver ();

	/*
	 * Create a virtual buffer..
	 */
	if ((virtual_buffer = drv->createbuff (320,240))==NULL)
	{
		drv->exit ();
		printf ("Unable to create virtual screen buffer\n");
		exit (1);
	}

	/*
	 * Tell the graphics driver to use our buffer as
	 * current active buffer...
	 */
	drv->setbuff (virtual_buffer);

	/*
	 * Clear the buffer...
	 */
	drv->clearbuff (RGBA_black);


	while(!drv->kbhit())
	{
		/*
		 * Call vertical retrace sync..
		 */
		drv->vsync ();
		/*
		 * Swap active buffer to screen, at XY-position (0,0).
		 */
		drv->copybuff (0,0);

		/*
		 * Do something with the buffer
		 */
		for (i=0;i<320;i++)
			virtual_buffer->image[i+120*virtual_buffer->width]=RGBA_color;
	}

	/*
	 * Destroy virtual screen and exit driver!
	 */
	drv->destroybuff (virtual_buffer);
	drv->exit ();

	return (0);
}
