/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isSynth_h
#define __isSynth_h

#include <ctime>

#include "isInstrument.h"
#include "isSamplePool.h"
#include "isEvent.h"

#include "isEffectChain.h"

class isTimer
{
public:
	inline isTimer() { 
		QueryPerformanceFrequency(&isTimerFreq); 
		QueryPerformanceCounter(&TimeStart); 
	}
	inline ~isTimer() {}

	inline float getTime() {
		QueryPerformanceCounter(&TimeCur);
		return ((float)(TimeCur.QuadPart-TimeStart.QuadPart)/(float)isTimerFreq.QuadPart);
	}
	inline void reset() {
		QueryPerformanceCounter(&TimeStart);
	}

private:
	LARGE_INTEGER isTimerFreq;	// bsTimer Frequency.
	LARGE_INTEGER TimeStart;	// Time of start.
	LARGE_INTEGER TimeCur;		// Current time.

};

class isSynth : public isBase
{
public:
	isSynth();
	virtual ~isSynth();

	void Load(isFile *f);
	void Save(isFile *f);


	void GetSamples(float *left, float *right);
	float GetCPUUsage() { return ccpu; }
	void SetBufferSize(int length);
	void Event(int channel, isEVENT event);

	isInstrument *instrument[16]; // 16 channels, so. 16 instruments. use them all :)
	isEffectChain effectChain[3];// tree effect chains

	float volume[16];		// volume for each instrument
	float panning[16];	// stereo panning from 0.0-1.0 (left->right) for each instrument
	float fx1Gain[16],fx2Gain[16],fx3Gain[16]; // effect sends

	// new on 19/7 2002 - the sample pool!

	isSamplePool samplePool;
	
private:
	isTimer timer;
	float start,end;
	float ccpu; // current cpu usage
	float *fxsend[3]; // the input buffers to the send effects
	int bufferLength;


};

#endif
