/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include "isController.h"

isController::isController()
{
	cutoff=0.01f;
	endValue[0]=startValue[0]=inValue=0.0f;
	controllerNumber=2;

	// for isBase
	type=is_CONTROLLER;
}

isController::~isController()
{

}

void isController::Load(isFile *f)
{
	cutoff=f->ReadFloat();
	controllerNumber=f->ReadInt(1);

}

void isController::Save(isFile *f)
{
	SaveType(f);
	f->WriteFloat(cutoff);
	f->WriteInt(controllerNumber,1);
}

void isController::Render(int polyNr)
{
	// lowpass the controller value
	startValue[0]=endValue[0];
	endValue[0]=endValue[0]*(1.0f-cutoff)+inValue*cutoff;
}

void isController::Event(isEVENT event, int polyNr)
{
	if(event.type==CONTROLLER && event.param1==controllerNumber)
	{
		inValue=event.param2/65535.0f;
	}

}
