#if !defined(AFX_INSTREDITOR_H__F162B004_A4C5_43EE_BC0C_C69CE7C61D62__INCLUDED_)
#define AFX_INSTREDITOR_H__F162B004_A4C5_43EE_BC0C_C69CE7C61D62__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// instrEditor.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// instrEditor form view

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

#include "roundsliderctrl.h"
#include "trackerdoc.h"
#include "voicebasedlg.h"
#include "MIDIReceptor.h"
#include "ArpEditor.h"

class CInstrEditor : public CFormView, public MIDIReceptor
{

protected:
	// steffo testar midi-grejs
	bool midiopen;
	static UINT curdevice;
	HMIDIIN handle;


protected:
	CInstrEditor();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CInstrEditor)

// Form Data
public:
	//{{AFX_DATA(CInstrEditor)
	enum { IDD = IDD_DIALOG_INSTREDIT };
	CComboBox	m_vol1ModNr;
	CComboBox	m_vol0ModNR;
	CStatic	m_instrDistAmText;
	CStatic	m_textPolyCount;
	CStatic	m_textNRangeStart;
	CStatic	m_textNRangeEnd;
	CSliderCtrl	m_instrDistAmount;
	CComboBox	m_instrDistType;
	CSliderCtrl	m_noterangeend;
	CSliderCtrl	m_noterangestart;
	CListBox	m_voicelist;
	CComboBox	m_instrlist;
	CTabCtrl	m_subObects;
	BOOL	m_useDist;
	float	m_vol0ModAmount;
	float	m_vol1ModAmount;
	BOOL	m_enable_arp;
	//}}AFX_DATA

// Attributes
public:
  CTrackerDoc* GetDocument();

  CArpEditor m_arpeditor;
  
// Operations
public:
	void GetVoiceData(void);
	void SetVoiceData(void);
    void UpdateCntrlText (void);
    void FillVolModCombo();
    int cursel_voice;
	void UpdateCurrent ();
	isSynth * GetSynth(void);
    isVoice * GetVoice(void);
    isInstrument *GetInstr();
	void SetUpVoices (int instrnr);

	// <MIDI HANDLERS>
	virtual void OnMIDIKeyDown( UINT key, UINT velocity );
	virtual void OnMIDIKeyUp( UINT key, UINT velocity );
	// </MIDI HANDLERS>

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CInstrEditor)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CInstrEditor();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
  CVoiceBaseDlg *current;
	// Generated message map functions
	//{{AFX_MSG(CInstrEditor)
	afx_msg void OnSelchangeTabSubobjects(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnButtonDelvoice();
	afx_msg void OnSelchangeListVoice();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSelchangeComboInstrument();
	afx_msg void OnDeltaposSpinNrpolyfoni(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCheckUsedist();
	afx_msg void OnSelchangeComboInstrDistType();
	afx_msg void OnButtonInstrsave();
	afx_msg void OnButtonInstrload();
	afx_msg void OnSelchangeCombo();
	afx_msg void OnMaxtextEditVolMod();
	afx_msg void OnChangeEditVol0modamount();
	afx_msg void OnChangeEditVol1modamount();
	afx_msg void OnKillfocusEditVol0modamount();
	afx_msg void OnKillfocusEditVol1modamount();
	afx_msg void OnEditArpeggio();
	afx_msg void OnButtonAddvoice();
	afx_msg void OnEnablearp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/*
#ifndef _DEBUG  // debug version in trackerView.cpp
inline CTrackerDoc* CInstrEditor::GetDocument()
{ return (CTrackerDoc*)m_pDocument; }
#endif
*/

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_INSTREDITOR_H__F162B004_A4C5_43EE_BC0C_C69CE7C61D62__INCLUDED_)
