#if !defined(AFX_ROUNDSLIDERCTRL_H__21E63D43_D1CD_4FE6_84AB_D805D4AB576D__INCLUDED_)
#define AFX_ROUNDSLIDERCTRL_H__21E63D43_D1CD_4FE6_84AB_D805D4AB576D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// RoundSliderCtrl.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CRoundSliderCtrl window

class CRoundSliderCtrl : public CSliderCtrl
{
protected:
	CPoint	m_ptCenter;
	int		m_nRadius;
	CRgn	m_rgn;

	int		m_nZero;
	bool	m_bInverted;

	CString m_strText;
	int		m_nKnobRadius;
  float m_scale;

	bool	m_bDragging;
	bool	m_bDragChanged;
	bool	m_bDrawRadioButton;
// Construction
public:
	DECLARE_DYNAMIC(CRoundSliderCtrl)
	CRoundSliderCtrl();

// Attributes
public:
	// You may use '%ld' to show the slider value. Default: "%ld"
  virtual void SetScale (const float scale);
  virtual float GetScale (void) const;
	virtual void SetText(const CString& strNewText);
	virtual CString GetText() const;

	// Override this function for customized output
	virtual CString OnFormatText();

	// Default: 7, Minimum: 5
	virtual void SetKnobRadius(const int nNewKnobRadius);
	virtual int GetKnobRadius() const;

	// 0-359, 0 = Top, 90 = Right, 180 = Bottom, 270 = Left
	virtual void SetZero(const int nZero);
	virtual int GetZero() const;

	virtual void SetInverted(const bool bNewInverted = true);
	virtual bool GetInverted();
	
	void SetDrawRadioButton(const bool nDrawRadioButton);
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CRoundSliderCtrl)
	protected:
	virtual void PreSubclassWindow();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CRoundSliderCtrl();

	// Generated message map functions
protected:
	virtual void Init();
	virtual bool SetKnob(const CPoint& pt);
	virtual void PostMessageToParent(const int nTBCode) const;
	//{{AFX_MSG(CRoundSliderCtrl)
		// NOTE - the ClassWizard will add and remove member functions here.
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
#ifdef _DEBUG
public:
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif // _DEBUG
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ROUNDSLIDERCTRL_H__21E63D43_D1CD_4FE6_84AB_D805D4AB576D__INCLUDED_)
