// PropPageSound.cpp : implementation file
//



#include "stdafx.h"
#include "tracker.h"
#include "PropPageSound.h"
#include "Configuration.h"
#include <mmsystem.h>
#include "isPlayer.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropPageSound property page

IMPLEMENT_DYNCREATE(CPropPageSound, CPropertyPage)

CPropPageSound::CPropPageSound() : CPropertyPage(CPropPageSound::IDD)
{
	//{{AFX_DATA_INIT(CPropPageSound)
	m_latency = 0;
	//}}AFX_DATA_INIT
}

CPropPageSound::~CPropPageSound()
{
}

void CPropPageSound::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropPageSound)
	DDX_Control(pDX, IDC_COMBO1, m_threadpriority);
	DDX_Control(pDX, IDC_SPIN1, m_latspinner);
	DDX_Text(pDX, IDC_EDIT1, m_latency);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropPageSound, CPropertyPage)
	//{{AFX_MSG_MAP(CPropPageSound)
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropPageSound message handlers

void CPropPageSound::OnChangeEdit1() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	SetModified();
	
}

BOOL CPropPageSound::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_latspinner.SetRange( 1, 1000 );
	m_latency = CONFIGURATION_GETDWORD( _T("dsound"), _T("latency"), 400 );
	m_latspinner.SetBuddy( GetDlgItem( IDC_EDIT1 ) );				

	m_threadpriority.InsertString( 0, _T("Normal") );
	m_threadpriority.InsertString( 1, _T("Above normal") );
	m_threadpriority.InsertString( 2, _T("Highest") );
	m_threadpriority.InsertString( 3, _T("Time critical") );
	m_threadpriority.SetCurSel( CONFIGURATION_GETDWORD( _T("dsound"), _T("threadpriority"), 0 ) );
	
	UpdateData( FALSE );
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// lista
extern isPlayer *g_docPlayerList[16];

BOOL CPropPageSound::OnApply() 
{
	// TODO: Add your specialized code here and/or call the base class
	UpdateData( TRUE );
	CONFIGURATION_SETDWORD( _T("dsound"), _T("latency"), m_latency );
	CONFIGURATION_SETDWORD( _T("dsound"), _T("threadpriority"), m_threadpriority.GetCurSel( ) );

	for (int i=0;i<16;i++)
		if (g_docPlayerList[i]) {
			g_docPlayerList[i]->SetLatency( m_latency );
			HANDLE thread = g_docPlayerList[i]->GetThreadHandle();
			switch ( m_threadpriority.GetCurSel() ) {
				case 0:
					SetThreadPriority( thread, THREAD_PRIORITY_NORMAL );
					break;
				case 1:
					SetThreadPriority( thread, THREAD_PRIORITY_ABOVE_NORMAL );
					break;
				case 2:
					SetThreadPriority( thread, THREAD_PRIORITY_HIGHEST );
					break;
				case 3:
					SetThreadPriority( thread, THREAD_PRIORITY_TIME_CRITICAL );
					break;
			}
		}

	
	return CPropertyPage::OnApply();
}

void CPropPageSound::OnSelchangeCombo1() 
{
	// TODO: Add your control notification handler code here
	SetModified();
	
}
