// ModLfo.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "isSynth.h"

#include "ModLfo.h"
#include "isLFO.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModLfo dialog
#define FloatIntMAX 1024
#define uFloatToInt(a) ((a)*1024)
#define sFloatToInt(a) ((a)*1024+1024)

#define uIntToFloat(a) ((a)/1024.0f)
#define sIntToFloat(a) (((a)-1024)/1024.0f)


static int waveids[]=
{
    SINE,
    SAW,
    SQUARE,
    TRIANGLE,
    RANDOM1,
    RANDOM2
};
static char *wavenames[]=
{
  "SINE",
    "SAW",
    "SQUARE",
    "TRIANGLE",
    "RANDOM1",
    "RANDOM2",
    NULL
};


CModLfo::CModLfo(CWnd* pParent /*=NULL*/)
	: CModulateBaseDlg(CModLfo::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModLfo)
	//}}AFX_DATA_INIT
}


void CModLfo::DoDataExchange(CDataExchange* pDX)
{
	CModulateBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModLfo)
	DDX_Control(pDX, IDC_STATIC_VVAL, m_vval);
	DDX_Control(pDX, IDC_STATIC_OVAL, m_oval);
	DDX_Control(pDX, IDC_STATIC_AVAL, m_aval);
	DDX_Control(pDX, IDC_SLIDER_LFOVELOSENSE, m_velosenseSlider);
	DDX_Control(pDX, IDC_SLIDER_LFOOFS, m_ofsSlider);
	DDX_Control(pDX, IDC_SLIDER_LFOATTAC, m_attacSlider);
	DDX_Control(pDX, IDC_EDIT_LFOLENGTH, m_lengthString);
	DDX_Control(pDX, IDC_COMBO_LFOWAVE, m_waveList);
	DDX_Control(pDX, IDC_CHECK_LFORETRIG, m_retrigCheck);
	DDX_Control(pDX, IDC_CHECK_LFOINVERT, m_invertCheck);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CModLfo, CModulateBaseDlg)
	//{{AFX_MSG_MAP(CModLfo)
	ON_WM_HSCROLL()
	ON_CBN_SELCHANGE(IDC_COMBO_LFOWAVE, OnSelchangeComboLfowave)
	ON_EN_MAXTEXT(IDC_EDIT_LFOLENGTH, OnMaxtextEditLfolength)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModLfo message handlers
void CModLfo::SetModData()
{
  isLFO *lfo;
  lfo = (isLFO *)modulator;
  char buffer[128];

  lfo->attack = m_attacSlider.GetPos();
  lfo->offset = sIntToFloat(m_ofsSlider.GetPos());
  lfo->veloSens = sIntToFloat(m_velosenseSlider.GetPos());

  if (m_retrigCheck.GetCheck())
    lfo->retrig = TRUE;
  else
    lfo->retrig = FALSE;

  if (m_invertCheck.GetCheck())
    lfo->invert = TRUE;
  else
    lfo->invert = FALSE;

  m_lengthString.GetWindowText(buffer,128);
  lfo->length = atoi (buffer);


  int cursel;
  cursel = m_waveList.GetCurSel();
  lfo->wave = (isLFOWave)m_waveList.GetItemData((int)cursel);


  CString bla;

  bla.Format("%d",lfo->attack);
  m_aval.SetWindowText (bla);
  bla.Format("%5.4f",lfo->offset);
  m_oval.SetWindowText (bla);
  bla.Format("%5.4f",lfo->veloSens);
  m_vval.SetWindowText (bla);
  

//  instrument->Update();
  
}
void CModLfo::UpdateModulateData()
{
    isLFO *lfo;
    lfo = (isLFO *)modulator;

    m_attacSlider.SetPos (lfo->attack);
    m_ofsSlider.SetPos (sFloatToInt(lfo->offset));
    m_velosenseSlider.SetPos(sFloatToInt(lfo->veloSens));
    if (lfo->retrig)
        m_retrigCheck.SetCheck(1);
    else
        m_retrigCheck.SetCheck(0);

    if (lfo->invert)
        m_invertCheck.SetCheck(1);
    else
        m_invertCheck.SetCheck(0);

    char buffer[128];
    sprintf (buffer,"%d",lfo->length);

    m_lengthString.SetWindowText (buffer);

    m_waveList.SetCurSel(lfo->wave);

    CString bla;
    
    bla.Format("%d",lfo->attack);
    m_aval.SetWindowText (bla);
    bla.Format("%5.4f",lfo->offset);
    m_oval.SetWindowText (bla);
    bla.Format("%5.4f",lfo->veloSens);
    m_vval.SetWindowText (bla);
    
  
}

BOOL CModLfo::OnInitDialog() 
{
	CModulateBaseDlg::OnInitDialog();
    int i;

    m_attacSlider.SetRange(0,255);
    m_ofsSlider.SetRange(0,2048);
    m_velosenseSlider.SetRange(0,2048);
    for (i=0;wavenames[i]!=NULL;i++)
    {
        m_waveList.InsertString(i,wavenames[i]);
        m_waveList.SetItemData(i,waveids[i]);
    }

    m_waveList.SetCurSel(0);

    // TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CModLfo::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	SetModData();
	CModulateBaseDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CModLfo::OnSelchangeComboLfowave() 
{
	// TODO: Add your control notification handler code here
    SetModData();
	
}


void CModLfo::OnMaxtextEditLfolength() 
{
	// TODO: Add your control notification handler code here
    SetModData();
    
}
