
#include "stdafx.h"
#include "tracker.h"

#include "mainfrm.h"
#include "gtkformat.h"
#include "trackerDoc.h"
#include "trackerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SETHIBYTE(a,b) ((a)=((a)&0x0f)|(((b)<<4)&0xf0));
#define SETLOWBYTE(a,b) ((a)=((a)&0xf0)|((b)&0x0f));

static char *legal_num_char="0123456789ABCDEF";


void CPatternView::ModifySequencerData (int val)
{
	CTrackerDoc *pDoc = GetDocument ();

	GTK_SEQPOS *patpos;

	patpos = &pDoc->gtk->channels[seqCursor.col].positions[seqCursor.pos];
	switch (seqCursor.rowcol)
	{
		case 0 :
			SETHIBYTE (patpos->pattern,val);
			break;
		case 1 :
			SETLOWBYTE (patpos->pattern,val);
			break;

		case 2 :
			SETHIBYTE (patpos->transpose,val);
			break;
		case 3 :
			SETLOWBYTE (patpos->transpose,val);
			break;
		case 4 :
			SETHIBYTE (patpos->fx,val);
			break;
		case 5 :
			SETLOWBYTE (patpos->fx,val);
			break;
		case 6 :
			SETHIBYTE (patpos->param1,val);
			break;
		case 7 :
			SETLOWBYTE (patpos->param1,val);
			break;
		case 8 :
			SETHIBYTE (patpos->param2,val);
			break;
		case 9 :
			SETLOWBYTE (patpos->param2,val);
			break;
		case 10:
			SETHIBYTE (patpos->param3,val);
			break;
		case 11:
			SETLOWBYTE (patpos->param3,val);
			break;
    case 12 :
      SETHIBYTE (patpos->param4,val);
      break;
    case 13 :
      SETLOWBYTE (patpos->param4,val);
      break;
    case 14:
      SETHIBYTE (patpos->param5,val);
      break;
    case 15:
      SETLOWBYTE (patpos->param5,val);
      break;
    case 16:
      SETHIBYTE (patpos->param6,val);
      break;
    case 17:
      SETLOWBYTE (patpos->param6,val);
      break;
      
      
	}
}

void CPatternView::MoveSequencerCursor (int val,int flag)
{
    CTrackerDoc *pDoc = GetDocument ();
    GTK_SEQCHANNEL *schn;
    schn = &pDoc->gtk->channels[seqCursor.col];
    
	switch (flag)
	{
		case 0 :
			seqCursor.pos+=val;
			if (seqCursor.pos > (schn->len-1)) seqCursor.pos = (schn->len-1);
			if (seqCursor.pos < 0) seqCursor.pos = 0;	
			break;
		case 1:
			seqCursor.rowcol+=val;
			if (seqCursor.rowcol > 17) seqCursor.rowcol = 0;
			if (seqCursor.rowcol < 0) seqCursor.rowcol = 17;
			break;
		case 2 :
			seqCursor.col+=val;
			if (seqCursor.col > 15) seqCursor.col = 0;
			if (seqCursor.col < 0) seqCursor.col = 15;
			break;
	}
}
void CPatternView::SetSequencerCursor (int val,int flag)
{
/*
	if (!flag)
	{
		seqCursor.pos=val;
	} else
		{
			seqCursor.rowcol = val;			
		}
*/
	switch (flag)
	{
		case 0 :
			seqCursor.pos=val;
			break;
		case 1 :
			seqCursor.rowcol = val;			
			break;
		case 2 :
			seqCursor.col = val;
			break;

	}
}

void CPatternView::ProcessSequencerKey(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  CTrackerDoc *pDoc = GetDocument ();
  EDITDATA *edt;
  edt = &pDoc->editData;
  if (pDoc != NULL)
  {
    switch (nChar)
    {
    case VK_HOME :
      SetSequencerCursor (0,0);
      break;
    case VK_END :
      SetSequencerCursor (63,0);
      break;
    case VK_DOWN :
      if (!(GetKeyState (VK_CONTROL) & 0x8000))
        MoveSequencerCursor (1,0);
      else
        isPatternEdit=1;
      break;
    case VK_UP :
      if (!(GetKeyState (VK_CONTROL) & 0x8000))
        MoveSequencerCursor (-1,0);
      else
        isPatternEdit=1;
      break;
    case VK_NEXT :
      MoveSequencerCursor (16,0);
      break;
    case VK_PRIOR :
      MoveSequencerCursor (-16,0);
      break;
    case VK_RIGHT :
      if (!(GetKeyState (VK_CONTROL) & 0x8000))
        MoveSequencerCursor (1,1);
      else
      {
        MoveSequencerCursor (1,2);
        SetSequencerCursor (0,1);
      }
      break;
    case VK_LEFT :
      if (!(GetKeyState (VK_CONTROL) & 0x8000)) 
        MoveSequencerCursor (-1,1);
      else
      {
        if (!seqCursor.rowcol) MoveSequencerCursor (-1,2);
        SetSequencerCursor (0,1);
      }
      break;
    case VK_DELETE :
      ModifySequencerData (0);
      MoveSequencerCursor (1,0);
      break;
    case VK_TAB :
      if (!(GetKeyState (VK_RSHIFT) & 0x8000))
      {
        if (GetKeyState (VK_LSHIFT) & 0x8000)
          MoveSequencerCursor (-1,2);
        else MoveSequencerCursor (1,2);
      } else
      {
        isPatternEdit = 1;
      }
      break;
    default :
      {
        char *ptr;
        if ((ptr = strchr (legal_num_char,nChar))!=NULL)
        {
          int val = ptr - (char *)legal_num_char;
          
          ModifySequencerData (val);
          MoveSequencerCursor (1,0);
          
        } // if 
      } // block
      
      break;	// default
    } // switch
//  pDoc->UpdateAllViews (NULL);
    Invalidate();
    UpdateWindow();
  }
  
} // on chn key
