#include "ComTry.h"

#include "LimitedStreams.h"
#include "StreamObjects.h"
#include "StreamUtils.h"
#include "MyWindows.h"

#include "DeflateEncoder.h"
#include "CopyCoder.h"

#include "Defs.h"

ISequentialInStream *LockedStreamIn;
ISequentialOutStream *LockedStreamOut;
NCompress::NDeflate::NEncoder::CCoder cc;

bool compress_deflate_7z(const unsigned char *in_data,
                         unsigned in_size,
                         unsigned char *out_data,
                         unsigned &out_size) throw ()
{
	try
    {
        const unsigned __int64 insize = in_size;
        const unsigned __int64 outsize = out_size;

        CSequentialInStreamImp *streamInSpec2 = new CSequentialInStreamImp;
        CSequentialOutStreamImp2 *streamOutSpec2 = new CSequentialOutStreamImp2;

        streamInSpec2->Init(in_data, in_size);
        streamOutSpec2->Init(out_data, out_size);

        LockedStreamIn = streamInSpec2;
        LockedStreamOut = streamOutSpec2;
        
        cc.m_NumPasses = 258;
        cc.m_NumDivPasses = 16;
        cc.m_NumFastBytes = 258;
        cc.m_MatchFinderCycles = 258;
        cc._fastMode = false;
        cc._btMode = true;

        if(cc.BaseCode(LockedStreamIn, LockedStreamOut, NULL, NULL, NULL) != S_OK)
        {
            return false;
        }

        out_size = (unsigned int) streamOutSpec2->GetPos();
        
        cc.Free();

		return true;
	}
    catch(...)
    {
		return false;
	}
}

bool compress_rfc1950_7z(const unsigned char *in_data,
                         unsigned in_size,
                         unsigned char *out_data,
                         unsigned &out_size) throw ()
{
	if(out_size < 6)
    {
		return false;
    }

	// 8 - deflate
	// 7 - 32k window
	// 3 - max compression
    // Added within the depacker (fake via push & ret instructions)
//	unsigned header = (8 << 8);// | (7 << 12);// | (3 << 6);
//	header += 31 - (header % 31);
//	out_data[0] = (header >> 8) & 0xff;
//	out_data[1] = header & 0xff;
//	out_data += 2;

    unsigned size = out_size;

	if(!compress_deflate_7z(in_data, in_size, out_data, size))
    {
		return false;
	}
	out_size = size;
	return true;
}
