//
// Terrain - blends terrain for transition.
//
// ps1.1, FFP
// 

#include "_lib.fx"

float4x4	mWorld;
float4x4	mWorldView;
float4x4	mWVP;

float	fBlend;

texture tBody;
texture tLightMap;

sampler2D smpBody = sampler_state {
	Texture = (tBody);
    MipFilter = Linear;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Wrap; AddressV = Wrap;
};
sampler2D smpLightMap = sampler_state {
	Texture = (tLightMap);
    MipFilter = Linear;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Wrap; AddressV = Wrap;
};


#include "blur_11FFpath.fx"


SPosTex2 vsMain11a( SPosTex4 i ) {
	SPosTex2 o;
	o.pos = mul( i.pos, mWVP );
	o.uv[0] = i.uv[3];
	o.uv[1] = i.uv[1];
	return o;
}

#ifdef ENABLE_PS11_PATH

half4 psMain11a( SPosTex2 i ) : COLOR
{
	half3 col = tex2D( smpBody, i.uv[0] );
	half3 lmap = tex2D( smpLightMap, i.uv[1] );
	return half4( col*lmap, fBlend );
}

technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11a();
		PixelShader = compile ps_1_1 psMain11a();
		AlphaBlendEnable = True;
		ZEnable = False;
		ZWriteEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
	pass PBlur {
		BLUR11_PASS
		AlphaBlendEnable = False;
	}
	pass PLast {
		BLUR_RESTORE
		AlphaBlendEnable = False;
		ZEnable = True;
	}
}

#endif


technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11a();
		PixelShader = NULL;
		AlphaBlendEnable = True;
		ZEnable = False;
		ZWriteEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		TextureFactor = ( float4(1,1,1,fBlend) );

		Sampler[0] = (smpBody);
		Sampler[1] = (smpLightMap);

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = TFactor;
		ColorOp[1] = Modulate;
		ColorArg1[1] = Texture;
		ColorArg2[1] = Current;
		AlphaOp[1] = SelectArg1;
		AlphaArg1[1] = Current;
		ColorOp[2] = Disable;
		AlphaOp[2] = Disable;
	}
	pass PBlur {
		BLURFF_PASS
		AlphaBlendEnable = False;
	}
	pass PLast {
		BLUR_RESTORE
		AlphaBlendEnable = False;
		ZEnable = True;
	}
}

