// Just FFP rendering path, not complete effect.
// See bumped.fx


SPosColor2Tex vsMainFF( SPosNormalTex i ) {
	SPosColor2Tex o;
	o.pos = mul( i.pos, mWVP );
	float3 pos = mul( i.pos, mWorld );
	float3 l = -vLightDir;
	float3 n = normalize( mul( i.normal, (float3x3)mWorld ) );
	float3 v = normalize( vEye - pos );
	float3 h = normalize( l + v );
	float diff, spec;
	gDiffSpec( n, l, h, diff, spec );
	o.color[0].rgb = diff;
	o.color[0].a = gBlurFactor( i.pos, mWorldView );
	o.color[1] = spec;
	o.uv = i.uv;
	return o;
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMainFF();
		PixelShader = NULL;

		Sampler[0] = (smpBase);
		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = Diffuse;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Diffuse;
		ColorOp[1] = Add;
		ColorArg1[1] = Current;
		ColorArg2[1] = Specular;
		AlphaOp[1] = SelectArg1;
		AlphaArg1[1] = Current;
		ColorOp[2] = Disable;
		AlphaOp[2] = Disable;
	}
	pass PLast {
	}
}

