#include "glfunctions.h"

GLFunctions gl;

#if !FINALBUILD
static void APIENTRY GLMessageCallback(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* message, const void* userParam)
{
	if (type != GL_DEBUG_TYPE_ERROR && type != GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR)
		return;
	DebugBreak();
}
void GLCheckError()
{
	int glErrCode = glGetError();
	if (glErrCode != 0)
		DebugBreak();
}
#endif


static const char* kGlFunctionNames[] = {
#define DO_GL_FUNC(prot,member,name) #name,
#include "glfunctionslist.h"
#undef DO_GL_FUNC
};

void GLFunctions::Initialize()
{
	// note, this assumes that this object *only* contains the function pointer members
	PROC* ptrs = (PROC*)this;
	for (int i = 0; i < sizeof(kGlFunctionNames) / sizeof(kGlFunctionNames[0]); ++i)
	{
		*ptrs++ = wglGetProcAddress(kGlFunctionNames[i]);
	}
#if !FINALBUILD
	glEnable(GL_DEBUG_OUTPUT);
	gl.debugMessageCallback(GLMessageCallback, 0);
#endif
}
