/************************************************************************
 *
 *    Copyright (c) 1991 Microsoft Corporation.  All Rights Reserved.
 *
 *-----------------------------------------------------------------------
 *
 *      Module:  wsscanf.h
 *
 *      Author:  baw
 *
 *     Remarks:  header file for wsscanf.c
 *
 *   Revisions:  
 *     01.00.000  2/23/91 baw   Initial version, initial build
 *
 ************************************************************************/

// constant definitions

#define ALLOW_RANGE                        // allow "%[a-z]" - style 
                                           // scansets

#define LEFT_BRACKET  ('[' | ('a' - 'A'))  // 'lowercase' version
//#define LEFT_BRACKET  ('[')  // 'lowercase' version

#define ASCII         32                   // # of bytes needed to 
                                           // hold 256 bits

// macro definitions

#define INC()            (++nCharCount, Inc( (char *) &lpPtrBuffer ))
#define UN_INC( chr )    (--nCharCount, UnInc( chr, (char *) &lpPtrBuffer ))
#define EAT_WHITE()      WhiteOut( (int *) &nCharCount, (char *) &lpPtrBuffer )
#define HEXTODEC( chr )  HexToDec( chr )

#define MUL10(x)         ( (((x)<<2) + (x))<<1 )

// function definitions

#ifdef	__cplusplus
extern "C" {
#endif

//int wsscanf( char *, char *, char *, ... ) ;
int wsscanf( char *, char *, void *, ... ) ;
char HexToDec( char ) ;
char Inc( char ** ) ;
void UnInc( char, char ** ) ;
char WhiteOut( int *, char ** ) ;

#ifdef	__cplusplus
}
#endif

/************************************************************************
 * End of File: wsscanf.h
 ************************************************************************/
