
#include <sys/types.h>
#include <sys/file.h>
#include <libpress.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libspu.h>
#include <libgs.h>
#include <libsn.h>
#include <libcd.h>
#include <kernel.h>
#include <stdarg.h>
#include <libmath.h>

#include "asm.h"

#define	SCREEN_WIDTH	256
#define	SCREEN_HEIGHT	256
#define	SCREEN_Z		(SCREEN_WIDTH+SCREEN_HEIGHT)/2
#define	OT_SIZE			256
#define	POLYS			4000

/*****************************/

void warp( int fx );
void DrawQuad( int a, int b, int c, int d, int fx );
void plasma( int fx );
void pic( int fx );
void select_mode( void );

	typedef	struct
	{
		DISPENV		disp;
		DRAWENV 	draw;
		POLY_FT4	ft4[POLYS];
		POLY_G4		g4[POLYS];

		DR_ENV		env;
		DR_MOVE		mov;
		u_long		ot[OT_SIZE];

	}	DB;

	DRAWENV		tempdraw[2];

	DB			db[2],*cdb;
	POLY_FT4	*ft4_ptr;
	POLY_G4		*g4_ptr;

	long	padd;
	RECT	rect;

	MATRIX	m;
	SVECTOR	ang;
	VECTOR	pos;
	long	p;
	long	flag;
	CVECTOR	cluts[256];
	CVECTOR	clutsp[256];

	int		vmode;


void main( void )
{
	int		i;
	int		vbcount;
	char	*char_ptr;
	short	*short_ptr;

	select_mode();

	ResetGraph(0);
	SetGraphDebug(0);
	SetVideoMode(vmode);
	InitGeom();


	ClearOTag( db[0].ot, OT_SIZE);
	ClearOTag( db[1].ot, OT_SIZE);

	for(i=0;i<POLYS;i++)
	{
		SetPolyFT4(&db[0].ft4[i]);
		SetPolyFT4(&db[1].ft4[i]);
		SetPolyG4(&db[0].g4[i]);
		SetPolyG4(&db[1].g4[i]);
	}

	// setup drawing/display enviroment

	rect.x = 0;
	rect.y = 0;
	rect.w = 1024;
	rect.h = 512;
	ClearImage(&rect,0,0,0);

	SetDefDrawEnv(&db[0].draw, 0, 0,   256, 256);
	SetDefDispEnv(&db[0].disp, 0, 256, 256, 256);
	SetDefDrawEnv(&db[1].draw, 0, 256, 256, 256);
	SetDefDispEnv(&db[1].disp, 0, 0,   256, 256);

	SetDefDrawEnv(&tempdraw[0], 256, 0,   256, 256);
	SetDefDrawEnv(&tempdraw[1], 256, 256, 256, 256);

	db[1].disp.screen.x = db[0].disp.screen.x = 5;  
	db[1].disp.screen.y = db[0].disp.screen.y = 15;
	db[1].disp.screen.h = db[0].disp.screen.h = 256;

	tempdraw[0].isbg	=	tempdraw[1].isbg	= 1;	db[0].draw.isbg 	= db[1].draw.isbg     = 1;
	tempdraw[0].dtd		=	tempdraw[1].dtd		= 1;	db[0].draw.dtd 		= db[1].draw.dtd	  = 1;
	db[0].draw.r0	 	= 	db[1].draw.r0   = 0;
	db[0].draw.g0	 	=	db[1].draw.g0   = 0;
	db[0].draw.b0	 	= 	db[1].draw.b0   = 0;

	tempdraw[0].r0		=	tempdraw[1].r0	=	
	tempdraw[0].g0		=	tempdraw[1].g0	=	
	tempdraw[0].b0		=	tempdraw[1].b0	= 0;

	rect.x = 256;
	rect.y = 0;
	rect.w = 256;
	rect.h = 256;
	SetDrawMove(&db[0].mov,&rect,0,0);
	rect.x = 256;
	rect.y = 256;
	rect.w = 256;
	rect.h = 256;
	SetDrawMove(&db[1].mov,&rect,0,256);

	SetGeomOffset(SCREEN_WIDTH/2, SCREEN_HEIGHT/2);
	SetGeomScreen( SCREEN_Z );

	for(i=0;i<256;i++)
	{
		cluts[i].r = clut[i*3];
		cluts[i].g = clut[(i*3)+1];
		cluts[i].b = clut[(i*3)+2];
	}

	char_ptr  = (char*)logop;
	short_ptr = (short*)logop;
	for(i=0;i<256;i++)
	{
		*(short_ptr+i) = ((*(char_ptr+(i*3)+2)>>3)<<10) | ((*(char_ptr+(i*3)+1)>>3)<<5) | ((*(char_ptr+(i*3))>>3));
		if(*(short_ptr+i))	*(short_ptr+i) |= 0x8000;
	}
	rect.x = 512;
	rect.y = 256;
	rect.w = 256;
	rect.h = 1;
	LoadImage(&rect,(u_long*)&logop);
	rect.x = 512;
	rect.y = 0;
	rect.w = 256/2;
	rect.h = 256;
	LoadImage(&rect,(u_long*)&logo);


	// init font for scroller

	for(i=0;i<40960>>1;i++)
	{
		cdnfnt[i] = cdnfnt[(i<<1)] | (cdnfnt[(i<<1)+1]<<4) ;
	}
	rect.x = 640;
	rect.y = 0;
	rect.w = 320/4;
	rect.h = 128;
	LoadImage(&rect,&cdnfnt);

	rect.x = 768;
	rect.y = 256;
	rect.w = 256/2;
	rect.h = 100;
	LoadImage(&rect,&logo2);

	char_ptr  = (char*)logo2p;
	short_ptr = (short*)logo2p;
	for(i=0;i<256;i++)
	{
		*(short_ptr+i) = ((*(char_ptr+(i*3)+2)>>3)<<10) | ((*(char_ptr+(i*3)+1)>>3)<<5) | ((*(char_ptr+(i*3))>>3));
		*(short_ptr+i) |= 0x8000;
	}
	rect.x = 512;
	rect.y = 257;
	rect.w = 256;
	rect.h = 1;
	LoadImage(&rect,(u_long*)&logo2p);
	/////////


	char_ptr = (char*)&cdnpal;
	short_ptr = (short*)&cdnpal;
	for(i=0;i<256;i++)
	{
		*(short_ptr+i) = ((*(char_ptr+(i*3)+2)>>3)<<10) | ((*(char_ptr+(i*3)+1)>>3)<<5) | (*(char_ptr+(i*3)+0)>>3) ;
		if(*(short_ptr+i))	*(short_ptr+i) |= 0x8000;
	}
	rect.x = 640;
	rect.y = 510;
	rect.w = 256;
	rect.h = 1;
	LoadImage(&rect,&cdnpal);



	char_ptr  = (char*)title;
	short_ptr = (short*)title;
	for(i=0;i<256*256;i++)
	{
		*(short_ptr+i) = ((*(char_ptr+(i*3)+2)>>3)<<10) | ((*(char_ptr+(i*3)+1)>>3)<<5) | ((*(char_ptr+(i*3))>>3));
		*(short_ptr+i) |= 0x8000;
	}
	rect.x = 768;
	rect.y = 0;
	rect.w = 256;
	rect.h = 256;
	LoadImage(&rect,(u_long*)&title);




	char_ptr  = (char*)bd;
	short_ptr = (short*)bd;
	for(i=0;i<32*64;i++)
	{
		*(short_ptr+i) = ((*(char_ptr+(i*3)+2)>>3)<<10) | ((*(char_ptr+(i*3)+1)>>3)<<5) | ((*(char_ptr+(i*3))>>3));
		*(short_ptr+i) |= 0x8000;
	}
	rect.x = 256;
	rect.y = 0;
	rect.w = 32;
	rect.h = 64;
	LoadImage(&rect,(u_long*)&bd);

	char_ptr  = (char*)bdp;
	short_ptr = (short*)bdp;
	for(i=0;i<256;i++)
	{
		*(short_ptr+i) = ((*(char_ptr+(i*3)+2)>>3)<<10) | ((*(char_ptr+(i*3)+1)>>3)<<5) | ((*(char_ptr+(i*3))>>3));
		*(short_ptr+i) |= 0x8000;
	}
	rect.x = 256;
	rect.y = 64;
	rect.w = 256;
	rect.h = 1;
	LoadImage(&rect,(u_long*)&bdp);



/***************************************************/
	for(;;)
	{
		pic(1);
		pic(0);
		plasma(0);
		warp(1);
		plasma(1);
		warp(0);
	}
}


///////////////////////
//
//
//
//
//
///////////////////////

DVECTOR	points2d[8];
SVECTOR	points3d[8]={
						{	-1000, -1000, -1000	},
						{	 1000, -1000, -1000	},
						{	-1000,  1000, -1000	},
						{	 1000,  1000, -1000	},
						{	-1000, -1000,  1000	},
						{	 1000, -1000,  1000	},
						{	-1000,  1000,  1000	},
						{	 1000,  1000,  1000	}
					};

SVECTOR	points3d2[8]={
						{	-2000, -2000, -2000	},
						{	 2000, -2000, -2000	},
						{	-2000,  2000, -2000	},
						{	 2000,  2000, -2000	},
						{	-4000, -2000,  2000	},
						{	 2000, -2000,  2000	},
						{	-2000,  2000,  2000	},
						{	 2000,  2000,  2000	}
					};

int		cnt;


int		AMB=256;


char	txt[]={	
				"                  "
				"NAPALM PROUDLY PRESENT         BITS AND PIECEEZ          "
				"CODE   NIK        "
				"GFX   DANZIG      "
				"MUSIC   BOSCO     "
				"RELEASED AT    DE JA VU NINETY EIGHT       "
				"CODED IN TWO DAYZ     AND VIEWING THE CODE     YOU CAN TELL               "
				"AND NOW     "
				"GROUP GREETS      "
				"HITMEN   TESKO   BLACKBAG   TRSI   CODEWORKS   FAB FOUR       "
				"PERSONAL GREETS      "
				"BAROG   DANZIG   JACKRIPPER   ICEPIC   GABKNIGHT   CURLIN   JIHAD   BUFFERMAN   FRENZY   "
				"MAJICMUSHROOM   TENSHU   SPANSH   VIM   NAGRA   SILPHEED   STDGUTS   CHEMICAL   ASHH   "
				"MOONSHADOW   RASKY   MADMAN   ANTILOOP   ANDREW AND JIM OF CODEWORKS   "
				"VAMPIRE   AND EVERYONE I HAVE FORGOTTEN         RESTART INTRO PLEASE  "
				"            ^       "
				"                    "
			  };


int		type=0;
int		count=0;
int		fdir=0;

int		timer;

void	warp( int fx )
{
	int		i;
	int		intens=0, dir=0;
	int		vbcount,x,ch,u,v,code,sc,xscroll;

	pos.vz = 7000;

	cdb = &db[0];
	timer=0;
	intens=0;
	cnt=0;
	count=0;
	vbcount=0;
	xscroll=0;
	sc=0;

	if(fx)
	{
		tempdraw[0].dtd		=	tempdraw[1].dtd		= 1;	db[0].draw.dtd 		= db[1].draw.dtd	  = 1;
	}
	else
	{
		tempdraw[0].dtd		=	tempdraw[1].dtd		= 0;	db[0].draw.dtd 		= db[1].draw.dtd	  = 0;
	}


	SetDrawEnv(&db[0].env,&tempdraw[0]);
	SetDrawEnv(&db[1].env,&tempdraw[1]);


	SetDispMask(1);
	while(1)
	{
		cdb  = (cdb==db)? db+1: db;	
		ClearOTag( cdb->ot, OT_SIZE);

		padd = PadRead(1);

		g4_ptr = &cdb->g4[0];
		ft4_ptr  = &cdb->ft4[0];

		RotMatrix(&ang,&m);
		TransMatrix(&m,&pos);
		SetRotMatrix(&m);
		SetTransMatrix(&m);

		RotTransPers4(&points3d[0],&points3d[1],&points3d[2],&points3d[3],(long*)&points2d[0],(long*)&points2d[1],(long*)&points2d[2],(long*)&points2d[3],&p,&flag);
		RotTransPers4(&points3d[4],&points3d[5],&points3d[6],&points3d[7],(long*)&points2d[4],(long*)&points2d[5],(long*)&points2d[6],(long*)&points2d[7],&p,&flag);
		
		///////////////////////////////////////////////////

		DrawQuad(0,1,2,3,fx);
		if(fx)
		{
			DrawQuad(4,5,0,1,fx);
			DrawQuad(5,4,7,6,fx);
			DrawQuad(2,3,6,7,fx);
			DrawQuad(1,5,3,7,fx);
			DrawQuad(4,0,6,2,fx);
		}

		setXYWH(ft4_ptr,-6,-6,256+10,256+10);
		setUVWH(ft4_ptr,0,0,255,255);
		if(fx)
		{
			i = (intens>>1) - AMB;
		}
		else
		{
			i = 128 - AMB;
		}
		if(i<0)	i=0;
		setRGB0(ft4_ptr,i,i,i);
		ft4_ptr->tpage = GetTPage(2,1,256,((cnt)&1)<<8);
		AddPrim(cdb->ot+1,ft4_ptr++);
		AddPrim(cdb->ot+1,&cdb->env);


		
		if(!dir)
		{
			intens+=2;
			if(intens>260)
			{
				dir++;
				dir&=1;
			}
		}
		else
		{
			intens-=2;
			if(intens<128)
			{
				dir++;
				dir&=1;
			}
		}
		///////////////////////////////////////////////////

		if(fx)
		{
			setXYWH(ft4_ptr,0,78,256,100);
			setUVWH(ft4_ptr,0,0,255,99);
			ft4_ptr->clut = GetClut(512,257);
			SetSemiTrans(ft4_ptr,1);
			i = count - AMB;
			if(i<0) i=0;
			setRGB0(ft4_ptr,i,i,i);

			if(!fdir)
			{
				count++;
				if(count>128)
				{
					fdir++;
					fdir&=1;
				}
			}
			else
			{
				count--;
				if(count<1)
				{
					fdir++;
					fdir&=1;
					type++;
					type&=1;
				}
			}
			if(!type)	ft4_ptr->tpage = GetTPage(1,1,768,256);
			else		ft4_ptr->tpage = GetTPage(1,2,768,256);
			AddPrim(cdb->ot, ft4_ptr++);
		}
		AddPrim(cdb->ot, &cdb->mov);

		if(fx)
		{
			ang.vz += 16;
			ang.vx += 17;
			ang.vy += 12;
			pos.vx = rcos(cnt<<4)>>2;
			pos.vy = (-rsin((cnt<<5)&2047)>>1)+1000;
		}
		else
		{
			ang.vz += 32;
			ang.vx = 0;
			ang.vy = 0;
			pos.vx = 0;
			pos.vy = 0;
		}



		xscroll++;
		xscroll&=15;
		if(xscroll==0)
				sc++;

		if(!fx)
		{
			i = 0;
			x = 0;
			for(;;)
			{
				ch = txt[sc + i++];
				if(!ch)
				{
						sc=0;
						break;
				}
				if(ch == '^')
				{
					timer=3000;
					continue;
				}

				if(ch != ' ')
				{
					ch -= 'A';
					u = (ch % 10)<<5;
					v = (ch / 10)<<5;

					ft4_ptr->x0 = (x-xscroll);
					ft4_ptr->y0 = (-(rsin(((vbcount+x+(sc<<4))<<4))>>6))+100;
					ft4_ptr->x1 = (x+16-xscroll);
					ft4_ptr->y1 = (-(rsin(((vbcount+x+16+(sc<<4))<<4))>>6))+100;
					ft4_ptr->x2 = (x-xscroll);
					ft4_ptr->y2 = (-(rsin(((vbcount+x+(sc<<4))<<4))>>6))+100+16;
					ft4_ptr->x3 = (x+16-xscroll);
					ft4_ptr->y3 = (-(rsin(((vbcount+x+16+(sc<<4))<<4))>>6))+100+16;

					ft4_ptr->u0 = u;
					ft4_ptr->v0 = v;
					ft4_ptr->u1 = u+32-1;
					ft4_ptr->v1 = v+0;
					ft4_ptr->u2 = u;
					ft4_ptr->v2 = v+32-1;
					ft4_ptr->u3 = u+32-1;
					ft4_ptr->v3 = v+32-1;

					code=ft4_ptr->code;
					*((long*)&ft4_ptr->r0) = *((long*)&cluts[(vbcount+i)&255]);
					ft4_ptr->code = code;
					ft4_ptr->tpage = GetTPage(0,3,640+((u&0xff00)>>2),0);
					ft4_ptr->clut = GetClut(640,510);
					SetSemiTrans(ft4_ptr,1);
					AddPrim(cdb->ot+1, ft4_ptr++);
				}
				x += 16;
				if(i>16)	break;
			}
		}



		if(AMB>0   && timer==0)		AMB-=2;
		if(fx)
		{
			if(AMB<256 && timer>2360)	AMB+=2;
		}
		else
		{
			if(AMB<260 && timer>2360)	AMB+=2;
		}

		if(fx)
		{
			if(AMB==0)	timer++;
		}

		vbcount++;
		cnt++;

		DrawSync(0);
		VSync(0);
		PutDrawEnv(&cdb->draw);
		PutDispEnv(&cdb->disp);
		DrawOTag( cdb->ot );

		if(fx)
		{
			if(timer>360 && AMB==256)	break;
		}
		else
		{
			if(timer>2360 && AMB==256)	break;
		}

	}
}



void DrawQuad( int a, int b, int c, int d, int fx )
{
	int	nrm;
	int	col;
	int	i;

	nrm = NormalClip(*((long*)&points2d[a]),*((long*)&points2d[b]),*((long*)&points2d[c]));
	
	if(nrm>0)
	{
		*((u_long*)&g4_ptr->x0) = *((u_long*)&points2d[a]);
		*((u_long*)&g4_ptr->x1) = *((u_long*)&points2d[b]);
		*((u_long*)&g4_ptr->x2) = *((u_long*)&points2d[c]);
		*((u_long*)&g4_ptr->x3) = *((u_long*)&points2d[d]);

		i = (cluts[(cnt   )&255].r * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->r0 = i;
		i = (cluts[(cnt   )&255].g * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->g0 = i;
		i = (cluts[(cnt   )&255].b * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->b0 = i;
		i = (cluts[(cnt+32)&255].r * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->r1 = i;
		i = (cluts[(cnt+32)&255].g * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->g1 = i;
		i = (cluts[(cnt+32)&255].b * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->b1 = i;
		i = (cluts[(cnt+64)&255].r * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->r2 = i;
		i = (cluts[(cnt+64)&255].g * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->g2 = i;
		i = (cluts[(cnt+64)&255].b * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->b2 = i;
		i = (cluts[(cnt+96)&255].r * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->r3 = i;
		i = (cluts[(cnt+96)&255].g * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->g3 = i;
		i = (cluts[(cnt+96)&255].b * (nrm>>5) / 256)-AMB;
		if(i<0)	i=0;
		g4_ptr->b3 = i;
		if(fx)
		{
				SetSemiTrans(g4_ptr,1);
		}
		else
		{
				SetSemiTrans(g4_ptr,0);
		}
		AddPrim(cdb->ot+1,g4_ptr++);
	}
}


///////////////////////
//
//
//
//
//
///////////////////////

void	plasma( int fx )
{
	int		i;
	int		x, y;

	int		xoffs[4];
	int		yoffs[4];

	int		c1,c2,c3,c4;
	int		o1,o2,o3,o4;

	for(i=0;i<256;i++)
	{
		clutsp[i].cd = db[0].g4[0].code;
	}

	g4_ptr = &db[0].g4[0];
		for(y=0;y<256;y+=8)
			for(x=0;x<256;x+=8)
			{
				g4_ptr->x0 = x;
				g4_ptr->y0 = y;
				g4_ptr->x1 = x+8;
				g4_ptr->y1 = y;
				g4_ptr->x2 = x;
				g4_ptr->y2 = y+8;
				g4_ptr->x3 = x+8;
				g4_ptr->y3 = y+8;
				g4_ptr++;
			 }
	g4_ptr = &db[1].g4[0];
		for(y=0;y<256;y+=8)
			for(x=0;x<256;x+=8)
			{
				g4_ptr->x0 = x;
				g4_ptr->y0 = y;
				g4_ptr->x1 = x+8;
				g4_ptr->y1 = y;
				g4_ptr->x2 = x;
				g4_ptr->y2 = y+8;
				g4_ptr->x3 = x+8;
				g4_ptr->y3 = y+8;
				g4_ptr++;
			}

	pos.vz = 7000;

	tempdraw[0].dtd		=	tempdraw[1].dtd		= 1;	db[0].draw.dtd 		= db[1].draw.dtd	  = 1;
	cdb = &db[0];
	timer = 0;
	SetDispMask(1);
	while(1)
	{
		cdb  = (cdb==db)? db+1: db;	
		ClearOTag( cdb->ot, OT_SIZE);

		padd = PadRead(1);

		g4_ptr = &cdb->g4[0];
		ft4_ptr  = &cdb->ft4[0];

		RotMatrix(&ang,&m);
		TransMatrix(&m,&pos);
		SetRotMatrix(&m);
		SetTransMatrix(&m);



		setXYWH(ft4_ptr,0,0,256,256);
		setUVWH(ft4_ptr,0,0,255,255);
		ft4_ptr->clut = GetClut(512,256);
		SetSemiTrans(ft4_ptr,1);
		i = 128 - AMB;
		if(i<0) i=0;
		setRGB0(ft4_ptr,i,i,i);
		ft4_ptr->tpage = GetTPage(1,1,512,0);
		AddPrim(cdb->ot, ft4_ptr++);


	

		if(fx)
		{
			for(i=0; i<64; i++)
			{
				x = (i<<2) - AMB;
				if(x<0)	x=0;
				clutsp[i].r     = x;

				clutsp[i].g     = 0;
				clutsp[i].b     = 0;
			}
			for(i=0; i<64; i++)
			{
				x = ((63-i)<<2) - AMB;
				if(x<0)	x=0;
				clutsp[i+64].r = x;
				
				clutsp[i+64].g = 0;
				
				x = (i<<2) - AMB;
				if(x<0)	x=0;
				clutsp[i+64].b = x;
			}
			for(i=0; i<64; i++)
			{
				clutsp[i+128].r = 0;

				x = (i<<2) - AMB;
				if(x<0)	x=0;
				clutsp[i+128].g = x;

				x = ((63-i)<<2) - AMB;
				if(x<0)	x=0;
				clutsp[i+128].b = x;
			}
			for(i=0; i<64; i++)
			{
				clutsp[i+192].r = 0;

				x = ((63-i)<<2) - AMB;
				if(x<0)	x=0;
				clutsp[i+192].g = x ;

				clutsp[i+192].b = 0;
			}
		}
		else
		{
			for(i=0; i<256; i++)
			{
				x = cluts[i].r - AMB;
				if(x<0)	x=0;
				clutsp[i].r     = x;
				x = cluts[i].g - AMB;
				if(x<0)	x=0;
				clutsp[i].g     = x;
				x = cluts[i].b - AMB;
				if(x<0)	x=0;
				clutsp[i].b     = x;

			}
		}

		///////////////////////////////////////////////////
	
		xoffs[0] = rcos(cnt<<1)>>2;
		xoffs[1] = rsin(cnt+180<<1)>>1;
		xoffs[2] = rsin(cnt+65<<2)>>3;

		yoffs[0] = rsin(cnt<<1)>>2;
		yoffs[1] = rsin(cnt+180<<1)>>1;
		yoffs[2] = rcos(cnt+65<<2)>>3;

		for(y=0;y<256;y+=8)
			for(x=0;x<256;x+=8)
			{
				o1 = ((xoffs[0]+x)+((yoffs[0]+y)<<9));
				o2 = ((xoffs[1]+x)+((yoffs[1]+y)<<9));
				o3 = ((xoffs[2]+x)+((yoffs[2]+y)<<9));

				c1 = plasdat[o1 & 0x3ffff];
				c1+= plasdat[o2 & 0x3ffff];
				c1+= plasdat[o3 & 0x3ffff];

				c2 = plasdat[o1 + 8 & 0x3ffff];
				c2+= plasdat[o2 + 8 & 0x3ffff];
				c2+= plasdat[o3 + 8 & 0x3ffff];

				c3 = plasdat[o1 + (8<<9) & 0x3ffff];
				c3+= plasdat[o2 + (8<<9) & 0x3ffff];
				c3+= plasdat[o3 + (8<<9) & 0x3ffff];

				c4 = plasdat[o1 + 8 + (8<<9) & 0x3ffff];
				c4+= plasdat[o2 + 8 + (8<<9) & 0x3ffff];
				c4+= plasdat[o3 + 8 + (8<<9) & 0x3ffff];

				*((u_long*)&g4_ptr->r0) = *((u_long*)&clutsp[c1]);
				*((u_long*)&g4_ptr->r1) = *((u_long*)&clutsp[c2]);
				*((u_long*)&g4_ptr->r2) = *((u_long*)&clutsp[c3]);
				*((u_long*)&g4_ptr->r3) = *((u_long*)&clutsp[c4]);

				AddPrim(cdb->ot, g4_ptr++);
			}

		if(AMB>0   && timer==0)		AMB-=2;
		if(AMB<256 && timer>360)	AMB+=2;
		if(AMB==0)	timer++;

		cnt++;
		DrawSync(0);
		VSync(0);
		PutDrawEnv(&cdb->draw);
		PutDispEnv(&cdb->disp);
		DrawOTag( cdb->ot );

		if(timer>360 && AMB==256)	break;

	}
}



///////////////////////
//
//
//
//
//
///////////////////////

void	pic( int fx )
{
	int		i;

	tempdraw[0].dtd		=	tempdraw[1].dtd		= 1;	db[0].draw.dtd 		= db[1].draw.dtd	  = 1;
	cdb = &db[0];
	timer = 0;

	SetDispMask(1);
	while(1)
	{
		cdb  = (cdb==db)? db+1: db;	
		ClearOTag( cdb->ot, OT_SIZE);

		padd = PadRead(1);

		g4_ptr = &cdb->g4[0];
		ft4_ptr  = &cdb->ft4[0];

		RotMatrix(&ang,&m);
		TransMatrix(&m,&pos);
		SetRotMatrix(&m);
		SetTransMatrix(&m);


		setXYWH(ft4_ptr,0,0,256,256);
		setUVWH(ft4_ptr,0,0,255,255);
		ft4_ptr->clut = GetClut(512,256);
		SetSemiTrans(ft4_ptr,1);
		i = 128 - AMB;
		if(i<0) i=0;
		setRGB0(ft4_ptr,i,i,i);
		if(fx)
		{
			ft4_ptr->tpage = GetTPage(1,1,512,0);
		}
		else
		{
			ft4_ptr->tpage = GetTPage(2,1,768,0);
		}
		AddPrim(cdb->ot, ft4_ptr++);


		if(AMB>0   && timer==0)		AMB-=2;
		if(AMB<256 && timer>160)	AMB+=2;
		if(AMB==0)	timer++;

		cnt++;
		DrawSync(0);
		VSync(0);
		PutDrawEnv(&cdb->draw);
		PutDispEnv(&cdb->disp);
		DrawOTag( cdb->ot );

		if(timer>160 && AMB==256)	break;

	}
}

///////////////////////
//
//
//
//
//
///////////////////////

void	select_mode( void )
{
	int		i;
	int		x, y;

	ResetGraph(0);
	SetGraphDebug(0);
	SetVideoMode(MODE_NTSC);
	PadInit(0);

	SetDefDrawEnv(&db[0].draw, 0, 0,   512, 256);
	SetDefDispEnv(&db[0].disp, 0, 256, 512, 256);
	SetDefDrawEnv(&db[1].draw, 0, 256, 512, 256);
	SetDefDispEnv(&db[1].disp, 0, 0,   512, 256);
	db[1].disp.screen.x = db[0].disp.screen.x = 5;  
	db[1].disp.screen.y = db[0].disp.screen.y = 15;
	db[0].draw.r0	 	= db[1].draw.r0   = 0;
	db[0].draw.g0	 	= db[1].draw.g0   = 0;
	db[0].draw.b0	 	= db[1].draw.b0   = 0;
	db[0].draw.isbg 	= db[1].draw.isbg = 1;

	FntLoad(640, 256);
	SetDumpFnt(FntOpen(16,0, 512, 240, 0, 1024));

	SetDispMask(1);
	while(1)
	{
		cdb  = (cdb==db)? db+1: db;	
		ClearOTag( cdb->ot, OT_SIZE);

		padd = PadRead(1);


		FntPrint("\n\n");
		FntPrint("PROGRAM  :  BITS AND PIECEEZ\n\n");
		FntPrint("CODE     :  N!K/NAPALM\n");
		FntPrint("GFX      :  DANZIG/NAPALM\n");
		FntPrint("MODPLAYER:  DANZIG/NAPALM\n");
		FntPrint("MUSIC    :  BOSCO\n\n");
		FntPrint("WRITTEN IN 2 DAYZ FOR THE DE JA VU UK PARTY.. 30-08-98\n\n\n");
		FntPrint("X - PAL\n");
		FntPrint("O - NTSC\n");

		FntFlush(-1);

		if(padd&PADRdown)
		{
			vmode = MODE_PAL;
			break;
		}
		if(padd&PADRright)
		{
			vmode = MODE_NTSC;
			break;
		}


		DrawSync(0);
		VSync(0);
		PutDrawEnv(&cdb->draw);
		PutDispEnv(&cdb->disp);
	}
	SetDispMask(1);
}
