#include <tamtypes.h>
#include <defines.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <kernel.h>

#include "vu0.h"
#include "sincos.h"


//
// coords-system:
//
//      +y
//      |   -z
//      |  /
//-x_ _ |/_ _+x
//     /|
//   /  |
// +z   |
//      -y
//



void vu0_setup_gcc(VU0_TRNSFRM_TABLE *tt)
{
  asm __volatile__("

                # load/convert scale and translate vectors
                lqc2        vf24, 0x10(%0)
                lqc2        vf25,  0x20(%0)
                vitof4.xyz  vf24, vf24
                vitof15.xyz vf25,  vf25

                # load +sin/-sin/+cos/-cos vector for theta and phi
                la          $8,  sincos_f32
                lhu         $9,  0x00(%0)
                lhu         $10, 0x04(%0)
                lhu         $11, 0x08(%0)
                andi        $9,  1023
                andi        $10, 1023
                andi        $11, 1023
                sll         $9,  4
                sll         $10, 4
                sll         $11, 4
                add         $9,  $8
                add         $10, $8
                add         $11, $8
                lqc2        vf26, 0($9)
                lqc2        vf27,  0($10)
                lqc2        vf28, 0($11)


                # ***************************************************
                # init global transformation matrix (GTM: vf10..vf13)
                # and normal trafo matrix (NTM: vf14..vf17)
                # usage of temporary matrix (TMP: vf20..vf23)
                # ***************************************************

                # --- Translation Matrix -> GTM ---
                vmove.xyz   vf13, vf24                  # set translation values
                vmr32.xyzw  vf12, vf0                   # Unity Matrix
                vmr32.xyzw  vf11, vf12
                vmr32.xyzw  vf10, vf11
                vmove.w     vf13, vf0                   # set to 1

                # --- Rx Rotating Matrix -> NTM ---
                vmove.xyzw  vf17, vf0                   # Unity Matrix
                vmr32.xyzw  vf16, vf0
                vmr32.xyzw  vf15, vf16
                vmr32.xyzw  vf14, vf15

                vaddz.y     vf15, vf0, vf26             # z= +cos
                vaddx.z     vf15, vf0, vf26             # x= +sin
                vmove.y     vf16, vf26                  # y= -sin
                vmove.z     vf16, vf26                  # z= +cos

                # multiply GTM*NTM -> GTM
                    vmulax.xyzw  ACC, vf14, vf10
                    vmadday.xyzw ACC, vf15, vf10
                    vmaddaz.xyzw ACC, vf16, vf10
                    vmaddw.xyzw  vf10, vf17, vf10

                    vmulax.xyzw  ACC, vf14, vf11
                    vmadday.xyzw ACC, vf15, vf11
                    vmaddaz.xyzw ACC, vf16, vf11
                    vmaddw.xyzw  vf11, vf17, vf11

                    vmulax.xyzw  ACC, vf14, vf12
                    vmadday.xyzw ACC, vf15, vf12
                    vmaddaz.xyzw ACC, vf16, vf12
                    vmaddw.xyzw  vf12, vf17, vf12

                    vmulax.xyzw  ACC, vf14, vf13
                    vmadday.xyzw ACC, vf15, vf13
                    vmaddaz.xyzw ACC, vf16, vf13
                    vmaddw.xyzw  vf13, vf17, vf13


                # --- Ry Rotating Matrix -> TMP ---
                vmove.xyzw  vf23, vf0                   # Unity Matrix
                vmr32.xyzw  vf22, vf0
                vmr32.xyzw  vf21, vf22
                vmr32.xyzw  vf20, vf21

                vaddz.x     vf20, vf0, vf27             # z= +cos
                vaddy.z     vf20, vf0, vf27             # y= -sin
                vmove.x     vf22, vf27                  # x= +sin
                vaddz.z     vf22, vf0, vf27             # z= +cos

                # multiply GTM*TMP -> GTM
                    vmulax.xyzw  ACC, vf20, vf10
                    vmadday.xyzw ACC, vf21, vf10
                    vmaddaz.xyzw ACC, vf22, vf10
                    vmaddw.xyzw  vf10, vf23, vf10

                    vmulax.xyzw  ACC, vf20, vf11
                    vmadday.xyzw ACC, vf21, vf11
                    vmaddaz.xyzw ACC, vf22, vf11
                    vmaddw.xyzw  vf11, vf23, vf11

                    vmulax.xyzw  ACC, vf20, vf12
                    vmadday.xyzw ACC, vf21, vf12
                    vmaddaz.xyzw ACC, vf22, vf12
                    vmaddw.xyzw  vf12, vf23, vf12

                    vmulax.xyzw  ACC, vf20, vf13
                    vmadday.xyzw ACC, vf21, vf13
                    vmaddaz.xyzw ACC, vf22, vf13
                    vmaddw.xyzw  vf13, vf23, vf13

                # multiply NTM*TMP -> NTM
                    vmulax.xyzw  ACC, vf20, vf14
                    vmadday.xyzw ACC, vf21, vf14
                    vmaddaz.xyzw ACC, vf22, vf14
                    vmaddw.xyzw  vf14, vf23, vf14

                    vmulax.xyzw  ACC, vf20, vf15
                    vmadday.xyzw ACC, vf21, vf15
                    vmaddaz.xyzw ACC, vf22, vf15
                    vmaddw.xyzw  vf15, vf23, vf15

                    vmulax.xyzw  ACC, vf20, vf16
                    vmadday.xyzw ACC, vf21, vf16
                    vmaddaz.xyzw ACC, vf22, vf16
                    vmaddw.xyzw  vf16, vf23, vf16

                    vmulax.xyzw  ACC, vf20, vf17
                    vmadday.xyzw ACC, vf21, vf17
                    vmaddaz.xyzw ACC, vf22, vf17
                    vmaddw.xyzw  vf17, vf23, vf17


                # --- Rz Rotating Matrix -> TMP ---
                vmove.xyzw  vf23, vf0                   # Unity Matrix
                vmr32.xyzw  vf22, vf0
                vmr32.xyzw  vf21, vf22
                vmr32.xyzw  vf20, vf21

                vaddz.x     vf20, vf0, vf28             # z= +cos
                vaddx.y     vf20, vf0, vf28             # x= +sin
                vaddy.x     vf21, vf0, vf28             # y= -sin
                vaddz.y     vf21, vf0, vf28             # z= +cos

                # multiply GTM*TMP -> GTM
                    vmulax.xyzw  ACC, vf20, vf10
                    vmadday.xyzw ACC, vf21, vf10
                    vmaddaz.xyzw ACC, vf22, vf10
                    vmaddw.xyzw  vf10, vf23, vf10

                    vmulax.xyzw  ACC, vf20, vf11
                    vmadday.xyzw ACC, vf21, vf11
                    vmaddaz.xyzw ACC, vf22, vf11
                    vmaddw.xyzw  vf11, vf23, vf11

                    vmulax.xyzw  ACC, vf20, vf12
                    vmadday.xyzw ACC, vf21, vf12
                    vmaddaz.xyzw ACC, vf22, vf12
                    vmaddw.xyzw  vf12, vf23, vf12

                    vmulax.xyzw  ACC, vf20, vf13
                    vmadday.xyzw ACC, vf21, vf13
                    vmaddaz.xyzw ACC, vf22, vf13
                    vmaddw.xyzw  vf13, vf23, vf13

                # multiply NTM*TMP -> NTM
                    vmulax.xyzw  ACC, vf20, vf14
                    vmadday.xyzw ACC, vf21, vf14
                    vmaddaz.xyzw ACC, vf22, vf14
                    vmaddw.xyzw  vf14, vf23, vf14

                    vmulax.xyzw  ACC, vf20, vf15
                    vmadday.xyzw ACC, vf21, vf15
                    vmaddaz.xyzw ACC, vf22, vf15
                    vmaddw.xyzw  vf15, vf23, vf15

                    vmulax.xyzw  ACC, vf20, vf16
                    vmadday.xyzw ACC, vf21, vf16
                    vmaddaz.xyzw ACC, vf22, vf16
                    vmaddw.xyzw  vf16, vf23, vf16

                    vmulax.xyzw  ACC, vf20, vf17
                    vmadday.xyzw ACC, vf21, vf17
                    vmaddaz.xyzw ACC, vf22, vf17
                    vmaddw.xyzw  vf17, vf23, vf17


                # --- Scale Matrix -> TMP ---
                vmove.xyzw  vf23, vf0                  # Unity Matrix
                vmr32.xyzw  vf22, vf0
                vmr32.xyzw  vf21, vf22
                vmr32.xyzw  vf20, vf21

                vmove.z     vf22, vf25                 # get scale vector
                vmove.y     vf21, vf25
                vmove.x     vf20, vf25

                # multiply GTM*TMP -> GTM
                    vmulax.xyzw  ACC, vf20, vf10
                    vmadday.xyzw ACC, vf21, vf10
                    vmaddaz.xyzw ACC, vf22, vf10
                    vmaddw.xyzw  vf10, vf23, vf10

                    vmulax.xyzw  ACC, vf20, vf11
                    vmadday.xyzw ACC, vf21, vf11
                    vmaddaz.xyzw ACC, vf22, vf11
                    vmaddw.xyzw  vf11, vf23, vf11

                    vmulax.xyzw  ACC, vf20, vf12
                    vmadday.xyzw ACC, vf21, vf12
                    vmaddaz.xyzw ACC, vf22, vf12
                    vmaddw.xyzw  vf12, vf23, vf12

                    vmulax.xyzw  ACC, vf20, vf13
                    vmadday.xyzw ACC, vf21, vf13
                    vmaddaz.xyzw ACC, vf22, vf13
                    vmaddw.xyzw  vf13, vf23, vf13

  ": : "r" (tt) );
}



void vu0_normal_i12( VERTEX_F32 *coord_out, VERTEX12 *coord_in )
{
  asm __volatile__("

                lqc2            vf20, 0(%1)             # load coord_in
                vitof12.xyz     vf20, vf20
                vmove.w         vf20, vf0               # set vector.w to 1 (const)

                vmulax.xyzw     ACC,  vf14, vf20        # mul vf20 with NTM (14..17)
                vmadday.xyzw    ACC,  vf15, vf20
                vmaddaz.xyzw    ACC,  vf16, vf20
                vmaddw.xyzw     vf20, vf17, vf20

                sqc2            vf20, 0(%0)             # store coord_out

  ": : "r" (coord_out), "r" (coord_in) );
}

/*
void vu0_transform_i4( VERTEX4 *coord_out, VERTEX4 *coord_in )
{
  asm __volatile__("

                lqc2            vf20, 0(%1)             # load coord_in
                vitof4.xyz      vf20, vf20
                vmove.w         vf20, vf0               # set vector.w to 1 (const)

                vmulax.xyzw     ACC,  vf10, vf20        # mul vf20 with GTM (10..13)
                vmadday.xyzw    ACC,  vf11, vf20
                vmaddaz.xyzw    ACC,  vf12, vf20
                vmaddw.xyzw     vf20, vf13, vf20

                vdiv            Q, vf0w, vf20w          # do perspective correction
                vwaitq
                vmulq.xyz       vf20, vf20, Q

                vftoi4.xyzw     vf20, vf20              # store coord_out
                sqc2            vf20, 0(%0)

  ": : "r" (coord_out), "r" (coord_in) );
}


void vu0_transform_ipol_i4( VERTEX4 *coord_out, VERTEX4 *coord_in_a, VERTEX4 *coord_in_b, float fade )
{
  asm __volatile__("

	            lqc2			vf20, 0x0(%1)
	            lqc2			vf21, 0x0(%2)
                vitof4.xyz      vf20, vf20
                vitof4.xyz      vf21, vf21
	            mfc1			$8, %3
	            qmtc2			$8, vf22

	            vaddw.x         vf23, vf0, vf0
	            vsub.x          vf23, vf23, vf22
	            vmulax.xyz 		ACC, vf21, vf22
                vmove.w         vf20, vf0               # set vector.w to 1 (const)
                vmaddx.xyz      vf20, vf20, vf23

                vmulax.xyzw     ACC,  vf10, vf20        # mul vf20 with GTM (10..13)
                vmadday.xyzw    ACC,  vf11, vf20
                vmaddaz.xyzw    ACC,  vf12, vf20
                vmaddw.xyzw     vf20, vf13, vf20

                vdiv            Q, vf0w, vf20w          # do perspective correction
                vwaitq
                vmulq.xyz       vf20, vf20, Q

                vftoi4.xyzw     vf20, vf20              # store coord_out
                sqc2            vf20, 0(%0)

  ": : "r" (coord_out), "r" (coord_in_a), "r" (coord_in_b), "f" (fade) : "$8" );
}
*/

void vu0_transform_i12( VERTEX4 *coord_out, VERTEX12 *coord_in )
{
  asm __volatile__("

                lqc2            vf20, 0(%1)             # load coord_in
                vitof12.xyz     vf20, vf20
                vmove.w         vf20, vf0               # set vector.w to 1 (const)

                vmulax.xyzw     ACC,  vf10, vf20        # mul vf20 with GTM (10..13)
                vmadday.xyzw    ACC,  vf11, vf20
                vmaddaz.xyzw    ACC,  vf12, vf20
                vmaddw.xyzw     vf20, vf13, vf20

                vdiv            Q, vf0w, vf20w          # do perspective correction
                vwaitq
                vmulq.xyz       vf20, vf20, Q

                vftoi4.xyzw     vf20, vf20              # store coord_out
                sqc2            vf20, 0(%0)

  ": : "r" (coord_out), "r" (coord_in) );
}


void vu0_transform_ipol_i12( VERTEX4 *coord_out, VERTEX12 *coord_in_a, VERTEX12 *coord_in_b, float fade )
{
  asm __volatile__("

	            lqc2			vf20, 0x0(%1)
	            lqc2			vf21, 0x0(%2)
                vitof12.xyz     vf20, vf20
                vitof12.xyz     vf21, vf21
	            mfc1			$8, %3
	            qmtc2			$8, vf22

	            vaddw.x         vf23, vf0, vf0
	            vsub.x          vf23, vf23, vf22
	            vmulax.xyz 		ACC, vf21, vf22
                vmove.w         vf20, vf0               # set vector.w to 1 (const)
                vmaddx.xyz      vf20, vf20, vf23

                vmulax.xyzw     ACC,  vf10, vf20        # mul vf20 with GTM (10..13)
                vmadday.xyzw    ACC,  vf11, vf20
                vmaddaz.xyzw    ACC,  vf12, vf20
                vmaddw.xyzw     vf20, vf13, vf20

                vdiv            Q, vf0w, vf20w          # do perspective correction
                vwaitq
                vmulq.xyz       vf20, vf20, Q

                vftoi4.xyzw     vf20, vf20              # store coord_out
                sqc2            vf20, 0(%0)

  ": : "r" (coord_out), "r" (coord_in_a), "r" (coord_in_b), "f" (fade) : "$8" );
}
