;
; PS2 EE kernel syscalls
; set of general macro definitions for ps2 kernel syscalls
;
; (c) wiRe / Napalm 2002
;


; desc: flush the entire cache. allways assumes param a0 zero
; waste: a0,v0,v1
SysFlushCache   MACRO
                daddu   a0, zero, zero
                addiu   v1, zero, 0x64
                syscall
SysFlushCache   ENDM



; desc: execute file
; in: a0 = ptr on filename string, a1 = number of args, a2 = ptr on args
; waste: v0,v1
SysExecPS2      MACRO   _name, _n, _args
                addiu   v1, zero, 0x07
                syscall
SysExecPS2      ENDM

; desc: load executable file
; in: a0 = ptr on filename string, a1 = number of args, a2 = ptr on args
; waste: v0,v1
SysLoadExecPS2  MACRO   _name, _n, _args
                la      a0, _name
                li      a1, _n
                la      a2, _args
                addiu   v1, zero, 0x06
                syscall
SysLoadExecPS2  ENDM

; desc: leave current process
SysExit         MACRO
                addiu   v1, zero, 0x04
                syscall
SysExit         ENDM



; desc: write value a1 into register _reg
; waste: a0,v0,v1
SysSifSetReg    MACRO   _reg
                li      a0, _reg
                addiu   v1, zero, 0x79
                syscall
SysSifSetReg    ENDM

; desc: read register _reg into v0
; waste: a0,v0,v1
SysSifGetReg    MACRO   _reg
                li      a0, _reg
                addiu   v1, zero, 0x7A
                syscall
SysSifGetReg    ENDM



; desc: turn on dmac chn
SysEnableDmac   MACRO   _chn
                addiu   a0, zero, _chn
                addiu   v1, zero, 0x16
                syscall
SysEnableDmac   ENDM

; desc: turn off dmac chn
SysDisableDmac  MACRO   _chn
                addiu   a0, zero, _chn
                addiu   v1, zero, 0x17
                syscall
SysDisableDmac  ENDM



; thread definitions

; note:
;   thread with highest priority takes full ee time
;   higher priority == lower number
;   priority of naplink = 21
;   priority of main thread = 41

SYS_THREAD_STATUS           EQU 0
SYS_THREAD_ENTRY            EQU 4
SYS_THREAD_STACK            EQU 8
SYS_THREAD_STACK_SIZE       EQU 12
SYS_THREAD_GP_REG           EQU 16
SYS_THREAD_INIT_PRIORITY    EQU 20
SYS_THREAD_CURRENT_PRIORITY EQU 24
SYS_THREAD_ATTR             EQU 28
SYS_THREAD_OPTION           EQU 32
SYS_THREAD_WAIT_TYPE        EQU 36
SYS_THREAD_WAIT_ID          EQU 40
SYS_THREAD_WAKEUP_COUNT     EQU 44
SYS_THREAD_SIZE_            EQU 48

SYS_THREAD_TABLE MACRO   _name, _entry_ptr, _stack_ptr, _stack_size, _gp_reg, _priority
  _name           TABLE ALIGN 16
    status          DW      0
    entry           DW      _entry_ptr
    stack           DW      _stack_ptr
    stack_size      DW      _stack_size
    gp_reg          DW      _gp_reg 
    init_priority   DW      _priority
    current_priority DW     0
    attr            DW      0
    option          DW      0
    wait_type       DW      0
    wait_id         DW      0
    wakeup_count    DW      0
  _name           ENDT
SYS_THREAD_TABLE ENDM

; desc: create new thread
; in: a0 = ptr on thread table allocated by SYS_THREAD_TABLE
; out: v0 = new thread id
SysCreateThread MACRO
                addiu   v1, zero, 0x20
                syscall
SysCreateThread ENDM

; desc: start thread
; in: a0 = thread id
SysStartThread  MACRO
                daddu   a1, zero, zero
                addiu   v1, zero, 0x22
                syscall
SysStartThread  ENDM

; desc: get id of calling thread
; in: a0 = thread id
SysSetThreadId  MACRO
                addiu   v1, zero, 0x2F
                syscall
SysSetThreadId  ENDM

; desc: get id of calling thread
; out: v0 = thread id
SysGetThreadId  MACRO
                addiu   v1, zero, 0x2F
                syscall
SysGetThreadId  ENDM

; desc: change thread to wait state
; in: a0 = thread id
SysSleepThread  MACRO
                addiu   v1, zero, 0x32
                syscall
SysSleepThread  ENDM



; semaphore definitions

SYS_SEMA_CURRENT_COUNT  EQU 0
SYS_SEMA_MAX_COUNT      EQU 4
SYS_SEMA_INIT_COUNT     EQU 8
SYS_SEMA_NUM_WAIT_THRDS EQU 12
SYS_SEMA_ATTR           EQU 16
SYS_SEMA_OPTION         EQU 20
SYS_SEMA_SIZE_          EQU 24

SYS_SEMA_TABLE  MACRO   _name, _max_cnt, _init_cnt, _option
  _name TABLE     ALIGN 16
    current_cnt     DW 0
    max_cnt         DW _max_cnt
    init_cnt        DW _init_cnt
    num_wait_thrds  DW 0
    attr            DW 0
    option          DW _option
  _name           ENDT
SYS_SEMA_TABLE  ENDM

; desc: create sema
; in: a0 = ptr on semaphore table allocated by SYS_SEMA_TABLE
SysCreateSema   MACRO
                addiu   v1, zero, 0x40
                syscall
SysCreateSema   ENDM

; desc: delete sema
; in: a0 = sema id
SysDeleteSema   MACRO
                addiu   v1, zero, 0x41
                syscall
SysDeleteSema   ENDM

; desc: signal sema
; in: a0 = sema id
SysSignalSema   MACRO
                addiu   v1, zero, 0x42
                syscall
SysSignalSema   ENDM

; desc: wait sema
; in: a0 = sema id
SysWaitSema     MACRO
                addiu   v1, zero, 0x44
                syscall
SysWaitSema     ENDM



COMMENT /*



.set noat
.set noreorder
.text

.global RFU000_FullReset
.ent RFU000_FullReset
RFU000_FullReset:
	li      v1, 0
	syscall
	jr      ra
	nop
.end RFU000_FullReset
	
.global ResetEE
.ent ResetEE
ResetEE:
	li      v1, 1
	syscall
	jr      ra
	nop
.end ResetEE

.global SetGsCrt
.ent SetGsCrt
SetGsCrt:
	li      v1, 2
	syscall
	jr      ra
	nop
.end SetGsCrt

.global RFU003
.ent RFU003
RFU003:
	li      v1, 3
	syscall
	jr      ra
	nop
.end RFU003

.global Exit
.ent Exit
Exit:
	li      v1, 4
	syscall
	jr      ra
	nop
.end Exit

.global RFU005
.ent RFU005
RFU005:
	li      v1, 5
	syscall
	jr      ra
	nop
.end RFU005

.global LoadExecPS2
.ent LoadExecPS2
LoadExecPS2:
	li      v1, 6
	syscall
	jr      ra
	nop
.end LoadExecPS2

.global ExecPS2
.ent ExecPS2
ExecPS2:
	li      v1, 7
	syscall
	jr      ra
	nop
.end ExecPS2

.global RFU008
.ent RFU008
RFU008:
	li      v1, 8
	syscall
	jr      ra
	nop
.end RFU008

.global RFU009
.ent RFU009
RFU009:
	li      v1, 9
	syscall
	jr      ra
	nop
.end RFU009

.global AddSbusIntcHandler
.ent AddSbusIntcHandler
AddSbusIntcHandler:
	li      v1, 10
	syscall
	jr      ra
	nop
.end AddSbusIntcHandler

.global RemoveSbusIntcHandler
.ent RemoveSbusIntcHandler
RemoveSbusIntcHandler:
	li      v1, 11
	syscall
	jr      ra
	nop
.end RemoveSbusIntcHandler

.global Interrupt2Iop
.ent Interrupt2Iop
Interrupt2Iop:
	li      v1, 12
	syscall
	jr      ra
	nop
.end Interrupt2Iop

.global SetVTLBRefillHandler
.ent SetVTLBRefillHandler
SetVTLBRefillHandler:
	li      v1, 13
	syscall
	jr      ra
	nop
.end SetVTLBRefillHandler

.global SetVCommonHandler
.ent SetVCommonHandler
SetVCommonHandler:
	li      v1, 14
	syscall
	jr      ra
	nop
.end SetVCommonHandler

.global SetVInterruptHandler
.ent SetVInterruptHandler
SetVInterruptHandler:
	li      v1, 15
	syscall
	jr      ra
	nop
.end SetVInterruptHandler

.global AddIntcHandler
.ent AddIntcHandler
AddIntcHandler:
	li      v1, 16
	syscall
	jr      ra
	nop
.end AddIntcHandler

.global RemoveIntcHandler
.ent RemoveIntcHandler
RemoveIntcHandler:
	li      v1, 17
	syscall
	jr      ra
	nop
.end RemoveIntcHandler

.global AddDmacHandler
.ent AddDmacHandler
AddDmacHandler:
	li      v1, 18
	syscall
	jr      ra
	nop
.end AddDmacHandler

.global RemoveDmacHandler
.ent RemoveDmacHandler
RemoveDmacHandler:
	li      v1, 19
	syscall
	jr      ra
	nop
.end RemoveDmacHandler

.global _EnableIntc
.ent _EnableIntc
_EnableIntc:
	li      v1, 20
	syscall
	jr      ra
	nop
.end _EnableIntc

.global _DisableIntc
.ent _DisableIntc
_DisableIntc:
	li      v1, 21
	syscall
	jr      ra
	nop
.end _DisableIntc

.global _EnableDmac
.ent _EnableDmac
_EnableDmac:
	li      v1, 22
	syscall
	jr      ra
	nop
.end _EnableDmac

.global _DisableDmac
.ent _DisableDmac
_DisableDmac:
	li      v1, 23
	syscall
	jr      ra
	nop
.end _DisableDmac

.global _SetAlarm
.ent _SetAlarm
_SetAlarm:
	li      v1, 24
	syscall
	jr      ra
	nop
.end _SetAlarm

.global _ReleaseAlarm
.ent _ReleaseAlarm
_ReleaseAlarm:
	li      v1, 25
	syscall
	jr      ra
	nop
.end _ReleaseAlarm

.global _iEnableIntc
.ent _iEnableIntc
_iEnableIntc:
	li      v1, -26
	syscall
	jr      ra
	nop
.end _iEnableIntc

.global _iDisableIntc
.ent _iDisableIntc
_iDisableIntc:
	li      v1, -27
	syscall
	jr      ra
	nop
.end _iDisableIntc

.global _iEnableDmac
.ent _iEnableDmac
_iEnableDmac:
	li      v1, -28
	syscall
	jr      ra
	nop
.end _iEnableDmac

.global _iDisableDmac
.ent _iDisableDmac
_iDisableDmac:
	li      v1, -29
	syscall
	jr      ra
	nop
.end _iDisableDmac

.global _iSetAlarm
.ent _iSetAlarm
_iSetAlarm:
	li      v1, -30
	syscall
	jr      ra
	nop
.end _iSetAlarm

.global _iReleaseAlarm
.ent _iReleaseAlarm
_iReleaseAlarm:
	li      v1, -31
	syscall
	jr      ra
	nop
.end _iReleaseAlarm

.global CreateThread
.ent CreateThread
CreateThread:
	li      v1, 32
	syscall
	jr      ra
	nop
.end CreateThread

.global DeleteThread
.ent DeleteThread
DeleteThread:
	li      v1, 33
	syscall
	jr      ra
	nop
.end DeleteThread

.global StartThread
.ent StartThread
StartThread:
	li      v1, 34
	syscall
	jr      ra
	nop
.end StartThread

.global ExitThread
.ent ExitThread
ExitThread:
	li      v1, 35
	syscall
	jr      ra
	nop
.end ExitThread

.global ExitDeleteThread
.ent ExitDeleteThread
ExitDeleteThread:
	li      v1, 36
	syscall
	jr      ra
	nop
.end ExitDeleteThread

.global TerminateThread
.ent TerminateThread
TerminateThread:
	li      v1, 37
	syscall
	jr      ra
	nop
.end TerminateThread

.global iTerminateThread
.ent iTerminateThread
iTerminateThread:
	li      v1, -38
	syscall
	jr      ra
	nop
.end iTerminateThread

.global DisableDispatchThread
.ent DisableDispatchThread
DisableDispatchThread:
	li      v1, 39
	syscall
	jr      ra
	nop
.end DisableDispatchThread

.global EnableDispatchThread
.ent EnableDispatchThread
EnableDispatchThread:
	li      v1, 40
	syscall
	jr      ra
	nop
.end EnableDispatchThread

.global ChangeThreadPriority
.ent ChangeThreadPriority
ChangeThreadPriority:
	li      v1, 41
	syscall
	jr      ra
	nop
.end ChangeThreadPriority

.global iChangeThreadPriority
.ent iChangeThreadPriority
iChangeThreadPriority:
	li      v1, -42
	syscall
	jr      ra
	nop
.end iChangeThreadPriority

.global RotateThreadReadyQueue
.ent RotateThreadReadyQueue
RotateThreadReadyQueue:
	li      v1, 43
	syscall
	jr      ra
	nop
.end RotateThreadReadyQueue

.global _iRotateThreadReadyQueue
.ent _iRotateThreadReadyQueue
_iRotateThreadReadyQueue:
	li      v1, -44
	syscall
	jr      ra
	nop
.end _iRotateThreadReadyQueue

.global ReleaseWaitThread
.ent ReleaseWaitThread
ReleaseWaitThread:
	li      v1, 45
	syscall
	jr      ra
	nop
.end ReleaseWaitThread

.global iReleaseWaitThread
.ent iReleaseWaitThread
iReleaseWaitThread:
	li      v1, -46
	syscall
	jr      ra
	nop
.end iReleaseWaitThread

.global GetThreadId
.ent GetThreadId
GetThreadId:
	li      v1, 47
	syscall
	jr      ra
	nop
.end GetThreadId

.global ReferThreadStatus
.ent ReferThreadStatus
ReferThreadStatus:
	li      v1, 48
	syscall
	jr      ra
	nop
.end ReferThreadStatus

.global iReferThreadStatus
.ent iReferThreadStatus
iReferThreadStatus:
	li      v1, -49
	syscall
	jr      ra
	nop
.end iReferThreadStatus

.global SleepThread
.ent SleepThread
SleepThread:
	li      v1, 50
	syscall
	jr      ra
	nop
.end SleepThread

.global WakeupThread
.ent WakeupThread
WakeupThread:
	li      v1, 51
	syscall
	jr      ra
	nop
.end WakeupThread

.global _iWakeupThread
.ent _iWakeupThread
_iWakeupThread:
	li      v1, -52
	syscall
	jr      ra
	nop
.end _iWakeupThread

.global CancelWakeupThread
.ent CancelWakeupThread
CancelWakeupThread:
	li      v1, 53
	syscall
	jr      ra
	nop
.end CancelWakeupThread

.global iCancelWakeupThread
.ent iCancelWakeupThread
iCancelWakeupThread:
	li      v1, -54
	syscall
	jr      ra
	nop
.end iCancelWakeupThread

.global SuspendThread
.ent SuspendThread
SuspendThread:
	li      v1, 55
	syscall
	jr      ra
	nop
.end SuspendThread

.global _iSuspendThread
.ent _iSuspendThread
_iSuspendThread:
	li      v1, -56
	syscall
	jr      ra
	nop
.end _iSuspendThread

.global ResumeThread
.ent ResumeThread
ResumeThread:
	li      v1, 57
	syscall
	jr      ra
	nop
.end ResumeThread

.global iResumeThread
.ent iResumeThread
iResumeThread:
	li      v1, -58
	syscall
	jr      ra
	nop
.end iResumeThread

.global JoinThread
.ent JoinThread
JoinThread:
	li      v1, 59
	syscall
	jr      ra
	nop
.end JoinThread

.global RFU060
.ent RFU060
RFU060:
	li      v1, 60
	syscall
	jr      ra
	nop
.end RFU060

.global RFU061
.ent RFU061
RFU061:
	li      v1, 61
	syscall
	jr      ra
	nop
.end RFU061

.global EndOfHeap
.ent EndOfHeap
EndOfHeap:
	li      v1, 62
	syscall
	jr      ra
	nop
.end EndOfHeap

.global RFU063
.ent RFU063
RFU063:
	li      v1, 63
	syscall
	jr      ra
	nop
.end RFU063

.global CreateSema
.ent CreateSema
CreateSema:
	li      v1, 64
	syscall
	jr      ra
	nop
.end CreateSema

.global DeleteSema
.ent DeleteSema
DeleteSema:
	li      v1, 65
	syscall
	jr      ra
	nop
.end DeleteSema

.global SignalSema
.ent SignalSema
SignalSema:
	li      v1, 66
	syscall
	jr      ra
	nop
.end SignalSema

.global iSignalSema
.ent iSignalSema
iSignalSema:
	li      v1, -67
	syscall
	jr      ra
	nop
.end iSignalSema

.global WaitSema
.ent WaitSema
WaitSema:
	li      v1, 68
	syscall
	jr      ra
	nop
.end WaitSema

.global PollSema
.ent PollSema
PollSema:
	li      v1, 69
	syscall
	jr      ra
	nop
.end PollSema

.global iPollSema
.ent iPollSema
iPollSema:
	li      v1, -70
	syscall
	jr      ra
	nop
.end iPollSema

.global ReferSemaStatus
.ent ReferSemaStatus
ReferSemaStatus:
	li      v1, 71
	syscall
	jr      ra
	nop
.end ReferSemaStatus

.global iReferSemaStatus
.ent iReferSemaStatus
iReferSemaStatus:
	li      v1, -72
	syscall
	jr      ra
	nop
.end iReferSemaStatus

.global RFU073
.ent RFU073
RFU073:
	li      v1, 73
	syscall
	jr      ra
	nop
.end RFU073

.global SetOsdConfigParam
.ent SetOsdConfigParam
SetOsdConfigParam:
	li      v1, 74
	syscall
	jr      ra
	nop
.end SetOsdConfigParam

.global GetOsdConfigParam
.ent GetOsdConfigParam
GetOsdConfigParam:
	li      v1, 75
	syscall
	jr      ra
	nop
.end GetOsdConfigParam

.global GetGsHParam
.ent GetGsHParam
GetGsHParam:
	li      v1, 76
	syscall
	jr      ra
	nop
.end GetGsHParam

.global GetGsVParam
.ent GetGsVParam
GetGsVParam:
	li      v1, 77
	syscall
	jr      ra
	nop
.end GetGsVParam

.global SetGsHParam
.ent SetGsHParam
SetGsHParam:
	li      v1, 78
	syscall
	jr      ra
	nop
.end SetGsHParam

.global SetGsVParam
.ent SetGsVParam
SetGsVParam:
	li      v1, 79
	syscall
	jr      ra
	nop
.end SetGsVParam

.global RFU080_CreateEventFlag
.ent RFU080_CreateEventFlag
RFU080_CreateEventFlag:
	li      v1, 80
	syscall
	jr      ra
	nop
.end RFU080_CreateEventFlag

.global RFU081_DeleteEventFlag
.ent RFU081_DeleteEventFlag
RFU081_DeleteEventFlag:
	li      v1, 81
	syscall
	jr      ra
	nop
.end RFU081_DeleteEventFlag

.global RFU082_SetEventFlag
.ent RFU082_SetEventFlag
RFU082_SetEventFlag:
	li      v1, 82
	syscall
	jr      ra
	nop
.end RFU082_SetEventFlag

.global RFU083_iSetEventFlag
.ent RFU083_iSetEventFlag
RFU083_iSetEventFlag:
	li      v1, -83
	syscall
	jr      ra
	nop
.end RFU083_iSetEventFlag

.global RFU084_ClearEventFlag
.ent RFU084_ClearEventFlag
RFU084_ClearEventFlag:
	li      v1, 84
	syscall
	jr      ra
	nop
.end RFU084_ClearEventFlag

.global RFU085_iClearEventFlag
.ent RFU085_iClearEventFlag
RFU085_iClearEventFlag:
	li      v1, -85
	syscall
	jr      ra
	nop
.end RFU085_iClearEventFlag

.global RFU086_WaitEventFlag
.ent RFU086_WaitEventFlag
RFU086_WaitEventFlag:
	li      v1, 86
	syscall
	jr      ra
	nop
.end RFU086_WaitEventFlag

.global RFU087_PollEventFlag
.ent RFU087_PollEventFlag
RFU087_PollEventFlag:
	li      v1, 87
	syscall
	jr      ra
	nop
.end RFU087_PollEventFlag

.global RFU088_iPollEventFlag
.ent RFU088_iPollEventFlag
RFU088_iPollEventFlag:
	li      v1, -88
	syscall
	jr      ra
	nop
.end RFU088_iPollEventFlag

.global RFU089_ReferEventFlagStatus
.ent RFU089_ReferEventFlagStatus
RFU089_ReferEventFlagStatus:
	li      v1, 89
	syscall
	jr      ra
	nop
.end RFU089_ReferEventFlagStatus

.global RFU090_iReferEventFlagStatus
.ent RFU090_iReferEventFlagStatus
RFU090_iReferEventFlagStatus:
	li      v1, -90
	syscall
	jr      ra
	nop
.end RFU090_iReferEventFlagStatus

.global RFU091
.ent RFU091
RFU091:
	li      v1, 91
	syscall
	jr      ra
	nop
.end RFU091

.global EnableIntcHandler
.ent EnableIntcHandler
EnableIntcHandler:
	li      v1, 92
	syscall
	jr      ra
	nop
.end EnableIntcHandler

.global DisableIntcHandler
.ent DisableIntcHandler
DisableIntcHandler:
	li      v1, 93
	syscall
	jr      ra
	nop
.end DisableIntcHandler

.global iDisableIntcHandler
.ent iDisableIntcHandler
iDisableIntcHandler:
	li      v1, -93
	syscall
	jr      ra
	nop
.end iDisableIntcHandler

.global EnableDmacHandler
.ent EnableDmacHandler
EnableDmacHandler:
	li      v1, 94
	syscall
	jr      ra
	nop
.end EnableDmacHandler

.global iEnableDmacHandler
.ent iEnableDmacHandler
iEnableDmacHandler:
	li      v1, -94
	syscall
	jr      ra
	nop
.end iEnableDmacHandler

.global DisableDmacHandler
.ent DisableDmacHandler
DisableDmacHandler:
	li      v1, 95
	syscall
	jr      ra
	nop
.end DisableDmacHandler

.global iDisableDmacHandler
.ent iDisableDmacHandler
iDisableDmacHandler:
	li      v1, -95
	syscall
	jr      ra
	nop
.end iDisableDmacHandler

.global KSeg0
.ent KSeg0
KSeg0:
	li      v1, 96
	syscall
	jr      ra
	nop
.end KSeg0

.global EnableCache
.ent EnableCache
EnableCache:
	li      v1, 97
	syscall
	jr      ra
	nop
.end EnableCache

.global DisableCache
.ent DisableCache
DisableCache:
	li      v1, 98
	syscall
	jr      ra
	nop
.end DisableCache

.global GetCop0
.ent GetCop0
GetCop0:
	li      v1, 99
	syscall
	jr      ra
	nop
.end GetCop0

.global FlushCache
.ent FlushCache
FlushCache:
	li      v1, 100
	syscall
	jr      ra
	nop
.end FlushCache

.global CpuConfig
.ent CpuConfig
CpuConfig:
	li      v1, 102
	syscall
	jr      ra
	nop
.end CpuConfig

.global iGetCop0
.ent iGetCop0
iGetCop0:
	li      v1, -103
	syscall
	jr      ra
	nop
.end iGetCop0

.global iFlushCache
.ent iFlushCache
iFlushCache:
	li      v1, -104
	syscall
	jr      ra
	nop
.end iFlushCache

.global iCpuConfig
.ent iCpuConfig
iCpuConfig:
	li      v1, -106
	syscall
	jr      ra
	nop
.end iCpuConfig

.global sceSifStopDma
.ent sceSifStopDma
sceSifStopDma:
	li      v1, 107
	syscall
	jr      ra
	nop
.end sceSifStopDma

.global SetCPUTimerHandler
.ent SetCPUTimerHandler
SetCPUTimerHandler:
	li      v1, 108
	syscall
	jr      ra
	nop
.end SetCPUTimerHandler

.global SetCPUTimer
.ent SetCPUTimer
SetCPUTimer:
	li      v1, 109
	syscall
	jr      ra
	nop
.end SetCPUTimer

.global SetOsdConfigParam2
.ent SetOsdConfigParam2
SetOsdConfigParam2:
	li      v1, 110
	syscall
	jr      ra
	nop
.end SetOsdConfigParam2

.global GetOsdConfigParam2
.ent GetOsdConfigParam2
GetOsdConfigParam2:
	li      v1, 111
	li      v1, 111
	syscall
	jr      ra
	nop
.end GetOsdConfigParam2

.global GsGetIMR
.ent GsGetIMR
GsGetIMR:
	li      v1, 112
	syscall
	jr      ra
	nop
.end GsGetIMR

.global iGsGetIMR
.ent iGsGetIMR
iGsGetIMR:
	li      v1, -112
	syscall
	jr      ra
	nop
.end iGsGetIMR

.global GsPutIMR
.ent GsPutIMR
GsPutIMR:
	li      v1, 113
	syscall
	jr      ra
	nop
.end GsPutIMR

.global iGsPutIMR
.ent iGsPutIMR
iGsPutIMR:
	li      v1, -113
	syscall
	jr      ra
	nop
.end iGsPutIMR

.global SetPgifHandler
.ent SetPgifHandler
SetPgifHandler:
	li      v1, 114
	syscall
	jr      ra
	nop
.end SetPgifHandler

.global SetVSyncFlag
.ent SetVSyncFlag
SetVSyncFlag:
	li      v1, 115
	syscall
	jr      ra
	nop
.end SetVSyncFlag

.global RFU116
.ent RFU116
RFU116:
	li      v1, 116
	syscall
	jr      ra
	nop
.end RFU116

.global print
.ent print
print:
	li      v1, 117
	syscall
	jr      ra
	nop
.end print

.global sceSifDmaStat
.ent sceSifDmaStat
sceSifDmaStat:
	li      v1, 118
	syscall
	jr      ra
	nop
.end sceSifDmaStat

.global isceSifDmaStat
.ent isceSifDmaStat
isceSifDmaStat:
	li      v1, -118
	syscall
	jr      ra
	nop
.end isceSifDmaStat

.global sceSifSetDma
.ent sceSifSetDma
sceSifSetDma:
	li      v1, 119
	syscall
	jr      ra
	nop
.end sceSifSetDma

.global isceSifSetDma
.ent isceSifSetDma
isceSifSetDma:
	li      v1, -119
	syscall
	jr      ra
	nop
.end isceSifSetDma

.global sceSifSetDChain
.ent sceSifSetDChain
sceSifSetDChain:
	li      v1, 120
	syscall
	jr      ra
	nop
.end sceSifSetDChain

.global isceSifSetDChain
.ent isceSifSetDChain
isceSifSetDChain:
	li      v1, -120
	syscall
	jr      ra
	nop
.end isceSifSetDChain

.global sceSifSetReg
.ent sceSifSetReg
sceSifSetReg:
	li      v1, 121
	syscall
	jr      ra
	nop
.end sceSifSetReg

.global sceSifGetReg
.ent sceSifGetReg
sceSifGetReg:
	li      v1, 122
	syscall
	jr      ra
	nop
.end sceSifGetReg

.global ExecOSD
.ent ExecOSD
ExecOSD:
	li      v1, 123
	syscall
	jr      ra
	nop
.end ExecOSD

.global Deci2Call
.ent Deci2Call
Deci2Call:
	li      v1, 124
	syscall
	jr      ra
	nop
.end Deci2Call

.global PSMode
.ent PSMode
PSMode:
	li      v1, 125
	syscall
	jr      ra
	nop
.end PSMode

.global MachineType
.ent MachineType
MachineType:
	li      v1, 126
	syscall
	jr      ra
	nop
.end MachineType

.global GetMemorySize
.ent GetMemorySize
GetMemorySize:
	li      v1, 127
	syscall
	jr      ra
	nop
.end GetMemorySize

*/