;
; PS2 equates
; set of general value definitions for ps2 assembler
;
; (c) wiRe / Napalm 2002
;


REGDEF dhwbin = 24
REGDEF status = 12

; MIPS CPU Registers
COMMENT $
REGDEF zero	    = 0		    ; Always zero
REGDEF at		= 1		    ; Assembler temporary
REGDEF v0		= 2		    ; Function return
REGDEF v1		= 3		    ;
REGDEF a0		= 4		    ; Function arguments
REGDEF a1		= 5
REGDEF a2		= 6
REGDEF a3		= 7
REGDEF t0		= 8		    ; Temporaries. No need
REGDEF t1		= 9		    ; to preserve in your
REGDEF t2		= 10		; functions.
REGDEF t3		= 11
REGDEF t4		= 12
REGDEF t5		= 13
REGDEF t6		= 14
REGDEF t7		= 15
REGDEF s0		= 16		; Saved Temporaries.
REGDEF s1		= 17		; Make sure to restore
REGDEF s2		= 18		; to original value
REGDEF s3		= 19		; if your function
REGDEF s4		= 20		; changes their value.
REGDEF s5		= 21
REGDEF s6		= 22
REGDEF s7		= 23
REGDEF t8		= 24		; More Temporaries.
REGDEF t9		= 25
REGDEF k0		= 26		; Reserved for Kernel
REGDEF k1		= 27
REGDEF gp		= 28		; Global Pointer
REGDEF sp		= 29		; Stack Pointer
REGDEF fp		= 30		; Frame Pointer
REGDEF ra		= 31		; Function Return Address
$

COMMENT $
; Playstation2 GS Privileged Registers
pmode		EQU 0x12000000	; Setup CRT Controller
smode2		EQU 0x12000020	; CRTC Video Settings: PAL/NTCS, Interlace, etc.
dispfb1		EQU 0x12000070	; Setup the CRTC's Read Circuit 1 data source settings
display1	EQU 0x12000080	; RC1 display output settings
dispfb2		EQU 0x12000090	; Setup the CRTC's Read Circuit 2 data source settings
display2	EQU 0x120000a0	; RC2 display output settings
extbuf		EQU 0x120000b0	; ...
extdata		EQU 0x120000c0	; ...
extwrite	EQU 0x120000d0	; ...
bgcolor		EQU 0x120000e0	; Set CRTC background color
csr			EQU 0x12001000	; System status and reset
imr			EQU 0x12001010	; Interrupt Mask Register
busdir		EQU 0x12001040	; ...
siglblid	EQU 0x12001080	; ...

; Playstation2 GS General Purpose Registers
prim		EQU 0x00	; Select and configure current drawing primitive
rgbaq		EQU 0x01	; Setup current vertex color
st			EQU 0x02	; ...
uv			EQU 0x03	; Specify Vertex Texture Coordinates
xyzf2		EQU 0x04	; Set vertex coordinate
xyz2		EQU 0x05	; Set vertex coordinate and 'kick' drawing
tex0_1		EQU 0x06	; Texture Buffer Setup (Context 1)
tex0_2		EQU 0x07	; Texture Buffer Setup (Context 2)
clamp_1		EQU 0x08	; ...
clamp_2		EQU 0x09	; ...
fog			EQU 0x0a	; ...
xyzf3		EQU 0x0c	; ...
xyz3		EQU 0x0d	; ...
tex1_1		EQU 0x14	; ...
tex1_2		EQU 0x15	; ...
tex2_1		EQU 0x16	; ...
tex2_2		EQU 0x17	; ...
xyoffset_1	EQU 0x18	; Mapping from Primitive to Window coordinate system (Context 1)
xyoffset_2	EQU 0x19	; Mapping from Primitive to Window coordinate system (Context 2)
prmodecont	EQU 0x1a	; ...
prmode		EQU 0x1b	; ...
texclut		EQU 0x1c	; ...
scanmsk		EQU 0x22	; ...
miptbp1_1	EQU 0x34	; ...
miptbp1_2	EQU 0x35	; ...
miptbp2_1	EQU 0x36	; ...
miptbp2_2	EQU 0x37	; ...
texa		EQU 0x3b	; ...
fogcol		EQU 0x3d	; ...
texflush	EQU 0x3f	; Write to this register before using newly loaded texture
scissor_1	EQU 0x40	; Setup clipping rectangle (Context 1)
scissor_2	EQU 0x41	; Setup clipping rectangle (Context 2)
alpha_1		EQU 0x42	; Setup Alpha Blending Parameters (Context 1)
alpha_2		EQU 0x43	; Setup Alpha Blending Parameters (Context 2)
dimx		EQU 0x44	; ...
dthe		EQU 0x45	; ...
colclamp	EQU 0x46	; ...
test_1		EQU 0x47	; ...
test_2		EQU 0x48	; ...
pabe		EQU 0x49	; ...
fba_1		EQU 0x4a	; ...
fba_2		EQU 0x4b	; ...
frame_1		EQU 0x4c	; Frame buffer settings (Context 1)
frame_2		EQU 0x4d	; Frame buffer settings (Context 2)
zbuf_1		EQU 0x4e	; ...
zbuf_2		EQU 0x4f	; ...
bitbltbuf	EQU 0x50	; Setup Image Transfer Between EE and GS
trxpos		EQU 0x51	; Setup Image Transfer Coordinates
trxreg		EQU 0x52	; Setup Image Transfer Size
trxdir		EQU 0x53	; Set Image Transfer Directon + Start Transfer
hwreg		EQU 0x54	; ...
signal		EQU 0x60	; ...
finish		EQU 0x61	; ...
label		EQU 0x62	; ...
$