#define RPC_MCSERV 		0x80000400

#define RPC_MCSERV_INIT		0x70
#define RPC_MCSERV_OPEN		0x71
#define RPC_MCSERV_CLOSE	0x72
#define RPC_MCSERV_READ		0x73
#define RPC_MCSERV_WRITE	0x74
#define RPC_MCSERV_SEEK		0x75
#define RPC_MCSERV_GETDIR	0x76
#define RPC_MCSERV_FORMAT	0x77
#define RPC_MCSERV_GETINFO	0x78
#define RPC_MCSERV_DELETE	0x79
#define RPC_MCSERV_FLUSH	0x7A
#define RPC_MCSERV_CHDIR	0x7B
#define	RPC_MCSERV_SETINFO	0x7C
#define	RPC_MCSERV_RENAME	0x7D
#define RPC_MCSERV_UNFORMAT     0x80

#define MCATTR_READ             0x0001
#define MCATTR_WRITE	        0x0002
#define MCATTR_EXEC		0x0004
#define MCATTR_COPYPROT	        0x0008
#define MCATTR_SUBDIR           0x0020
#define MCATTR_PDA		0x0800
#define MCATTR_PS1		0x1000

typedef struct {
	unsigned char Resv2, sec, min, hour;
	unsigned char day, month;
	unsigned short year;
} mc_timestamp;

typedef struct {
    mc_timestamp create;
    mc_timestamp modify;
} mc_info;

typedef struct {
    mc_timestamp create;
    mc_timestamp modify;
    unsigned int size;
    unsigned short attr;
    unsigned short pad1;
    unsigned pad2[2];
    unsigned char name[32];
} mc_dirent __attribute__ ((aligned(64)));

int mc_open(int port, int slot, const char *name, int mode);
int mc_close(int fd);
int mc_read(int fd, void *buff, int size);
int mc_seek(int fd, int offset, int mode);
int mc_flush(int fd);
int mc_getdir(int port, int slot, const char *name, unsigned int mode, int maxent, mc_dirent * table);
int mc_chdir(int port, int slot, const char *path, char *pwd);
int mc_rename(int port, int slot, const char *old, const char *new);
int mc_delete(int port, int slot, const char *name);
int mc_format(int port, int slot);
int mc_set_fileinfo(int port, int slot, const char *name, void *info, int flags);
int mc_mkdir(int port, int slot, const char *name);
int mc_init(void);
int mc_sync(int mode, int *cmd, int *result);
int mc_getinfo(int port, int slot, int *type, int *free);
int mc_unformat(int port, int slot);

int _mc_getinfo(int port, int *type, int *free);
int _mc_chdir(int port, const char *name);
int _mc_mkdir(int port, const char *name);
int _mc_open(int port, const char *name, int mode);
int _mc_read(int fd, void *buff, int size);
int _mc_write(int fd, void *buff, int size);
int _mc_close(int fd);
int _mc_getdir(int port, mc_dirent *dir, int entries);
int _mc_delete(int port, const char *name);
int _mc_deltree(int port, const char *name);
