


;--------------------------------------------------------------------------------------------------
;                               loader for nPort
;--------------------------------------------------------------------------------------------------



;--------------------------------------------------------------------------------------------------
                                TARGET  BIN,R5900

                                INCLUDE     ".\tools\asm_inc\macros.inc"
                                INCLUDE     ".\tools\asm_inc\equates.inc"
                                INCLUDE     ".\tools\asm_inc\syscalls.inc"
;--------------------------------------------------------------------------------------------------
                                INCLUDE     "prog0000.inc"
                               ;INCLUDE     "prog0001.inc"
;--------------------------------------------------------------------------------------------------
LOADER_ADDR                     EQU             0x0800000
STACK_ADDR                      EQU             0x1C00000
;--------------------------------------------------------------------------------------------------
                                DB  7Fh,"ELF"   ; indentifier
                                DB  1           ; File Class: 1=32bit, 2=64bit objects
                                DB  1           ; Data Encoding: 1=ELFDATA2LSB, 2=ELFDATA2MSB
                                DB  1           ; ELF header version (must be 1)
                                DB  0,'w','i','R','e','/','N','P','M'
                                DH  2           ; ELF type: 0=NONE, 1=REL, 2=EXEC, 3=SHARED, 4=CORE
                                DH  8           ; Processor: 8=MIPS
                                DW  1           ; Version: 1=current
                                DW  code.main   ; Entry point address
                                DW  program     ; Start of program headers (offset from file start)
                                DW  0           ; Start of section headers (offset from file start)
                                DW  20924001h   ; Processor specific flags = 0x20924001 noreorder, mips
                                DH  34h         ; ELF header size (0x34 = 52 bytes)
                                DH  20h         ; Program headers entry size
                                DH  1           ; Number of program headers
                                DH  0           ; Section headers entry size
                                DH  0           ; Number of section headers
                                DH  0           ; Section header stringtable index
program:                        DW  1           ; Segment type: 1=Load the segment into memory, no. of bytes specified by 0x10 and 0x14
                                DW  code._fofs  ; Offset from file start to program segment.
                                DW  code._ofs   ; Virtual address of the segment
                                DW  code._ofs   ; Physical address of the segment
                                DW  code._fsize ; Number of bytes in the file image of the segment
                                DW  ((code._size+15)>>4)<<4     ; Number of bytes in the memory image of the segment
                                DW  0           ; Flags for segment
                               ;DW  PH0_ALIGN   ; Alignment. The address of 0x08 and 0x0C must fit this alignment. 0=no alignment
code                            SEGMENT         LOADER_ADDR
                                DW  0
;--------------------------------------------------------------------------------------------------
main:                           di
                                la              sp, STACK_ADDR
                                ei
                                la              a0, prog0000
                                la              a1, PH0_PADDR
                                jal             npm_rnc_decomp
                                nop
                               ;la              a0, prog0001
                               ;la              a1, PH1_PADDR
                               ;jal             npm_rnc_decomp
                               ;nop
                                la              at, PH0_ENTRY
                                jalr            at
                                nop
;--------------------------------------------------------------------------------------------------
                                INCLUDE         ".\tools\asm_inc\npmrnc1.asm"
prog0000:                       INCLUDE BINARY  "prog0000.bin" ALIGN 16
prog0001:                       ;INCLUDE BINARY  "prog0001.bin" ALIGN 16
;--------------------------------------------------------------------------------------------------
code                            ENDS
;--------------------------------------------------------------------------------------------------
                                END
;-----------------------------------------------------------------------------------------------EOF
