#ifndef _INDEX_H_
#define _INDEX_H_


#define INDEX_ID 0x74726F506E
#define FILENAME_INDEX "host0:\\saves\\index."
#define FILENAME_INDEX_ENTRY "host0:\\saves\\%s.npo"

#define MAX_COPY_SPACE (16*1024)
#define MAX_ENTRIES_ROOT 1024
#define MAX_ENTRIES_SUB 256



typedef struct {
    unsigned long id;
    uint32 entries;
    uint32 fofs_sys;
    uint32 fofs_ico;
} INDEX_SUB_HEAD;

typedef struct {
    // file descriptor
    char name[MAX_FILENAME_SPACE];  // empty name means last entry of current dir
    unsigned int size;   // size of file
    unsigned short attr;   // if MCATTR_SUBDIR is set, then the following entry traces into subdirectory

    // insert file here...
} INDEX_SUB_ENTRY;


typedef struct {
    unsigned long id;
    uint32 entries;
} INDEX_ROOT_HEAD;

typedef struct {
    char filename[MAX_FILENAME_SPACE];
    char title[2][MAX_TITLE_SPACE];
} INDEX_ROOT_ENTRY;

typedef struct {
    INDEX_ROOT_HEAD head;
    INDEX_ROOT_ENTRY entry[MAX_ENTRIES_ROOT];
} INDEX_ROOT;



extern INDEX_ROOT index_root;

extern int index_read();
extern int index_add(int port, char *name, uint8 overwrite);
extern int index_copy(int port, char *name, uint8 overwrite);
extern int index_delete(char *name);


#endif
