#ifndef _ICON_H_
#define _ICON_H_

#define ICON_SMALL_X_POS ((0x800+47)<<4)
#define ICON_SMALL_Y_POS ((0x800+86)<<4)
#define ICON_SMALL_SCALE (12 << 15)

#define ICON_HUGE_X_POS ((0x800+640/2)<<4)
#define ICON_HUGE_Y_POS ((0x800+128+480/2)<<4)
#define ICON_HUGE_SCALE (70 << 15)




// icon-sys file descriptions

typedef struct {
  uint32 id;
  uint16 dmy01;
  uint16 offs_2nd_title;
  uint32 dmy02;
  uint32 bg_alpha;

  struct {
    uint32 r,g,b,a;
  } bg_color[4];

  struct {
    float x,y,z,w;
  } light_dir[3];
  struct {
    float r,g,b,a;
  } light_color[3];

  struct {
    float r,g,b,a;
  } ambient_color;

  uint8 title[68];

  char ico_file[3][64];

  uint8 dmy03[512];
} ICON_SYS_FILE;


typedef struct {
  char title[2][68];
  char icon[3][64];

  uint8 loaded;
} ICON_SYS;





// icon file descriptions

#define ICON_MAX_VERTEX (10*1024)
#define ICON_MAX_ANIMATION (1*1024)
#define ICON_MAX_NKS 16
#define ICON_MAX_NKF 16



typedef struct {
  uint32 ver;
} ICON_HEAD;



typedef struct {
  uint32 nks;
  uint32 attr;  //bit8 = compressed texture
  float bfcv;
  uint32 nv;
} ICON_MODEL_HEAD;


typedef struct {
  int16 vertex[ICON_MAX_NKS][4];
  int16 normal[4];
  uint16 u,v;
  uint32 rgba;
} ICON_MODEL;



typedef struct {
  uint32 num;
  uint32 length;
  float speed;  //float?
  uint32 offs;
  uint32 ns;
} ICON_ANIMATION_HEAD;

typedef struct {
  uint32 shape;
  uint32 nkf;
  int16 key[ICON_MAX_NKF][4];
} ICON_ANIMATION;



typedef struct {
  uint32 size;
} ICON_TEXTURE_HEAD;

typedef union {
  uint16 u[128*128];
  int16 s[128*128];
} __attribute__((aligned(16))) ICON_TEXTURE;



typedef struct {
  ICON_HEAD ih __attribute__((aligned (16)));

  ICON_MODEL_HEAD imh __attribute__((aligned (16)));
  ICON_MODEL im[ICON_MAX_VERTEX] __attribute__((aligned (16)));

  ICON_ANIMATION_HEAD iah __attribute__((aligned (16)));
  ICON_ANIMATION ia[ICON_MAX_ANIMATION] __attribute__((aligned (16)));

  //ICON_TEXTURE_HEAD ith;
  ICON_TEXTURE it __attribute__((aligned (16)));

  // user data...
  uint8 loaded;             // successfully loaded?
  uint16 alpha,beta,gamma;  // angles
  uint32 key_pos,key_next;  // animations counters
  float time;               // animation flow control
} __attribute__((aligned (16))) ICON;





extern int icon_load_sys(char *name, ICON_SYS *is, int mc_port);
extern int icon_load(char *name, ICON *ico, int mc_port);
extern void icon_draw(int8 alpha, ICON *ico, uint32 tbp, uint8 size);

#endif
