varying vec3 lightVec;
varying vec3 eyeVec;
varying vec2 texCoord;
varying float fogFactor;

uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform float axa;
float invRadius=0.0003;

void main (void)
{
 gl_FragColor = gl_Color;
	float distSqr = dot(lightVec, lightVec);
	float att = clamp(1.0 - invRadius * sqrt(distSqr), 0.0, 1.0);
	vec3 lVec = lightVec * inversesqrt(distSqr);
    float aaa=axa;
	vec3 vVec = normalize(eyeVec);
	vec4 base = texture2D(colorMap, texCoord);
	vec3 colornormal =texture2D(normalMap, texCoord).xyz;
	colornormal.z+=aaa;

	vec3 bump = normalize(colornormal * 2 - 1);

	vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;

	float diffuse = max(dot(lVec, bump), 0.0);
	vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * 	diffuse;

	float specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess);
	vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;

	//gl_FragColor = (vAmbient*base + vDiffuse*base + vSpecular) * att;

    vec4 finalColor = (vAmbient*base + vDiffuse*base + vSpecular) * att;


const float LOG2 = 1.442695;
float z = gl_FragCoord.z / gl_FragCoord.w;
float fogFactor = exp2( -gl_Fog.density *
				   gl_Fog.density *
				   z *
				   z *
				   LOG2 );
fogFactor = clamp(fogFactor, 0.0, 1.0);

gl_FragColor = mix(gl_Fog.color, finalColor, fogFactor );


	gl_FragColor = mix(gl_Fog.color, finalColor, fogFactor );
}
