//===============================================================================================
// Ex3D1.EXE
// Copyright (c), Firelight Multimedia, 1999.
//
// This test shows EAX, DS3D, A3D and Software all being used together.  For vortex cards
// geometry will obstruct and relfect sounds.
// This refreshes the scene every frame.
// To see how to use geometry lists, see sample Ex3D2 which is a slight variation on this one.
// Converted to Delphi by Bocevski Dragan   mailto: d_bocevski@yahoo.com
//===============================================================================================
//  History
//
//  2001/09/09 by Steve 'Sly' Williams
//  - Updated to version 3.40
//
//  2000/12/15 by Steve 'Sly' Williams
//  - Updated to version 3.30
//
//  2000/11/14 by Steve 'Sly' Williams
//  - Fixed version check
//  - Added FMODErrors to uses clause
//  - Added chekc for Delphi 4 to change wVirtualKeyCode to wVirtualScanCode
//===============================================================================================
program Ex3d1;

uses
  FMOD, FMODErrors, Windows;

const
  UPDATETIME = 50;
  NUMPOLYS = 4;
{$APPTYPE CONSOLE}

var
  stream: PFSoundStream;
  key, dw: DWORD;
  driver: Integer;
  enm: TFSoundOutputTypes;
  h, h1: Thandle;
  buf: input_record;
  c: coord;
  s: string;
  samp1, samp2, samp3: PFSoundSample;
  material: PFSoundMaterial;
  openflag, listenerflag: boolean;
  channel, count, i, channel1, channel2: Longint;
  listenerpos: array[0..2] of single;
  lastpos: array[0..2] of single = (0, 0, 0);
  openingfactor, t: single;
  pos, vel: TFSoundVector;

    // COORDINATE SYSTEM : X = right, Y = up, Z = forwards. (Left handed)
  poly: array[0..NUMPOLYS - 1, 0..3, 0..2] of Single =
  (
    (// left wall
    (-35.0, -20.0, -20.0),
    (-35.0, 20.0, -20.0),
    (-35.0, 20.0, 20.0),
    (-35.0, -20.0, 20.0)
    ),
    (// front wall
    (-35.0, 20.0, 20.0),
    (10.0, 20.0, 20.0),
    (10.0, -20.0, 20.0),
    (-35.0, -20.0, 20.0)
    ),
    (// back wall
    (-35.0, -20.0, -20.0),
    (10.0, -20.0, -20.0),
    (10.0, 20.0, -20.0),
    (-35.0, 20.0, -20.0)
    ),
    (// right wall
    (10.0, -20.0, -20.0),
    (10.0, -20.0, 20.0),
    (10.0, 20.0, 20.0),
    (10.0, 20.0, -20.0)
    )
    );
  doorpoly: array[0..3, 0..2] of Single =
  (// hole in right wall
    (10.0, -20.0, -5.0),
    (10.0, -20.0, 5.0),
    (10.0, 20.0, 5.0),
    (10.0, 20.0, -5.0)
    );
  normal: array[0..NUMPOLYS - 1, 0..2] of Single =
  (
    (1.0, 0.0, 0.0), // left wall
    (-1.0, 0.0, 0.0), // right wall
    (0.0, 0.0, -1.0), // front wall
    (0.0, 0.0, 1.0) // back wall
    );
begin
  openflag := false; listenerflag := true; //channel1:=-1; channel2:=-1;
  listenerpos[0] := 0; listenerpos[1] := 0; listenerpos[2] := 0;
  openingfactor := 0;
  t := 0;
  SetLength(s, 80);
  SetConsoleTitle(pchar('Example Ex3D1 (3d enviroment)'));
  h := GetStdHandle(STD_INPUT_HANDLE);
  h1 := GetStdHandle(STD_OUTPUT_HANDLE);
  Buf.EventType := Key_Event;
  c.X := 1;
  c.Y := 23;
  if FMOD_VERSION > FSOUND_GetVersion then
  begin
    WriteLn('Error: You are using FMOD version ', FSOUND_GetVersion: 3: 2, '.  You should be using version ', FMOD_VERSION: 3: 2);
    Exit;
  end;

// ==========================================================================================
// SELECT OUTPUT METHOD
// ==========================================================================================

  writeln;
  writeln('---------------------------------------------------------');
  writeln('Output Type');
  writeln('---------------------------------------------------------');

  writeln('1 - Direct Sound');
  writeln('2 - Windows Multimedia Waveout');
  writeln('3 - A3D');
  writeln('4 - NoSound');
  writeln('---------------------------------------------------------'); // print driver names
  writeln('Press a corresponding number or ESC to quit');

  repeat
    Sleep(50);
    FlushConsoleInputBuffer(h);
    repeat
      ReadConsoleInput(h, buf, 1, dw);
    until buf.Event.KeyEvent.bKeyDown = false;
{$IFDEF VER120}
    Key := buf.Event.KeyEvent.wVirtualScanCode;
{$ELSE}
    Key := buf.Event.KeyEvent.wVirtualKeyCode;
{$ENDIF}
    case key of
      ord('1'): FSOUND_SetOutput(FSOUND_OUTPUT_DSOUND);
      ord('2'): FSOUND_SetOutput(FSOUND_OUTPUT_WINMM);
      ord('3'): FSOUND_SetOutput(FSOUND_OUTPUT_A3D);
      ord('4'): FSOUND_SetOutput(FSOUND_OUTPUT_NOSOUND);
      27: exit;
    end;
  until ((key >= ord('1')) and (key <= ord('4')));

// ==========================================================================================
// SELECT DRIVER
// ==========================================================================================


// The following list are the drivers for the output method selected above.
  writeln('---------------------------------------------------------');
  enm := FSOUND_GetOutput();
  case enm of

    FSOUND_OUTPUT_NOSOUND: write('NoSound');
    FSOUND_OUTPUT_WINMM: write('Windows Multimedia Waveout');
    FSOUND_OUTPUT_DSOUND: write('Direct Sound');
    FSOUND_OUTPUT_A3D: write('A3D');
  end;
  writeln(' Driver list');
  writeln('---------------------------------------------------------');
  for i := 0 to FSOUND_GetNumDrivers() - 1 do
    writeln(i + 1, ' - ', FSOUND_GetDriverName(i)); // print driver names
  writeln('---------------------------------------------------------'); // print driver names
  writeln('Press a corresponding number or ESC to quit');
  repeat
    FlushConsoleInputBuffer(h);
    repeat
      ReadConsoleInput(h, buf, 1, dw);
    until buf.Event.KeyEvent.bKeyDown = false;
{$IFDEF VER120}
    Key := buf.Event.KeyEvent.wVirtualScanCode;
{$ELSE}
    Key := buf.Event.KeyEvent.wVirtualKeyCode;
{$ENDIF}
    if (ord(key) = 27) then exit;
    driver := ord(key) - ord('1');
  until ((driver > 0) or (driver <= FSOUND_GetNumDrivers()));
  FSOUND_SetDriver(driver); // Select sound card (0 = default)

// ==========================================================================================
// INITIALIZE
// ==========================================================================================
  if not FSOUND_Init(44100, 32, 0) then
  begin
    writeln('Error! Initializing');
    writeln(FMOD_ErrorString(FSOUND_GetError()));
    FSOUND_Close();
    exit;
  end;

// ==========================================================================================
// LOAD SAMPLES
// ==========================================================================================

// ==========================================================================================
// 16 BIT MONO
// ==========================================================================================
  samp1 := FSOUND_Sample_Load(FSOUND_FREE, '../../media/drumloop.wav', FSOUND_HW3D, 0);
  if samp1 = nil then
  begin
    writeln('Error! Loading 16bit Mono sample');
    writeln(FMOD_ErrorString(FSOUND_GetError()));
    exit;
  end;
 // increasing mindistance makes it louder in 3d space
  FSOUND_Sample_SetMinMaxDistance(samp1, 4.0, 1000.0);
  FSOUND_Sample_SetLoopMode(samp1, FSOUND_LOOP_NORMAL);

// ==========================================================================================
// 8 BIT MONO
// ==========================================================================================
  samp2 := FSOUND_Sample_Load(FSOUND_UNMANAGED, '../../media/jungle.wav', FSOUND_HW3D, 0);
  if samp2 = nil then
  begin
    writeln('Error! Loading 8bit Mono sample');
    writeln(FMOD_ErrorString(FSOUND_GetError()));
    exit;
  end;
 // increasing mindistance makes it louder in 3d space
  FSOUND_Sample_SetMinMaxDistance(samp2, 3.0, 1000.0);
  FSOUND_Sample_SetLoopMode(samp2, FSOUND_LOOP_NORMAL);

// ==========================================================================================
// 16 BIT STEREO
// ==========================================================================================
  samp3 := FSOUND_Sample_Load(FSOUND_UNMANAGED, '../../media/chimes.wav', FSOUND_2D, 0);
  if samp3 = nil then
  begin
    writeln('Error! Loading 16bit Stereo sample');
    writeln(FMOD_ErrorString(FSOUND_GetError()));
    exit;
  end;

// ==========================================================================================
// DISPLAY HELP
// ==========================================================================================

  write('FSOUND Output Method : ');
  case (FSOUND_GetOutput()) of
    FSOUND_OUTPUT_NOSOUND: writeln('FSOUND_OUTPUT_NOSOUND');
    FSOUND_OUTPUT_WINMM: writeln('FSOUND_OUTPUT_WINMM');
    FSOUND_OUTPUT_DSOUND: writeln('FSOUND_OUTPUT_DSOUND');
    FSOUND_OUTPUT_A3D: writeln('FSOUND_OUTPUT_A3D');
  end;

  write('FSOUND Mixer         : ');
  case (FSOUND_GetMixer()) of
    FSOUND_MIXER_BLENDMODE: writeln('FSOUND_MIXER_BLENDMODE');
    FSOUND_MIXER_MMXP5: writeln('FSOUND_MIXER_MMXP5');
    FSOUND_MIXER_MMXP6: writeln('FSOUND_MIXER_MMXP6');
    FSOUND_MIXER_QUALITY_FPU: writeln('FSOUND_MIXER_QUALITY_FPU');
    FSOUND_MIXER_QUALITY_MMXP5: writeln('FSOUND_MIXER_QUALITY_MMXP5');
    FSOUND_MIXER_QUALITY_MMXP6: writeln('FSOUND_MIXER_QUALITY_MMXP6');
  end;
  write('FSOUND Driver        : ');
  writeln(FSOUND_GetDriverName(FSOUND_GetDriver()));
  writeln('Hardware 3D channels : ', FSOUND_GetNumHardwareChannels());

  writeln('=========================================================================');
  writeln('Press 1		Pause/Unpause 16bit 3D sound at any time');
  writeln('      2		Pause/Unpause 8bit 3D sound at any time');
  writeln('      3		Play 16bit STEREO 2D sound at any time');
  writeln('      4		Change to EAX Reverb mode CONCERTHALL (DirectSound/SBLive only)');
  writeln('      5		Change to EAX Reverb mode SEWERPIPE (DirectSound/SBLive only)');
  writeln('      6		Change to EAX Reverb mode PSYCHOTIC (DirectSound/SBLive only)');
  writeln('      7		Open/Close door on right wall (affects A3D only)');
  writeln('      8		Change to dull material type for walls (affects A3D only)');
  writeln('      9		Change to bright material type for walls (affects A3D only)');
  writeln('      <-		Move listener left (in still mode)');
  writeln('      ->		Move listener right (in still mode)');
  writeln('      SPACE SPACE to stop/start listener automatic movement');
  writeln('      ESC	Quit');
  writeln('=========================================================================');

// ==========================================================================================
// PLAY 2 LOOPING SOUNDS
// ==========================================================================================


  pos.x := -10; pos.y := -0; pos.z := 0;
  vel.x := 0; vel.y := 0; vel.z := 0;
  channel1 := FSOUND_PlaySound(FSOUND_FREE, samp1);
  FSOUND_3D_SetAttributes(channel1, @pos, @vel);
  FSOUND_Reverb_SetMix(channel1, -1.0);

  pos.x := 15; pos.y := -0; pos.z := -0;
  vel.x := 0; vel.y := 0; vel.z := 0;
  channel2 := FSOUND_PlaySound(FSOUND_FREE, samp2);
  FSOUND_3D_SetAttributes(channel2, @pos, @vel);
  FSOUND_Reverb_SetMix(channel2, -1.0);

// ==========================================================================================
// MAIN LOOP
// ==========================================================================================

//	FSOUND_Reverb_SetEnvironment(FSOUND_PRESET_CONCERTHALL);
//	FSOUND_Reverb_SetEnvironmentAdvanced(FSOUND_ENVIRONMENT_HALLWAY, -10000, 0, 0.0, 1.0, 0.5, -10000, .02, -10000, .04, 100.0, 100.0, 5000.0);

  material := FSOUND_Geometry_Material_Create();

  repeat
    FlushConsoleInputBuffer(h);
    Sleep(50);
    PeekConsoleInput(h, buf, 1, dw);
    if dw > 0 then
    begin
{$IFDEF VER120}
      Key := buf.Event.KeyEvent.wVirtualScanCode;
{$ELSE}
      Key := buf.Event.KeyEvent.wVirtualKeyCode;
{$ENDIF}
      if (key = ord('1')) then
        FSOUND_SetPaused(channel1, not FSOUND_GetPaused(channel1));
      if (key = ord('2')) then
        FSOUND_SetPaused(channel2, not FSOUND_GetPaused(channel2));
      if (key = ord('3')) then
      begin
        channel := FSOUND_PlaySound(FSOUND_FREE, samp3);
        FSOUND_SetPan(channel, FSOUND_STEREOPAN);
      end;
      if (key = ord('4')) then FSOUND_Reverb_SetEnvironment(FSOUND_ENVIRONMENT_BATHROOM, 0.653, 1.499, 0.166);
      if (key = ord('5')) then FSOUND_Reverb_SetEnvironment(FSOUND_ENVIRONMENT_BATHROOM, 0.5, 3.961, 0.0);
      if (key = ord('6')) then FSOUND_Reverb_SetEnvironment(FSOUND_ENVIRONMENT_BATHROOM, 0.5, 3.961, 2.0);
      if (key = ord('7')) then openflag := not openflag;
      if (key = ord('8')) then FSOUND_Geometry_Material_SetAttributes(material, 0, 0, 0, 0);
      if (key = ord('9')) then FSOUND_Geometry_Material_SetAttributes(material, 1, 1, 0.1, 0.1);
      if (key = ord(' ')) then
        listenerflag := not listenerflag;
      if key = 27 then exit;
      if not listenerflag then
      begin
        if (key = vk_left) then
        begin
          listenerpos[0] := listenerpos[0] - 1.0;
          if (listenerpos[0] < -35) then
            listenerpos[0] := -35;
        end;
        if (key = vk_right) then
        begin
          listenerpos[0] := listenerpos[0] + 1.0;
          if (listenerpos[0] > 30) then
            listenerpos[0] := 30;
        end;
      end;
    end;

// ==========================================================================================
// BUILD GEOMETRY
// ==========================================================================================

    FSOUND_Geometry_Material_Set(material); // remember to put this BEFORE the addpolygons
    for count := 0 to NUMPOLYS - 1 do
      FSOUND_Geometry_AddPolygon(@poly[count, 0], @poly[count, 1], @poly[count, 2], @poly[count, 3], nil, FSOUND_GEOMETRY_NORMAL or FSOUND_GEOMETRY_REFLECTIVE, nil);
    if openflag then openingfactor := 1.0 else openingfactor := 0.0;
    FSOUND_Geometry_AddPolygon(@doorpoly[0], @doorpoly[1], @doorpoly[2], @doorpoly[3], nil, FSOUND_GEOMETRY_NORMAL or FSOUND_GEOMETRY_REFLECTIVE or FSOUND_GEOMETRY_OPENING_REFERENCE, @openingfactor);

// ==========================================================================================
// UPDATE THE LISTENER
// ==========================================================================================
    if true then
    begin
      if (listenerflag) then
        listenerpos[0] := (sin(t * 0.05) * 33.0); // left right pingpong

 // vel = how far we moved last FRAME (m/f), then time compensate it to SECONDS (m/s).
      vel.x := (listenerpos[0] - lastpos[0]) * (1000 / UPDATETIME);
      vel.y := (listenerpos[1] - lastpos[1]) * (1000 / UPDATETIME);
      vel.z := (listenerpos[2] - lastpos[2]) * (1000 / UPDATETIME);
 // store pos for next time
      lastpos[0] := listenerpos[0];
      lastpos[1] := listenerpos[1];
      lastpos[2] := listenerpos[2];
      FSOUND_3D_Listener_SetAttributes(@listenerpos[0], @vel.x, 0, 0, 1.0, 0, 1.0, 0);
      t := t + (30 * (1.0 / UPDATETIME)); // 50m/s

        // print out a small visual display
      SetConsoleCursorPosition(h1, c);
      if openflag then
        s := '|.......................<1>..................|   <2>               Door: Open    '
      else s := '|.......................<1>..................|   <2>               Door: Closed ';
      s[trunc(listenerpos[0] + 35)] := 'L';
      if (openflag) then
        s[10 + 35] := ':';
      SetConsoleCursorPosition(h1, c);
      WriteConsole(h1, pchar(s), length(s) - 1, dw, nil);
      s := '                                                                                ';
    end;

    FSOUND_3D_Update();
  until false;
  FSOUND_Geometry_Material_Free(material);

    // you dont need to free samples if you let fsound's sample manager look after samples, as
    // it will free them all for you.
  FSOUND_Sample_Free(samp1);
  FSOUND_Sample_Free(samp2);
  FSOUND_Sample_Free(samp3);

  writeln;
  FSOUND_Stream_Close(stream);
  FSOUND_Close();
end.

