#ifndef IMPORTINTERFACEC_H
#define IMPORTINTERFACEC_H

namespace Import {
	class ImportInterfaceC;
};

#include "FactoryC.h"
#include "ImportableI.h"
#include "ClassIdC.h"
#include "FileListC.h"


namespace Import {

	//! Import interface class.
	/*!	Import interface class is a tool class for importers.
		It's purpose is to enable the importer to import other
		files inside a importer.

		This class is implemented by the system.
	*/
	class ImportInterfaceC
	{
	public:
		//! Default constructor (used internally).
		ImportInterfaceC( FileListC* pFileList, PluginClass::FactoryC* pFactory );
		//! Default destructor (used internally).
		virtual ~ImportInterfaceC();

		//! Imports requested file.
		/*! Request a import for a specified file. File importer filters can be used
			range the number of possible importers which could match the file extension.

			For example if it is known that the file must be image, SUPERCLASS_IMAGE could be
			passed as the rSuperFilter argument.
			
			If a filter (class Id of super class ID) isn't used NULL_CLASSID or NULL_SUPERCLASS
			should be passed as argument.

			Example:
			\code
			// Request import for a image.
			FileHandleC*	pHandle = m_pImpInterface->request_import( szFileName, SUPERCLASS_IMAGE, NULL_CLASSID );
			\endcode
		*/
		virtual FileHandleC*	request_import( const char* szName, PluginClass::SuperClassIdC rSuperFilter,
												const PluginClass::ClassIdC rClassFilter );

	private:
		PluginClass::FactoryC*	m_pFactory;
		FileListC*				m_pFileList;
	};

};

#endif // IMPORTINTERFACEC_H