
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>

#include "PajaTypes.h"
#include "SceneC.h"
#include "FileListC.h"
#include "DemopajaVersion.h"
#include "DeviceContextC.h"
#include "TimeContextC.h"
#include <string>
#include <vector>


#include "bass.h"


class DemopajaPlayerC
{
public:

	DemopajaPlayerC();
	virtual ~DemopajaPlayerC();

	void				register_plugin( PluginClass::ClassDescC* pDesc );
	PajaTypes::uint32	load_demo( const char* szFileName );
	void				load_plugins( const char* szPath );

	PajaTypes::int32	run( HINSTANCE hInst, bool bFullScreen );

private:

	PajaTypes::uint32			load_scene( FileIO::LoadC* pLoad );
	void						draw_frame();
	bool						init_music_system( HWND hWnd );

	static bool					set_pixelformat( HDC hDC );
	static LRESULT CALLBACK		wnd_proc( HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam );

	PajaSystem::DeviceContextC*	m_pContext;
	PajaSystem::TimeContextC*	m_pTimeContext;
	Import::FileListC*			m_pFileList;
	Composition::SceneC*		m_pScene;
	PluginClass::FactoryC		m_rFactory;

	PajaTypes::int32			m_i32Time;
	PajaTypes::int32			m_i32MaxTime;
	PajaTypes::int32			m_i32SampleSize;
	PajaTypes::int32			m_i32Freq;
	PajaTypes::float64			m_f64TimeScale;
	PajaTypes::int32			m_i32StartTime;
	bool						m_bFullscreen;
	std::string					m_sMusicFile;

	static HSTREAM				m_hMp3Stream;
	static bool					m_bBASSPresent;
	static HDC					m_hDC;
	static HGLRC				m_hGLRC;
};