pico-8 cartridge // http://www.pico-8.com
version 35
__lua__
--night over celestia
--by moonshine

--custom font
poke(0x5600,unpack(split"8,8,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,63,63,63,63,63,63,0,0,0,63,63,63,0,0,0,0,0,63,51,63,0,0,0,0,0,51,12,51,0,0,0,0,0,51,0,51,0,0,0,0,0,51,51,51,0,0,0,0,48,60,63,60,48,0,0,0,3,15,63,15,3,0,0,62,0,6,6,6,0,0,0,0,0,48,48,48,0,62,0,99,54,28,62,8,62,8,0,0,0,0,24,0,0,0,0,0,0,0,0,0,12,24,0,0,0,0,0,0,12,12,0,0,0,10,10,0,0,0,0,0,4,10,4,0,0,0,0,0,0,0,0,0,0,0,0,30,30,12,12,12,0,12,0,0,54,54,0,0,0,0,0,0,54,127,54,54,127,54,0,8,62,11,62,104,62,8,0,0,51,24,12,6,51,0,0,14,27,27,110,59,59,110,0,12,12,4,0,0,0,0,0,24,12,6,6,6,12,24,0,12,24,48,48,48,24,12,0,0,54,28,127,28,54,0,0,0,12,12,63,12,12,0,0,0,0,0,0,0,8,12,4,0,0,0,54,0,0,0,0,0,0,0,0,0,12,12,0,32,48,24,12,6,3,1,0,119,99,107,107,107,99,119,0,28,24,24,24,24,24,60,0,119,99,96,119,3,99,119,0,119,99,96,116,96,99,119,0,51,51,51,55,48,48,48,0,119,99,3,119,96,99,119,0,119,99,3,119,99,99,119,0,119,99,96,96,96,96,96,0,119,99,99,119,99,99,119,0,119,99,99,119,96,96,119,0,0,0,12,12,0,12,12,0,0,0,12,12,0,8,12,4,48,24,12,6,12,24,48,0,0,0,30,0,30,0,0,0,6,12,24,48,24,12,6,0,55,51,56,28,12,0,12,0,0,26,51,59,59,3,26,0,0,0,119,96,119,99,119,0,3,3,119,99,99,99,119,0,0,0,119,99,3,99,119,0,96,96,119,99,99,99,119,0,0,0,119,99,119,3,119,0,118,6,6,55,6,6,6,0,0,0,119,99,99,119,96,119,3,3,119,99,99,99,99,0,0,24,0,24,24,24,60,0,48,0,56,48,48,48,51,55,3,3,51,51,27,51,51,0,12,12,12,12,12,12,60,0,0,0,99,119,119,99,99,0,0,0,119,99,99,99,99,0,0,0,119,99,99,99,119,0,0,0,119,99,99,119,3,3,0,0,119,99,99,119,96,96,0,0,119,99,3,3,3,0,0,0,119,3,119,96,119,0,12,12,62,12,12,12,60,0,0,0,99,99,99,99,119,0,0,0,99,99,99,54,20,0,0,0,99,99,99,119,54,0,0,0,99,119,54,119,99,0,0,0,99,99,99,119,96,119,0,0,119,112,54,7,119,0,54,6,6,6,6,6,54,0,1,3,6,12,24,48,32,0,54,48,48,48,48,48,54,0,12,30,18,0,0,0,0,0,0,0,0,0,0,0,30,0,12,24,0,0,0,0,0,0,119,99,99,99,119,99,99,0,119,99,99,55,99,99,119,0,119,99,3,3,3,99,119,0,55,115,99,99,99,99,119,0,119,99,3,55,3,99,119,0,119,99,3,55,3,3,3,0,119,99,3,115,99,99,119,0,99,99,99,119,99,99,99,0,63,12,12,12,12,12,63,0,127,48,48,48,48,51,55,0,99,99,99,55,99,99,99,0,3,3,3,3,3,99,119,0,119,119,119,99,99,99,99,0,99,103,103,119,115,115,99,0,119,99,99,99,99,99,119,0,119,99,99,119,3,3,3,0,119,99,99,99,99,51,103,0,119,99,99,55,99,99,99,0,119,99,3,119,96,99,119,0,63,12,12,12,12,12,12,0,99,99,99,99,99,99,119,0,99,99,99,99,119,54,20,0,99,99,99,99,119,119,99,0,99,99,54,54,54,99,99,0,99,99,99,119,96,99,119,0,119,96,112,54,7,3,119,0,56,12,12,7,12,12,56,0,8,8,8,0,8,8,8,0,14,24,24,112,24,24,14,0,0,0,110,59,0,0,0,0,0,0,0,0,0,0,0,0,127,127,127,127,127,127,127,0,85,42,85,42,85,42,85,0,65,99,127,93,93,119,62,0,62,99,99,119,62,65,62,0,17,68,17,68,17,68,17,0,4,12,124,62,31,24,16,0,28,38,95,95,127,62,28,0,34,119,127,127,62,28,8,0,42,28,54,119,54,28,42,0,28,28,62,93,28,20,20,0,8,28,62,127,62,42,58,0,62,103,99,103,62,65,62,0,62,127,93,93,127,99,62,0,24,120,8,8,8,15,7,0,62,99,107,99,62,65,62,0,8,20,42,93,42,20,8,0,0,0,0,85,0,0,0,0,62,115,99,115,62,65,62,0,8,28,127,28,54,34,0,0,127,34,20,8,20,34,127,0,62,119,99,99,62,65,62,0,0,10,4,0,80,32,0,0,17,42,68,0,17,42,68,0,62,107,119,107,62,65,62,0,127,0,127,0,127,0,127,0,85,85,85,85,85,85,85,0"))

--variables
scene="intro"
frames=-3
secondary_frames=64
star_amount=64

--arrays
city_pal={6,13,5,1}
ground={}
for i=1,128 do
 add(ground,flr(rnd(1)*5)*5)
end
stars={}
for i=1,star_amount do
 add(stars,{x=rnd(128),y=rnd(128)})
end

--rotating sphere effect
function texsphere(x,y,w,h,sw,sh,sx)
 for i=0,sw*1.57 do
  sspr((i+sx)%sw,0,1,sh,x+(i-sw)*w/sw,y-sqrt(sin(1.57*(i/(sh*2))))*h,w/sw,sqrt(sin(1.57*(i/(sh*2))))*h*2)
 end
end

music(36)
--update
function _update60()
 --frames
 if scene=="endscreen" then
  frames=0
 else 
  frames+=1/100
 end
 --star scrolling
 for i=1,#stars do
  if scene=="outro" or scene=="endscreen" then
   stars[i].y=(stars[i].y+0.25)%128
  else
   stars[i].x=(stars[i].x+0.25)%128
  end
 end
 --intro
 if scene=="intro" then
  if frames>30 then 
   scene="main"
   frames=-3
   music(0)
  elseif frames>26 then
   music(-1,1000)
  end
 --main
 elseif scene=="main" then
  if secondary_frames>0 then
   secondary_frames-=0.25
  end
  if frames>60 then
   scene="end_transition"
  end
 --end transition
 elseif scene=="end_transition" then
  if secondary_frames<63 then
   secondary_frames+=0.25
  else
   scene="outro"
   frames=-3
   music(22)
  end
 --outro
 elseif scene=="outro" then
  if frames>12 then
   scene="endscreen"
   anim_frames=72
  end
 --endscreen
 elseif scene=="endscreen" then
  if secondary_frames>0 then
   secondary_frames-=0.25
  end
 end
end

--draw
function _draw()
 cls()
 --stars
 for i=1,#stars do
  pset(stars[i].x,stars[i].y,13)
 end
 --intro
 if scene=="intro" then
  poke(0x5f58,0x81) 
  print("welcome to 'night over celestia', the first prod from moonshine! code, graphics and music by megasparky. this group is all about the tunes! now here's some music, just listen...",-frames*50,7*8,11)
 --main/end transition
 elseif scene=="main" or scene=="end_transition" then 
  poke(0x5f58,0x0) 
  for a=3,0,-1 do
   for i=1,128 do
    line((i+a*10+t()*2*(20-2*a))%128,128-ground[i]-8*a+secondary_frames,(i+a*10+t()*2*(20-2*a))%128,128+secondary_frames,city_pal[a+1])
   end
  end
  texsphere(64+secondary_frames*2,64,64,16+sin(t()/4)*8,32,32,t()*16)
  spr(4,2*8+sin(t()/2)*10,8-secondary_frames,12,2)
  print("night over celestia",3*8-sin(t()/2)*10,3*8-secondary_frames,7)
 --outro
 elseif scene=="outro" then
  poke(0x5f58,0x81)
  print("it's time for\nthe greetings!",8,64-frames*25,12)
  print("we say hi to:",8,64-frames*25+3*8,12)
  print("acrouzet\ndeved\net1999cc\njammer\nkulor\nmibri\nps\nsoupstand\nsuperogue\ntobach\nviralbox",8,64-frames*25+5*8,9)
  print("if you want to\nknow more about\nthe group or\njoin us, come\nto the discord\nserver from our\ndemozoo page!",8,64-frames*25+19*8,12)
 --endscreen
 elseif scene=="endscreen" then
  spr(4,2*8+sin(t()/2)*10,7*8+secondary_frames,12,2)
 end
end
__gfx__
66666666666666666666666666666666000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
77777777777777777777777777777777000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
77777777777777777777777776667777000bbbb00bbbb000000000000000000003333003333000bbbbbbb0033330033330033330033330033330033333333000
77777666667777777777777767776777000baabbbbaab00006666600ddddd00003bb3303bb300bbaaaaab003bb3003bb3003bb3003bb3303bb3003bbbbbb3000
77776777776777777777777677777677000baaabbaaab0006666666dd555dd0003bbb333bb300baaaaaab003bb3003bb3003bb3003bbb333bb3003bbbbbb3000
77767777777677777777777677777677000baaaaaaaab000d655566655555dd003bbbb33bb300baaabbbb003bb3333bb3003bb3003bbbb33bb3003bb33333000
67676767676767676767676d67676d67000baaaaaaaab006d5555566500056d003bbbbb3bb300baaaaabb003bbbbbbbb3003bb3003bbbbb3bb3003bbbbbb3000
766676767676667676767676d676d676000baabaabaab00d6500056660006d6003bb3bbbbb300bbaaaaab003bbbbbbbb3003bb3003bb3bbbbb3003bbbbbb3000
6767676767676767666767676ddd6767000baabbbbaab00ddd000dd66666665003bb33bbbb300bbbbaaab003bb3333bb3003bb3003bb33bbbb3003bb33333000
76667676767666766766767676767676000baab33baab0055ddddd556666655003bb333bbb300baaaaaab003bb3113bb3003bb3003bb333bbb3003bbbbbb3000
666d6666666d6666d6d6666666666dd6000baab33baab000555555555555550003bb3133bb300baaaaabb003bb3113bb3003bb3003bb3133bb3003bbbbbb3000
6666d66666d666666d6666666666d66d000bbbb00bbbb00005555500555550000333311333300bbbbbbb30033330033330033330033331133330033333333000
66666ddddd666666666666666666d66d000333300333300000000000000000000111101111100333333330011110011110011110011110111110011111111000
66666666666666666666666666666dd6000333300333300000000000000000000111100111100333333300011110011110011110011110011110011111111000
d6ddd6d6d6d6d6d6d6ddddd6d6d6d6d6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
6d6d6d6d6d6d6d6d6d6d6ddd6d6d6d6d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
d6d6d6d6d6d6d6d6d6d6d6ddd6d6d6d6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
dd6d6ddd6d6d6d6ddd6d6d6d6d6d6d6d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
5ddddd5ddddddddd5dddddd5dddddddd000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
d5ddd5ddddddddddd5dddd5ddddddddd000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
dd555ddddd5555dddd5555dddd5555dd000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
ddddddddd5dddd5dddddddddd5dddd5d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
5d5d5d5d5d5d5d555d5d5d5d555d5d5d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
d5d5d5d555d5d5d5d5d5d5d5d5d5d555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
5d5d5d5d5d5d5d555d5d5d5d555d5d5d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
d5d5d5d555d5d5d5d5d5d5d5d55555d5000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
55511555155555515555515555555555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
55155155515555155555151555555555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
55155155551111555555515555555555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
55511555555555555555555555555555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
55555555555555555555555555555555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
11111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
00d00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000d000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000bbbb00bbbb000000000000000000003333003333000bbbbbbb003333003333003333003333003333003333333300000000000000000
000000000000000000000baabbbbaab00006666600ddddd00003bb3303bb300bbaaaaab003bb3003bb3003bb3003bb3303bb3003bbbbbb300000000000000000
00000000d000000000000baaabbaaab0006666666dd555dd0003bbb333bb300baaaaaab003bb3003bb3003bb3003bbb333bb3003bbbbbb3000d0000000000000
000000000000000000000baaaaaaaab000d655566655555dd003bbbb33bb300baaabbbb003bb3333bb3003bb3003bbbb33bb3003bb3333300000000000000000
000000000000000000000baaaaaaaab006d5555566500056d003bbbbb3bb300baaaaabb003bbbbbbbb3003bb3003bbbbb3bb3003bbbbbb300000000000000000
000000000000000000000baabaabaab00d6500056660006d6003bb3bbbbb300bbaaaaab003bbbbbbbb3003bb3003bb3bbbbb3003bbbbbb300000000000000000
000000000000000000000baabbbbaab00ddd000dd66666665003bb33bbbb300bbbbaaab003bb3333bb3003bb3003bb33bbbb3003bb3333300000000000000000
000000000000000000000baab33baab0055ddddd556666655003bb333bbb300baaaaaab003bb3113bb3003bb3003bb333bbb3003bbbbbb300000000000000000
000000000000000000000baab33baab000555555555555550003bb3133bb300baaaaabb003bb3113bb3003bb3003bb3133bb3003bbbbbb300000000000000000
000000000000000000000bbbb00bbbb00005555500555550000333311333300bbbbbbb3003333003333003333003333113333003333333300000000000000000
00000000000000000000033330033330000000000000000000011110111110033333333001111001111001111001111011111001111111100000000000000000
00000000000000000000033330033330000000000000000000011110011110033333330001111001111001111001111001111001111111100000000000000000
000000000000000000000000000000000000d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000d00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000077007770077070707770000007707070777077700000077077707000777007707770777077700000000000000000000000000000000
000000000000000000000707007007000707007000000707070707000707000007000700070007000700007000700707000000d0000000000000000000000000
000000000000000000000707007007000777007000000707070707700770000007000770070007700777007000700777000000000000000000000d0000000000
000000000000000000000707007007070707007000000707077707000707000007000700070007d0000700700070070700000000000000000000000000000000
00000000000000000000070707770777070700700000077000700777070700000077077707770777077000700777070700000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000d000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000d000000000000000000000000000d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000666666666666000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000066777777777777660000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000777777777777777766000d0000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000006677777777777777777700000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000667777777777777777777766000000000000000000000000000000000000000000000000000000
000d0000000000000000000000000000000000000000000000777777777777777777777777000000000000000000000000d00000000d00000000000000000000
000000000000000000000000000000000000000000000000667777777777777777777777776600000000000000000000000000000000000000000d0000000000
00000000000000000000000000000000000000000000000077777777777777777777777777770000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000006677777777777777777777777777776600000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000d0776666666677667766776677777777770000d000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000007777776666667766776677776677777700000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000006677667766667766776677667777777766000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000667777776666776677666666777777776677000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000777766777766667766667766666666666666000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000006666666677666677666677dd66777777dd77000000000000000000000000000000000000000000000000
00000000000d00000000000000000000000000000000777777776666666666dd66dd666666666677770000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000007777776666dd6666666666dd666666667766dd770000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000066666666dd666666666666dd6666666666666677000000000000000000000000000d000000000000000000
00000000000000000000000000000000000000000077666666666666666666666666666666666677660000000000000000000000000000000000000000000000
00000000000000000000000000000d0000000000007766dddd666666666666666666666666666666660000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000d0666666666666dd6666666666dddddd66666666660000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000dd66dd66dd66dd66dd66dd66dddddddddd6666660000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000dd6666dd66dd66dd66dd66dd66dd66dddddd66dd0000000000000000000000d00000000000000000000000
000000000000000000000000000000000000000000dddddd66dddddd6666dd66dddd66dddddddddddd0000000000000000000000000000000000000000000000
0000000000d0000000000000000000000000000000dddd66dd666666dddd66dd6666dd6666dddd66dd0000000000000000000000000000000000000000000000
0000000000000000000d0000000000000000000000dddddddddddd66dd66dddddd66dd66dd6655dd5500000000d0000000000000000000000000000000000000
000000000000000000000000000000000000000000dddddddddddddddddddd55dddddddddddddddd550000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000055dddddddddddddddddd55dddddddddd55dddd550000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000055dddd5555dddddddddddd55dddd5555dddddd550000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000055dd55dddd555555dddddddd55555555dddd55550000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000055555555dddddddddddddddddddddd5555dd110000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000555555dddd55dd55dddddddddd55dddd5555000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000005511dddd5555dd555555dd55dddd55555555000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000005555555555dd55555555dddd55dddddd5555000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000115555dddd5555dd55dd55dddd555555551100000000000000000000000000000000000d000000000000
000000000000000000000000000000000000000000000055115555dddd555555dd5555dd55555500000000000000000000000000000000000000000000000000
000000000000000000000000000000d00000000000000055555555dd55555555dddd555511115500000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000115511555555dd55dd5555551155551100000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000055555555555511555555551111550000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000011551155555511555555555555550000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000555511111155555555555555110000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000115555115555555555555555000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000055555555555555555555110000000000000000000000d0000000000000000000000000000000
00000000000000000000000000000000000000000000000000001155555555555555551100000000000000000000000000000000000000000000000000000000
00100000000000001000010000000000000000000000000010101011555555555555110000100010010000000000010001010000010101100111101010000010
00100000000000001000010000000000000000000000000010101001115555555511000000100010010000000000010001010000010101100111101010000010
00100000000000001000010000000000000000000000000010101001001111111100000000100010010000000000010001010000010101100111101010000010
00100000000000001000010000000000000000000000000010101001000000000000000000100010010000000000010001010000010101100111101010000010
d0100000000000001000010000000000000000000000000010101001000000000000000000100010010000000000010001010000010101100111101d10000010
00101010011010001000110011000000000000000000010010101001010001011100010000101011010001000010010101010001010101111111101010100010
00101010011010001000110011000000000000000000010010101001010001011100010000101011010001000010010101010001010101111111101010100010
00101010011010001000110011000000000000000000010010101001010001011100010000101011010001000010010101010001010101111111101010100010
55105555051510001500150011000000000500005000010010101001010001011105050500501011010001000010050105015001010101115111505010105050
55105555051510001500150011000000000500005000010010101001010001011105050500501011010001000010050105015001010101115111505010105050
55105555051510001500150111100000000510015100110111101101010011011115150510501111010001000011050105115001110101115111505010105050
55105555051510001500150111100000000510015100110111101101010011011115150510501111010001000011050105115001110101115111505010105050
55105555051510001500150111100000000510015100110111101101010011011115150510501111010001000011050105115001110101115111505010105050
55555555051515001500150515105505000510055105510111101101010011015115150510505111515551005011050505515001510105115151505010505050
55555555051515001500150515105505000510055105510111101101010011015115150510505111515551005011050505515001510105115151505010505050
55555555151515011501151515115505000511155105510111111101111011115115150510515111515551105011150505515111510105115151505110505150
55d555d5d51515d1d5dd15dddd1d5d05000d111d5105510111111d0111d01111511515051051511151555d1d5d11d505055151115101051d515d50d110505150
55d555d5d51515d1d5dd15dddd1d5d05000d111d5105510111111d0111d01111511515051051511151555d1d5d11d505055151115101051d515d50d110505150
55d555d5d51515d1d5dd15dddd1d5d05000d111d5155550111111d0511d05115515555055051511551555d1d5d15d505555151115101055d515d55d110555150
55d555d5d51515d1d5dd15dddd1d5d05000d111d5155550111111d0511d05115515555055051511551555d1d5d15d505555151115101055d515d55d110555150
55d555d5d51515d1d5dd15dddd1d5d15111d111d5155551111111d1511d15115515555155151511551555d1d5d15d515555151115111155d515d55d111555151
55d5d5d5d515d5d1d5dddddddd1d5d1d111d111d5d5d55dd1d111d151dd15dd5515555155151511551d55d1d5d15d5d555d1ddd151d1155d5d5dd5d111d5515d
55d5d5d5d515d5d1d5dddddddd1d5d1d111d111d5d5d55dd1d111d151dd15dd5515555155151511551d55d1d5d15d5d555d1ddd151d1155d5d5dd5d111d5515d
55d5d5d5d555d5d5d5dddddddd1d5d5d115d515d5d5d55dd1d111d155dd55dd5515555555155551555d55d5d5d15d5d555d5ddd555d1155d5d5dd5d155d5515d
56d5d6d56555d5d5d5dd6ddd6d6d5d5d616d665d666656d61d11161556d55dd5515555565155651555d55d5d5d15d5d555d5ddd656d6156d5d5dd5d155d5515d
56d5d6d56555d5d5d5dd6ddd6d6d5d5d616d665d666656d61d11161556d55dd5515555565155651555d55d5d5d15d5d555d5ddd656d6156d5d5dd5d155d5515d
d6d5d6dd6555ddd5d5dd6ddd6d6d5d5d616d665d666656d61d11161556d5dddd515555565d5565d55dd5dddd5dd5d5d55dd5ddd656d61d6d5dddd5d155d5515d
d6d5d6dd6555ddd5d5dd6ddd6d6d5d5d616d665d666656d61d11161556d5dddd515555565d5565d55dd5dddd5dd5d5d55dd5ddd656d61d6d5dddd5d155d5515d
d6d5d6dd6555ddd5d5dd6ddd6d6d5d5d656d665d666656d65d55565556d5dddd555555565d5565d55dd5dddd5dd5d5d55dd5ddd656d65d6d5dddd5d555d5555d
d6d6d66d65556dd5d6dd6d6d6d6d5d6d656d6666666656d65655565556d6d6dd665655565d5665d66dd5dddd5dd5d5d55dd56dd656d65d6d6ddd656665d5655d
d6d6d66d65556dd5d6dd6d6d6d6d5d6d656d6666666656d65655565556d6d6dd665655565d5665d66dd5dddd5dd5d5d55dd56dd656d65d6d6ddd656665d5655d
d6d6d66d65dd6dd5d6dd6d6d6d6ddd6d6d6d6666666656d6d655d6d5d6d6d6dd665655565dd66dd66dd5ddddddd5dddd5ddd6dd6d6d65d6d6ddd6d666ddd655d
d6d6d66d65dd6dd5d6dd6d6d6d6ddd6d6d6d6666666656d6d655d6d5d6d6d6dd665655565dd66dd66dd5ddddddd5dddd5ddd6dd6d6d65d6d6ddd6d666ddd655d
d6d6d66d65dd6dd5d6dd6d6d6d6ddd6d6d6d6666666656d6d655d6d5d6d6d6dd665655565dd66dd66dd5ddddddd5dddd5ddd6dd6d6d65d6d6ddd6d666ddd655d
d6d6666d65dd6dd5d66d6d6d666ddd666d6d6666666656d6d655d6d5d6d6d6dd665655565dd66d6666d5ddddddd6dd6d6dd66d6666d66d6d6dd66d6666d66556
d6d6666d65dd6dd5d66d6d6d666ddd666d6d6666666656d6d655d6d5d6d6d6dd665655565dd66d6666d5ddddddd6dd6d6dd66d6666d66d6d6dd66d6666d66556
d6d6666d6ddd6dddd66d6d6d666ddd666d6d66666666d6d6d6ddd6ddd6d6d6dd66d6ddd6ddd66d6666ddddddddd6dd6d6dd66d6666d66d6d6dd66d6666d66dd6
d6d6666d6ddd6dddd66d6d6d666ddd666d6d66666666d6d6d6ddd6ddd6d6d6dd66d6ddd6ddd66d6666ddddddddd6dd6d6dd66d6666d66d6d6dd66d6666d66dd6
d6d6666d6ddd6dddd66d6d6d666ddd666d6d66666666d6d6d6ddd6ddd6d6d6dd66d6ddd6ddd66d6666ddddddddd6dd6d6dd66d6666d66d6d6dd66d6666d66dd6
d6666666666666ddd6666d6d666d66666d6d66666666d666d6d666d6666666d66666dd666d666666666dddddddd666666dd66d6666666d6666d6666666666dd6
d6666666666666ddd6666d6d666d66666d6d66666666d666d6d666d6666666d66666dd666d666666666dddddddd666666dd66d6666666d6666d6666666666dd6
d6666666666666ddd6666d6d666d66666d6d66666666d666d6d666d6666666d66666dd666d666666666dddddddd666666dd66d6666666d6666d6666666666dd6
d6666666666666ddd6666d6d666d66666d6d66666666d666d6d666d6666666d66666dd666d666666666dddddddd666666dd66d6666666d6666d6666666666dd6
d6666666666666ddd6666d6d666d66666d6d66666666d666d6d666d6666666d66666dd666d666666666dddddddd666666dd66d6666666d6666d6666666666dd6

__sfx__
0101000015650100500e0500905007050050500005000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01010000180501305017650136500e6400c6400b63007630056200262000610000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010100001d6400e620176101460000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
1512000017030000001503517030000001503517030000001503517030000001a0301a0321b031170301503017030000001503517030000001503517030000001503517030000001a0301a0321c031170301a030
0d1200001a02000000190251a02000000190251a02000000190251a020000001e0201e0221f0211a020190201a02000000190251a02000000190251a02000000190251a020000001e0201e022200211a0201e020
091200000b4450b235171150b4450b2350b115174450b2350b1150b445172350b1150b4450b235171150b4450b2450b135174150b2450b1350b415172450b1350b4150b245171350b4150b2450b135174150b245
091200000444504235101150444504235041151044504235041150444510235041150444504235101150444504245041351041504245041350441510245041350441504245101350441504245041351041504245
151200001a03000000100351a03000000100351a0300000010035190301901519030190151903019015190351a03000000100351a03000000100351a03000000100351c0301c0151c0301c0151c0301c0151c035
0d1200001e03000000150351e03000000150351e03000000140351c0301c0151c0301c0151c0301c0151c0351e03000000150351e03000000150351e030000001403520030200152003020015200302001520035
011200001885000000000000000018850000000000000000188500000000000188501880000000000000000018850000000000000000188500000000000000001885000000000001885000000000000000000000
011200001885000000000000000018850000000000000000188500000000000188501880018950000000000018850000000000000000188500000000000000001885000000000001885000000189501995000000
011200001885018a50189501885018a50189501885018a50189501885018a50189501885018a501895018a501885018a50189501885018a50189501885018a50189501885018a50189501885018a501895018a50
091200000b2300b1350b23509130091000b2300b1000b1300b1350b230000000b1350923006135091300a2350b2300b1350b23509130091000b2300b1000b1300b1350b230000000b1350923006135091300a235
011200002a5502a5422a5322855028542285321e55026545235501e545215501e5401e532215551e5401e5321c5501e555215551e5502155523555215501e5551c5551a550175551a5551c5501e5552155023555
011200002a5502a5422a5322855028542285321e55026545235501e545215501e5401e532215551e5401e5321c5501e555215551e5502155523555215501e5551c5551a550175551a5552155023555265502a555
01120000275502855128552285522855228555285502a5512a5502a5502a5522a552285572a557285572a5572d5502a555285552a55028555265552855026555235552655023555215551e5501a5551c5501e555
091200000423004135102300423004135102301013504230041300423510230042350423004135102301013504230041351023004230041351023010135042300413004235102300423504230041351023010135
01120000225502355123552235522355223552225512155121552215522155221552285572655728557265572555026550255501e550000002155023550000000000000000000000000000000000000000000000
01120000225502355123552235522355223552225512155121552215522155221552285572655728557265572555026550285502a550000002d5502f550000000000000000000000000000000000000000000000
011200001885018a50189501885018a50189501885018a50189501885018a50189501885018a501895018a501885018a50189501885018a50189501885018a50189501885018a501895018850189501995018a50
151200001c03000000120351c03000000120351c03000000120351b0301b0151b0301b0151b0301b0151b0351c03000000120351c03000000120351c03000000120351e0301e0151e0301e0151e0301e0151e035
0d120000190300000010035190300000010035190300000010035170301701517030170151703017015170351903000000100351903000000100351903000000100351b0301b0151b0301b0151b0301b0151b035
0912000001230011350d2300123001135012300d1350123001130012350d2300123501230011350d2300113501230011350d2300123001135012300d1350123001130012350d2300123501230011350d23001135
15120000190300000010035190300000010035190300000010035170301701517030170151703017015170351903000000100351903000000100351903000000100351b0301b0151b0301b0151b0301b0151b035
011200001885000000000000000018850000000000000000188500000000000188501880018950000000000018850000000000000000188500000000000000001885000000000001885000000189501990000000
0912000001230011350d23008230081351423008135062300613006235122300623501230011350d2300113501230011350d23008230081351423008135062300613006235122300623501230011350b2300d135
151200001c03000000100351c03000000100351c030000000f0351b0301b01519030190151903019015190351c03000000100351c03000000100351c03000000120351e0301e0151903019015190301901519035
051200002575525735257152c7502c7422c7322a75028750287452a7502874025750257452074523750207452575525735257152c7502c7422c7322a7502c7502c7452e7502f7402c7502c745207452375020745
051200002575523735257152c7502c742237352a75028750227452a7502874020750257452074523750207452575523735257152c7502c742237352a7502c750227452e7502f740207502c745207452375020745
091200000423004135102300423004135102300413506230061300623512230062350623006135122300613504230041351023004230041351023004135062300613006235122300623506230061351223006135
151200001c03000000100351c03000000100351c03000000120351e0301e0151e0301e0151e0301e0151e0351c03000000100351c03000000100351c03000000120351e0301e0151e0301e0151e0301e0151e035
051200002b7502c7512c7522c7522c7522c7522c7522b7512a7512a7502a7522e7572f7572e7572f7572e7572c7502a750237352c7502a750237352e7502c750257352e7502c750257352f750000002e75000000
051200002575523735257152c7502c742237352a75028750227452a7502874020750257452074523750207452575523735257152c7502c742237352a7502c750227452e7502f74020750317452c7452f75031745
01120000188500000018a5000000189500000018a5000000188500000018a5018850189501885018a5000000188500000018a5000000189500000018a5000000188500000018a5018850189501885018a5000000
151200001c0301c0301c0301c0201c0201c0201c0101c0101b0301b0301b0301b0201b0201b0201b0101b0101c0301c0301c0301c0201c0201c0201c0101c0101e0301e0301e0301e0201e0201e0201e0101e010
151200001f0301f0301f0301f0201f0201f0201f0101f010210302103021030210202102021020210102101020030200302003020030200302002020020200202002020020200202001020010200102001020010
0d12000020020200202002020020200102001020010200101e0201e0201e0201e0201e0101e0101e0101e01020020200202002020020200102001020010200102202022020220202202022010220102201022010
01120000012300113001125011150d2300d1300d1250d115012300113001125011350d230011300112501115012300113001125011150d2300d1300d1250d115012300113001125011350d230011300112501115
0d1200002303023030230302302023020230202301023010250302503025030250202502025020250102501023030230302303023030230302302023020230202302023020230202301023010230102301023010
011200000423004130041250411510230101301012510115062300613006125061351223006130061250611501230011300113001130012300112001120011200122001120011200111001210011100111001110
0d0e00001243713427174171a4171243713427174171a41710437114271541718417104371142715417184170f43713427164171a4170f43713427164171a4171043711427154171841710437114271541718417
090e00000713007230132300713007230132300713007230051300523011230051300523011230051300523003130032300f23003130032300f23003130032300513005230112300513005230112300513005230
090e00000713007230132300713007230132300713007230051300523011230051300523011230051300523003130032300f23003130032300f230031300323002130022300e2300213002230022300513006230
010e00001885000000000001885000000000000000000000000001885019850000000000000000000000000018850000000000018850000000000000000000000000018850198500000000000188500000000000
010e00001885000000000001885000000189500000000000000001885019850000000000018950000000000018850000000000018850000001895000000000000000018850198500000000000189501885000000
0d0e00000f43713427164171a4170f43713427164171a41713437164271a4171d41713437164271a4171d41710437114271541718417104371142715417184171343715427184171c4171343715427184171c417
090e000003130032300f23003130032300f230031300323003130032300f23003130032300f230031300323002130022300e23002130022300e230021300223002130022300e23002130022300e2300213002230
0d0e00000f43713427164171a4170f43713427164171a41713437164271a4171d41713437164271a4171d4171c4371d42721417244171c4371d42721417244171f4372142724417284171f437214272441728417
010e00001885018a501895018a501885019850189501885018a5018850189501885018a501885018950198501885018a501895018a501885019850189501885018a5018850189501885018a50188501895019850
0d0e00001f7451f7451f740137411f7451f7451f740137411f7451f740137411f7451f740137411f745137451f7451f7451f740137411f7451f7451f740137411f7451f740137411f7451f740137411f74513745
010e00001885018a501895018a501885019850189501885018a5018850189501885018a501885018950198501885018a501895018a501885019850189501885018a5018850189501885018a50188501895019950
010e00001885018a501895018a501885019850189501885018a5018850189501885018a501885018950198501885018a501895018a501885019850189501885018a501895018a501885018950188501895019950
010e00001885018a5019a5018a501885018a5019a5018a501885018a5019a5018850189501885018a5019a501885018a5019a5018a501885018a5019a5018a501885018a5019a5018850189501885018a5019a50
090e000007130072301323007130072301323007130072300513005230112300513005230112300513005230041300423010230041300423010230041300423003130032300f230031300f230022300513006230
0d0e000022030220351f03522030220351f0301f03522030220351f03522030220351f0301f0351d0301d03522030220351f03522030220351f0301f03522030220351f03522030220351f0301f0351d0301d035
0d0e00001f0301f0351b0001f0301f0351a0001a0001f0301f0351a0001f0301f0351b0301b0351a0301a0351f0301f0351b0001f0301f0351a0001a0001f0301f0351a0001f0301f0351b0301b0351a0301a035
150e00001f0301f0351b0001f0301f0351a0001a0001f0301f0351a0001f0301f0351b0301b0351a0301a0351f0301f0351b0001f0301f0351a0001a0001f0301f0351a0001f0301f0351b0301b0351a0301a035
010e00001885000000000001885000000000001885000000000001885000000000001895000000000000000018850000000000018850000000000018850000001895000000000000000000000000000000000000
090e0000072350e23513235072350e23513235072350e23513235072350e23513235072350e235132350e235072350e23513235072350e23513235072350e23513235072350e23513235072350e235132350e235
010e0000071200e12013120071200e12013120071200e12013120071200e12013120071200e120131200e120071200e12013120071200e12013120071200e12013120071200e12013120071200e120131200e120
010e0000188500000018a5018850189500000018a5018850000001885018a5018850189500000018a5018950188500000018a5018850189500000018a5018850000001895018a5018850189500000018a5018950
150e00000723000200072300000005230022300000007230002000723000000052350223005235022300000007230002000723000000052300223000000072300020007230000000523502230052000523002235
150e00000c230002000c230000000a23007230000000c230002000c230000000a235072300a23507230000000c230002000c230000000a23007230000000c230002000c230000000a23507230000000a23007235
150e00000e230002000e230000000c23009230000000e230002000e230000000c235092300c23509230000000c230002000c230000000a23007230000000c230002000c230000000a23507230000000a23007235
__music__
00 03044344
00 03040544
00 07080644
00 03040544
00 07080609
00 0304050a
00 030d0c0b
00 030e0c13
00 070f100b
00 03110c13
00 070f100b
00 03120c13
00 14151609
00 14171609
00 14151618
00 1417160a
00 1a1b190b
00 1a1c1913
00 1e1f1d0b
00 1a201913
00 22242521
04 23262721
00 2842292b
00 28422a2b
00 2d4e2e2c
00 2f4e2e2c
01 28312930
00 28312a32
00 2d312e30
00 2f312e33
00 36373533
00 36373532
00 36383533
00 36383532
00 3b713a39
02 3b713a39
01 59423d34
00 59423d34
00 59423e34
00 59423f33
00 59313d3c
00 59313d3c
00 76313e3c
00 59313f3c
00 36317d3c
02 36317d34

