
#ifndef _PLASMACLASS
#define _PLASMACLASS

#include "surface.h"
#include "core.h"

#define PLASMA_MONO		0
#define PLASMA_COLOR	1
#define PLASMA_ALPHA	2

class cPlasma
{

	public:

		cPlasma();
		~cPlasma();

		Init(int xdim,int ydim);
		SetMode(int mode);
		SetSpeed(int sp1,int sp2,int sp3);
		void SetTransparency(int transp) { transparency=transp; }
		Update(float time);
		Draw();

		CSurface *getSurface() { return surface; };

	private:
		unsigned int *ptr;
		CSurface *surface;
		int GLindex;
		int Mode;
		int RandSeed;

		float start1;
		float start2;
		float start3;
		float up1;
		float up2;
		float up3;
		int transparency;

		ColorPlasma();
		MonoPlasma();
		AlphaPlasma();
};

#endif _PLASMACLASS