; Tunnel.asm
; 'Textured' 3D tunnel effect with primitive greyscale.
; Depends largely on a pair of pretty big precomputed trig tables.
; Runs sufficiently fast on a regular 83+.

.module Tunnel
.varloc variable_free, free_space
.using noname

Tunnel
	ld a,5
	ld (_move_depth+1),a
	ld a,1
	ld (_move_angle+1),a	
_loop
	; Set y-increment mode (increments X)
	ld a,$07
	call safe_lcd_pause
	out ($10),a
	
	ld a,(_gs_dither+1)
	xor $FF
	ld (_gs_dither+1),a
	
	ld a,$C6
	ld (_angle_switch_positive+1),a
	ld a,$D6
	ld (_angle_switch_negative+1),a
	ld a,$CA
	ld (_colour_switch_z+1),a
	ld a,$C2
	ld (_colour_switch_nz+1),a

	ld hl,49
	ld (_dir_through_lookup_a+1),hl
	ld (_dir_through_lookup_d+1),hl

_depth_table_location
	ld hl,_depths
_angle_table_location
	ld de,_angles
	
	ld a,$80
	ld (_set_y_offset+1),a

_next_row

	ld a,$23	; INC HL
	ld (_lut_a_offset),a

	ld a,$13	; INC DE
	ld (_lut_d_offset),a
_angle_switch_positive:
	ld a,$C6	; ADD A,*
	ld (_view_angle),a

_colour_switch_z
	ld a,$CA	; JP Z
	ld (_branch_mode_light),a
	ld (_branch_mode_dark),a

	ld a,$20
	out ($10),a
_set_y_offset
	ld a,$80
	call safe_lcd_pause
	out ($10),a
	
	ld b,12
_row_loop
	ld ixl,0
	ld c,%10000000
	
_build_up_data_byte

	ld a,(de)
_lut_d_offset
	inc de

_view_angle
	add a,$00
	ld (_to_xor+1),a
	ld a,(hl)
_lut_a_offset
	inc hl
_view_depth
	add a,$00

_to_xor
	xor $00	
	
	bit 5,a
_branch_mode_light
	jp z,_no_draw_at_all

	
	bit 3,a
_branch_mode_dark
	jp z,_draw_full_black

_draw_grey
	ld a,c
_gs_dither
	and %10101010
	jp z,_no_draw_at_all

_draw_full_black

	ld a,ixl
	or c
	ld ixl,a
_no_draw_at_all
	srl c
	jp nc,_build_up_data_byte
	
	; Write to LCD:
	ld a,ixl

	out ($11),a
	
	ld a,b
	cp 7	; Do we need to start moving BACKWARDS on our table?
	jp nz,{+}
	ld a,$2B	; DEC HL
	ld (_lut_a_offset),a
	ld a,$1B	; DEC DE
	ld (_lut_d_offset),a
_angle_switch_negative
	ld a,$D6	; SUB *
	ld (_view_angle),a
_colour_switch_nz
	ld a,$C2	; JP NZ
	ld (_branch_mode_light),a
	ld (_branch_mode_dark),a	
	dec hl
	dec de
+
	
	djnz _row_loop
	
	ld a,(_gs_dither+1)
	xor $FF
	ld (_gs_dither+1),a
	
	; Move down a row
	ld a,(_set_y_offset+1)
	inc a
	cp $80+32
	jp nz,_not_half_way
	
	; We are now half-way, so let's flip the directions...
	

	ld (_set_y_offset+1),a	
	push hl
	ld hl,-47
	ld (_dir_through_lookup_a+1),hl
	ld (_dir_through_lookup_d+1),hl
	pop hl

	ld a,$D6
	ld (_angle_switch_positive+1),a
	ld a,$C6
	ld (_angle_switch_negative+1),a
	ld a,$C2
	ld (_colour_switch_z+1),a
	ld a,$CA
	ld (_colour_switch_nz+1),a	

	inc hl
	inc de

	jp _next_row


_not_half_way
	cp $80+64
	jp z,_finished_frame
	ld (_set_y_offset+1),a	
	
	; Move pointers up/down a row
	
	push de
_dir_through_lookup_a
	ld de,49
	add hl,de
	pop de
	
	push hl
_dir_through_lookup_d
	ld hl,49
	add hl,de
	ld d,h
	ld e,l
	pop hl
	
	
	jp _next_row
_finished_frame

	; Update the angle/depth offsets
	ld a,(_view_angle+1)
_move_angle
	add a,1
	ld (_view_angle+1),a
	
	ld a,(_view_depth+1)
_move_depth
	add a,1
	ld (_view_depth+1),a
	
	; Now handle directional keypresses (uses direct input)
	
	ld a,$FF
	out (1),a
	ld a,KeyRow_Pad
	out (1),a
	in a,(1)
	
	ld hl,_move_angle+1
	bit 1,a
	jr nz,{+}
	inc (hl)
+	bit 2,a
	jr nz,{+}
	dec (hl)
+	

	ld hl,_move_depth+1
	bit 3,a
	jr nz,{+}
	inc (hl)
+	bit 0,a
	jr nz,{+}
	dec (hl)
+
	
	; Branch back to the main loop.
	call scene_countdown
	jp _loop
	

.endmodule