; Flip.asm
; Makes copying from plotSScreen a little more exciting than normal!
; Sadly, the effect is not perfect. In reality, the vertical scaling would
; NOT be linear (the so-called perspective-correctness). Ah well. It's good
; enough for our low-res fast spinning quad. :)

;

.module Flip
.varloc variable_free, free_space
.using noname
.var 1, _spin
.var 1, _text_timeout
.var 2, _text_pointer
.var 13*8, _text_buffer
.var 1, _scroll_in_pic_counter ; Goes from 0->64, NOT 0->32.
.var 1, _picture_index
.var 1, _change_timer
_source = plotSScreen
_time_between_change = 80 ; Waste a few cc on blank lines to keep timing consistant
Flip
	
	xor a
	ld (_scroll_in_pic_counter),a
	ld (_picture_index),a
	call _decompress_current_pic
	
	ld a,_time_between_change
	ld (_change_timer),a

	call take_screenshot
	
	ld hl,_text_buffer
	ld bc,13*8
	xor a
	bcall(_MemSet)

	ld a,4
	ld (_spin_speed+1),a
	
	ld a,1
	ld (_text_timeout),a
	
	ld hl,_text
	ld (_reset_text+1),hl
	ld (_text_pointer),hl
	
_loop

	ld a,$80
	ld (_row_count+1),a
	
	ld (_source_start+1),hl
	
	ld a,$07
	call safe_lcd_pause
	out ($10),a
	
	; We need to decide how tall we are to draw the spinning card.
	; Do this by calculating an offset from the top/bottom based on a sine wave.
	; If we give ourselves a clearance of 8px at the top, 32-8=24.
	; Our sine wave must be 12*, and be offset by 20 pixels.
	
	ld a,(_spin)
_spin_speed
	add a,2
	ld (_spin),a
	and ~$80
	ld l,a
	ld h,0
	ld de,_heights
	add hl,de
	ld a,(hl)
	sra a
	; a = our sine value
	ld b,a
	add a,20+$80 ; Top...
	ld (_start_height+1),a
	ld a,64+$80-20
	sub b
	ld (_end_height+1),a
	
	
	; So, we're drawing a "textured" line.
	; How wide is it?
	ld a,(_spin)
	add a,32 ; 90 degrees
	and ~$80
	ld l,a
	ld h,0
	ld de,_heights
	add hl,de
	ld a,(hl)
	ld b,a

	
	add a,73
	ld (_s2+1),a
	ld c,a
		
	; We need to eventually scale up to a second width
	ld a,b
	neg
	add a,73
	
	sub c ; a = offset
	
	jp m,_scale_down ; offset is negative
	
	ld c,$34 ; INC (hl)
	jp _scaled_up
_scale_down
	neg
	ld c,$35 ; DEC (hl)
_scaled_up
	; So at this point, we know that the offset is the value of A
	; and that the width changer is in C.
	
	ld (_horiz_scale_delta_width+1),a
	
	ld a,c
	ld (_still_need_width_change),a
	
	ld a,(_start_height+1)
	ld b,a
	ld a,(_end_height+1)
	sub b
	ld (_horiz_scale_total_height+1),a
	ld (_saved_width_scale_fxp+1),a
	ld (_vert_relative+1),a
	
	ld a,64
	ld (_vert_tracking+1),a
	
	; Are we upside down?
	ld hl,12	; Assume not.
	ld de,_source
	ld a,(_spin)
	sub 16+8
	jp p,_am_right_way_up
	ld hl,-12
	ld de,_source+12*63
_am_right_way_up
	ld (_way_up_offset+1),hl
	ld (_source_start+1),de	
	

_draw_line

	ld a,$20
	call safe_lcd_pause
	out ($10),a

	

_row_count	
	ld a,$80
	call safe_lcd_pause
	out ($10),a


_start_height
	cp $00 ; Start...
	jp c, _fill_blank_line
_end_height
	cp $00 ; End
	jp nc,_fill_text_scroller



	
	
_source_start
	ld hl,0  ; HL = pointer to the source image

	ld c,%10000000 ; C = bitmask for LCD pixel write
	ld ixl,12      ; IXL = dest byte counter

	; We need to 'fast forward' a few pixels to line up the trapezium correctly


	ld a,(_s2+1)   ; Absolute width
	sra a
	ld b,a
	ld a,48
	sub b
	ld b,a	       ; Pixels to skip
	xor a
-	or c
	srl c
	jp nc,{+}
	out ($11),a
	xor a
	dec ixl
	ld c,%10000000	
+	djnz {-}
	ld d,a ; D = LCD byte write tracker
	
	
	ld ixh,12      ; 12 bytes per row (used to work out when we've run out of source data)
	ld b,%10000000 ; B = bitmask for source data

	ld e,96	       ; Total width counter	
	; Move to next pixel of source...
_get_next_pixel
	ld a,e	
_try_next_pixel
	srl b
	jp nc,{+}
	ld b,%10000000
	inc hl
	dec ixh
	jp z,_finish_row_with_blanks
+
_s2
	sub 0
	jp z,_hit_pixel
	jp p,_try_next_pixel
	
	; At this point, we have the next pixel to fetch.
_hit_pixel
	add a,96
	ld e,a
	
	ld a,(hl) ; From source
	and b     ;     ""
	
	jp z,_not_set_pixel
	; Set the pixel...	
	ld a,d
	or c
	ld d,a	
_not_set_pixel

	srl c
	jp nc,_get_next_pixel
	ld c,%10000000
	; We can now perform the LCD write
	ld a,d
	out ($11),a
	ld d,$00 ; Clear the byte
	dec ixl
	jp nz,_get_next_pixel
	jp _finished_row	
_finish_row_with_blanks

	; So, we have finished the row.
	ld a,d
	or c
-	srl c
	jp c,_finished_blacking_rest
	or c
	jr {-}
_finished_blacking_rest
	out ($11),a
	

	ld a,ixl
	or a
-	jr z,_finished_row
	ld a,$FF
	call safe_lcd_pause
	out ($11),a
	dec ixl
	jr {-}


_finished_row
	; Advance pointer on height scaling...
	ld hl,(_source_start+1)
_way_up_offset
	ld de,12
	
_vert_tracking
	ld a,10
	
	sub 64	; Total height of texture

_vert_scaling	
	add hl,de
_vert_relative
	add a,0 ; Relative height of texture
	jp m,_vert_scaling
	
	ld (_vert_tracking+1),a
	
	
	ld (_source_start+1),hl
	
	; We need to change the horizontal stretching
	
_saved_width_scale_fxp
	ld a,0
_horiz_scale_delta_width
	sub 32
	ld (_saved_width_scale_fxp+1),a
	jp z,_need_change_width
	jp p,_finished_scaled_row

_need_change_width
	ld hl,_s2+1
_horiz_scale_total_height
	ld b,20
_still_need_width_change
	dec (hl)
	add a,b
	jp m,_still_need_width_change
	
	ld (_saved_width_scale_fxp+1),a		
	
	
	jp _finished_scaled_row
	
_fill_text_scroller
	; a is the row we need...
	cp $80+64-8
	jp c,_fill_blank_line
	
	; We can now fill in a row of our text scroller.
	sub $80+(64-8)
	; 13 = 1101
	ld b,a  ;b=a*1
	add a,a ;*2
	add a,a ;*4
	ld c,a  ;c=a*4
	add a,a ;*8
	add a,c ;*8+*4=*12
	add a,b ;*12+*1=*13
	ld l,a
	ld h,0
	ld de,_text_buffer
	add hl,de
	
	ld b,12
-	ld a,(hl)
	inc hl
	cpl
	call safe_lcd_pause	
	out ($11),a
	djnz {-}
	
	; At this point, HL points to the end... let's do a nice little smooth scroll job.
	ld b,13
-
	rl (hl)
	dec hl
	djnz {-}
	
	jp _finished_scaled_row

_fill_blank_line
	ld b,12
	ld a,$20
	call safe_lcd_pause	
	out ($10),a
-	ld a,$FF
	call safe_lcd_pause
	out ($11),a
	djnz {-}
	
	; We need to waste some clocks here.
	; Otherwise, the speed of the demo (scroller) fluctuates.
	; Very fast when the card is edge-on, much slower when face-on.
	
	ld hl,75
-	dec hl
	push hl
	pop hl
	ld a,h
	or l
	jr nz,{-}

_finished_scaled_row


	ld a,(_row_count+1)
	inc a
	ld (_row_count+1),a
	cp $80+64
	jp nz,_draw_line
	; Finished the screen

	ld a,KeyRow_Pad
	out (1),a
	in a,(1)
	
	ld hl,_spin_speed+1
	bit 3,a
	jr nz,{+}
	dec (hl)
+	bit 0,a
	jr nz,{+}
	inc (hl)
+

	and ~(dKLeft&dkRight)
	jr nz,{+}
	
	call take_screenshot
	ld hl,plotSScreen
	ld bc,768
-	ld a,(hl)
	cpl
	ld (hl),a
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,{-}
+

	; Handle the scrolling text
	
	ld a,(_text_timeout)
	dec a
	and 7
	ld (_text_timeout),a
	jp nz,_no_text_scroll

	ld hl,(_text_pointer)
	ld a,(hl)
	cp $FF
	jp nz,_no_text_reset
	
_reset_text
	ld hl,0
	ld a,(hl)
_no_text_reset
	inc hl
	ld (_text_pointer),hl
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	ld de,font
	add hl,de
	ld d,h
	ld e,l
	ld hl,_text_buffer+12
	ld bc,13
	ld ixl,8

-	ld a,(de)
	inc de
	ld (hl),a
	add hl,bc
	dec ixl
	jr nz,{-}

_no_text_scroll	
	call scene_countdown
	


	
	ld a,(_change_timer)
	or a
	jr z,_scroll_into_next_picture
	
	dec a
	ld (_change_timer),a
	jp _loop


_scroll_into_next_picture

	; Scroll up the screen by one pixel
	
	ld hl,plotSScreen+12
	ld de,plotSScreen
	ld bc,768-12
	ldir
	ld hl,plotSScreen+12*63
	ld bc,12
	xor a
	bcall(_MemSet)
	
	; Scroll in a row of one of the pictures


	ld a,(_picture_index)

	; OLD----------
	;ld l,a
	;ld h,0
	;; *192 = *128+*64
	;add hl,hl
	;add hl,hl
	;add hl,hl
	;add hl,hl
	;add hl,hl
	;add hl,hl
	;ld d,h
	;ld e,l
	;add hl,hl
	;add hl,de
	;ld de,_pics
	;add hl,de
	;ld d,h
	;ld e,l
	; ----------OLD
	
	; NEW----------
	ld de,saveSScreen
	; ----------NEW

	
	
	ld a,(_scroll_in_pic_counter)
	and ~1 ; Clear the LSB (it's already *2)
	ld b,a
	add a,a ;*4
	add a,b ;*6
	ld l,a
	ld h,0
	add hl,de
	ld d,h
	ld e,l
	
	ld hl,plotSScreen+12*63
	
	ld ixl,12	; 12 columns per scanline
	
_next_byte_of_source
	ld b,%11000000
	ld c,%10000000

_get_next_scale_pixel
	ld a,(de)
	and c
	jp z,{+}
	ld a,b
	or (hl)
	ld (hl),a
+
	srl b
	srl b
	jp nc,_no_next_write
	
	dec ixl
	jp z,_finished_scanline
	ld b,%11000000
	inc hl
	
_no_next_write
	srl c
	jp nc,_get_next_scale_pixel
	; Move to the next byte of the image
	inc de
	jp _next_byte_of_source
_finished_scanline
	ld a,(_scroll_in_pic_counter)
	inc a
	and 63
	ld (_scroll_in_pic_counter),a
	jp nz,_loop
	
	ld a,(_picture_index)
	inc a
	and 3
	ld (_picture_index),a
	call _decompress_current_pic
	ld a,_time_between_change
	ld (_change_timer),a
	
		
	jp _loop
	
_decompress_current_pic
	ld a,(_picture_index)
	add a,a
	ld l,a
	ld h,0
	ld de,_pics
	add hl,de
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld hl,saveSScreen
	ex de,hl
	ld bc,768/4
	jp disprlel ; CALL ... RET

.endmodule