; ======================================-=====================================
; Singen68k - A 14 byte sine generator for M68k by Superogue / Marquee Design|
; ============================================================================
; Atari ST Example
; ============================================================================

	OPT O+,D-,X-

SIZE	equ 256	

	; Optional: Backup bss address for drawing (Initialised in a4 on Atari ST)
	move.l	a4,a5		; 2b 

	; Sine generator (14 bytes)
	; Requires d3 or any replacement reg to be zero at startup
	moveq	#127,d2		;2b 
singen:
	subq.l	#2,d2		;2b
	move.w	d3,(a4)+	;2b
	sub.w	d3,(SIZE-4,a4)	;4b
	add.l	d2,d3		;2b
	bne.b	singen		;2b

	; Init graphics
	dc.w	$A000	;2
	movem.l	(a0),a1-a4	; 4A3=INTIN, A4=PTSIN

	; Draw sinewave
	move.w #255,d5
drawloop:	

	; Read sine value and scale back for plotting
	move.w (a5)+,d6	
	asr.w #6,d6	
	add.w #100,d6		

	; Plot pixel
	movem.w	d5/d6,(a4)
	move.w #15,(a3)	
	dc.w $A001	
	dbra d5,drawloop
	
	; wait loop
	bra.s	*

	section bss

sintab  ds.w 256
