/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;

public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToInlineClassTypeValueParameters(@NotNull CallableMemberDescriptor descriptor2) {
        boolean bl;
        block8: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (!(callableMemberDescriptor instanceof ClassConstructorDescriptor)) {
                callableMemberDescriptor = null;
            }
            ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)callableMemberDescriptor;
            if (classConstructorDescriptor == null) {
                return false;
            }
            ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
            if (Visibilities.isPrivate(constructorDescriptor.getVisibility())) {
                return false;
            }
            ClassDescriptor classDescriptor = constructorDescriptor.getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "constructorDescriptor.constructedClass");
            if (classDescriptor.isInline()) {
                return false;
            }
            if (DescriptorUtils.isSealedClass(constructorDescriptor.getConstructedClass())) {
                return false;
            }
            List<ValueParameterDescriptor> list = constructorDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "constructorDescriptor.valueParameters");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it;
                    ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
                    KotlinType kotlinType = valueParameterDescriptor.getType();
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
                    if (!InlineClassManglingRulesKt.requiresFunctionNameMangling(kotlinType)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInlineClassThatRequiresMangling(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return InlineClassesUtilsKt.isInlineClass($receiver) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)$receiver);
    }

    public static final boolean isInlineClassThatRequiresMangling(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null && InlineClassManglingRulesKt.isInlineClassThatRequiresMangling(classifierDescriptor);
    }

    private static final boolean requiresFunctionNameMangling(@NotNull KotlinType $receiver) {
        return InlineClassManglingRulesKt.isInlineClassThatRequiresMangling($receiver) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling($receiver);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor) {
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor), DescriptorUtils.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(@NotNull KotlinType $receiver) {
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor descriptor2 = typeParameterDescriptor;
        return InlineClassManglingRulesKt.requiresFunctionNameMangling(TypeSignatureMappingKt.getRepresentativeUpperBound(descriptor2));
    }
}

