/*
	RNDR / post_blur.frag
	Edwin Jakobs (edwin@lustlab.net)
*/

uniform sampler2D texture;

uniform vec2 blurDirection;
uniform int window;

void main() {

    float w = 0.0;
    vec4 sum = vec4(0,0,0,0);
    for (int i = -window; i <= window; ++i) {
        float fi = float(i);

	    vec4 col = texture2D(texture, gl_TexCoord[0].xy + blurDirection * fi);
	    sum+=col;
	    w+=1.0;
	}

    gl_FragColor = sum/w;
}