
uniform sampler2D texture;
uniform vec4 clipArea;
uniform float viewHeight;

void main() {
	vec4 col = texture2D(texture, gl_TexCoord[0].xy);

	if (gl_FragCoord.x < clipArea.x
	    || gl_FragCoord.x > clipArea.y
	    || (viewHeight-gl_FragCoord.y) < clipArea.z
	    || (viewHeight-gl_FragCoord.y) > clipArea.w) {
	    discard;
	}

	gl_FragColor = vec4(col.r * gl_Color.r * gl_Color.a, col.g * gl_Color.g* gl_Color.a, col.b * gl_Color.b * gl_Color.a, col.a * gl_Color.a);
}