#version 150

/*
    SSLR fragment shader

*/

// --- varyings ---
in vec2 v_texCoord0;

// --- G buffer ---
uniform sampler2D colors;
uniform sampler2D normals;
uniform sampler2D positions;

uniform sampler2D noise;

// --- transforms ---
uniform mat4 projectionMatrix;

// --- output ---
out vec4 o_color;


const int maxSteps = 128;

vec3 screen(vec3 world) {
    vec4 projected = (projectionMatrix * vec4(world, 1));
    return vec3((projected.x/projected.w) / 2 + 0.5, (projected.y/projected.w) / 2 + 0.5, world.z );
}


void main() {

    vec4 color = texture(colors, v_texCoord0);

     vec3 viewNormal = normalize(texture(normals, v_texCoord0).xyz);// + (texture(noise, v_texCoord0*0.1).xyz - 0.5) * 0.0;
     vec3 viewPos = texture(positions, v_texCoord0).xyz;
     vec3 reflected = normalize(reflect(normalize(viewPos), normalize(viewNormal)));

     float frontalFade = clamp(-reflected.z,0, 1);

    if (length(viewNormal) == 0 || frontalFade == 0) {
        o_color = color;
        return;
    }

    vec3 screenPos = screen(viewPos);
    vec3 screenReflect = screen(viewPos + reflected) - screen(viewPos);
    screenReflect /= length(screenReflect.xy);
    //screenReflect *= ( (1280.0/maxSteps) )/(1280.0);
    screenReflect *= (1.0 + texture(noise, v_texCoord0).x*0.1) /1280.0;


    float srxa = screenReflect.x == 0? 0.0001 : screenReflect.x;
    float srya = screenReflect.y == 0? 0.0001 : screenReflect.y;
    float srza = screenReflect.z == 0? 0.0001 : screenReflect.z;

    int xSteps = int( max (-screenPos.x / srxa, (1.0-screenPos.x) / srxa));
    int ySteps = int( max (-screenPos.y / srya, (1.0-screenPos.y) / srya));
    int zSteps = int( max (-screenPos.z / srza, (-100.0-screenPos.z) / srza));

    int totalSteps = min(min(xSteps, ySteps) , min(zSteps, maxSteps));

    float found = 0;
    vec3 marchPos = screen(viewPos) + screenReflect;
    vec3 lastPos = marchPos;

    vec2 ddx = dFdx(marchPos.xy);
    vec2 ddy = dFdy(marchPos.xy);

    float steps =  0;


    for (int i = 0; i < totalSteps; ++i) {
        float depth = textureGrad(positions, marchPos.xy, ddx, ddy).z;
        vec3 sampleNormal = normalize(textureGrad(normals, marchPos.xy, ddx, ddy).xyz);
        float diff = marchPos.z - depth;
        float ndiff =  dot(sampleNormal, viewNormal);



        if (diff < 0 && diff > -0.1 && ndiff < 0.5) {

            //marchPos = lastPos + (depth - lastPos.z) * screenReflect;

            found = 1;
            break;
        }

        steps+=1.0;
        lastPos = marchPos;
        marchPos += screenReflect;
    }

   float distanceFade = max(0.0, 1.0 - steps/maxSteps);
   float fadeEdges = clamp(distance(marchPos.xy , vec2(0.5, 0.5)) * 2.0, 0, 1);
   float diffFade = 1.0; //clamp(1.0+diff*10,0,1);

   //vec4 reflectedColor = texture(colors, marchPos.xy);

   vec4 reflectedColor = textureGrad(colors, marchPos.xy, ddx, ddy);

   o_color = color + 0.5 * found * diffFade * distanceFade * fadeEdges * frontalFade* reflectedColor;



}