#version 150

// -- inputs --
in vec3 position;
in vec2 texCoord0;
in vec3 normal;

// -- transforms --
uniform mat4 modelViewProjectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 normalMatrix;

out vec3 v_normal;
out vec2 v_texCoord0;
out vec3 v_position;
out vec3 v_objectPosition;

void main() {
    gl_Position = modelViewProjectionMatrix * vec4(position, 1);
    v_position = (modelViewMatrix * vec4(position, 1)).xyz;
    v_objectPosition = position;
    v_normal = (normalMatrix * vec4(normal, 0)).xyz;
    v_texCoord0 = texCoord0;

}
