#version 150


uniform vec4[4] colors;
uniform float[4] ds;
uniform sampler2D noise;

in vec2 v_texCoord0;

out vec4 o_color;

void main() {

    float d = (length(v_texCoord0 - vec2(0.5))) * 2;

    vec4 n = texture(noise, gl_FragCoord.xy * vec2(1.0/256.0,1.0/256.0));
d += n.x * 0.03;
    vec4 vl;
    vec4 vr;

    float dl;
    float dr;

    d = min(d, ds[3]);

    if (d < ds[1]) {
        dl = ds[0];
        dr = ds[1];
        vl = colors[0];
        vr = colors[1];
    }
    else if (d < ds[2]) {
        dl = ds[1];
        dr = ds[2];
        vl = colors[1];
        vr = colors[2];
    }
    else if (d <= ds[3]) {
        dl = ds[2];
        dr = ds[3];
        vl = colors[2];
        vr = colors[3];
    }

    float dd = dl - dr;
    vec4 dv = vl - vr;
    vec4 dvdd = dv /dd;



    o_color = vl + dvdd * (d-dl);

}