#version 150

uniform mat4 modelViewProjectionMatrix;
uniform mat4 projectionMatrix;

uniform mat4 normalMatrix;
uniform mat4 modelViewMatrix;

in vec3 position;
in vec2 texCoord0;

out vec3 v_position;
out vec2 v_texCoord0;

uniform float time;


mat4 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;

    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
                0.0,                                0.0,                                0.0,                                1.0);
}

void main() {

     vec3 transformed = vec3(0,0,0);

     transformed.y += (gl_InstanceID-10000) * 0.000025;

     mat4 transformMatrix = rotationMatrix(normalize(vec3(cos(time*0.5436),cos(time+gl_InstanceID*0.03),cos(time*0.4325))), gl_InstanceID * 0.2);


     transformed = (transformMatrix * vec4(transformed,1)).xyz;


    gl_Position = projectionMatrix * ( vec4(position + transformed + modelViewMatrix[3].xyz,1.0));
    //gl_Position = modelViewProjectionMatrix * vec4(transformed, 1);

    v_position = gl_Position.xyz;
    v_texCoord0 = texCoord0;

}