#version 150

uniform mat4 modelViewProjectionMatrix;
uniform mat4 projectionMatrix;

uniform mat4 normalMatrix;
uniform mat4 modelViewMatrix;

uniform sampler2D positions;



in vec3 position;
in vec2 texCoord0;

out vec3 v_position;
out vec2 v_texCoord0;


uniform float time;
out float v_velocity;
out float v_intensity;

void main() {

    ivec2 ts = textureSize(positions, 0);
    v_intensity = 0.4; //((256*256*64) / (ts.x*ts.y)) / 256.0;

    float u = (gl_InstanceID % ts.x) / float(ts.x);
    float v = (gl_InstanceID / ts.x) / float(ts.y);

    vec3 particlePosition = texture(positions, vec2(u,v)).xyz;
    v_velocity = texture(positions, vec2(u,v)).w;
    particlePosition = (modelViewMatrix * vec4(particlePosition,1)).xyz;

    gl_Position = projectionMatrix * ( vec4(position + particlePosition,1.0));

    v_position = gl_Position.xyz;
    v_texCoord0 = texCoord0;

}